/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.glider;

import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.util.ImageUtil;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwindx.applications.glider.GliderRegionOfInterest;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;

public class GliderImage
extends AVListImpl {
    public static final String GLIDER_REGIONS_OF_INTEREST = "gov.nasa.worldwind.glider.RegionsOfInterest";
    public static final String GLIDER_IMAGE_SOURCE = "gov.nasa.worldwind.glider.ImageSource";
    public static final String GLIDER_IMAGE_OPACITY = "gov.nasa.worldwind.glider.ImageOpacity";
    protected String name;
    protected Sector sector;
    protected List<LatLon> corners;
    protected double altitude;
    protected double opacity = 1.0;
    protected Object imageSource;
    protected PropertyChangeListener regionListener = new RegionListener();
    private CopyOnWriteArraySet<GliderRegionOfInterest> regionTable = new CopyOnWriteArraySet();

    public GliderImage(String string, Iterable<? extends LatLon> iterable, double d) {
        this(string, string, iterable, d);
    }

    public GliderImage(String string, ImageUtil.AlignedImage alignedImage, double d) {
        this(string, alignedImage.image, (Iterable<? extends LatLon>)alignedImage.sector, d);
    }

    public GliderImage(String string, Object object, Iterable<? extends LatLon> iterable, double d) {
        if (string == null) {
            String string2 = Logging.getMessage((String)"nullValue.NameIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (object == null) {
            String string3 = Logging.getMessage((String)"nullValue.ImageSource");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (iterable == null) {
            String string4 = Logging.getMessage((String)"nullValue.LocationsListIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        this.name = string;
        this.imageSource = object;
        this.sector = Sector.boundingSector(iterable);
        this.altitude = d;
        this.corners = new ArrayList<LatLon>();
        for (LatLon latLon : iterable) {
            this.corners.add(latLon);
        }
    }

    public void releaseImageSource() {
        this.imageSource = null;
    }

    public String getName() {
        return this.name;
    }

    public Sector getSector() {
        return this.sector;
    }

    public List<LatLon> getCorners() {
        return Collections.unmodifiableList(this.corners);
    }

    public double getAltitude() {
        return this.altitude;
    }

    public void setImageSource(String string) {
        if (string == null) {
            String string2 = Logging.getMessage((String)"nullValue.ImageSource");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.setImageSource(string, string);
    }

    public void setImageSource(String string, Object object) {
        if (string == null) {
            String string2 = Logging.getMessage((String)"nullValue.NameIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (object == null) {
            String string3 = Logging.getMessage((String)"nullValue.ImageSource");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        this.name = string;
        this.imageSource = object;
        this.firePropertyChange(GLIDER_IMAGE_SOURCE, null, (Object)this);
    }

    public Object getImageSource() {
        return this.imageSource;
    }

    public double getOpacity() {
        return this.opacity;
    }

    public void setOpacity(double d) {
        this.opacity = d;
        this.firePropertyChange(GLIDER_IMAGE_OPACITY, null, (Object)this);
    }

    public void addRegionOfInterest(GliderRegionOfInterest gliderRegionOfInterest) {
        if (gliderRegionOfInterest == null) {
            String string = Logging.getMessage((String)"nullValue.RegionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        gliderRegionOfInterest.removePropertyChangeListener(this.regionListener);
        gliderRegionOfInterest.addPropertyChangeListener(this.regionListener);
        if (this.regionTable.add(gliderRegionOfInterest)) {
            this.firePropertyChange(GLIDER_REGIONS_OF_INTEREST, null, this.getRegionsOfInterest());
        }
    }

    public void removeRegionOfInterest(GliderRegionOfInterest gliderRegionOfInterest) {
        if (gliderRegionOfInterest == null) {
            String string = Logging.getMessage((String)"nullValue.RegionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        gliderRegionOfInterest.removePropertyChangeListener(this.regionListener);
        if (this.regionTable.remove((Object)gliderRegionOfInterest)) {
            this.firePropertyChange(GLIDER_REGIONS_OF_INTEREST, null, this.getRegionsOfInterest());
        }
    }

    public GliderRegionOfInterest.RegionSet getRegionsOfInterest() {
        return new GliderRegionOfInterest.RegionSet(this.regionTable);
    }

    public static ImageUtil.AlignedImage alignImage(BufferedImage bufferedImage, float[] fArray, float[] fArray2) throws InterruptedException {
        return ImageUtil.alignImage((BufferedImage)bufferedImage, (float[])fArray, (float[])fArray2, null, null);
    }

    public static void alignImageDump(BufferedImage bufferedImage, float[] fArray, float[] fArray2) {
        ImageUtil.alignImageDump((BufferedImage)bufferedImage, (float[])fArray, (float[])fArray2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        GliderImage gliderImage = (GliderImage)((Object)object);
        if (Double.compare(gliderImage.altitude, this.altitude) != 0) {
            return false;
        }
        if (this.corners != null ? !this.corners.equals(gliderImage.corners) : gliderImage.corners != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(gliderImage.name) : gliderImage.name != null) {
            return false;
        }
        return !(this.sector != null ? !this.sector.equals((Object)gliderImage.sector) : gliderImage.sector != null);
    }

    public int hashCode() {
        int n = this.name != null ? this.name.hashCode() : 0;
        n = 31 * n + (this.sector != null ? this.sector.hashCode() : 0);
        n = 31 * n + (this.corners != null ? this.corners.hashCode() : 0);
        long l = this.altitude != 0.0 ? Double.doubleToLongBits(this.altitude) : 0L;
        n = 31 * n + (int)(l ^ l >>> 32);
        return n;
    }

    protected class RegionListener
    implements PropertyChangeListener {
        protected RegionListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName() == "gov.nasa.worldwind.glider.RegionOfInterest") {
                GliderImage.this.firePropertyChange(GliderImage.GLIDER_REGIONS_OF_INTEREST, null, GliderImage.this.getRegionsOfInterest());
            }
        }
    }
}

