/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.glider;

import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.util.Logging;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class GliderRegionOfInterest
extends AVListImpl {
    public static final String GLIDER_REGION_OF_INTEREST = "gov.nasa.worldwind.glider.RegionOfInterest";
    private List<LatLon> locations;
    private Color color;

    public GliderRegionOfInterest(Iterable<? extends LatLon> iterable, Color color) {
        if (iterable == null) {
            String string = Logging.getMessage((String)"nullValue.LocationsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (color == null) {
            String string = Logging.getMessage((String)"nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.locations = new ArrayList<LatLon>();
        for (LatLon latLon : iterable) {
            this.locations.add(latLon);
        }
        this.color = color;
    }

    public GliderRegionOfInterest(GliderRegionOfInterest gliderRegionOfInterest) {
        this(gliderRegionOfInterest.getLocations(), gliderRegionOfInterest.getColor());
    }

    public List<LatLon> getLocations() {
        return this.locations;
    }

    public void setLocations(Iterable<? extends LatLon> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage((String)"nullValue.LocationsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        GliderRegionOfInterest gliderRegionOfInterest = new GliderRegionOfInterest(this);
        this.locations = new ArrayList<LatLon>();
        for (LatLon latLon : iterable) {
            this.locations.add(latLon);
        }
        this.firePropertyChange(GLIDER_REGION_OF_INTEREST, (Object)gliderRegionOfInterest, (Object)this);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            String string = Logging.getMessage((String)"nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        GliderRegionOfInterest gliderRegionOfInterest = new GliderRegionOfInterest(this);
        this.color = color;
        this.firePropertyChange(GLIDER_REGION_OF_INTEREST, (Object)gliderRegionOfInterest, (Object)this);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        GliderRegionOfInterest gliderRegionOfInterest = (GliderRegionOfInterest)((Object)object);
        if (this.color != null ? !this.color.equals(gliderRegionOfInterest.color) : gliderRegionOfInterest.color != null) {
            return false;
        }
        return !(this.locations != null ? !this.locations.equals(gliderRegionOfInterest.locations) : gliderRegionOfInterest.locations != null);
    }

    public int hashCode() {
        int n = this.locations != null ? this.locations.hashCode() : 0;
        n = 31 * n + (this.color != null ? this.color.hashCode() : 0);
        return n;
    }

    public static class RegionSet {
        public final Set<GliderRegionOfInterest> regions;

        public RegionSet(Set<GliderRegionOfInterest> set) {
            if (set == null) {
                String string = Logging.getMessage((String)"nullValue.RegionListIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.regions = Collections.unmodifiableSet(set);
        }
    }
}

