/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.glider;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.util.ImageUtil;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwindx.applications.glider.GliderImage;
import gov.nasa.worldwindx.applications.glider.GliderRegionOfInterest;
import gov.nasa.worldwindx.applications.glider.GliderWorldWindow;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class GliderTestApp
extends ApplicationTemplate {
    protected static LatLon nw = LatLon.fromDegrees((double)48.55774732, (double)-134.459224670811);
    protected static LatLon ne = nw.add(LatLon.fromDegrees((double)0.0, (double)9.19875));
    protected static LatLon se = nw.add(LatLon.fromDegrees((double)-7.359, (double)9.19875));
    protected static LatLon sw = nw.add(LatLon.fromDegrees((double)-7.359, (double)0.0));
    protected static List<LatLon> corners = Arrays.asList(sw, se, ne, nw);
    protected static String cloudImagePath = "gov/nasa/worldwindx/examples/images/GLIDERTestImage-800x519.jpg";

    protected static float[][] makeField(List<LatLon> list, int n, int n2, Angle angle) {
        Sector sector = Sector.boundingSector(list);
        double d = sector.getDeltaLatDegrees() / ((double)n2 - 1.0);
        double d2 = sector.getDeltaLonDegrees() / ((double)n - 1.0);
        float[] fArray = new float[n * n2];
        float[] fArray2 = new float[fArray.length];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                fArray[i * n + j] = (float)(sector.getMinLongitude().degrees + (double)j * d2);
                fArray2[i * n + j] = (float)(sector.getMaxLatitude().degrees - (double)i * d);
            }
        }
        double d3 = angle.cos();
        double d4 = angle.sin();
        LatLon latLon = sector.getCentroid();
        float f = (float)latLon.getLongitude().degrees;
        float f2 = (float)latLon.getLatitude().degrees;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n3 = i * n + j;
                float f3 = fArray[n3];
                float f4 = fArray2[n3];
                fArray[n3] = (float)((double)(f3 - f) * d3 - (double)(f4 - f2) * d4 + (double)f);
                fArray2[n3] = (float)((double)(f3 - f) * d4 + (double)(f4 - f2) * d3 + (double)f2);
            }
        }
        return new float[][]{fArray2, fArray};
    }

    protected static ArrayList<LatLon> makeBorder(float[][] fArray, int n, int n2, ArrayList<LatLon> arrayList) {
        int n3;
        for (n3 = 0; n3 < n; ++n3) {
            arrayList.add(LatLon.fromDegrees((double)fArray[0][n3], (double)fArray[1][n3]));
        }
        for (n3 = 2 * n - 1; n3 < n2 * n; n3 += n) {
            arrayList.add(LatLon.fromDegrees((double)fArray[0][n3], (double)fArray[1][n3]));
        }
        for (n3 = n * n2 - 2; n3 > n * (n2 - 1); --n3) {
            arrayList.add(LatLon.fromDegrees((double)fArray[0][n3], (double)fArray[1][n3]));
        }
        for (n3 = n * (n2 - 2); n3 > 0; n3 -= n) {
            arrayList.add(LatLon.fromDegrees((double)fArray[0][n3], (double)fArray[1][n3]));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        String string;
        ImageUtil.AlignedImage alignedImage;
        final ArrayList<LatLon> arrayList = new ArrayList<LatLon>();
        final ApplicationTemplate.AppFrame appFrame = GliderTestApp.start("GLIDER Test Application", GliderAppFrame.class);
        InputStream inputStream = null;
        try {
            inputStream = WWIO.openFileOrResourceStream((String)cloudImagePath, null);
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            long l = System.currentTimeMillis();
            float[][] fArray = GliderTestApp.makeField(corners, bufferedImage.getWidth(), bufferedImage.getHeight(), Angle.fromDegrees((double)15.0));
            GliderTestApp.makeBorder(fArray, bufferedImage.getWidth(), bufferedImage.getHeight(), arrayList);
            alignedImage = GliderImage.alignImage(bufferedImage, fArray[0], fArray[1]);
            System.out.printf("Image projected, %d ms\n", System.currentTimeMillis() - l);
            string = WWIO.getFilename((String)cloudImagePath);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        finally {
            WWIO.closeStream((Object)inputStream, (String)cloudImagePath);
        }
        appFrame.getWwd().addPropertyChangeListener("gov.nasa.worldwind.glider.ImageSource", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                appFrame.getLayerPanel().update(appFrame.getWwd());
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                final GliderImage gliderImage = new GliderImage(string, alignedImage, 100.0);
                GliderRegionOfInterest gliderRegionOfInterest = new GliderRegionOfInterest(arrayList, Color.RED);
                gliderImage.addRegionOfInterest(gliderRegionOfInterest);
                Timer timer = new Timer(1000, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            if (((GliderWorldWindow)((GliderAppFrame)appFrame).getWwd()).getImages().size() == 0) {
                                System.out.println("ADDING");
                                ((GliderWorldWindow)((GliderAppFrame)appFrame).getWwd()).addImage(gliderImage);
                                gliderImage.releaseImageSource();
                            }
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                });
                timer.setRepeats(false);
                timer.start();
            }
        });
    }

    public static class GliderAppFrame
    extends ApplicationTemplate.AppFrame {
        public GliderAppFrame() {
            super(true, true, false);
        }

        @Override
        protected ApplicationTemplate.AppPanel createAppPanel(Dimension dimension, boolean bl) {
            return new GliderAppPanel(dimension, bl);
        }
    }

    public static class GliderAppPanel
    extends ApplicationTemplate.AppPanel {
        public GliderAppPanel(Dimension dimension, boolean bl) {
            super(dimension, bl);
        }

        @Override
        protected WorldWindow createWorldWindow() {
            return new GliderWorldWindow();
        }
    }
}

