/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.glider;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.awt.WorldWindowGLCanvas;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwindx.applications.glider.GliderImage;
import gov.nasa.worldwindx.applications.glider.GliderImageLayer;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public class GliderWorldWindow
extends WorldWindowGLCanvas {
    protected CopyOnWriteArraySet<GliderImage> imageTable = new CopyOnWriteArraySet();
    protected LayerListener layerListener = new LayerListener();

    public void addImage(GliderImage gliderImage) throws IOException {
        if (gliderImage == null) {
            String string = Logging.getMessage((String)"nullValue.ImageIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.imageTable.contains((Object)gliderImage)) {
            this.removeImage(gliderImage);
        }
        GliderImageLayer gliderImageLayer = new GliderImageLayer();
        gliderImage.setValue("gov.nasa.worldwind.avkey.LayerObject", (Object)gliderImageLayer);
        gliderImageLayer.setImage(gliderImage);
        ApplicationTemplate.insertBeforeCompass((WorldWindow)this, (Layer)gliderImageLayer);
        gliderImageLayer.addPropertyChangeListener(this.layerListener);
        this.imageTable.add(gliderImage);
        this.firePropertyChange("gov.nasa.worldwind.glider.ImageSource", null, (Object)gliderImage);
        this.repaint();
    }

    public void removeImage(GliderImage gliderImage) {
        if (gliderImage == null) {
            String string = Logging.getMessage((String)"nullValue.ImageIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.imageTable.remove((Object)gliderImage);
        Layer layer = (Layer)gliderImage.getValue("gov.nasa.worldwind.avkey.LayerObject");
        if (layer != null) {
            gliderImage.removeKey("gov.nasa.worldwind.avkey.LayerObject");
            layer.removePropertyChangeListener((PropertyChangeListener)this.layerListener);
            this.getModel().getLayers().remove(layer);
            layer.dispose();
        }
        this.firePropertyChange("gov.nasa.worldwind.glider.ImageSource", null, (Object)gliderImage);
        this.repaint();
    }

    public Set<GliderImage> getImages() {
        return Collections.unmodifiableSet(this.imageTable);
    }

    public boolean containsImage(GliderImage gliderImage) {
        return gliderImage != null && this.imageTable.contains((Object)gliderImage);
    }

    protected class LayerListener
    implements PropertyChangeListener {
        protected LayerListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            GliderWorldWindow.this.firePropertyChange("gov.nasa.worldwind.glider.ImageSource", null, this);
            GliderWorldWindow.this.repaint();
        }
    }
}

