/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.sar;

import gov.nasa.worldwind.Restorable;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.ContourLinePolygon;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.PatternFactory;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.render.SurfacePolygon;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RestorableSupport;
import gov.nasa.worldwind.util.WWMath;
import gov.nasa.worldwindx.applications.sar.ElevationPlane;
import gov.nasa.worldwindx.applications.sar.SAR2;
import gov.nasa.worldwindx.applications.sar.render.ScreenElevationLine;
import java.awt.Color;
import java.io.Serializable;
import java.lang.constant.Constable;
import java.util.ArrayList;

public class CloudCeiling
implements Restorable {
    public static String DELTA_MODE_PLUS = "Sar.CloudCeiling.DeltaModePlus";
    public static String DELTA_MODE_MINUS = "Sar.CloudCeiling.DeltaModeMinus";
    public static String DELTA_MODE_BOTH = "Sar.CloudCeiling.DeltaModeBoth";
    private WorldWindow wwd;
    private RenderableLayer layer = new RenderableLayer();
    private ContourLinePolygon[] lines = new ContourLinePolygon[2];
    private ScreenElevationLine[] screenLines = new ScreenElevationLine[2];
    private ElevationPlane[] planes = new ElevationPlane[2];
    private String name = "";
    private boolean enabled = true;
    private boolean showExtent = false;
    private String elevationUnit = "Imperial";
    private Color color = Color.WHITE;
    private String pattern = "PatternFactory.PatternCircles";
    private double patternSize = 150.0;
    private double planeOpacity = 0.3;
    private double elevationBase = 0.0;
    private double elevationDelta = 0.0;
    private String deltaMode = DELTA_MODE_PLUS;
    private ArrayList<? extends LatLon> centerPositions;
    private ArrayList<LatLon> extentPositions;
    private double radius = 10000.0;
    private SurfacePolygon shape;

    public CloudCeiling(WorldWindow worldWindow) {
        this.wwd = worldWindow;
        this.lines[0] = new ContourLinePolygon();
        this.lines[1] = new ContourLinePolygon();
        this.screenLines[0] = new ScreenElevationLine();
        this.screenLines[1] = new ScreenElevationLine();
        this.planes[0] = new ElevationPlane();
        this.planes[1] = new ElevationPlane();
        this.setPatternSize(this.patternSize);
        this.setColor(this.color);
        this.updateElevations();
        this.layer.addRenderable((Renderable)this.lines[0]);
        this.layer.addRenderable((Renderable)this.lines[1]);
        this.layer.addRenderable((Renderable)this.screenLines[0]);
        this.layer.addRenderable((Renderable)this.screenLines[1]);
        this.layer.addRenderable((Renderable)this.planes[0]);
        this.layer.addRenderable((Renderable)this.planes[1]);
        this.layer.setPickEnabled(false);
        this.wwd.getModel().getLayers().add((Layer)this.layer);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        this.lines[0].setEnabled(bl);
        this.screenLines[0].setEnabled(bl);
        this.planes[0].setVisible(bl);
        if (this.elevationDelta > 0.0) {
            this.lines[1].setEnabled(bl);
            this.screenLines[1].setEnabled(bl);
            this.planes[1].setVisible(bl);
        }
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
        this.lines[0].setColor(color.darker());
        this.lines[1].setColor(color.brighter());
        this.screenLines[0].setColor(color.darker());
        this.screenLines[1].setColor(color.brighter());
        this.planes[0].setImageSource(PatternFactory.createPattern((String)this.pattern, (Color)CloudCeiling.computeAlphaColor(color.darker(), this.planeOpacity)));
        this.planes[1].setImageSource(PatternFactory.createPattern((String)this.pattern, (Color)CloudCeiling.computeAlphaColor(color.brighter(), this.planeOpacity)));
    }

    public double getPlaneOpacity() {
        return this.planeOpacity;
    }

    public void setPlaneOpacity(double d) {
        if (this.planeOpacity == d) {
            return;
        }
        this.planeOpacity = d;
        this.setColor(this.getColor());
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String string) {
        if (this.pattern.equals(string)) {
            return;
        }
        this.pattern = string;
        this.setColor(this.getColor());
    }

    public double getPatternSize() {
        return this.patternSize;
    }

    public void setPatternSize(double d) {
        this.patternSize = d;
        this.planes[0].setImageSize(d);
        this.planes[1].setImageSize(d);
    }

    public String getElevationUnit() {
        return this.elevationUnit;
    }

    public void setElevationUnit(String string) {
        if (!this.elevationUnit.equals(string)) {
            if ("Imperial".equals(string)) {
                this.elevationBase = SAR2.metersToFeet(this.elevationBase);
                this.elevationDelta = SAR2.metersToFeet(this.elevationDelta);
            } else {
                this.elevationBase = SAR2.feetToMeters(this.elevationBase);
                this.elevationDelta = SAR2.feetToMeters(this.elevationDelta);
            }
            this.elevationUnit = string;
        }
    }

    public double getElevationBase() {
        return this.elevationBase;
    }

    public void setElevationBase(double d) {
        if (this.elevationBase == d) {
            return;
        }
        this.elevationBase = d;
        this.updateElevations();
    }

    public double getElevationDelta() {
        return this.elevationDelta;
    }

    public void setElevationDelta(double d) {
        if (this.elevationDelta == d) {
            return;
        }
        this.elevationDelta = d;
        this.updateElevations();
    }

    public String getDeltaMode() {
        return this.deltaMode;
    }

    public void setDeltaMode(String string) {
        if (this.deltaMode.equals(string)) {
            return;
        }
        this.deltaMode = string;
        this.updateElevations();
    }

    public void relocateLayerOnTop() {
        this.wwd.getModel().getLayers().remove((Layer)this.layer);
        this.wwd.getModel().getLayers().add((Layer)this.layer);
    }

    private void updateElevations() {
        double d;
        double d2 = d = "Imperial".equals(this.elevationUnit) ? SAR2.feetToMeters(1.0) : 1.0;
        if (this.deltaMode.equals(DELTA_MODE_PLUS)) {
            this.lines[0].setElevation(this.elevationBase * d);
            this.lines[1].setElevation((this.elevationBase + this.elevationDelta) * d);
        } else if (this.deltaMode.equals(DELTA_MODE_MINUS)) {
            this.lines[0].setElevation((this.elevationBase - this.elevationDelta) * d);
            this.lines[1].setElevation(this.elevationBase * d);
        } else if (this.deltaMode.equals(DELTA_MODE_BOTH)) {
            this.lines[0].setElevation((this.elevationBase - this.elevationDelta) * d);
            this.lines[1].setElevation((this.elevationBase + this.elevationDelta) * d);
        }
        if (this.elevationDelta > 0.0) {
            this.lines[1].setEnabled(this.isEnabled());
        } else {
            this.lines[1].setEnabled(false);
        }
        this.screenLines[0].setElevation(this.lines[0].getElevation());
        this.screenLines[1].setElevation(this.lines[1].getElevation());
        this.planes[0].setAltitude(this.lines[0].getElevation());
        this.planes[1].setAltitude(this.lines[1].getElevation());
        this.screenLines[1].setEnabled(this.lines[1].isEnabled());
        this.planes[1].setVisible(this.lines[1].isEnabled());
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double d) {
        if (this.radius == d) {
            return;
        }
        this.radius = d;
        this.updateExtent();
    }

    public ArrayList<? extends LatLon> getPositions() {
        return this.centerPositions;
    }

    public void setPositions(ArrayList<? extends LatLon> arrayList) {
        boolean bl = false;
        if (this.centerPositions != null && this.centerPositions.size() == arrayList.size()) {
            for (int i = 0; i < arrayList.size(); ++i) {
                if (this.centerPositions.get(i).equals((Object)arrayList.get(i))) continue;
                bl = true;
            }
        } else {
            bl = true;
        }
        if (!bl) {
            return;
        }
        this.centerPositions = arrayList;
        this.updateExtent();
    }

    private void updateExtent() {
        if (this.centerPositions == null || this.radius <= 0.0) {
            return;
        }
        this.computeExtentPositions();
        this.lines[0].setPositions(this.extentPositions);
        this.lines[1].setPositions(this.extentPositions);
        this.planes[0].setLocations(this.extentPositions);
        this.planes[1].setLocations(this.extentPositions);
        this.updateExtentShape();
    }

    private void updateExtentShape() {
        if (this.shape != null) {
            this.layer.removeRenderable((Renderable)this.shape);
        }
        if (this.enabled && this.showExtent && this.extentPositions != null && this.extentPositions.size() > 0) {
            this.shape = new SurfacePolygon(this.extentPositions);
            BasicShapeAttributes basicShapeAttributes = new BasicShapeAttributes();
            basicShapeAttributes.setDrawOutline(false);
            basicShapeAttributes.setInteriorMaterial(Material.WHITE);
            basicShapeAttributes.setInteriorOpacity(0.1);
            this.shape.setAttributes((ShapeAttributes)basicShapeAttributes);
            this.layer.addRenderable((Renderable)this.shape);
        }
    }

    private void computeExtentPositions() {
        Angle angle;
        Angle angle2;
        Globe globe = this.wwd.getModel().getGlobe();
        this.extentPositions = new ArrayList();
        Angle angle3 = Angle.ZERO;
        int n = 0;
        if (this.centerPositions.size() > 1) {
            angle3 = LatLon.greatCircleAzimuth((LatLon)this.centerPositions.get(n), (LatLon)this.centerPositions.get(n + 1));
        }
        this.extentPositions.addAll(CloudCeiling.computeArcPositions(globe, this.centerPositions.get(n), angle3.addDegrees(90.0), angle3.addDegrees(270.0), this.radius));
        while (n < this.centerPositions.size() - 1) {
            angle2 = angle3;
            angle = angle3 = LatLon.greatCircleAzimuth((LatLon)this.centerPositions.get(n), (LatLon)this.centerPositions.get(n + 1));
            if (n < this.centerPositions.size() - 2) {
                angle = LatLon.greatCircleAzimuth((LatLon)this.centerPositions.get(n + 1), (LatLon)this.centerPositions.get(n + 2));
            }
            this.extentPositions.addAll(CloudCeiling.computeLinePositions(globe, this.centerPositions.get(n), this.centerPositions.get(n + 1), angle2, angle3, angle, this.radius));
            ++n;
        }
        angle3 = CloudCeiling.normalizedHeading(angle3.addDegrees(180.0));
        this.extentPositions.addAll(CloudCeiling.computeArcPositions(globe, this.centerPositions.get(n), angle3.addDegrees(90.0), angle3.addDegrees(270.0), this.radius));
        for (n = this.centerPositions.size() - 1; n > 0; --n) {
            angle2 = angle3;
            angle = angle3 = LatLon.greatCircleAzimuth((LatLon)this.centerPositions.get(n), (LatLon)this.centerPositions.get(n - 1));
            if (n > 1) {
                angle = LatLon.greatCircleAzimuth((LatLon)this.centerPositions.get(n - 1), (LatLon)this.centerPositions.get(n - 2));
            }
            this.extentPositions.addAll(CloudCeiling.computeLinePositions(globe, this.centerPositions.get(n), this.centerPositions.get(n - 1), angle2, angle3, angle, this.radius));
        }
        this.extentPositions.add(this.extentPositions.get(0));
    }

    private static ArrayList<LatLon> computeArcPositions(Globe globe, LatLon latLon, Angle angle, Angle angle2, double d) {
        angle = CloudCeiling.normalizedHeading(angle);
        angle2 = CloudCeiling.normalizedHeading(angle2);
        angle2 = angle2.degrees > angle.degrees ? angle2 : angle2.addDegrees(360.0);
        ArrayList<LatLon> arrayList = new ArrayList<LatLon>();
        Angle angle3 = Angle.fromRadians((double)(d / globe.getRadiusAt(latLon)));
        arrayList.add(LatLon.greatCircleEndPosition((LatLon)latLon, (Angle)Angle.midAngle((Angle)angle, (Angle)angle2), (Angle)angle3));
        arrayList.add(LatLon.greatCircleEndPosition((LatLon)latLon, (Angle)angle2, (Angle)angle3));
        return arrayList;
    }

    private static ArrayList<LatLon> computeLinePositions(Globe globe, LatLon latLon, LatLon latLon2, Angle angle, Angle angle2, Angle angle3, double d) {
        ArrayList<LatLon> arrayList = new ArrayList<LatLon>();
        Angle angle4 = Angle.fromRadians((double)(d / globe.getRadiusAt(latLon)));
        if (CloudCeiling.isClockwiseHeadingChange(angle2, angle3)) {
            arrayList.add(LatLon.greatCircleEndPosition((LatLon)latLon2, (Angle)angle2.subtractDegrees(90.0), (Angle)angle4));
            if (!angle2.equals((Object)angle3)) {
                arrayList.addAll(CloudCeiling.computeArcPositions(globe, latLon2, angle2.subtractDegrees(90.0), angle3.subtractDegrees(90.0), d));
            }
        } else {
            arrayList.add(LatLon.greatCircleEndPosition((LatLon)latLon2, (Angle)CloudCeiling.computeMidHeading(angle2, angle3).subtractDegrees(90.0), (Angle)angle4));
        }
        return arrayList;
    }

    private static boolean isClockwiseHeadingChange(Angle angle, Angle angle2) {
        double d = CloudCeiling.normalizedHeading((Angle)angle2).degrees;
        double d2 = CloudCeiling.normalizedHeading((Angle)angle).degrees;
        return d > d2 && d - d2 < 180.0;
    }

    private static Angle computeMidHeading(Angle angle, Angle angle2) {
        angle = CloudCeiling.normalizedHeading(angle);
        angle2 = CloudCeiling.normalizedHeading(angle2);
        if (angle.degrees < angle2.degrees && angle2.degrees - angle.degrees > 180.0) {
            angle = angle.addDegrees(360.0);
        } else if (angle2.degrees < angle.degrees && angle.degrees - angle2.degrees > 180.0) {
            angle2 = angle2.addDegrees(360.0);
        }
        return Angle.midAngle((Angle)angle, (Angle)angle2);
    }

    private static Angle normalizedHeading(Angle angle) {
        double d;
        for (d = angle.degrees % 360.0; d < 0.0; d += 360.0) {
        }
        return Angle.fromDegrees((double)d);
    }

    private static Color computePremultipliedAlphaColor(Color color, double d) {
        float[] fArray = new float[4];
        color.getRGBComponents(fArray);
        fArray[3] = (float)WWMath.clamp((double)d, (double)0.0, (double)1.0);
        return new Color(fArray[0] * fArray[3], fArray[1] * fArray[3], fArray[2] * fArray[3], fArray[3]);
    }

    private static Color computeAlphaColor(Color color, double d) {
        float[] fArray = new float[4];
        color.getRGBComponents(fArray);
        fArray[3] = (float)WWMath.clamp((double)d, (double)0.0, (double)1.0);
        return new Color(fArray[0], fArray[1], fArray[2], fArray[3]);
    }

    public String getRestorableState() {
        String string;
        RestorableSupport restorableSupport = RestorableSupport.newRestorableSupport();
        if (restorableSupport == null) {
            return null;
        }
        restorableSupport.addStateValueAsString("name", this.name);
        if (this.color != null && (string = RestorableSupport.encodeColor((Color)this.color)) != null) {
            restorableSupport.addStateValueAsString("color", string);
        }
        if (this.centerPositions != null && (string = restorableSupport.addStateObject("positions")) != null) {
            for (LatLon latLon : this.centerPositions) {
                RestorableSupport.StateObject stateObject;
                if (latLon == null || latLon.getLatitude() == null || latLon.getLongitude() == null || (stateObject = restorableSupport.addStateObject((RestorableSupport.StateObject)string, "position")) == null) continue;
                restorableSupport.addStateValueAsDouble(stateObject, "latitudeDegrees", latLon.getLatitude().degrees);
                restorableSupport.addStateValueAsDouble(stateObject, "longitudeDegrees", latLon.getLongitude().degrees);
            }
        }
        restorableSupport.addStateValueAsString("elevationUnit", this.elevationUnit);
        restorableSupport.addStateValueAsString("deltaMode", this.deltaMode);
        restorableSupport.addStateValueAsDouble("elevationDelta", this.elevationDelta);
        restorableSupport.addStateValueAsDouble("elevationBase", this.elevationBase);
        restorableSupport.addStateValueAsDouble("radius", this.radius);
        restorableSupport.addStateValueAsBoolean("enabled", this.enabled);
        restorableSupport.addStateValueAsBoolean("showExtent", this.showExtent);
        restorableSupport.addStateValueAsString("pattern", this.pattern);
        restorableSupport.addStateValueAsDouble("patternSize", this.patternSize);
        restorableSupport.addStateValueAsDouble("planeOpacity", this.planeOpacity);
        return restorableSupport.getStateAsXml();
    }

    public void restoreState(String string) {
        Serializable serializable;
        String string2;
        String string3;
        Double d;
        Double d2;
        Double d3;
        Constable constable;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        RestorableSupport restorableSupport;
        if (string == null) {
            String string4 = Logging.getMessage((String)"nullValue.StringIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        try {
            restorableSupport = RestorableSupport.parse((String)string);
        }
        catch (Exception exception) {
            String string5 = Logging.getMessage((String)"generic.ExceptionAttemptingToParseStateXml", (String)string);
            Logging.logger().severe(string5);
            throw new IllegalArgumentException(string5, exception);
        }
        RestorableSupport.StateObject stateObject = restorableSupport.getStateObject("positions");
        if (stateObject != null) {
            object4 = new ArrayList();
            object3 = restorableSupport.getAllStateObjects(stateObject, "position");
            if (object3 != null && ((RestorableSupport.StateObject[])object3).length != 0) {
                object2 = object3;
                int n = ((RestorableSupport.StateObject[])object2).length;
                for (int i = 0; i < n; ++i) {
                    object = object2[i];
                    if (object == null) continue;
                    constable = restorableSupport.getStateValueAsDouble((RestorableSupport.StateObject)object, "latitudeDegrees");
                    d3 = restorableSupport.getStateValueAsDouble((RestorableSupport.StateObject)object, "longitudeDegrees");
                    if (constable == null || d3 == null) continue;
                    ((ArrayList)object4).add(LatLon.fromDegrees((double)((Double)constable), (double)d3));
                }
            }
            this.centerPositions = object4;
        }
        if ((object4 = restorableSupport.getStateValueAsString("name")) != null) {
            this.name = object4;
        }
        if ((object3 = restorableSupport.getStateValueAsString("elevationUnit")) != null) {
            this.elevationUnit = object3;
        }
        if ((object2 = restorableSupport.getStateValueAsString("deltaMode")) != null) {
            this.deltaMode = object2;
        }
        if ((d2 = restorableSupport.getStateValueAsDouble("elevationDelta")) != null) {
            this.elevationDelta = d2;
        }
        if ((d = restorableSupport.getStateValueAsDouble("elevationBase")) != null) {
            this.elevationBase = d;
        }
        if ((object = restorableSupport.getStateValueAsDouble("radius")) != null) {
            this.radius = (Double)object;
        }
        if ((constable = restorableSupport.getStateValueAsBoolean("enabled")) != null) {
            this.setEnabled((Boolean)constable);
        }
        if ((d3 = restorableSupport.getStateValueAsDouble("patternSize")) != null) {
            this.setPatternSize(d3);
        }
        Double d4 = restorableSupport.getStateValueAsDouble("planeOpacity");
        if (d3 != null) {
            this.planeOpacity = d4;
        }
        if ((string3 = restorableSupport.getStateValueAsString("pattern")) != null) {
            this.pattern = string3;
        }
        if ((string2 = restorableSupport.getStateValueAsString("color")) != null && (serializable = RestorableSupport.decodeColor((String)string2)) != null) {
            this.setColor((Color)serializable);
        }
        if ((serializable = restorableSupport.getStateValueAsBoolean("showExtent")) != null) {
            this.showExtent = (Boolean)serializable;
        }
        this.updateElevations();
        this.updateExtent();
    }
}

