/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.sar;

import gov.nasa.worldwind.Restorable;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RestorableSupport;
import gov.nasa.worldwind.util.WWMath;
import gov.nasa.worldwindx.applications.sar.CloudCeiling;
import gov.nasa.worldwindx.applications.sar.SAR2;
import gov.nasa.worldwindx.applications.sar.SARPosition;
import gov.nasa.worldwindx.applications.sar.SARTrack;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerListModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CloudCeilingPanel
extends JPanel
implements Restorable {
    public static final String CLOUD_CEILING_OPEN = "CloudCeilingPanel.CloudCeilingOpen";
    public static final String CLOUD_CEILING_CHANGE = "CloudCeilingPanel.CloudCeilingChange";
    private static final String SIZE_SMALL = "Small";
    private static final String SIZE_MEDIUM = "Medium";
    private static final String SIZE_LARGE = "Large";
    private static final String PATTERN_STRIPES = "Stripes";
    private static final String PATTERN_CROSS_HATCHED = "Cross Hatched";
    private static final String PATTERN_DOTS = "Dots";
    private CloudCeiling cloudCeiling;
    private SARTrack track;
    private int trackCurrentPositionNumber;
    private String elevationUnit = "Imperial";
    private boolean suspendEvents = false;
    private Box controlPanel;
    private Box advancedPanel;
    private JLabel descriptionLabel;
    private JTextField descriptionTextField;
    private JCheckBox enabledCheckBox;
    private JLabel baseElevationLabel;
    private JTextField baseElevationTextField;
    private JLabel elevationUnitLabel1;
    private JLabel elevationUnitLabel2;
    private JLabel deltaElevationLabel;
    private JTextField deltaElevationTextField;
    private ButtonGroup deltaModeGroup;
    private JRadioButton deltaPlusRadioButton;
    private JRadioButton deltaMinusRadioButton;
    private JRadioButton deltaBothRadioButton;
    private JLabel incrementLabel;
    private JSpinner incrementSpinner;
    private JButton incrementPlusButton;
    private JButton incrementMinusButton;
    private JButton incrementResetButton;
    private JLabel incrementedBaseLabel;
    private JButton advancedButton;
    private JLabel segmentsFromLabel;
    private JLabel segmentsToLabel;
    private JSpinner segmentStartSpinner;
    private JSpinner segmentEndSpinner;
    private JCheckBox currentSegmentCheckBox;
    private JCheckBox wholeTrackCheckBox;
    private JLabel patternLabel;
    private JComboBox patternCombo;
    private JComboBox patternSizeCombo;
    private JLabel opacityLabel;
    private JSpinner opacitySpinner;
    private JButton colorButton;

    public CloudCeilingPanel() {
        this.initComponents();
    }

    public CloudCeiling getCloudCeiling() {
        return this.cloudCeiling;
    }

    public void setCloudCeiling(CloudCeiling cloudCeiling) {
        this.cloudCeiling = cloudCeiling;
        this.updateCloudCeiling();
    }

    public SARTrack getTrack() {
        return this.track;
    }

    public void setTrack(SARTrack sARTrack) {
        this.track = sARTrack;
        this.trackCurrentPositionNumber = this.clampTrackCurrentPosition(this.trackCurrentPositionNumber, sARTrack);
        this.updateSegmentSpinnersList();
        this.updateCloudCeiling();
        this.cloudCeiling.relocateLayerOnTop();
    }

    public void setTrackCurrentPositionNumber(int n) {
        if (this.trackCurrentPositionNumber == n) {
            return;
        }
        this.trackCurrentPositionNumber = n;
        if (this.currentSegmentCheckBox.isSelected()) {
            this.suspendEvents = true;
            this.setSegmentSpinnerValue(this.segmentStartSpinner, n);
            this.setSegmentSpinnerValue(this.segmentEndSpinner, n);
            this.suspendEvents = false;
            this.updateCloudCeiling();
        }
    }

    public String getElevationUnit() {
        return this.elevationUnit;
    }

    public void setElevationUnit(String string) {
        if (!this.elevationUnit.equals(string)) {
            this.cloudCeiling.setElevationUnit(string);
            double d = this.getNumberValue(this.baseElevationTextField.getText());
            double d2 = this.getNumberValue(this.deltaElevationTextField.getText());
            double d3 = this.getNumberValue(this.incrementedBaseLabel.getText());
            if ("Imperial".equals(this.elevationUnit)) {
                d = SAR2.feetToMeters(d);
                d2 = SAR2.feetToMeters(d2);
                d3 = SAR2.feetToMeters(d3);
                this.baseElevationTextField.setText(String.format("%.0f", d));
                this.deltaElevationTextField.setText(String.format("%.0f", d2));
                this.incrementedBaseLabel.setText(String.format("%.0f", d3));
                this.elevationUnitLabel1.setText("m");
                this.elevationUnitLabel2.setText("m");
            } else {
                d = SAR2.metersToFeet(d);
                d2 = SAR2.metersToFeet(d2);
                d3 = SAR2.metersToFeet(d3);
                this.baseElevationTextField.setText(String.format("%.0f", d));
                this.deltaElevationTextField.setText(String.format("%.0f", d2));
                this.incrementedBaseLabel.setText(String.format("%.0f", d3));
                this.elevationUnitLabel1.setText("ft");
                this.elevationUnitLabel2.setText("ft");
            }
            this.elevationUnit = string;
        }
    }

    private int clampTrackCurrentPosition(int n, SARTrack sARTrack) {
        if (sARTrack.size() == 0) {
            return 0;
        }
        return WWMath.clamp((int)n, (int)0, (int)(sARTrack.size() - 1));
    }

    private void descriptionTextFieldActionPerformed(ActionEvent actionEvent) {
        this.updateCloudCeiling();
    }

    private void enabledCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.updateCloudCeiling();
    }

    private void baseElevationTextFieldActionPerformed(ActionEvent actionEvent) {
        Double d = this.getNumberValue(this.baseElevationTextField.getText());
        this.baseElevationTextField.setText(String.format("%.0f", d));
        this.incrementedBaseLabel.setText(String.format("%.0f", d));
        this.updateCloudCeiling();
    }

    private void deltaElevationTextFieldActionPerformed(ActionEvent actionEvent) {
        this.deltaElevationTextField.setText(String.format("%.0f", this.getNumberValue(this.deltaElevationTextField.getText())));
        this.updateCloudCeiling();
    }

    private void deltaModeRadioButtonActionPerformed(ActionEvent actionEvent) {
        this.updateCloudCeiling();
    }

    private void advancedButtonActionPerformed(ActionEvent actionEvent) {
        Dimension dimension = this.getTopLevelAncestor().getSize();
        int n = dimension.width - this.getPreferredSize().width;
        int n2 = dimension.height - this.getPreferredSize().height;
        if (this.advancedPanel.isVisible()) {
            this.advancedPanel.setVisible(false);
            this.advancedButton.setText("Advanced...");
        } else {
            this.advancedPanel.setVisible(true);
            this.advancedButton.setText("...Simple");
        }
        this.validate();
        this.getTopLevelAncestor().setSize(new Dimension(this.getPreferredSize().width + n, this.getPreferredSize().height + n2));
        this.getTopLevelAncestor().validate();
    }

    private void segmentSpinnerStateChanged(ChangeEvent changeEvent) {
        int n;
        int n2 = Integer.parseInt(((String)this.segmentStartSpinner.getValue()).trim());
        if (n2 > (n = Integer.parseInt(((String)this.segmentEndSpinner.getValue()).trim()))) {
            if (changeEvent.getSource().equals(this.segmentStartSpinner)) {
                this.setSegmentSpinnerValue(this.segmentEndSpinner, n2);
            } else {
                this.setSegmentSpinnerValue(this.segmentStartSpinner, n);
            }
        }
        this.currentSegmentCheckBox.setSelected(false);
        this.wholeTrackCheckBox.setSelected(false);
        this.updateCloudCeiling();
    }

    private void wholeTrackCheckBoxActionPerformed(ActionEvent actionEvent) {
        if (this.wholeTrackCheckBox.isSelected()) {
            this.currentSegmentCheckBox.setSelected(false);
            if (this.track != null && this.track.size() > 0) {
                this.suspendEvents = true;
                this.setSegmentSpinnerValue(this.segmentStartSpinner, 0);
                this.setSegmentSpinnerValue(this.segmentEndSpinner, this.track.size() - 1);
                this.suspendEvents = false;
                this.updateCloudCeiling();
            }
        }
    }

    private void currentSegmentCheckBoxActionPerformed(ActionEvent actionEvent) {
        if (this.currentSegmentCheckBox.isSelected()) {
            this.wholeTrackCheckBox.setSelected(false);
            if (this.track != null && this.track.size() > 0) {
                this.suspendEvents = true;
                this.setSegmentSpinnerValue(this.segmentStartSpinner, this.trackCurrentPositionNumber);
                this.setSegmentSpinnerValue(this.segmentEndSpinner, this.trackCurrentPositionNumber);
                this.suspendEvents = false;
                this.updateCloudCeiling();
            }
        }
    }

    private void incrementButtonActionPerformed(ActionEvent actionEvent) {
        Double d;
        if (actionEvent.getSource().equals(this.incrementResetButton)) {
            d = this.getNumberValue(this.baseElevationTextField.getText());
        } else {
            d = this.getNumberValue(this.incrementedBaseLabel.getText());
            int n = Integer.parseInt(((String)this.incrementSpinner.getValue()).trim());
            d = actionEvent.getSource().equals(this.incrementPlusButton) ? Double.valueOf(d + (double)n) : Double.valueOf(d - (double)n);
        }
        this.incrementedBaseLabel.setText(String.format("%.0f", d));
        this.updateCloudCeiling();
    }

    private void colorButtonActionPerformed(ActionEvent actionEvent) {
        Color color = JColorChooser.showDialog(this, "Choose a color...", ((JButton)actionEvent.getSource()).getBackground());
        if (color != null) {
            ((JButton)actionEvent.getSource()).setBackground(color);
            this.updateCloudCeiling();
        }
    }

    private void patternComboActionPerformed(ActionEvent actionEvent) {
        this.updateCloudCeiling();
    }

    private void patternSizeComboActionPerformed(ActionEvent actionEvent) {
        this.updateCloudCeiling();
    }

    private void opacitySpinnerChanged(ChangeEvent changeEvent) {
        this.updateCloudCeiling();
    }

    private Double getNumberValue(String string) {
        double d;
        try {
            d = Double.parseDouble(string);
        }
        catch (Exception exception) {
            d = 0.0;
        }
        return d;
    }

    private void updateSegmentSpinnersList() {
        int n;
        Object[] objectArray = new String[this.track != null ? this.track.size() : 0];
        for (n = 0; n < objectArray.length; ++n) {
            objectArray[n] = String.format("%,4d", n);
        }
        if (objectArray.length == 0) {
            objectArray = new String[]{"   0"};
        }
        this.suspendEvents = true;
        n = Math.min(Integer.parseInt(((String)this.segmentStartSpinner.getValue()).trim()), objectArray.length - 1);
        int n2 = Math.min(Integer.parseInt(((String)this.segmentEndSpinner.getValue()).trim()), objectArray.length - 1);
        this.segmentStartSpinner.setModel(new SpinnerListModel(objectArray));
        this.segmentStartSpinner.setValue(objectArray[n]);
        this.segmentEndSpinner.setModel(new SpinnerListModel(objectArray));
        this.segmentEndSpinner.setValue(objectArray[n2]);
        if (this.currentSegmentCheckBox.isSelected()) {
            this.currentSegmentCheckBoxActionPerformed(null);
        } else if (this.wholeTrackCheckBox.isSelected()) {
            this.wholeTrackCheckBoxActionPerformed(null);
        }
        this.suspendEvents = false;
    }

    private void setSegmentSpinnerValue(JSpinner jSpinner, int n) {
        jSpinner.setValue(String.format("%,4d", n));
    }

    private void updateCloudCeiling() {
        if (this.cloudCeiling == null) {
            return;
        }
        this.cloudCeiling.setName(this.descriptionTextField.getText());
        this.cloudCeiling.setEnabled(this.enabledCheckBox.isSelected());
        this.cloudCeiling.setElevationBase(this.getNumberValue(this.incrementedBaseLabel.getText()));
        this.cloudCeiling.setElevationDelta(this.getNumberValue(this.deltaElevationTextField.getText()));
        if (this.deltaPlusRadioButton.isSelected()) {
            this.cloudCeiling.setDeltaMode(CloudCeiling.DELTA_MODE_PLUS);
        } else if (this.deltaMinusRadioButton.isSelected()) {
            this.cloudCeiling.setDeltaMode(CloudCeiling.DELTA_MODE_MINUS);
        } else if (this.deltaBothRadioButton.isSelected()) {
            this.cloudCeiling.setDeltaMode(CloudCeiling.DELTA_MODE_BOTH);
        }
        this.cloudCeiling.setColor(this.colorButton.getBackground());
        this.cloudCeiling.setPattern(this.getPattern());
        this.cloudCeiling.setPatternSize(this.getPatternSize());
        this.cloudCeiling.setPlaneOpacity(Double.parseDouble((String)this.opacitySpinner.getValue()) / 10.0);
        if (this.track != null && this.track.getPositions().size() > 0) {
            int n = Integer.parseInt(((String)this.segmentStartSpinner.getValue()).trim());
            int n2 = Integer.parseInt(((String)this.segmentEndSpinner.getValue()).trim());
            if (n2 < this.track.getPositions().size() - 1) {
                ++n2;
            }
            ArrayList<SARPosition> arrayList = new ArrayList<SARPosition>(n2 - n + 1);
            for (int i = n; i <= n2; ++i) {
                arrayList.add(this.track.getPositions().get(i));
            }
            this.cloudCeiling.setPositions(arrayList);
        }
        this.firePropertyChange(CLOUD_CEILING_CHANGE, -1, 0);
        this.enableComponents(this.enabledCheckBox.isSelected());
    }

    private String getPattern() {
        String string = (String)this.patternCombo.getSelectedItem();
        if (PATTERN_CROSS_HATCHED.equals(string)) {
            return "PatternFactory.PatternHVLine";
        }
        if (PATTERN_DOTS.equals(string)) {
            return "PatternFactory.PatternCircles";
        }
        return "PatternFactory.PatternHLine";
    }

    private double getPatternSize() {
        String string = (String)this.patternSizeCombo.getSelectedItem();
        if (SIZE_SMALL.equals(string)) {
            return 50.0;
        }
        if (SIZE_LARGE.equals(string)) {
            return 500.0;
        }
        return 150.0;
    }

    private void initComponents() {
        this.setLayout(new BoxLayout(this, 3));
        this.controlPanel = Box.createVerticalBox();
        this.controlPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        Box box = Box.createHorizontalBox();
        box.setAlignmentX(0.0f);
        this.descriptionLabel = new JLabel("Name:");
        box.add(this.descriptionLabel);
        box.add(Box.createHorizontalStrut(20));
        this.descriptionTextField = new JTextField("Cloud contour", 20);
        this.descriptionTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!CloudCeilingPanel.this.suspendEvents) {
                    CloudCeilingPanel.this.descriptionTextFieldActionPerformed(actionEvent);
                }
            }
        });
        box.add(this.descriptionTextField);
        box.add(Box.createHorizontalStrut(20));
        this.enabledCheckBox = new JCheckBox("Show contour");
        this.enabledCheckBox.setSelected(false);
        this.enabledCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!CloudCeilingPanel.this.suspendEvents) {
                    CloudCeilingPanel.this.enabledCheckBoxActionPerformed(actionEvent);
                }
            }
        });
        box.add(this.enabledCheckBox);
        this.controlPanel.add(box);
        this.controlPanel.add(Box.createVerticalStrut(10));
        Box box2 = Box.createHorizontalBox();
        box2.setAlignmentX(0.0f);
        this.baseElevationLabel = new JLabel("Base:");
        box2.add(this.baseElevationLabel);
        box2.add(Box.createHorizontalStrut(10));
        this.baseElevationTextField = new JTextField("0", 5);
        this.baseElevationTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!CloudCeilingPanel.this.suspendEvents) {
                    CloudCeilingPanel.this.baseElevationTextFieldActionPerformed(actionEvent);
                }
            }
        });
        box2.add(this.baseElevationTextField);
        box2.add(Box.createHorizontalStrut(5));
        this.elevationUnitLabel1 = new JLabel("ft");
        box2.add(this.elevationUnitLabel1);
        box2.add(Box.createHorizontalStrut(20));
        this.deltaElevationLabel = new JLabel("Delta:");
        box2.add(this.deltaElevationLabel);
        box2.add(Box.createHorizontalStrut(10));
        this.deltaElevationTextField = new JTextField("0", 5);
        this.deltaElevationTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!CloudCeilingPanel.this.suspendEvents) {
                    CloudCeilingPanel.this.deltaElevationTextFieldActionPerformed(actionEvent);
                }
            }
        });
        box2.add(this.deltaElevationTextField);
        box2.add(Box.createHorizontalStrut(20));
        this.deltaPlusRadioButton = new JRadioButton("+");
        this.deltaPlusRadioButton.setSelected(true);
        this.deltaPlusRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!CloudCeilingPanel.this.suspendEvents) {
                    CloudCeilingPanel.this.deltaModeRadioButtonActionPerformed(actionEvent);
                }
            }
        });
        box2.add(this.deltaPlusRadioButton);
        this.deltaMinusRadioButton = new JRadioButton("-");
        this.deltaMinusRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!CloudCeilingPanel.this.suspendEvents) {
                    CloudCeilingPanel.this.deltaModeRadioButtonActionPerformed(actionEvent);
                }
            }
        });
        box2.add(this.deltaMinusRadioButton);
        this.deltaBothRadioButton = new JRadioButton("+/-");
        this.deltaBothRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!CloudCeilingPanel.this.suspendEvents) {
                    CloudCeilingPanel.this.deltaModeRadioButtonActionPerformed(actionEvent);
                }
            }
        });
        box2.add(this.deltaBothRadioButton);
        this.deltaModeGroup = new ButtonGroup();
        this.deltaModeGroup.add(this.deltaPlusRadioButton);
        this.deltaModeGroup.add(this.deltaMinusRadioButton);
        this.deltaModeGroup.add(this.deltaBothRadioButton);
        this.controlPanel.add(box2);
        this.controlPanel.add(Box.createVerticalStrut(10));
        Box box3 = Box.createHorizontalBox();
        box3.setAlignmentX(0.0f);
        this.incrementLabel = new JLabel("Base Increment:");
        box3.add(this.incrementLabel);
        box3.add(Box.createHorizontalStrut(20));
        this.incrementSpinner = new JSpinner(new SpinnerListModel(new String[]{"10", "50", "100", "200", "500", "1000"}));
        this.incrementSpinner.setValue("100");
        box3.add(this.incrementSpinner);
        box3.add(Box.createHorizontalStrut(20));
        this.incrementMinusButton = new JButton("Down");
        this.incrementMinusButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!CloudCeilingPanel.this.suspendEvents) {
                    CloudCeilingPanel.this.incrementButtonActionPerformed(actionEvent);
                }
            }
        });
        box3.add(this.incrementMinusButton);
        box3.add(Box.createHorizontalStrut(10));
        this.incrementedBaseLabel = new JLabel("0");
        this.incrementedBaseLabel.setPreferredSize(new Dimension(60, 16));
        this.incrementedBaseLabel.setHorizontalAlignment(4);
        box3.add(this.incrementedBaseLabel);
        box3.add(Box.createHorizontalStrut(5));
        this.elevationUnitLabel2 = new JLabel("ft");
        box3.add(this.elevationUnitLabel2);
        box3.add(Box.createHorizontalStrut(10));
        this.incrementPlusButton = new JButton("Up");
        this.incrementPlusButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!CloudCeilingPanel.this.suspendEvents) {
                    CloudCeilingPanel.this.incrementButtonActionPerformed(actionEvent);
                }
            }
        });
        box3.add(this.incrementPlusButton);
        box3.add(Box.createHorizontalStrut(10));
        this.incrementResetButton = new JButton("Reset");
        this.incrementResetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!CloudCeilingPanel.this.suspendEvents) {
                    CloudCeilingPanel.this.incrementButtonActionPerformed(actionEvent);
                }
            }
        });
        box3.add(this.incrementResetButton);
        this.controlPanel.add(box3);
        this.controlPanel.add(Box.createVerticalStrut(10));
        Box box4 = Box.createHorizontalBox();
        box4.setAlignmentX(0.0f);
        this.advancedButton = new JButton("Advanced...");
        this.advancedButton.setContentAreaFilled(false);
        this.advancedButton.setBorderPainted(false);
        this.advancedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!CloudCeilingPanel.this.suspendEvents) {
                    CloudCeilingPanel.this.advancedButtonActionPerformed(actionEvent);
                }
            }
        });
        box4.add(Box.createHorizontalGlue());
        box4.add(this.advancedButton);
        this.controlPanel.add(box4);
        this.advancedPanel = Box.createVerticalBox();
        this.advancedPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        box = Box.createHorizontalBox();
        box.setAlignmentX(0.0f);
        this.segmentsFromLabel = new JLabel("Track points:");
        box.add(this.segmentsFromLabel);
        box.add(Box.createHorizontalStrut(20));
        this.segmentStartSpinner = new JSpinner(new SpinnerListModel(new String[]{"   0"}));
        this.segmentStartSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (!CloudCeilingPanel.this.suspendEvents) {
                    CloudCeilingPanel.this.segmentSpinnerStateChanged(changeEvent);
                }
            }
        });
        box.add(this.segmentStartSpinner);
        box.add(Box.createHorizontalStrut(20));
        this.segmentsToLabel = new JLabel("To:");
        box.add(this.segmentsToLabel);
        box.add(Box.createHorizontalStrut(20));
        this.segmentEndSpinner = new JSpinner(new SpinnerListModel(new String[]{"   0"}));
        this.segmentEndSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (!CloudCeilingPanel.this.suspendEvents) {
                    CloudCeilingPanel.this.segmentSpinnerStateChanged(changeEvent);
                }
            }
        });
        box.add(this.segmentEndSpinner);
        box.add(Box.createHorizontalStrut(10));
        this.currentSegmentCheckBox = new JCheckBox("Current segment");
        this.currentSegmentCheckBox.setSelected(true);
        this.currentSegmentCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!CloudCeilingPanel.this.suspendEvents) {
                    CloudCeilingPanel.this.currentSegmentCheckBoxActionPerformed(actionEvent);
                }
            }
        });
        box.add(this.currentSegmentCheckBox);
        box.add(Box.createHorizontalStrut(10));
        this.wholeTrackCheckBox = new JCheckBox("Whole track");
        this.wholeTrackCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!CloudCeilingPanel.this.suspendEvents) {
                    CloudCeilingPanel.this.wholeTrackCheckBoxActionPerformed(actionEvent);
                }
            }
        });
        box.add(this.wholeTrackCheckBox);
        this.advancedPanel.add(box);
        this.advancedPanel.add(Box.createVerticalStrut(10));
        box2 = Box.createHorizontalBox();
        box2.setAlignmentX(0.0f);
        this.patternLabel = new JLabel("Pattern:");
        box2.add(this.patternLabel);
        box2.add(Box.createHorizontalStrut(20));
        this.patternCombo = new JComboBox<String>(new String[]{PATTERN_STRIPES, PATTERN_CROSS_HATCHED, PATTERN_DOTS});
        this.patternCombo.setSelectedItem(PATTERN_DOTS);
        this.patternCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!CloudCeilingPanel.this.suspendEvents) {
                    CloudCeilingPanel.this.patternComboActionPerformed(actionEvent);
                }
            }
        });
        box2.add(this.patternCombo);
        box2.add(Box.createHorizontalStrut(10));
        this.patternSizeCombo = new JComboBox<String>(new String[]{SIZE_SMALL, SIZE_MEDIUM, SIZE_LARGE});
        this.patternSizeCombo.setSelectedItem(SIZE_MEDIUM);
        this.patternSizeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!CloudCeilingPanel.this.suspendEvents) {
                    CloudCeilingPanel.this.patternSizeComboActionPerformed(actionEvent);
                }
            }
        });
        box2.add(this.patternSizeCombo);
        box2.add(Box.createHorizontalStrut(20));
        this.opacityLabel = new JLabel("Opacity:");
        box2.add(this.opacityLabel);
        box2.add(Box.createHorizontalStrut(10));
        this.opacitySpinner = new JSpinner(new SpinnerListModel(new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"}));
        this.opacitySpinner.setValue("3");
        this.opacitySpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (!CloudCeilingPanel.this.suspendEvents) {
                    CloudCeilingPanel.this.opacitySpinnerChanged(changeEvent);
                }
            }
        });
        box2.add(this.opacitySpinner);
        box2.add(Box.createHorizontalStrut(20));
        this.colorButton = new JButton("Color");
        this.colorButton.setBackground(Color.CYAN);
        this.colorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!CloudCeilingPanel.this.suspendEvents) {
                    CloudCeilingPanel.this.colorButtonActionPerformed(actionEvent);
                }
            }
        });
        box2.add(this.colorButton);
        this.advancedPanel.add(box2);
        this.add(this.controlPanel);
        this.add(this.advancedPanel);
        this.advancedPanel.setVisible(false);
        this.enableComponents(this.enabledCheckBox.isSelected());
    }

    private void enableComponents(boolean bl) {
        this.descriptionTextField.setEnabled(bl);
        this.baseElevationTextField.setEnabled(bl);
        this.deltaElevationTextField.setEnabled(bl);
        this.deltaPlusRadioButton.setEnabled(bl);
        this.deltaMinusRadioButton.setEnabled(bl);
        this.deltaBothRadioButton.setEnabled(bl);
        this.segmentStartSpinner.setEnabled(bl);
        this.segmentEndSpinner.setEnabled(bl);
        this.currentSegmentCheckBox.setEnabled(bl);
        this.wholeTrackCheckBox.setEnabled(bl);
        this.colorButton.setEnabled(bl);
        this.incrementSpinner.setEnabled(bl);
        this.incrementMinusButton.setEnabled(bl);
        this.incrementPlusButton.setEnabled(bl);
        this.patternCombo.setEnabled(bl);
        this.patternSizeCombo.setEnabled(bl);
        this.opacitySpinner.setEnabled(bl);
        this.advancedButton.setEnabled(bl);
    }

    public String getRestorableState() {
        RestorableSupport restorableSupport = RestorableSupport.newRestorableSupport();
        this.doGetRestorableState(restorableSupport, null);
        return restorableSupport.getStateAsXml();
    }

    public void restoreState(String string) {
        RestorableSupport restorableSupport;
        if (string == null) {
            String string2 = Logging.getMessage((String)"nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        try {
            restorableSupport = RestorableSupport.parse((String)string);
        }
        catch (Exception exception) {
            String string3 = Logging.getMessage((String)"generic.ExceptionAttemptingToParseStateXml", (String)string);
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3, exception);
        }
        this.doRestoreState(restorableSupport, null);
    }

    protected void doGetRestorableState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        restorableSupport.addStateValueAsString(stateObject, "description", this.descriptionTextField.getText());
        restorableSupport.addStateValueAsBoolean(stateObject, "enabled", this.enabledCheckBox.isSelected());
        double d = this.getNumberValue(this.baseElevationTextField.getText());
        if (this.elevationUnit.equals("Imperial")) {
            d = SAR2.feetToMeters(d);
        }
        restorableSupport.addStateValueAsDouble(stateObject, "base", d);
        double d2 = this.getNumberValue(this.deltaElevationTextField.getText());
        if (this.elevationUnit.equals("Imperial")) {
            d2 = SAR2.feetToMeters(d2);
        }
        restorableSupport.addStateValueAsDouble(stateObject, "delta", d2);
        double d3 = this.getNumberValue(this.incrementedBaseLabel.getText());
        if (this.elevationUnit.equals("Imperial")) {
            d3 = SAR2.feetToMeters(d3);
        }
        restorableSupport.addStateValueAsDouble(stateObject, "incrementedBase", d3);
        restorableSupport.addStateValueAsBoolean(stateObject, "deltaPlus", this.deltaPlusRadioButton.isSelected());
        restorableSupport.addStateValueAsBoolean(stateObject, "deltaMinus", this.deltaMinusRadioButton.isSelected());
        restorableSupport.addStateValueAsBoolean(stateObject, "deltaBoth", this.deltaBothRadioButton.isSelected());
        restorableSupport.addStateValueAsString(stateObject, "segmentStart", (String)this.segmentStartSpinner.getValue());
        restorableSupport.addStateValueAsString(stateObject, "segmentEnd", (String)this.segmentEndSpinner.getValue());
        restorableSupport.addStateValueAsBoolean(stateObject, "currentSegment", this.currentSegmentCheckBox.isSelected());
        restorableSupport.addStateValueAsBoolean(stateObject, "wholeTrack", this.wholeTrackCheckBox.isSelected());
        restorableSupport.addStateValueAsString(stateObject, "increment", (String)this.incrementSpinner.getValue());
        restorableSupport.addStateValueAsString(stateObject, "pattern", (String)this.patternCombo.getSelectedItem());
        restorableSupport.addStateValueAsString(stateObject, "patternSize", (String)this.patternSizeCombo.getSelectedItem());
        restorableSupport.addStateValueAsString(stateObject, "opacity", (String)this.opacitySpinner.getValue());
        String string = RestorableSupport.encodeColor((Color)this.colorButton.getBackground());
        if (string != null) {
            restorableSupport.addStateValueAsString(stateObject, "color", string);
        }
    }

    protected void doRestoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        Color color;
        String string;
        String string2;
        String string3;
        String string4;
        Boolean bl;
        Boolean bl2;
        String string5;
        String string6;
        String string7;
        Boolean bl3;
        Boolean bl4;
        Boolean bl5;
        Double d;
        Double d2;
        Double d3;
        Boolean bl6;
        this.suspendEvents = true;
        String string8 = restorableSupport.getStateValueAsString(stateObject, "description");
        if (string8 != null) {
            this.descriptionTextField.setText(string8);
        }
        if ((bl6 = restorableSupport.getStateValueAsBoolean(stateObject, "enabled")) != null) {
            this.enabledCheckBox.setSelected(bl6);
        }
        if ((d3 = restorableSupport.getStateValueAsDouble(stateObject, "base")) != null) {
            if (this.elevationUnit.equals("Imperial")) {
                d3 = SAR2.metersToFeet(d3);
            }
            this.baseElevationTextField.setText(String.format("%.0f", d3));
        }
        if ((d2 = restorableSupport.getStateValueAsDouble(stateObject, "delta")) != null) {
            if (this.elevationUnit.equals("Imperial")) {
                d2 = SAR2.metersToFeet(d2);
            }
            this.deltaElevationTextField.setText(String.format("%.0f", d2));
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "incrementedBase")) != null) {
            if (this.elevationUnit.equals("Imperial")) {
                d = SAR2.metersToFeet(d);
            }
            this.incrementedBaseLabel.setText(String.format("%.0f", d));
        }
        if ((bl5 = restorableSupport.getStateValueAsBoolean(stateObject, "deltaPlus")) != null) {
            this.deltaPlusRadioButton.setSelected(bl5);
        }
        if ((bl4 = restorableSupport.getStateValueAsBoolean(stateObject, "deltaMinus")) != null) {
            this.deltaMinusRadioButton.setSelected(bl4);
        }
        if ((bl3 = restorableSupport.getStateValueAsBoolean(stateObject, "deltaBoth")) != null) {
            this.deltaBothRadioButton.setSelected(bl3);
        }
        if ((string7 = restorableSupport.getStateValueAsString(stateObject, "increment")) != null) {
            this.incrementSpinner.setValue(string7);
        }
        if ((string6 = restorableSupport.getStateValueAsString(stateObject, "segmentStart")) != null) {
            this.segmentStartSpinner.setValue(string6);
        }
        if ((string5 = restorableSupport.getStateValueAsString(stateObject, "segmentEnd")) != null) {
            this.segmentEndSpinner.setValue(string5);
        }
        if ((bl2 = restorableSupport.getStateValueAsBoolean(stateObject, "currentSegment")) != null) {
            this.currentSegmentCheckBox.setSelected(bl2);
        }
        if ((bl = restorableSupport.getStateValueAsBoolean(stateObject, "wholeTrack")) != null) {
            this.wholeTrackCheckBox.setSelected(bl);
        }
        if ((string4 = restorableSupport.getStateValueAsString(stateObject, "pattern")) != null) {
            this.patternCombo.setSelectedItem(string4);
        }
        if ((string3 = restorableSupport.getStateValueAsString(stateObject, "patternSize")) != null) {
            this.patternSizeCombo.setSelectedItem(string3);
        }
        if ((string2 = restorableSupport.getStateValueAsString(stateObject, "opacity")) != null) {
            this.opacitySpinner.setValue(string2);
        }
        if ((string = restorableSupport.getStateValueAsString(stateObject, "color")) != null && (color = RestorableSupport.decodeColor((String)string)) != null) {
            this.colorButton.setBackground(color);
        }
        this.suspendEvents = false;
        this.updateCloudCeiling();
    }
}

