/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.sar;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.layers.Earth.BMNGOneImage;
import gov.nasa.worldwind.layers.Earth.BMNGWMSLayer;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.layers.TiledImageLayer;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.SurfaceImage;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;

public class LayerMenu
extends JMenu {
    private WorldWindow wwd;

    public LayerMenu() {
        super("Layers");
    }

    public WorldWindow getWwd() {
        return this.wwd;
    }

    public void setWwd(WorldWindow worldWindow) {
        this.wwd = worldWindow;
        for (Layer layer : this.wwd.getModel().getLayers()) {
            if (!this.isLayerMenuItem(layer)) continue;
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(new LayerVisibilityAction(this.wwd, layer, this));
            jCheckBoxMenuItem.setState(layer.isEnabled());
            this.add(jCheckBoxMenuItem);
        }
    }

    private boolean isLayerMenuItem(Layer layer) {
        if (layer instanceof RenderableLayer) {
            Iterable iterable = ((RenderableLayer)layer).getRenderables();
            for (Renderable renderable : iterable) {
                if (!(renderable instanceof SurfaceImage)) continue;
                return true;
            }
            return false;
        }
        return layer instanceof TiledImageLayer && !(layer instanceof BMNGWMSLayer);
    }

    private static class LayerVisibilityAction
    extends AbstractAction {
        private final Layer layer;
        private final WorldWindow wwd;
        private final LayerMenu menu;

        public LayerVisibilityAction(WorldWindow worldWindow, Layer layer, LayerMenu layerMenu) {
            super(layer.getName());
            this.layer = layer;
            this.wwd = worldWindow;
            this.menu = layerMenu;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.layer.setEnabled(((JCheckBoxMenuItem)actionEvent.getSource()).getState());
            if (this.layer instanceof BMNGOneImage) {
                for (Layer layer : this.wwd.getModel().getLayers()) {
                    if (!(layer instanceof BMNGWMSLayer)) continue;
                    layer.setEnabled(((JCheckBoxMenuItem)actionEvent.getSource()).getState());
                }
            }
            this.menu.doClick(0);
            this.wwd.redraw();
        }
    }
}

