/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.sar;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.render.Polyline;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwind.view.orbit.BasicOrbitView;
import gov.nasa.worldwind.view.orbit.OrbitView;
import gov.nasa.worldwindx.applications.sar.AnalysisPanel;
import gov.nasa.worldwindx.applications.sar.SARTrack;
import gov.nasa.worldwindx.applications.sar.SARTrackBuilder;
import gov.nasa.worldwindx.applications.sar.SARTrackExtensionTool;
import gov.nasa.worldwindx.applications.sar.TracksPanel;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;

public class TrackController {
    public static final String TRACK_ADD = "TrackController.TrackAdded";
    public static final String TRACK_CURRENT = "TrackController.TrackCurrent";
    public static final String TRACK_DIRTY_BIT = "TrackController.TrackDirtyBit";
    public static final String TRACK_DISABLE = "TrackController.TrackDisabled";
    public static final String TRACK_ENABLE = "TrackController.TrackEnabled";
    public static final String TRACK_MODIFY = "TrackController.TrackModified";
    public static final String TRACK_NAME = "TrackController.TrackName";
    public static final String TRACK_OFFSET = "TrackController.TrackOffset";
    public static final String TRACK_REMOVE = "TrackController.TrackRemoved";
    public static final String BEGIN_TRACK_POINT_ENTRY = "TrackController.BeginTrackPointEntry";
    public static final String END_TRACK_POINT_ENTRY = "TrackController.EndTrackPointEntry";
    public static final String MOVE_TO_NEXT_POINT = "TrackController.MoveToNextPoint";
    public static final String REMOVE_LAST_POINT = "TrackController.RemoveLastPoint";
    public static final String EXTENSION_PLANE = "TrackController.ExtensionPlane";
    public static final String EXTENSION_CURSOR_GROUND = "TrackController.ExtensionMouseGround";
    public static final String EXTENSION_CURSOR_AIR = "TrackController.ExtensionMouseAir";
    private WorldWindow wwd;
    private TracksPanel tracksPanel;
    private AnalysisPanel analysisPanel;
    private HashMap<SARTrack, Layer> trackLayers = new HashMap();
    private SARTrackBuilder trackBuilder;
    private SARTrackExtensionTool trackExtensionTool;
    private final SelectListener selectListener = new SelectListener(){

        public void selected(SelectEvent selectEvent) {
            if (selectEvent == null) {
                return;
            }
            TrackController.this.onSelected(selectEvent);
        }
    };

    public TrackController() {
        this.trackBuilder = new SARTrackBuilder();
        this.trackExtensionTool = new SARTrackExtensionTool();
    }

    public WorldWindow getWwd() {
        return this.wwd;
    }

    public void setWwd(WorldWindow worldWindow) {
        if (worldWindow == this.wwd) {
            return;
        }
        if (this.wwd != null) {
            this.wwd.removeSelectListener(this.selectListener);
        }
        this.wwd = worldWindow;
        if (this.wwd != null) {
            this.wwd.addSelectListener(this.selectListener);
        }
        this.trackBuilder.setWwd(this.wwd);
        this.trackExtensionTool.setWorldWindow(this.wwd);
    }

    public TracksPanel getTracksPanel() {
        return this.tracksPanel;
    }

    public void setTracksPanel(TracksPanel tracksPanel) {
        this.tracksPanel = tracksPanel;
    }

    public AnalysisPanel getAnalysisPanel() {
        return this.analysisPanel;
    }

    public void setAnalysisPanel(AnalysisPanel analysisPanel) {
        this.analysisPanel = analysisPanel;
        this.analysisPanel.setTrackController(this);
    }

    public void addTrack(SARTrack sARTrack) {
        if (sARTrack == null) {
            return;
        }
        this.createPolylineTrackRepresentation(sARTrack);
        sARTrack.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName() == TrackController.TRACK_REMOVE) {
                    TrackController.this.removeTrack((SARTrack)propertyChangeEvent.getSource());
                } else if (propertyChangeEvent.getPropertyName() == TrackController.TRACK_MODIFY) {
                    TrackController.this.updateTrack((SARTrack)propertyChangeEvent.getSource());
                } else if (propertyChangeEvent.getPropertyName() == TrackController.TRACK_ENABLE) {
                    TrackController.this.enableTrack((SARTrack)propertyChangeEvent.getSource());
                } else if (propertyChangeEvent.getPropertyName() == TrackController.TRACK_DISABLE) {
                    TrackController.this.disableTrack((SARTrack)propertyChangeEvent.getSource());
                } else if (propertyChangeEvent.getPropertyName() == TrackController.TRACK_CURRENT) {
                    TrackController.this.trackCurrent((SARTrack)propertyChangeEvent.getSource());
                } else if (propertyChangeEvent.getPropertyName() == TrackController.TRACK_NAME) {
                    TrackController.this.trackName((SARTrack)propertyChangeEvent.getSource());
                } else if (propertyChangeEvent.getPropertyName() == TrackController.TRACK_DIRTY_BIT) {
                    TrackController.this.trackDirtyBit((SARTrack)propertyChangeEvent.getSource());
                } else if (propertyChangeEvent.getPropertyName() == TrackController.BEGIN_TRACK_POINT_ENTRY) {
                    TrackController.this.beginTrackPointEntry(propertyChangeEvent);
                } else if (propertyChangeEvent.getPropertyName() == TrackController.END_TRACK_POINT_ENTRY) {
                    TrackController.this.endTrackPointEntry(propertyChangeEvent);
                } else if (propertyChangeEvent.getPropertyName() == TrackController.MOVE_TO_NEXT_POINT) {
                    TrackController.this.moveToNextTrackPoint();
                } else if (propertyChangeEvent.getPropertyName() == TrackController.REMOVE_LAST_POINT) {
                    TrackController.this.removeLastTrackPoint();
                }
            }
        });
        this.tracksPanel.addTrack(sARTrack);
        this.moveToTrack(sARTrack);
    }

    public SARTrack getCurrentTrack() {
        return this.tracksPanel.getCurrentTrack();
    }

    public void refreshCurrentTrack() {
        this.trackCurrent(this.getCurrentTrack());
    }

    private void createPolylineTrackRepresentation(SARTrack sARTrack) {
        Polyline polyline = new Polyline((Iterable)sARTrack);
        polyline.setOffset(sARTrack.getOffset());
        polyline.setPathType(2);
        polyline.setColor(sARTrack.getColor());
        Polyline polyline2 = new Polyline((Iterable)sARTrack);
        polyline2.setFollowTerrain(true);
        polyline2.setPathType(2);
        polyline2.setColor(sARTrack.getColor());
        polyline2.setStippleFactor(5);
        polyline2.setStipplePattern((short)-21846);
        RenderableLayer renderableLayer = new RenderableLayer();
        renderableLayer.addRenderable((Renderable)polyline);
        renderableLayer.addRenderable((Renderable)polyline2);
        this.wwd.getModel().getLayers().add((Layer)renderableLayer);
        if (this.wwd != null) {
            this.wwd.redraw();
        }
        this.trackLayers.put(sARTrack, (Layer)renderableLayer);
    }

    private void removeTrack(SARTrack sARTrack) {
        Layer layer = this.trackLayers.get(sARTrack);
        if (layer == null) {
            return;
        }
        this.trackLayers.remove(sARTrack);
        this.wwd.getModel().getLayers().remove(layer);
        if (this.wwd != null) {
            this.wwd.redraw();
        }
    }

    private void enableTrack(SARTrack sARTrack) {
        RenderableLayer renderableLayer = (RenderableLayer)this.trackLayers.get(sARTrack);
        if (renderableLayer == null) {
            return;
        }
        renderableLayer.setEnabled(true);
        if (this.wwd != null) {
            this.wwd.redraw();
        }
    }

    private void disableTrack(SARTrack sARTrack) {
        RenderableLayer renderableLayer = (RenderableLayer)this.trackLayers.get(sARTrack);
        if (renderableLayer == null) {
            return;
        }
        renderableLayer.setEnabled(false);
        if (this.wwd != null) {
            this.wwd.redraw();
        }
    }

    private void updateTrack(SARTrack sARTrack) {
        RenderableLayer renderableLayer = (RenderableLayer)this.trackLayers.get(sARTrack);
        if (renderableLayer == null) {
            return;
        }
        for (Renderable renderable : renderableLayer.getRenderables()) {
            Polyline polyline = (Polyline)renderable;
            polyline.setPositions((Iterable)sARTrack);
            if (polyline.isFollowTerrain()) continue;
            polyline.setOffset(sARTrack.getOffset());
        }
        if (this.wwd != null) {
            this.wwd.redraw();
        }
    }

    private void trackCurrent(SARTrack sARTrack) {
        this.analysisPanel.setCurrentTrack(sARTrack);
        if (this.isExtending() && sARTrack != null) {
            this.endTrackPointEntry(new PropertyChangeEvent(sARTrack, END_TRACK_POINT_ENTRY, null, null));
        }
        for (SARTrack sARTrack2 : this.trackLayers.keySet()) {
            if (sARTrack2 == sARTrack) continue;
            this.setTrackLayerLineWidth(sARTrack2, 1.0);
        }
        this.setTrackLayerLineWidth(sARTrack, 2.0);
        this.wwd.firePropertyChange(TRACK_CURRENT, null, (Object)sARTrack);
    }

    private void trackName(SARTrack sARTrack) {
    }

    private void trackDirtyBit(SARTrack sARTrack) {
    }

    private void beginTrackPointEntry(PropertyChangeEvent propertyChangeEvent) {
        SARTrack sARTrack = (SARTrack)propertyChangeEvent.getSource();
        if (propertyChangeEvent.getNewValue().equals(EXTENSION_PLANE)) {
            this.trackExtensionTool.setArmed(false);
            this.trackExtensionTool.setTrack(sARTrack);
            this.trackExtensionTool.setArmed(true);
        } else {
            this.trackBuilder.setArmed(false);
            this.trackBuilder.setTrack(sARTrack);
            this.trackBuilder.setUseTrackElevation(propertyChangeEvent.getNewValue().equals(EXTENSION_CURSOR_AIR));
            this.trackBuilder.setArmed(true);
        }
        this.wwd.firePropertyChange(propertyChangeEvent);
        this.analysisPanel.gotoTrackEnd();
    }

    private void endTrackPointEntry(PropertyChangeEvent propertyChangeEvent) {
        this.trackBuilder.setArmed(false);
        this.trackExtensionTool.setArmed(false);
        this.wwd.firePropertyChange(propertyChangeEvent);
    }

    private void moveToNextTrackPoint() {
        if (this.trackExtensionTool.isArmed() && this.trackExtensionTool.canMoveToNextTrackPoint()) {
            this.trackExtensionTool.moveToNextTrackPoint();
        }
    }

    private void removeLastTrackPoint() {
        if (this.trackBuilder.isArmed() && this.trackBuilder.canRemoveLastTrackPoint()) {
            this.trackBuilder.removeLastTrackPoint();
        } else if (this.trackExtensionTool.isArmed() && this.trackExtensionTool.canRemoveLastTrackPoint()) {
            this.trackExtensionTool.removeLastTrackPoint();
        }
    }

    public boolean isExtending() {
        return this.trackBuilder.isArmed() || this.trackExtensionTool.isArmed();
    }

    private void moveToTrack(SARTrack sARTrack) {
        OrbitView orbitView = (OrbitView)this.wwd.getView();
        if (!sARTrack.getPositions().isEmpty()) {
            Position position = sARTrack.getPositions().get(0);
            ((BasicOrbitView)orbitView).addPanToAnimator(position, orbitView.getHeading(), Angle.ZERO, 10000.0, true);
        }
    }

    protected void onSelected(SelectEvent selectEvent) {
        SARTrack sARTrack = this.getPickedTrack(selectEvent.getTopPickedObject());
        if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.LeftClick")) {
            if (sARTrack != null) {
                this.onTrackClicked(sARTrack);
            }
        } else if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Rollover")) {
            this.onTrackRollover(sARTrack);
        } else if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Hover")) {
            this.onTrackHover(sARTrack);
        }
    }

    protected SARTrack getPickedTrack(PickedObject pickedObject) {
        if (pickedObject == null) {
            return null;
        }
        Layer layer = pickedObject.getParentLayer();
        if (layer == null) {
            return null;
        }
        return this.getTrackForLayer(layer);
    }

    protected void onTrackClicked(SARTrack sARTrack) {
        this.tracksPanel.setCurrentTrack(sARTrack);
    }

    protected void onTrackRollover(SARTrack sARTrack) {
        for (SARTrack sARTrack2 : this.trackLayers.keySet()) {
            if (sARTrack2 == sARTrack) continue;
            this.setTrackLayerColor(sARTrack2, sARTrack2.getColor());
        }
        if (sARTrack != null) {
            Color color = WWUtil.makeColorDarker((Color)sARTrack.getColor());
            this.setTrackLayerColor(sARTrack, color);
        }
    }

    protected void onTrackHover(SARTrack sARTrack) {
    }

    private void setTrackLayerColor(SARTrack sARTrack, Color color) {
        RenderableLayer renderableLayer = (RenderableLayer)this.trackLayers.get(sARTrack);
        if (renderableLayer == null) {
            return;
        }
        for (Renderable renderable : renderableLayer.getRenderables()) {
            Polyline polyline = (Polyline)renderable;
            polyline.setColor(color);
        }
        if (this.wwd != null) {
            this.wwd.redraw();
        }
    }

    private void setTrackLayerLineWidth(SARTrack sARTrack, double d) {
        RenderableLayer renderableLayer = (RenderableLayer)this.trackLayers.get(sARTrack);
        if (renderableLayer == null) {
            return;
        }
        for (Renderable renderable : renderableLayer.getRenderables()) {
            Polyline polyline = (Polyline)renderable;
            polyline.setLineWidth(d);
        }
        if (this.wwd != null) {
            this.wwd.redraw();
        }
    }

    private SARTrack getTrackForLayer(Layer layer) {
        for (Map.Entry<SARTrack, Layer> entry : this.trackLayers.entrySet()) {
            if (entry.getValue() != layer) continue;
            return entry.getKey();
        }
        return null;
    }
}

