/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.sar;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RestorableSupport;
import gov.nasa.worldwindx.applications.sar.AnalysisPanel;
import gov.nasa.worldwindx.applications.sar.SAR2;
import gov.nasa.worldwindx.applications.sar.SARTrack;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerListModel;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TrackViewPanel
extends JPanel {
    private AnalysisPanel analysisPanel;
    private SARTrack sarTrack;
    private PropertyChangeListener trackPropertyChangeListener;
    private String elevationUnit;
    private String angleFormat;
    private String viewMode = "TrackViewPanel.ViewModeFree";
    private boolean suspendPositionEvents = false;
    private double positionDelta = 0.0;
    private JLabel latLabel;
    private JLabel lonLabel;
    private JLabel altLabel;
    private JLabel latReadout;
    private JLabel lonReadout;
    private JLabel altReadout;
    private JSpinner positionSpinner;
    private JSlider positionSlider;
    private JButton fastReverseButton;
    private JButton reverseButton;
    private JButton stopButton;
    private JButton forwardButton;
    private JButton fastForwardButton;
    private JLabel speedLabel;
    private JSpinner speedSpinner;
    private JSpinner speedFactorSpinner;
    private static final int PLAY_FORWARD = 1;
    private static final int PLAY_BACKWARD = -1;
    private static final int PLAY_STOP = 0;
    private int playMode = 0;
    private Timer player;
    private long previousStepTime = -1L;
    public static final String POSITION_CHANGE = "TrackViewPanel.PositionChange";
    public static final String VIEW_CHANGE = "TrackViewPanel.ViewChange";
    public static final String VIEW_MODE_CHANGE = "TrackViewPanel.ViewModeChange";
    public static final String VIEW_MODE_EXAMINE = "TrackViewPanel.ViewModeExamine";
    public static final String VIEW_MODE_FOLLOW = "TrackViewPanel.ViewModeFollow";
    public static final String VIEW_MODE_FREE = "TrackViewPanel.ViewModeFree";
    public static final String SHOW_TRACK_INFORMATION = "TrackViewPanel.ShowTrackInformation";
    public static final String CURRENT_SEGMENT = "TrackViewPanel.CurrentSegment";

    public TrackViewPanel(AnalysisPanel analysisPanel) {
        this.analysisPanel = analysisPanel;
        this.initComponents();
        this.updateEnabledState();
        this.trackPropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("TrackController.TrackModified")) {
                    TrackViewPanel.this.updatePositionList(false);
                }
            }
        };
    }

    public WorldWindow getWwd() {
        return this.analysisPanel.getWwd();
    }

    public void setCurrentTrack(SARTrack sARTrack) {
        if (this.sarTrack != null) {
            this.sarTrack.removePropertyChangeListener(this.trackPropertyChangeListener);
        }
        this.sarTrack = sARTrack;
        if (this.sarTrack != null) {
            this.sarTrack.addPropertyChangeListener(this.trackPropertyChangeListener);
        }
        this.updatePositionList(true);
        this.updateEnabledState();
    }

    public String getElevationUnit() {
        return this.elevationUnit;
    }

    public void setElevationUnit(String string) {
        this.elevationUnit = string;
    }

    public String getAngleFormat() {
        return this.angleFormat;
    }

    public void setAngleFormat(String string) {
        this.angleFormat = string;
    }

    public String getViewMode() {
        return this.viewMode;
    }

    public void setViewMode(String string) {
        if (this.viewMode.equals(string)) {
            return;
        }
        this.viewMode = string;
        this.firePropertyChange(VIEW_CHANGE, -1, 0);
    }

    private void updatePositionList(boolean bl) {
        int n;
        Object[] objectArray = new String[this.sarTrack != null ? this.sarTrack.size() : 0];
        for (n = 0; n < objectArray.length; ++n) {
            objectArray[n] = String.format("%,4d", n);
        }
        if (objectArray.length == 0) {
            objectArray = new String[]{"   0"};
        }
        n = Math.min(this.getCurrentPositionNumber(), objectArray.length - 1);
        int n2 = this.positionSlider.getValue();
        this.positionSpinner.setModel(new SpinnerListModel(objectArray));
        this.positionSpinner.setValue(bl ? objectArray[0] : objectArray[n]);
        this.positionSlider.setValue(bl ? 0 : n2);
    }

    private void setPositionSpinnerNumber(int n) {
        this.positionSpinner.setValue(String.format("%,4d", n));
    }

    private void updateEnabledState() {
        boolean bl = this.sarTrack != null;
        this.positionSpinner.setEnabled(bl);
        this.positionSlider.setEnabled(bl);
        this.latLabel.setEnabled(bl);
        this.lonLabel.setEnabled(bl);
        this.altLabel.setEnabled(bl);
        this.fastReverseButton.setEnabled(bl);
        this.reverseButton.setEnabled(bl);
        this.forwardButton.setEnabled(bl);
        this.fastForwardButton.setEnabled(bl);
        this.speedLabel.setEnabled(bl);
        this.speedSpinner.setEnabled(bl);
        this.speedFactorSpinner.setEnabled(bl);
        this.updateReadout(this.sarTrack != null && this.sarTrack.size() > 0 ? this.sarTrack.get(0) : null);
    }

    private void positionSpinnerStateChanged() {
        if (!this.suspendPositionEvents) {
            this.setPositionDelta(this.getCurrentPositionNumber(), 0.0);
            this.firePropertyChange(POSITION_CHANGE, -1, 0);
        }
    }

    private void positionSliderStateChanged() {
        if (!this.suspendPositionEvents) {
            this.updatePositionDelta();
            this.firePropertyChange(POSITION_CHANGE, -1, 0);
        }
    }

    public int getCurrentPositionNumber() {
        Object object = this.positionSpinner.getValue();
        if (object == null) {
            return -1;
        }
        return Integer.parseInt(object.toString().trim().replaceAll(",", ""));
    }

    private boolean isLastPosition(int n) {
        return n >= this.sarTrack.size() - 1;
    }

    public double getPositionDelta() {
        return this.positionDelta;
    }

    private void updatePositionDelta() {
        int n = this.positionSlider.getValue();
        int n2 = this.positionSlider.getMinimum();
        int n3 = this.positionSlider.getMaximum();
        this.positionDelta = (double)n / ((double)n3 - (double)n2);
    }

    public void gotoTrackEnd() {
        if (this.sarTrack != null && this.sarTrack.size() > 0) {
            this.setPositionDelta(this.sarTrack.size() - 1, 0.0);
            this.firePropertyChange(POSITION_CHANGE, -1, 0);
        }
    }

    public void setPositionDelta(int n, double d) {
        this.suspendPositionEvents = true;
        this.setPositionSpinnerNumber(n);
        int n2 = this.positionSlider.getMinimum();
        int n3 = this.positionSlider.getMaximum();
        int n4 = (int)((double)n2 + (double)(n3 - n2) * d);
        this.positionSlider.setValue(n4);
        this.suspendPositionEvents = false;
        this.positionDelta = d;
    }

    public boolean isExamineViewMode() {
        return this.viewMode.equals(VIEW_MODE_EXAMINE);
    }

    public boolean isFollowViewMode() {
        return this.viewMode.equals(VIEW_MODE_FOLLOW);
    }

    public boolean isFreeViewMode() {
        return this.viewMode.equals(VIEW_MODE_FREE);
    }

    public void updateReadout(Position position) {
        this.latReadout.setText(position == null ? "" : SAR2.formatAngle(this.angleFormat, position.getLatitude()));
        this.lonReadout.setText(position == null ? "" : SAR2.formatAngle(this.angleFormat, position.getLongitude()));
        if ("Imperial".equals(this.elevationUnit)) {
            this.altReadout.setText(position == null ? "" : String.format("% 8.0f ft", SAR2.metersToFeet(position.getElevation())));
        } else {
            this.altReadout.setText(position == null ? "" : String.format("% 8.0f m", position.getElevation()));
        }
        this.speedLabel.setText("Imperial".equals(this.elevationUnit) ? "MPH: " : "KMH: ");
    }

    public double getSpeedKMH() {
        String string = (String)this.speedSpinner.getValue();
        double d = Double.parseDouble(string) * this.getSpeedFactor();
        if ("Imperial".equals(this.elevationUnit)) {
            d *= 1.609344;
        }
        return d;
    }

    public double getSpeedFactor() {
        String string = ((String)this.speedFactorSpinner.getValue()).replace("x", "");
        return Double.parseDouble(string);
    }

    private void fastReverseButtonActionPerformed() {
        if (this.getCurrentPositionNumber() > 0) {
            this.setPositionSpinnerNumber(this.getCurrentPositionNumber() - 1);
        }
    }

    private void reverseButtonActionPerformed() {
        this.setPlayMode(-1);
    }

    private void stopButtonActionPerformed() {
        this.setPlayMode(0);
    }

    private void forwardButtonActionPerformed() {
        this.setPlayMode(1);
    }

    private void fastForwardButtonActionPerformed() {
        if (!this.isLastPosition(this.getCurrentPositionNumber())) {
            this.setPositionSpinnerNumber(this.getCurrentPositionNumber() + 1);
        }
    }

    public boolean isPlayerActive() {
        return this.playMode != 0;
    }

    private void setPlayMode(int n) {
        this.playMode = n;
        if (this.player == null) {
            this.initPlayer();
        }
        this.player.start();
    }

    private void initPlayer() {
        if (this.player != null) {
            return;
        }
        this.player = new Timer(50, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TrackViewPanel.this.runPlayer();
            }
        });
    }

    private void runPlayer() {
        int n = this.getCurrentPositionNumber();
        double d = this.getPositionDelta();
        double d2 = this.getSpeedKMH();
        if (this.playMode == 0) {
            this.stopButton.setEnabled(false);
            this.player.stop();
            this.previousStepTime = -1L;
        } else if (this.playMode == 1) {
            this.stopButton.setEnabled(true);
            if (n >= this.sarTrack.size() - 1) {
                this.setPositionDelta(this.sarTrack.size() - 1, 0.0);
                this.playMode = 0;
            } else {
                double d3 = this.computeDistanceToGo(d2);
                while (d3 > 0.0) {
                    double d4 = this.analysisPanel.getSegmentLength(n);
                    if (d4 * d + d3 <= d4) {
                        this.setPositionDelta(n, d += d3 / d4);
                        d3 = 0.0;
                        continue;
                    }
                    if (!this.isLastPosition(n + 1)) {
                        d3 -= d4 * (1.0 - d);
                        ++n;
                        d = 0.0;
                        continue;
                    }
                    this.setPositionDelta(n + 1, 0.0);
                    this.playMode = 0;
                    break;
                }
                this.firePropertyChange(POSITION_CHANGE, -1, 0);
            }
        } else if (this.playMode == -1) {
            this.stopButton.setEnabled(true);
            if (n <= 0 && d <= 0.0) {
                this.setPositionDelta(0, 0.0);
                this.playMode = 0;
            } else {
                double d5 = this.computeDistanceToGo(d2);
                while (d5 > 0.0) {
                    double d6 = this.analysisPanel.getSegmentLength(n);
                    if (d6 * d - d5 >= 0.0) {
                        this.setPositionDelta(n, d -= d5 / d6);
                        d5 = 0.0;
                        continue;
                    }
                    if (n > 0) {
                        d5 -= d6 * d;
                        --n;
                        d = 1.0;
                        continue;
                    }
                    this.setPositionDelta(0, 0.0);
                    this.playMode = 0;
                    break;
                }
                this.firePropertyChange(POSITION_CHANGE, -1, 0);
            }
        }
    }

    private double computeDistanceToGo(double d) {
        long l = System.nanoTime();
        double d2 = 0.0;
        if (this.previousStepTime > 0L) {
            double d3 = (double)(l - this.previousStepTime) / 1000000.0;
            d2 = d / 3600.0 * d3;
        }
        this.previousStepTime = l;
        return d2;
    }

    private void initComponents() {
        this.setLayout(new BoxLayout(this, 3));
        Box box = Box.createVerticalBox();
        JPanel jPanel = new JPanel(new GridLayout(1, 3, 0, 0));
        jPanel.setAlignmentX(0.5f);
        Box box2 = Box.createHorizontalBox();
        box2.add(Box.createHorizontalGlue());
        this.latLabel = new JLabel();
        this.latLabel.setText("Lat:");
        box2.add(this.latLabel);
        box2.add(Box.createHorizontalStrut(3));
        this.latReadout = new JLabel();
        this.latReadout.setText("-90.0000");
        box2.add(this.latReadout);
        box2.add(Box.createHorizontalGlue());
        jPanel.add(box2);
        Serializable serializable = Box.createHorizontalBox();
        ((Container)serializable).add(Box.createHorizontalGlue());
        this.lonLabel = new JLabel();
        this.lonLabel.setText("Lon:");
        ((Container)serializable).add(this.lonLabel);
        ((Container)serializable).add(Box.createHorizontalStrut(3));
        this.lonReadout = new JLabel();
        this.lonReadout.setText("-180.0000");
        ((Container)serializable).add(this.lonReadout);
        ((Container)serializable).add(Box.createHorizontalGlue());
        jPanel.add((Component)serializable);
        Box box3 = Box.createHorizontalBox();
        box3.add(Box.createHorizontalGlue());
        this.altLabel = new JLabel();
        this.altLabel.setText("Alt:");
        box3.add(this.altLabel);
        box3.add(Box.createHorizontalStrut(3));
        this.altReadout = new JLabel();
        this.altReadout.setText("50,000.000");
        box3.add(this.altReadout);
        box3.add(Box.createHorizontalGlue());
        jPanel.add(box3);
        box.add(jPanel);
        box.add(Box.createVerticalStrut(16));
        box2 = Box.createHorizontalBox();
        box2.setAlignmentX(0.5f);
        this.positionSpinner = new JSpinner();
        this.positionSpinner.setModel(new SpinnerListModel(new String[]{"   0"}));
        this.positionSpinner.setEnabled(false);
        serializable = new Dimension(50, this.positionSpinner.getPreferredSize().height);
        this.positionSpinner.setMinimumSize((Dimension)serializable);
        this.positionSpinner.setPreferredSize((Dimension)serializable);
        this.positionSpinner.setMaximumSize((Dimension)serializable);
        this.positionSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                TrackViewPanel.this.positionSpinnerStateChanged();
            }
        });
        box2.add((Component)this.positionSpinner, "West");
        box2.add(Box.createHorizontalStrut(10));
        this.positionSlider = new JSlider();
        this.positionSlider.setMaximum(1000);
        this.positionSlider.setValue(0);
        this.positionSlider.setEnabled(false);
        this.positionSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                TrackViewPanel.this.positionSliderStateChanged();
            }
        });
        box2.add((Component)this.positionSlider, "Center");
        box.add(box2);
        box.add(Box.createVerticalStrut(16));
        serializable = Box.createHorizontalBox();
        ((JComponent)serializable).setAlignmentX(0.5f);
        ((Container)serializable).add(Box.createHorizontalGlue());
        this.fastReverseButton = new JButton();
        this.fastReverseButton.setText("<<");
        this.fastReverseButton.setEnabled(false);
        this.fastReverseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TrackViewPanel.this.fastReverseButtonActionPerformed();
            }
        });
        ((Container)serializable).add(this.fastReverseButton);
        ((Container)serializable).add(Box.createHorizontalStrut(3));
        this.reverseButton = new JButton();
        this.reverseButton.setText("<");
        this.reverseButton.setEnabled(false);
        this.reverseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TrackViewPanel.this.reverseButtonActionPerformed();
            }
        });
        ((Container)serializable).add(this.reverseButton);
        ((Container)serializable).add(Box.createHorizontalStrut(3));
        this.stopButton = new JButton();
        this.stopButton.setText("Stop");
        this.stopButton.setEnabled(false);
        this.stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TrackViewPanel.this.stopButtonActionPerformed();
            }
        });
        ((Container)serializable).add(this.stopButton);
        ((Container)serializable).add(Box.createHorizontalStrut(3));
        this.forwardButton = new JButton();
        this.forwardButton.setText(">");
        this.forwardButton.setBorder(UIManager.getBorder("Button.border"));
        this.forwardButton.setEnabled(false);
        this.forwardButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TrackViewPanel.this.forwardButtonActionPerformed();
            }
        });
        ((Container)serializable).add(this.forwardButton);
        ((Container)serializable).add(Box.createHorizontalStrut(3));
        this.fastForwardButton = new JButton();
        this.fastForwardButton.setText(">>");
        this.fastForwardButton.setEnabled(false);
        this.fastForwardButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TrackViewPanel.this.fastForwardButtonActionPerformed();
            }
        });
        ((Container)serializable).add(this.fastForwardButton);
        ((Container)serializable).add(Box.createHorizontalGlue());
        box.add((Component)serializable);
        box.add(Box.createVerticalStrut(16));
        box3 = Box.createHorizontalBox();
        box3.setAlignmentX(0.5f);
        box3.add(Box.createHorizontalGlue());
        this.speedLabel = new JLabel();
        this.speedLabel.setText("Speed:");
        box3.add(this.speedLabel);
        box3.add(Box.createHorizontalStrut(10));
        int n = 100;
        Object[] objectArray = new String[n];
        for (int i = 1; i <= n; ++i) {
            objectArray[i - 1] = "" + i * 10;
        }
        this.speedSpinner = new JSpinner();
        this.speedSpinner.setModel(new SpinnerListModel(objectArray));
        this.speedSpinner.setValue("200");
        this.speedSpinner.setEnabled(false);
        Dimension dimension = new Dimension(60, this.speedSpinner.getPreferredSize().height);
        this.speedSpinner.setMinimumSize(dimension);
        this.speedSpinner.setPreferredSize(dimension);
        this.speedSpinner.setMaximumSize(dimension);
        box3.add(this.speedSpinner);
        box3.add(Box.createHorizontalStrut(10));
        this.speedFactorSpinner = new JSpinner();
        this.speedFactorSpinner.setModel(new SpinnerListModel(new String[]{"x.12", "x.25", "x.50", "x1", "x2", "x3", "x4", "x5", "x7", "x10"}));
        this.speedFactorSpinner.setValue("x1");
        this.speedFactorSpinner.setEnabled(false);
        dimension = new Dimension(60, this.speedFactorSpinner.getPreferredSize().height);
        this.speedFactorSpinner.setMinimumSize(dimension);
        this.speedFactorSpinner.setPreferredSize(dimension);
        this.speedFactorSpinner.setMaximumSize(dimension);
        box3.add(this.speedFactorSpinner);
        box3.add(Box.createHorizontalGlue());
        box.add(box3);
        box.add(Box.createVerticalGlue());
        box.setAlignmentX(0.5f);
        this.add(box);
        this.add(Box.createVerticalGlue());
    }

    public String getRestorableState() {
        RestorableSupport restorableSupport = RestorableSupport.newRestorableSupport();
        this.doGetRestorableState(restorableSupport, null);
        return restorableSupport.getStateAsXml();
    }

    public void restoreState(String string) {
        RestorableSupport restorableSupport;
        if (string == null) {
            String string2 = Logging.getMessage((String)"nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        try {
            restorableSupport = RestorableSupport.parse((String)string);
        }
        catch (Exception exception) {
            String string3 = Logging.getMessage((String)"generic.ExceptionAttemptingToParseStateXml", (String)string);
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3, exception);
        }
        this.doRestoreState(restorableSupport, null);
    }

    protected void doGetRestorableState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        restorableSupport.addStateValueAsInteger(stateObject, "positionNumber", this.getCurrentPositionNumber());
        restorableSupport.addStateValueAsDouble(stateObject, "positionDelta", this.getPositionDelta());
        restorableSupport.addStateValueAsString(stateObject, "viewMode", this.getViewMode());
        restorableSupport.addStateValueAsString(stateObject, "speed", (String)this.speedSpinner.getValue());
        restorableSupport.addStateValueAsString(stateObject, "speedFactor", (String)this.speedFactorSpinner.getValue());
    }

    protected void doRestoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        String string;
        String string2;
        String string3;
        Integer n = restorableSupport.getStateValueAsInteger(stateObject, "positionNumber");
        Double d = restorableSupport.getStateValueAsDouble(stateObject, "positionDelta");
        if (n != null && d != null) {
            this.setPositionDelta(n, d);
        }
        if ((string3 = restorableSupport.getStateValueAsString(stateObject, "speed")) != null) {
            this.speedSpinner.setValue(string3);
        }
        if ((string2 = restorableSupport.getStateValueAsString(stateObject, "speedFactor")) != null) {
            this.speedFactorSpinner.setValue(string2);
        }
        if ((string = restorableSupport.getStateValueAsString(stateObject, "viewMode")) != null) {
            this.viewMode = string;
            this.firePropertyChange(VIEW_CHANGE, -1, 0);
            this.getWwd().firePropertyChange(VIEW_MODE_CHANGE, null, (Object)string);
        }
    }
}

