/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.sar;

import gov.nasa.worldwind.render.PatternFactory;
import gov.nasa.worldwindx.applications.sar.SARTrack;
import gov.nasa.worldwindx.applications.sar.TrackPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TracksPanel
extends JPanel {
    private String elevationUnit;
    private String angleFormat;
    private JTabbedPane tracksTabbedPane;

    public TracksPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout(0, 0));
        this.tracksTabbedPane = new JTabbedPane();
        this.tracksTabbedPane.setMinimumSize(new Dimension(361, 223));
        this.tracksTabbedPane.setPreferredSize(new Dimension(361, 223));
        this.tracksTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                TracksPanel.this.tracksTabbedPaneStateChanged(changeEvent);
            }
        });
        this.add((Component)this.tracksTabbedPane, "Center");
    }

    public SARTrack getCurrentTrack() {
        Component component = this.tracksTabbedPane.getSelectedComponent();
        return component != null ? ((TrackPanel)component).getTrack() : null;
    }

    public void setCurrentTrack(SARTrack sARTrack) {
        int n = this.getTrackPanelIndex(sARTrack);
        if (n < 0) {
            return;
        }
        this.tracksTabbedPane.setSelectedIndex(n);
    }

    public Iterable<SARTrack> getAllTracks() {
        ArrayList<SARTrack> arrayList = new ArrayList<SARTrack>();
        for (int i = 0; i < this.tracksTabbedPane.getTabCount(); ++i) {
            TrackPanel trackPanel = (TrackPanel)this.tracksTabbedPane.getComponentAt(i);
            if (trackPanel.getTrack() == null) continue;
            arrayList.add(trackPanel.getTrack());
        }
        return arrayList;
    }

    public void addTrack(SARTrack sARTrack) {
        TrackPanel trackPanel = new TrackPanel();
        trackPanel.setTrack(sARTrack);
        trackPanel.setElevationUnit(this.elevationUnit);
        trackPanel.setAngleFormat(this.angleFormat);
        trackPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.tracksTabbedPane.addTab(sARTrack.getName(), TracksPanel.makeColorCircle(sARTrack.getColor()), trackPanel);
        sARTrack.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName() == "TrackController.TrackRemoved") {
                    TracksPanel.this.removeTrack((SARTrack)propertyChangeEvent.getSource());
                } else if (propertyChangeEvent.getPropertyName() == "TrackController.TrackName") {
                    TracksPanel.this.renameTrack((SARTrack)propertyChangeEvent.getSource());
                } else if (propertyChangeEvent.getPropertyName() == "TrackController.TrackDirtyBit") {
                    TracksPanel.this.updateTrackDirty((SARTrack)propertyChangeEvent.getSource());
                }
            }
        });
        this.tracksTabbedPane.setSelectedComponent(trackPanel);
    }

    public String getElevationUnit() {
        return this.elevationUnit;
    }

    public void setElevationUnit(String string) {
        this.elevationUnit = string;
        for (int i = 0; i < this.tracksTabbedPane.getTabCount(); ++i) {
            TrackPanel trackPanel = (TrackPanel)this.tracksTabbedPane.getComponentAt(i);
            trackPanel.setElevationUnit(string);
        }
    }

    public String getAngleFormat() {
        return this.angleFormat;
    }

    public void setAngleFormat(String string) {
        this.angleFormat = string;
        for (int i = 0; i < this.tracksTabbedPane.getTabCount(); ++i) {
            TrackPanel trackPanel = (TrackPanel)this.tracksTabbedPane.getComponentAt(i);
            trackPanel.setAngleFormat(string);
        }
    }

    private void removeTrack(SARTrack sARTrack) {
        TrackPanel trackPanel = this.getTrackPanel(sARTrack);
        if (trackPanel != null) {
            this.tracksTabbedPane.remove(trackPanel);
        }
    }

    private void renameTrack(SARTrack sARTrack) {
        int n = this.getTrackPanelIndex(sARTrack);
        if (n != -1) {
            this.tracksTabbedPane.setTitleAt(n, sARTrack.getName());
        }
    }

    private void updateTrackDirty(SARTrack sARTrack) {
        int n = this.getTrackPanelIndex(sARTrack);
        if (n != -1) {
            this.tracksTabbedPane.setTitleAt(n, sARTrack.getName() + (sARTrack.isDirty() ? "*" : ""));
        }
    }

    public TrackPanel getTrackPanel(SARTrack sARTrack) {
        for (int i = 0; i < this.tracksTabbedPane.getTabCount(); ++i) {
            TrackPanel trackPanel = (TrackPanel)this.tracksTabbedPane.getComponentAt(i);
            if (trackPanel.getTrack() != sARTrack) continue;
            return trackPanel;
        }
        return null;
    }

    private int getTrackPanelIndex(SARTrack sARTrack) {
        for (int i = 0; i < this.tracksTabbedPane.getTabCount(); ++i) {
            TrackPanel trackPanel = (TrackPanel)this.tracksTabbedPane.getComponentAt(i);
            if (trackPanel.getTrack() != sARTrack) continue;
            return i;
        }
        return -1;
    }

    private void tracksTabbedPaneStateChanged(ChangeEvent changeEvent) {
        SARTrack sARTrack = this.getCurrentTrack();
        if (sARTrack == null) {
            return;
        }
        sARTrack.firePropertyChange("TrackController.TrackCurrent", null, sARTrack);
    }

    private static Icon makeColorCircle(Color color) {
        BufferedImage bufferedImage = PatternFactory.createPattern((String)"PatternFactory.PatternCircle", (Dimension)new Dimension(16, 16), (float)0.9f, (Color)color);
        return new ImageIcon(bufferedImage);
    }
}

