/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.sar;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWMath;
import gov.nasa.worldwind.util.WWXML;
import java.io.File;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.xpath.XPath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class UserPreferenceUtils {
    public static Document createUserPreferencesDocument(AVList aVList) {
        if (aVList == null) {
            String string = Logging.getMessage((String)"nullValue.ParametersIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Document document = WWXML.createDocumentBuilder((boolean)true).newDocument();
        Element element = document.createElement("Preferences");
        element.setAttribute("version", Integer.toString(1));
        document.appendChild(element);
        UserPreferenceUtils.createUserPreferenceElements(aVList, element);
        return document;
    }

    public static void getUserPreferences(Element element, AVList aVList) {
        if (element == null) {
            String string = Logging.getMessage((String)"nullValue.DocumentIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (aVList == null) {
            String string = Logging.getMessage((String)"nullValue.ParametersIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        XPath xPath = WWXML.makeXPath();
        Element element2 = WWXML.getElement((Element)element, (String)"PropertyList", (XPath)xPath);
        if (element2 != null) {
            UserPreferenceUtils.getPropertyList(element2, aVList, xPath);
        }
    }

    public static void createUserPreferenceElements(AVList aVList, Element element) {
        if (aVList == null) {
            String string = Logging.getMessage((String)"nullValue.ParametersIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (element == null) {
            String string = Logging.getMessage((String)"nullValue.DocumentIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Element element2 = WWXML.appendElementPath((Element)element, (String)"PropertyList");
        UserPreferenceUtils.createPropertyList(aVList, element2);
    }

    public static String getDefaultUserPreferencesPath() {
        String string = Configuration.getUserHomeDirectory();
        String string2 = ".sarapp/UserPreferences.xml";
        return string + File.separator + string2;
    }

    public static void getDefaultUserPreferences(AVList aVList) {
        if (aVList == null) {
            String string = Logging.getMessage((String)"nullValue.ParametersIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        aVList.setValue("AngleFormat", (Object)"gov.nasa.worldwind.Geom.AngleDD");
        aVList.setValue("AutoSaveTracks", (Object)Boolean.toString(true));
        aVList.setValue("AutoSaveTracksInterval", (Object)Long.toString((long)WWMath.convertMinutesToMillis((double)1.0)));
        aVList.setValue("ElevationUnit", (Object)"Imperial");
    }

    public static boolean getBooleanValue(AVList aVList, String string) {
        Object object = aVList.getValue(string);
        if (object == null) {
            return false;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        String string2 = AVListImpl.getStringValue((AVList)aVList, (String)string);
        if (string2 == null) {
            return false;
        }
        try {
            return Boolean.parseBoolean(string2);
        }
        catch (NumberFormatException numberFormatException) {
            Logging.logger().log(Level.SEVERE, "Configuration.ConversionError", string2);
            return false;
        }
    }

    protected static void getPropertyList(Element element, AVList aVList, XPath xPath) {
        Element[] elementArray = WWXML.getElements((Element)element, (String)"Property", (XPath)xPath);
        if (elementArray == null || elementArray.length == 0) {
            return;
        }
        for (Element element2 : elementArray) {
            if (element2 == null) continue;
            UserPreferenceUtils.getProperty(element2, aVList, xPath);
        }
    }

    protected static void getProperty(Element element, AVList aVList, XPath xPath) {
        String string = WWXML.getText((Element)element, (String)"@key", (XPath)xPath);
        String string2 = WWXML.getText((Element)element, (String)"@value", (XPath)xPath);
        if (string == null || string2 == null) {
            return;
        }
        aVList.setValue(string, (Object)string2);
    }

    protected static void createPropertyList(AVList aVList, Element element) {
        for (Map.Entry entry : aVList.getEntries()) {
            if (entry == null || entry.getKey() == null || entry.getValue() == null) continue;
            UserPreferenceUtils.createProperty(entry, element);
        }
    }

    protected static void createProperty(Map.Entry<String, Object> entry, Element element) {
        String string = entry.getValue().toString();
        if (string == null) {
            return;
        }
        Element element2 = WWXML.appendElementPath((Element)element, (String)"Property");
        element2.setAttribute("key", entry.getKey());
        element2.setAttribute("value", string);
    }
}

