/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.sar.render;

import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.OrderedRenderable;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.util.Logging;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import javax.media.opengl.GL2;

public class ScreenElevationLine
implements Renderable {
    private double elevation = 0.0;
    private Color color = Color.WHITE;
    private boolean enabled = true;

    public double getElevation() {
        return this.elevation;
    }

    public void setElevation(double d) {
        this.elevation = d;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            String string = Logging.getMessage((String)"nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.color = color;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public void render(DrawContext drawContext) {
        if (this.isEnabled()) {
            drawContext.addOrderedRenderable((OrderedRenderable)new OrderedItem());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void draw(DrawContext drawContext) {
        Double d = this.computeLineY(drawContext);
        if (d == null) {
            return;
        }
        GL2 gL2 = drawContext.getGL().getGL2();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            gL2.glPushAttrib(30977);
            bl = true;
            gL2.glEnable(3042);
            gL2.glBlendFunc(770, 771);
            gL2.glDisable(2929);
            Rectangle rectangle = drawContext.getView().getViewport();
            gL2.glMatrixMode(5889);
            gL2.glPushMatrix();
            bl3 = true;
            gL2.glLoadIdentity();
            gL2.glOrtho(0.0, (double)rectangle.width, 0.0, (double)rectangle.height, -1.0, 1.0);
            gL2.glMatrixMode(5888);
            gL2.glPushMatrix();
            bl2 = true;
            gL2.glLoadIdentity();
            if (!drawContext.isPickingMode()) {
                gL2.glColor4ub((byte)this.color.getRed(), (byte)this.color.getGreen(), (byte)this.color.getBlue(), (byte)this.color.getAlpha());
            }
            gL2.glBegin(3);
            gL2.glVertex3d(0.0, d.doubleValue(), 0.0);
            gL2.glVertex3d((double)rectangle.width, d.doubleValue(), 0.0);
            gL2.glEnd();
        }
        finally {
            if (bl3) {
                gL2.glMatrixMode(5889);
                gL2.glPopMatrix();
            }
            if (bl2) {
                gL2.glMatrixMode(5888);
                gL2.glPopMatrix();
            }
            if (bl) {
                gL2.glPopAttrib();
            }
        }
    }

    private Double computeLineY(DrawContext drawContext) {
        Vec4 vec4;
        Vec4 vec42 = drawContext.getGlobe().computePointFromPosition(new Position((LatLon)drawContext.getView().getEyePosition(), this.elevation));
        Vec4 vec43 = drawContext.getView().getForwardVector().perpendicularTo3(vec42);
        Vec4 vec44 = drawContext.getView().getFrustumInModelCoordinates().getNear().intersect(new Line(vec42, vec43));
        if (vec44 != null && (vec4 = drawContext.getView().project(vec44)) != null) {
            return vec4.y;
        }
        return null;
    }

    private class OrderedItem
    implements OrderedRenderable {
        private OrderedItem() {
        }

        public double getDistanceFromEye() {
            return 1.0;
        }

        public void render(DrawContext drawContext) {
            ScreenElevationLine.this.draw(drawContext);
        }

        public void pick(DrawContext drawContext, Point point) {
            ScreenElevationLine.this.draw(drawContext);
        }
    }
}

