/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.sar.segmentplane;

import gov.nasa.worldwind.View;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Intersection;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Plane;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.layers.AbstractLayer;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.airspaces.editor.AirspaceEditorUtil;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwindx.applications.sar.segmentplane.SegmentPlane;
import gov.nasa.worldwindx.applications.sar.segmentplane.SegmentPlaneRenderer;
import java.awt.Component;
import java.awt.Point;

public class SegmentPlaneEditor
extends AbstractLayer {
    protected static final int SEGMENT_BEGIN_INDEX = 0;
    protected static final int SEGMENT_END_INDEX = 1;
    private boolean armed = false;
    private boolean snapToGrid = true;
    private SegmentPlane segmentPlane;
    private SegmentPlaneRenderer renderer = new SegmentPlaneRenderer();

    public boolean isArmed() {
        return this.armed;
    }

    public void setArmed(boolean bl) {
        this.armed = bl;
    }

    public boolean isSnapToGrid() {
        return this.snapToGrid;
    }

    public void setSnapToGrid(boolean bl) {
        this.snapToGrid = bl;
    }

    public SegmentPlane getSegmentPlane() {
        return this.segmentPlane;
    }

    public void setSegmentPlane(SegmentPlane segmentPlane) {
        this.segmentPlane = segmentPlane;
    }

    public SegmentPlaneRenderer getSegmentPlaneRenderer() {
        return this.renderer;
    }

    public void setSegmentPlaneRenderer(SegmentPlaneRenderer segmentPlaneRenderer) {
        this.renderer = segmentPlaneRenderer;
    }

    protected void doRender(DrawContext drawContext) {
        if (!this.isArmed()) {
            return;
        }
        if (this.getSegmentPlane() == null || this.getSegmentPlaneRenderer() == null) {
            return;
        }
        this.getSegmentPlaneRenderer().render(drawContext, this.getSegmentPlane());
    }

    protected void doPick(DrawContext drawContext, Point point) {
        if (!this.isArmed()) {
            return;
        }
        if (this.getSegmentPlane() == null || this.getSegmentPlaneRenderer() == null) {
            return;
        }
        this.getSegmentPlaneRenderer().pick(drawContext, this.getSegmentPlane(), point, (Layer)this);
    }

    public void moveControlPoint(WorldWindow worldWindow, PickedObject pickedObject, Point point, Point point2) {
        if (worldWindow == null) {
            String string = Logging.getMessage((String)"nullValue.WorldWindow");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (pickedObject == null) {
            String string = Logging.getMessage((String)"nullValue.PickedObject");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.getSegmentPlane() == null) {
            return;
        }
        if (!(pickedObject.getObject() instanceof SegmentPlane.ControlPoint)) {
            return;
        }
        SegmentPlane.ControlPoint controlPoint = (SegmentPlane.ControlPoint)pickedObject.getObject();
        if (this.getSegmentPlane() != controlPoint.getOwner()) {
            return;
        }
        this.doMoveControlPoint(worldWindow, pickedObject, point, point2);
    }

    protected void doMoveControlPoint(WorldWindow worldWindow, PickedObject pickedObject, Point point, Point point2) {
        SegmentPlane.ControlPoint controlPoint = (SegmentPlane.ControlPoint)pickedObject.getObject();
        Object object = controlPoint.getKey();
        if (object == null) {
            return;
        }
        if (object.equals("SegmentPlane.SegmentBegin") || object.equals("SegmentPlane.SegmentEnd")) {
            this.doMoveSegmentPoint(worldWindow, pickedObject, point, point2);
        } else if (object.equals("SegmentPlane.ControlPointLowerLeft")) {
            this.doMoveSegmentPlane(worldWindow, pickedObject, point, point2);
        } else if (object.equals("SegmentPlane.ControlPointLowerRight") || object.equals("SegmentPlane.ControlPointUpperRight")) {
            this.doMoveLateralControlPoint(worldWindow, pickedObject, point, point2);
        } else if (object.equals("SegmentPlane.ControlPointTopEdge")) {
            this.doMoveVerticalControlPoint(worldWindow, pickedObject, point, point2);
        } else if (object.equals("SegmentPlane.ControlPointLeadingEdge")) {
            this.doMoveHorizontalControlPoint(worldWindow, pickedObject, point, point2);
        }
    }

    protected void doMoveSegmentPlane(WorldWindow worldWindow, PickedObject pickedObject, Point point, Point point2) {
        Line line;
        Intersection[] intersectionArray;
        View view = worldWindow.getView();
        Globe globe = worldWindow.getModel().getGlobe();
        LatLon[] latLonArray = this.getSegmentPlane().getPlaneLocations();
        Position position = pickedObject.getPosition();
        Position position2 = new Position(latLonArray[0], position.getElevation());
        Vec4 vec4 = globe.computePointFromPosition(position2);
        Vec4 vec42 = view.project(vec4);
        int n = point.x - point2.x;
        int n2 = point.y - point2.y;
        double d = vec42.x + (double)n;
        double d2 = vec42.y + (double)n2;
        if (worldWindow instanceof Component) {
            d2 = (double)((Component)worldWindow).getSize().height - vec42.y + (double)n2 - 1.0;
        }
        if ((intersectionArray = globe.intersect(line = view.computeRayFromScreenPoint(d, d2), position2.getElevation())) == null || intersectionArray.length == 0) {
            return;
        }
        Position position3 = globe.computePositionFromPoint(intersectionArray[0].getIntersectionPoint());
        Angle angle = LatLon.greatCircleAzimuth((LatLon)position2, (LatLon)position3);
        Angle angle2 = LatLon.greatCircleDistance((LatLon)position2, (LatLon)position3);
        latLonArray[0] = LatLon.greatCircleEndPosition((LatLon)latLonArray[0], (Angle)angle, (Angle)angle2);
        latLonArray[1] = LatLon.greatCircleEndPosition((LatLon)latLonArray[1], (Angle)angle, (Angle)angle2);
        this.moveSegmentLocationWithPlane(latLonArray, 0);
        this.moveSegmentLocationWithPlane(latLonArray, 1);
        this.getSegmentPlane().setPlaneLocations(latLonArray[0], latLonArray[1]);
    }

    protected void doMoveSegmentPoint(WorldWindow worldWindow, PickedObject pickedObject, Point point, Point point2) {
        Position position = pickedObject.getPosition();
        Position position2 = this.computeNewPositionFromPlaneGeometry(worldWindow);
        if (position2 == null && (position2 = this.computeNewPositionFromPlaneIntersection(worldWindow, point)) != null) {
            position2 = this.resizeSegmentPlaneToFitPosition(worldWindow, position2);
        }
        if (position2 == null) {
            return;
        }
        position2 = this.computePositionOnOrAboveSurface(worldWindow, position2);
        Position[] positionArray = this.getSegmentPlane().getSegmentPositions();
        Object object = pickedObject.getValue("gov.nasa.worldwind.avkey.PickedObject.ID");
        if (object.equals("SegmentPlane.SegmentBegin")) {
            positionArray[0] = new Position((LatLon)position, position2.getElevation());
        } else if (object.equals("SegmentPlane.SegmentEnd")) {
            positionArray[1] = position2;
        }
        this.getSegmentPlane().setSegmentPositions(positionArray[0], positionArray[1]);
    }

    protected Position computeNewPositionFromPlaneGeometry(WorldWindow worldWindow) {
        PickedObject pickedObject;
        if (this.isSnapToGrid() && (pickedObject = this.getPickedSegmentPlaneObject(worldWindow, "SegmentPlane.PlaneGrid")) != null) {
            return pickedObject.getPosition();
        }
        pickedObject = this.getPickedSegmentPlaneObject(worldWindow, "SegmentPlane.PlaneBackground");
        if (pickedObject != null) {
            return pickedObject.getPosition();
        }
        return null;
    }

    protected Position computeNewPositionFromPlaneIntersection(WorldWindow worldWindow, Point point) {
        View view = worldWindow.getView();
        Globe globe = worldWindow.getModel().getGlobe();
        Line line = view.computeRayFromScreenPoint(point.getX(), point.getY());
        Plane plane = this.getSegmentPlane().computeInfinitePlane(globe);
        if (plane == null) {
            return null;
        }
        Vec4 vec4 = plane.intersect(line);
        if (vec4 == null) {
            return null;
        }
        return globe.computePositionFromPoint(vec4);
    }

    protected Position resizeSegmentPlaneToFitPosition(WorldWindow worldWindow, Position position) {
        Globe globe = worldWindow.getModel().getGlobe();
        double[] dArray = this.getSegmentPlane().getPlaneAltitudes();
        double[] dArray2 = this.getSegmentPlane().getGridCellDimensions();
        LatLon[] latLonArray = this.getSegmentPlane().getPlaneLocations();
        if (position.getElevation() < dArray[0]) {
            dArray[0] = dArray[0] + this.getNextGridStep(position.getElevation(), dArray[0], dArray2[1]);
        }
        if (position.getElevation() > dArray[1]) {
            dArray[1] = dArray[0] + this.getNextGridStep(position.getElevation(), dArray[0], dArray2[1]);
        }
        Vec4[] vec4Array = new Vec4[]{globe.computePointFromPosition(latLonArray[0].getLatitude(), latLonArray[0].getLongitude(), dArray[0]), globe.computePointFromPosition(latLonArray[1].getLatitude(), latLonArray[1].getLongitude(), dArray[0])};
        Vec4 vec4 = vec4Array[1].subtract3(vec4Array[0]).normalize3();
        double d = vec4Array[0].distanceTo3(vec4Array[1]);
        Vec4 vec42 = globe.computePointFromPosition(position);
        Vec4 vec43 = vec42.subtract3(vec4Array[0]);
        double d2 = vec43.dot3(vec4);
        if (d2 > d) {
            double d3 = this.getNextGridStep(d2, 0.0, dArray2[0]);
            Vec4 vec44 = vec4Array[0].add3(vec4.multiply3(d3));
            latLonArray[1] = new LatLon((LatLon)globe.computePositionFromPoint(vec44));
        }
        if (d2 < 0.0) {
            position = new Position(latLonArray[0], position.getElevation());
        }
        this.getSegmentPlane().setPlaneAltitudes(dArray[0], dArray[1]);
        this.getSegmentPlane().setPlaneLocations(latLonArray[0], latLonArray[1]);
        return position;
    }

    protected void doMoveLateralControlPoint(WorldWindow worldWindow, PickedObject pickedObject, Point point, Point point2) {
        View view = worldWindow.getView();
        Globe globe = worldWindow.getModel().getGlobe();
        double[] dArray = this.getSegmentPlane().getPlaneAltitudes();
        LatLon[] latLonArray = this.getSegmentPlane().getPlaneLocations();
        Position position = pickedObject.getPosition();
        Line line = view.computeRayFromScreenPoint(point.getX(), point.getY());
        Intersection[] intersectionArray = globe.intersect(line, position.getElevation());
        if (intersectionArray == null || intersectionArray.length < 0) {
            return;
        }
        Vec4 vec4 = intersectionArray[0].getIntersectionPoint();
        LatLon latLon = new LatLon((LatLon)globe.computePositionFromPoint(vec4));
        Object object = pickedObject.getValue("gov.nasa.worldwind.avkey.PickedObject.ID");
        if (object.equals("SegmentPlane.ControlPointLowerRight") || object.equals("SegmentPlane.ControlPointUpperRight")) {
            latLonArray[1] = latLon;
            this.moveSegmentLocationWithPlane(latLonArray, 1);
        }
        this.getSegmentPlane().setPlaneLocations(latLonArray[0], latLonArray[1]);
    }

    protected void doMoveVerticalControlPoint(WorldWindow worldWindow, PickedObject pickedObject, Point point, Point point2) {
        View view = worldWindow.getView();
        Globe globe = worldWindow.getModel().getGlobe();
        double[] dArray = this.getSegmentPlane().getPlaneAltitudes();
        Position[] positionArray = this.getSegmentPlane().getSegmentPositions();
        Position position = pickedObject.getPosition();
        Vec4 vec4 = globe.computePointFromPosition(position);
        Vec4 vec42 = globe.computeSurfaceNormalAtPoint(vec4);
        Line line = new Line(vec4, vec42);
        Line line2 = view.computeRayFromScreenPoint(point.getX(), point.getY());
        Vec4 vec43 = AirspaceEditorUtil.nearestPointOnLine((Line)line, (Line)line2);
        Position position2 = globe.computePositionFromPoint(vec43);
        dArray[1] = position2.getElevation();
        if (dArray[1] < dArray[0]) {
            dArray[1] = dArray[0];
        }
        for (int i = 0; i < 2; ++i) {
            if (!(dArray[1] < positionArray[i].getElevation())) continue;
            dArray[1] = positionArray[i].getElevation();
        }
        this.getSegmentPlane().setPlaneAltitudes(dArray[0], dArray[1]);
    }

    protected void doMoveHorizontalControlPoint(WorldWindow worldWindow, PickedObject pickedObject, Point point, Point point2) {
        Angle angle;
        View view = worldWindow.getView();
        Globe globe = worldWindow.getModel().getGlobe();
        LatLon[] latLonArray = this.getSegmentPlane().getPlaneLocations();
        Position[] positionArray = this.getSegmentPlane().getSegmentPositions();
        Position position = pickedObject.getPosition();
        Line line = view.computeRayFromScreenPoint(point.getX(), point.getY());
        Intersection[] intersectionArray = globe.intersect(line, position.getElevation());
        if (intersectionArray == null || intersectionArray.length < 0) {
            return;
        }
        Vec4 vec4 = intersectionArray[0].getIntersectionPoint();
        LatLon latLon = new LatLon((LatLon)globe.computePositionFromPoint(vec4));
        Angle angle2 = LatLon.rhumbAzimuth((LatLon)latLonArray[0], (LatLon)latLonArray[1]);
        Angle angle3 = LatLon.rhumbDistance((LatLon)latLonArray[0], (LatLon)latLon);
        if (angle3.compareTo(angle = LatLon.rhumbDistance((LatLon)latLonArray[0], (LatLon)positionArray[1])) < 0) {
            angle3 = angle;
        }
        latLonArray[1] = LatLon.rhumbEndPosition((LatLon)latLonArray[0], (Angle)angle2, (Angle)angle3);
        this.getSegmentPlane().setPlaneLocations(latLonArray[0], latLonArray[1]);
    }

    protected Position moveSegmentAltitudeWithPlane(Position position, double[] dArray) {
        double d = position.getElevation();
        if (d >= dArray[0] && d <= dArray[1]) {
            return null;
        }
        if (d < dArray[0]) {
            d = dArray[0];
        }
        if (d > dArray[1]) {
            d = dArray[1];
        }
        return new Position((LatLon)position, d);
    }

    protected void moveSegmentLocationWithPlane(LatLon[] latLonArray, int n) {
        LatLon[] latLonArray2 = this.getSegmentPlane().getPlaneLocations();
        Position position = this.getSegmentPlane().getSegmentPositions()[n];
        if (n == 0) {
            Position position2 = new Position(latLonArray[0], position.getElevation());
            this.getSegmentPlane().setSegmentBeginPosition(position2);
        } else if (n == 1) {
            Angle angle;
            Angle angle2 = LatLon.rhumbAzimuth((LatLon)latLonArray[0], (LatLon)latLonArray[1]);
            Angle angle3 = LatLon.rhumbDistance((LatLon)latLonArray2[0], (LatLon)position);
            if (angle3.compareTo(angle = LatLon.rhumbDistance((LatLon)latLonArray[0], (LatLon)latLonArray[1])) > 0) {
                angle3 = angle;
            }
            LatLon latLon = LatLon.rhumbEndPosition((LatLon)latLonArray[0], (Angle)angle2, (Angle)angle3);
            Position position3 = new Position(latLon, position.getElevation());
            this.getSegmentPlane().setSegmentEndPosition(position3);
        }
    }

    protected PickedObject getPickedSegmentPlaneObject(WorldWindow worldWindow, Object object) {
        if (worldWindow.getSceneController().getPickedObjectList() == null) {
            return null;
        }
        for (PickedObject pickedObject : worldWindow.getSceneController().getPickedObjectList()) {
            Object object2;
            if (pickedObject == null || pickedObject.getObject() != this.getSegmentPlane() || (object2 = pickedObject.getValue("gov.nasa.worldwind.avkey.PickedObject.ID")) != object) continue;
            return pickedObject;
        }
        return null;
    }

    protected Position computePositionOnOrAboveSurface(WorldWindow worldWindow, Position position) {
        Vec4 vec4;
        if (worldWindow.getSceneController().getTerrain() != null && (vec4 = worldWindow.getSceneController().getTerrain().getSurfacePoint(position.getLatitude(), position.getLongitude())) != null) {
            Position position2 = worldWindow.getModel().getGlobe().computePositionFromPoint(vec4);
            if (position.getElevation() < position2.getElevation()) {
                return new Position((LatLon)position, position2.getElevation());
            }
            return position;
        }
        double d = worldWindow.getModel().getGlobe().getElevation(position.getLatitude(), position.getLongitude());
        if (position.getElevation() < d) {
            return new Position((LatLon)position, d);
        }
        return position;
    }

    protected double getNextGridStep(double d, double d2, double d3) {
        double d4 = Math.ceil((d - d2) / d3);
        return d3 * d4;
    }
}

