/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.sar.tracks;

import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.formats.gpx.GpxReader;
import gov.nasa.worldwind.tracks.Track;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwindx.applications.sar.tracks.AbstractTrackReader;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class GPXTrackReader
extends AbstractTrackReader {
    @Override
    public String getDescription() {
        return "GPS Exchange Format (*.xml, *.gpx)";
    }

    @Override
    protected Track[] doRead(InputStream inputStream) throws IOException {
        try {
            GpxReader gpxReader = new GpxReader();
            gpxReader.readStream(inputStream);
            return this.asArray(gpxReader.getTracks());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            String string = Logging.getMessage((String)"XML.ParserConfigurationException");
            Logging.logger().finest(string);
            throw new WWRuntimeException((Throwable)parserConfigurationException);
        }
        catch (SAXException sAXException) {
            String string = Logging.getMessage((String)"generic.ExceptionAttemptingToParseXml", (Object[])new Object[]{inputStream});
            Logging.logger().severe(string);
            throw new WWRuntimeException((Throwable)sAXException);
        }
    }

    @Override
    protected boolean acceptFilePath(String string) {
        String string2 = string.toLowerCase();
        return string2.endsWith(".xml") || string2.endsWith(".gpx");
    }
}

