/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.worldwindow;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwindx.applications.worldwindow.core.Controller;
import gov.nasa.worldwindx.applications.worldwindow.util.Util;
import java.awt.Dimension;
import java.util.logging.Level;

public class WorldWindow {
    private static final String APP_CONFIGURATION = "gov/nasa/worldwindx/applications/worldwindow/config/AppConfiguration.xml";

    public static void main(String[] stringArray) {
        Controller controller = new Controller();
        Dimension dimension = null;
        if (stringArray.length >= 2) {
            dimension = new Dimension(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]));
        }
        try {
            controller.start(APP_CONFIGURATION, dimension);
        }
        catch (Exception exception) {
            String string = "Fatal application error";
            controller.showErrorDialog(null, "Cannot Start Application", string, new Object[0]);
            Util.getLogger().log(Level.SEVERE, string);
        }
    }

    static {
        System.setProperty("gov.nasa.worldwind.app.config.document", "gov/nasa/worldwindx/applications/worldwindow/config/worldwindow.worldwind.xml");
        if (Configuration.isMacOS()) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.mrj.application.growbox.intrudes", "false");
            String string = Configuration.getStringValue((String)"gov.nasa.worldwindx.applications.worldwindow.ApplicationDisplayName");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", Configuration.getStringValue((String)"gov.nasa.worldwindx.applications.worldwindow.ApplicationDisplayName"));
        } else if (Configuration.isWindowsOS()) {
            System.setProperty("sun.awt.noerasebackground", "true");
        }
    }
}

