/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.worldwindow.core;

import gov.nasa.worldwindx.applications.worldwindow.core.Controller;
import gov.nasa.worldwindx.applications.worldwindow.core.Menu;
import gov.nasa.worldwindx.applications.worldwindow.core.Registry;
import gov.nasa.worldwindx.applications.worldwindow.core.WWMenu;
import gov.nasa.worldwindx.applications.worldwindow.features.Feature;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class AbstractMenu
extends JMenu
implements Menu,
MenuListener,
WWMenu {
    protected Controller controller;

    protected AbstractMenu(String string, String string2, Registry registry) {
        super(string);
        if (string2 != null && registry != null) {
            registry.registerObject(string2, this);
        }
    }

    @Override
    public void initialize(Controller controller) {
        this.controller = controller;
        this.addMenuListener(this);
    }

    @Override
    public boolean isInitialized() {
        return this.controller != null;
    }

    protected void addToMenuBar() {
        if (this.controller.getMenuBar() != null) {
            this.controller.getMenuBar().addMenu(this);
        }
    }

    @Override
    public void addMenu(String string) {
        this.addMenus(new String[]{string});
    }

    @Override
    public void addMenus(String[] stringArray) {
        boolean bl = false;
        for (String string : stringArray) {
            Object object;
            if (string == null || string.length() == 0) {
                bl = false;
                this.add(new JSeparator());
                continue;
            }
            if (string.equals("gov.nasa.worldwindx.applications.worldwindow.StatusBarMessage")) {
                bl = true;
                continue;
            }
            if (string.startsWith("gov.nasa.worldwindx.applications.worldwindow.menu")) {
                object = this.controller.getRegisteredObject(string);
                if (!(object instanceof Menu)) continue;
                this.add(((Menu)object).getJMenu());
                continue;
            }
            object = (Feature)this.controller.getRegisteredObject(string);
            if (object == null) continue;
            if (object.isTwoState()) {
                if (bl) {
                    final RadioMenuItem radioMenuItem = new RadioMenuItem((Action)object);
                    this.add(radioMenuItem);
                    object.addPropertyChangeListener(new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                            if (propertyChangeEvent.getPropertyName().equals("gov.nasa.worldwindx.applications.worldwindow.OnState")) {
                                radioMenuItem.setSelected((Boolean)propertyChangeEvent.getNewValue());
                                radioMenuItem.repaint();
                            }
                        }
                    });
                    continue;
                }
                this.add(new ToggleMenuItem((Action)object));
                continue;
            }
            bl = false;
            this.add(new JMenuItem((Action)object));
        }
    }

    @Override
    public void menuSelected(MenuEvent menuEvent) {
        for (int i = 0; i < this.getItemCount(); ++i) {
            JMenuItem jMenuItem = this.getItem(i);
            if (!(jMenuItem instanceof ToggleMenuItem)) continue;
            ToggleMenuItem toggleMenuItem = (ToggleMenuItem)jMenuItem;
            Feature feature = (Feature)toggleMenuItem.getAction();
            toggleMenuItem.setState(feature.isOn());
        }
    }

    @Override
    public void menuDeselected(MenuEvent menuEvent) {
    }

    @Override
    public void menuCanceled(MenuEvent menuEvent) {
    }

    protected Controller getController() {
        return this.controller;
    }

    @Override
    public JMenu getJMenu() {
        return this;
    }

    protected List<Feature> getFeatures() {
        ArrayList<Feature> arrayList = new ArrayList<Feature>();
        for (int i = 0; i < this.getItemCount(); ++i) {
            Action action;
            Action action2 = action = this.getItem(i) != null ? this.getItem(i).getAction() : null;
            if (action == null || !(action instanceof Feature)) continue;
            arrayList.add((Feature)action);
        }
        return arrayList;
    }

    private static class RadioMenuItem
    extends JRadioButtonMenuItem {
        public RadioMenuItem(Action action) {
            super(action);
        }
    }

    private static class ToggleMenuItem
    extends JCheckBoxMenuItem {
        public ToggleMenuItem(Action action) {
            super(action);
        }
    }
}

