/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.worldwindow.core;

import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwind.util.WWXML;
import gov.nasa.worldwindx.applications.worldwindow.core.Controller;
import gov.nasa.worldwindx.applications.worldwindow.core.ImageLibrary;
import gov.nasa.worldwindx.applications.worldwindow.core.Initializable;
import gov.nasa.worldwindx.applications.worldwindow.util.Util;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import javax.xml.xpath.XPathConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AppConfiguration
implements Initializable {
    protected Controller controller;
    protected String configurationLocation;

    @Override
    public void initialize(Controller controller) {
        this.controller = controller;
    }

    @Override
    public boolean isInitialized() {
        return this.controller != null;
    }

    public void configure(String string) {
        if (WWUtil.isEmpty((Object)string)) {
            throw new IllegalArgumentException("The application configuration location name is null or empty");
        }
        this.configurationLocation = string;
        ImageLibrary.setInstance(new ImageLibrary());
        this.configureFeatures(string);
    }

    protected void configureFeatures(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    AppConfiguration.this.registerConfiguration(string);
                }
                catch (Exception exception) {
                    Util.getLogger().log(Level.SEVERE, "Unable to create initial configuration for {0}", string);
                }
            }
        });
    }

    protected void registerConfiguration(String string) throws Exception {
        String string2;
        Document document = WWXML.openDocumentFile((String)string, this.getClass());
        NodeList nodeList = (NodeList)WWXML.makeXPath().evaluate("//Feature", document, XPathConstants.NODESET);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string3;
            String string4 = null;
            String string5 = null;
            string2 = null;
            try {
                Element element = (Element)nodeList.item(i);
                String string6 = WWXML.getText((Element)element, (String)"@featureID");
                string5 = WWXML.getText((Element)element, (String)"@className");
                string2 = WWXML.getText((Element)element, (String)"@actuate");
                if (string5 == null || string5.length() == 0) {
                    Util.getLogger().log(Level.WARNING, "Configuration entry in {0} missing feature ID ({1})or classname ({2})", new Object[]{string, string6 != null ? string6 : "null", string5 != null ? string5 : "null"});
                    continue;
                }
                if (!WWUtil.isEmpty((Object)string6)) {
                    if (string2 != null && string2.equals("onDemand")) {
                        this.controller.registerObject(string6, Class.forName(string5));
                    } else {
                        arrayList.add(this.controller.createAndRegisterObject(string6, string5));
                    }
                } else {
                    arrayList.add(this.controller.createRegistryObject(string5));
                }
                string3 = WWXML.getText((Element)element, (String)"@accelerator");
                if (string3 == null || string3.length() <= 0) continue;
                this.controller.registerObject(string5 + ".Accelerator", string3);
                continue;
            }
            catch (Exception exception) {
                string3 = String.format("Error creating configuration entry in %s for feature ID (%s), classname (%s), activate (%s)", string, string4 != null ? string4 : "null", string5 != null ? string5 : "null", string2 != null ? string2 : "null");
                Util.getLogger().log(Level.WARNING, string3, exception);
            }
        }
        for (Object e : arrayList) {
            try {
                if (!(e instanceof Initializable)) continue;
                ((Initializable)e).initialize(this.controller);
            }
            catch (Exception exception) {
                string2 = String.format("Error initializing object %s", e.getClass().getName());
                Util.getLogger().log(Level.WARNING, string2, exception);
            }
        }
    }
}

