/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.worldwindow.core;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.View;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.LayerList;
import gov.nasa.worldwind.poi.PointOfInterest;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwind.view.orbit.OrbitView;
import gov.nasa.worldwind.view.orbit.OrbitViewInputHandler;
import gov.nasa.worldwindx.applications.worldwindow.core.AppConfiguration;
import gov.nasa.worldwindx.applications.worldwindow.core.AppFrame;
import gov.nasa.worldwindx.applications.worldwindow.core.AppPanel;
import gov.nasa.worldwindx.applications.worldwindow.core.Initializable;
import gov.nasa.worldwindx.applications.worldwindow.core.MenuBar;
import gov.nasa.worldwindx.applications.worldwindow.core.Registry;
import gov.nasa.worldwindx.applications.worldwindow.core.StatusPanel;
import gov.nasa.worldwindx.applications.worldwindow.core.ToolBar;
import gov.nasa.worldwindx.applications.worldwindow.core.Version;
import gov.nasa.worldwindx.applications.worldwindow.core.WWPanel;
import gov.nasa.worldwindx.applications.worldwindow.core.layermanager.LayerManager;
import gov.nasa.worldwindx.applications.worldwindow.features.NetworkActivitySignal;
import gov.nasa.worldwindx.applications.worldwindow.util.Util;
import gov.nasa.worldwindx.applications.worldwindow.util.WWOUnitsFormat;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;

public class Controller {
    private String appConfigurationLocation;
    private Registry registry = new Registry();
    private String appTitle;
    private JFileChooser fileChooser;
    private Dimension appSize;
    private WWOUnitsFormat unitsFormat;
    private static final double GOTO_ALTITUDE = 100000.0;

    public void start(String string, Dimension dimension) throws Exception {
        this.appTitle = Configuration.getStringValue((String)"gov.nasa.worldwindx.applications.worldwindow.ApplicationDisplayName");
        this.appSize = dimension;
        this.unitsFormat = new WWOUnitsFormat();
        this.unitsFormat.setShowUTM(true);
        this.unitsFormat.setShowWGS84(true);
        this.appConfigurationLocation = string;
        AppConfiguration appConfiguration = new AppConfiguration();
        appConfiguration.initialize(this);
        appConfiguration.configure(this.appConfigurationLocation);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Controller.this.redraw();
            }
        });
    }

    public String getAppTitle() {
        return this.appTitle;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public String getAppConfigurationLocation() {
        return this.appConfigurationLocation;
    }

    public Dimension getAppSize() {
        return this.appSize;
    }

    public String getVersion() {
        return Version.getVersion();
    }

    public WorldWindow getWWd() {
        return this.getWWPanel().getWWd();
    }

    public WWPanel getWWPanel() {
        return (WWPanel)this.getRegisteredObject("gov.nasa.worldwindx.applications.worldwindow.WWPanel");
    }

    public AppFrame getAppFrame() {
        return (AppFrame)this.getRegisteredObject("gov.nasa.worldwindx.applications.worldwindow.AppFrame");
    }

    public Frame getFrame() {
        AppFrame appFrame = (AppFrame)this.getRegisteredObject("gov.nasa.worldwindx.applications.worldwindow.AppFrame");
        if (appFrame != null) {
            return appFrame.getFrame();
        }
        return Util.findParentFrame((Container)this.getRegisteredObject("gov.nasa.worldwindx.applications.worldwindow.AppPanel"));
    }

    public StatusPanel getStatusPanel() {
        return (StatusPanel)this.getRegisteredObject("gov.nasa.worldwindx.applications.worldwindow.StatusPanel");
    }

    public AppPanel getAppPanel() {
        return (AppPanel)this.getRegisteredObject("gov.nasa.worldwindx.applications.worldwindow.AppPanel");
    }

    public ToolBar getToolBar() {
        return (ToolBar)this.getRegisteredObject("gov.nasa.worldwindx.applications.worldwindow.ToolBar");
    }

    public MenuBar getMenuBar() {
        return (MenuBar)this.getRegisteredObject("gov.nasa.worldwindx.applications.worldwindow.MenuBar");
    }

    public LayerManager getLayerManager() {
        return (LayerManager)this.getRegisteredObject("gov.nasa.worldwindx.applications.worldwindow.feature.LayerManager");
    }

    public JFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
        }
        return this.fileChooser;
    }

    public WWOUnitsFormat getUnits() {
        return this.unitsFormat;
    }

    public NetworkActivitySignal getNetworkActivitySignal() {
        return (NetworkActivitySignal)this.getRegisteredObject("gov.nasa.worldwindx.applications.worldwindow.NetworkStatusSignal");
    }

    public void redraw() {
        if (this.getWWd() != null) {
            this.getWWd().redraw();
        }
    }

    public LayerList getActiveLayers() {
        return this.getWWd().getModel().getLayers();
    }

    public Layer addInternalLayer(Layer layer) {
        return this.addLayer(layer, "gov.nasa.worldwindx.applications.worldwindow.InternalLayer");
    }

    public Layer addInternalActiveLayer(Layer layer) {
        layer.setValue("gov.nasa.worldwindx.applications.worldwindow.ActiveLayer", (Object)true);
        return this.addLayer(layer, "gov.nasa.worldwindx.applications.worldwindow.InternalLayer");
    }

    private Layer addLayer(Layer layer, String string) {
        if (layer != null) {
            layer.setValue(string, (Object)true);
            this.getWWPanel().addLayer(layer);
        }
        return layer;
    }

    public void moveToLocation(PointOfInterest pointOfInterest) {
        this.moveToLocation(pointOfInterest.getLatlon());
    }

    public void moveToLocation(LatLon latLon) {
        Double d = this.getCurrentAltitude();
        double d2 = d != null && d <= 100000.0 ? d : 100000.0;
        this.moveToLocation(new Position(latLon, d2));
    }

    public Double getCurrentAltitude() {
        View view = this.getWWd().getView();
        return view != null ? Double.valueOf(view.getEyePosition().getElevation()) : null;
    }

    public void moveToLocation(Position position) {
        OrbitView orbitView = (OrbitView)this.getWWd().getView();
        Globe globe = this.getWWd().getModel().getGlobe();
        if (globe != null && orbitView != null) {
            ((OrbitViewInputHandler)orbitView.getViewInputHandler()).addPanToAnimator(position, Angle.ZERO, Angle.ZERO, position.elevation, true);
        }
    }

    public void setCursor(Cursor cursor) {
        if (!((Component)this.getWWd()).getCursor().equals(cursor)) {
            ((Component)this.getWWd()).setCursor(cursor);
        }
    }

    public String setStatusMessage(String string) {
        return this.getStatusPanel() != null ? this.getStatusPanel().setStatusMessage(string) : null;
    }

    public Object getRegisteredObject(String string) {
        Object object = this.registry.getRegisteredObject(string);
        if (object == null) {
            return null;
        }
        if (!(object instanceof Class)) {
            return this.registry.getRegisteredObject(string);
        }
        try {
            Object object2 = this.createAndRegisterObject(string, object);
            if (object2 instanceof Initializable) {
                ((Initializable)object2).initialize(this);
            }
            return object2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void registerObject(String string, Object object) {
        this.registry.registerObject(string, object);
    }

    public Object createAndRegisterObject(String string, Object object) throws IllegalAccessException, ClassNotFoundException, InstantiationException {
        return this.registry.createAndRegisterObject(string, object);
    }

    public Object createRegistryObject(String string) throws IllegalAccessException, ClassNotFoundException, InstantiationException {
        return this.registry.createRegistryObject(string);
    }

    public void showErrorDialog(Exception exception, String string, String string2, Object ... objectArray) {
        this.showMessageDialog(Controller.formatMessage(exception, string2, objectArray), string, 0);
    }

    public void showErrorDialogLater(final Exception exception, final String string, final String string2, final Object ... objectArray) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Controller.this.showErrorDialog(exception, string, string2, objectArray);
            }
        });
    }

    public void showCommunicationErrorDialogLater(final Exception exception, final String string, final Object ... objectArray) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Controller.this.showCommunicationErrorDialog(exception, string, objectArray);
            }
        });
    }

    public void showMessageDialog(Object object, String string, int n) {
        this.showMessageDialog(this.getFrame(), object, string, n);
    }

    public void showMessageDialog(Component component, Object object, String string, int n) {
        JOptionPane.showMessageDialog(component, object, string, n);
    }

    public void showMessageDialog(Object object, String string, int n, Object ... objectArray) {
        this.showMessageDialog(this.getFrame(), object, string, n, objectArray);
    }

    public void showMessageDialog(Component component, Object object, String string, int n, Object ... objectArray) {
        JOptionPane.showMessageDialog(component, Controller.formatMessage(null, object, objectArray), string, n);
    }

    public void showCommunicationErrorDialog(Exception exception, String string, Object ... objectArray) {
        this.showMessageDialog(Controller.formatMessage(exception, string, objectArray), "Communication Error", 0);
    }

    public int showOptionDialog(Object object, String string, int n, int n2, Icon icon, Object[] objectArray, Object object2) {
        return JOptionPane.showOptionDialog(this.getFrame(), object, string, n, n2, icon, objectArray, object2);
    }

    private static String formatMessage(Exception exception, Object object, Object[] objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        if (object != null) {
            stringBuilder.append(object.toString());
        }
        if (exception != null) {
            stringBuilder.append((stringBuilder.length() > 0 ? "\n" : "") + exception.toString());
        }
        for (Object object2 : objectArray) {
            if (object2 == null) continue;
            stringBuilder.append((stringBuilder.length() > 0 ? "\n" : "") + object2.toString());
        }
        return stringBuilder.toString();
    }

    public void openLink(String string) {
        if (WWUtil.isEmpty((Object)string)) {
            return;
        }
        try {
            try {
                URL uRL = new URL(string.replace(" ", "%20"));
                Desktop.getDesktop().browse(uRL.toURI());
                return;
            }
            catch (MalformedURLException malformedURLException) {
                File file = new File(string);
                if (file.exists()) {
                    Desktop.getDesktop().open(new File(string));
                    return;
                }
                String string2 = "Cannot open resource. It's not a valid file or URL.";
                Util.getLogger().log(Level.SEVERE, string2);
                this.showErrorDialog(null, "No Reconocido V\u00ednculo", string2, new Object[0]);
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            String string3 = "Unable to open resource.\n" + string + (unsupportedOperationException.getMessage() != null ? "\n" + unsupportedOperationException.getMessage() : "");
            Util.getLogger().log(Level.SEVERE, string3, unsupportedOperationException);
            this.showErrorDialog(unsupportedOperationException, "Error Opening Resource", string3, new Object[0]);
        }
        catch (IOException iOException) {
            String string4 = "I/O error while opening resource.\n" + string + (iOException.getMessage() != null ? ".\n" + iOException.getMessage() : "");
            Util.getLogger().log(Level.SEVERE, string4, iOException);
            this.showErrorDialog(iOException, "I/O Error", string4, new Object[0]);
        }
        catch (Exception exception) {
            String string5 = "Error attempting to open resource.\n" + string + (exception.getMessage() != null ? "\n" + exception.getMessage() : "");
            Util.getLogger().log(Level.SEVERE, string5);
            this.showMessageDialog(string5, "Error Opening Resource", 0);
        }
    }

    public File determineSaveLocation(String string, String string2) {
        File file;
        String string3 = this.getFileChooser().getCurrentDirectory().getPath();
        if (!WWUtil.isEmpty((Object)string3)) {
            string3 = string3 + File.separatorChar + string2;
        }
        while (true) {
            this.getFileChooser().setDialogTitle(string);
            this.getFileChooser().setSelectedFile(new File(string3));
            this.getFileChooser().setMultiSelectionEnabled(false);
            this.getFileChooser().setFileSelectionMode(1);
            int n = this.getFileChooser().showSaveDialog(this.getFrame());
            if (n != 0) {
                return null;
            }
            file = this.getFileChooser().getSelectedFile();
            if (file != null) break;
            this.showMessageDialog("No location selected", "No Selection", 0);
        }
        if (!file.exists()) {
            file.mkdir();
        }
        return file;
    }

    public File chooseOutputFile(String string, String string2, String string3) {
        File file;
        block8: {
            int n;
            String string4 = this.getFileChooser().getCurrentDirectory().getPath();
            if (string != null && string.length() > 0) {
                string4 = string4 + File.separatorChar + string;
            }
            if (string2 != null && string2.length() > 0) {
                string4 = string4 + "." + string2;
            }
            if (string3 == null || string3.length() == 0) {
                string3 = "Choose Save Location";
            }
            this.getFileChooser().setDialogTitle(string3);
            this.getFileChooser().setSelectedFile(new File(string4));
            this.getFileChooser().setMultiSelectionEnabled(false);
            while (true) {
                if ((n = this.getFileChooser().showSaveDialog(this.getFrame())) != 0) {
                    return null;
                }
                file = this.getFileChooser().getSelectedFile();
                if (file == null) {
                    this.showMessageDialog("No location selected", "No Selection", 0);
                    continue;
                }
                if (string2 != null && string2.length() > 0) {
                    file = Util.ensureFileSuffix(file, string2);
                }
                if (!file.exists()) break block8;
                n = this.showConfirmFileOverwriteDialog(file);
                if (n != 1) break;
            }
            if (n == 2) {
                return null;
            }
        }
        return file;
    }

    public int showConfirmFileOverwriteDialog(File file) {
        return JOptionPane.showConfirmDialog(this.getFrame(), "Replace existing file\n" + file.getName() + "?", "Overwrite Existing File?", 1);
    }

    static {
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
    }
}

