/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.worldwindow.core;

import gov.nasa.worldwind.Disposable;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.render.WWIcon;
import gov.nasa.worldwindx.applications.worldwindow.core.Controller;
import gov.nasa.worldwindx.applications.worldwindow.core.Registry;
import gov.nasa.worldwindx.applications.worldwindow.features.AbstractFeature;
import gov.nasa.worldwindx.applications.worldwindow.util.Util;

public class IconController
extends AbstractFeature
implements SelectListener,
Disposable {
    protected WWIcon lastPickedIcon = null;

    public IconController(Registry registry) {
        super("Icon Controller", "gov.nasa.worldwindx.applications.worldwindow.feature.IconController", registry);
    }

    @Override
    public void initialize(Controller controller) {
        super.initialize(controller);
        this.controller.getWWd().addSelectListener((SelectListener)this);
    }

    public void dispose() {
        this.controller.getWWd().removeSelectListener((SelectListener)this);
    }

    public void selected(SelectEvent selectEvent) {
        try {
            if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Rollover")) {
                this.highlight(selectEvent, selectEvent.getTopObject());
            } else if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.RightPress")) {
                this.showContextMenu(selectEvent);
            }
        }
        catch (Exception exception) {
            Util.getLogger().warning(exception.getMessage() != null ? exception.getMessage() : exception.toString());
        }
    }

    protected void highlight(SelectEvent selectEvent, Object object) {
        if (this.lastPickedIcon == object) {
            return;
        }
        if (this.lastPickedIcon != null) {
            this.lastPickedIcon.setHighlighted(false);
            this.lastPickedIcon = null;
        }
        if (object != null && object instanceof WWIcon) {
            this.lastPickedIcon = (WWIcon)object;
            this.lastPickedIcon.setHighlighted(true);
        }
    }

    protected void showContextMenu(SelectEvent selectEvent) {
    }
}

