/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.worldwindow.core;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.layers.AnnotationLayer;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.render.Annotation;
import gov.nasa.worldwind.render.AnnotationAttributes;
import gov.nasa.worldwind.render.ScreenAnnotation;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwindx.applications.worldwindow.core.Controller;
import gov.nasa.worldwindx.applications.worldwindow.core.Registry;
import gov.nasa.worldwindx.applications.worldwindow.features.AbstractFeature;
import gov.nasa.worldwindx.applications.worldwindow.util.Util;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;

public class InfoPanelController
extends AbstractFeature
implements SelectListener {
    protected static final String HARD_SPACE = "\u00a0";
    protected static final String INDENT = "\u00a0\u00a0\u00a0\u00a0";
    protected int maxLineLength = 100;
    protected AnnotationLayer annotationLayer;
    protected ScreenAnnotation annotationPanel;
    protected AVList lastSelectedObject;

    public InfoPanelController(Registry registry) {
        super("Info Panel", "gov.nasa.worldwindx.applications.worldwindow.feature.InfoPanelController", null, registry);
    }

    @Override
    public void initialize(Controller controller) {
        super.initialize(controller);
        this.controller.getWWd().addSelectListener((SelectListener)this);
    }

    public void selected(SelectEvent selectEvent) {
        try {
            if (selectEvent.isRollover()) {
                String string;
                if (this.lastSelectedObject == selectEvent.getTopObject()) {
                    return;
                }
                if (this.lastSelectedObject != null) {
                    this.hideAnnotationPanel();
                    this.lastSelectedObject = null;
                }
                if (selectEvent.getTopObject() != null && selectEvent.getTopObject() instanceof AVList && !WWUtil.isEmpty((Object)(string = ((AVList)selectEvent.getTopObject()).getStringValue("gov.nasa.worldwindx.applications.worldwindow.InfoPanelText")))) {
                    this.lastSelectedObject = (AVList)selectEvent.getTopObject();
                    this.showAnnotationPanel(string);
                }
            }
        }
        catch (Exception exception) {
            Util.getLogger().warning(exception.getMessage() != null ? exception.getMessage() : exception.toString());
        }
    }

    protected void showAnnotationPanel(String string) {
        String string2 = this.splitLines(string);
        AnnotationAttributes annotationAttributes = this.getAnnotationPanelAttributes(string2);
        int n = Math.min(this.controller.getWWPanel().getSize().height - annotationAttributes.getSize().height, 250);
        Point point = new Point(10 + annotationAttributes.getSize().width / 2, n);
        if (this.annotationPanel != null) {
            this.annotationPanel.setAttributes(this.getAnnotationPanelAttributes(string2));
        } else {
            this.annotationPanel = new ScreenAnnotation(string, point, this.getAnnotationPanelAttributes(string2));
        }
        this.annotationPanel.setScreenPoint(point);
        this.annotationPanel.setText(string2);
        if (this.annotationLayer == null) {
            this.annotationLayer = new AnnotationLayer();
            this.annotationLayer.setPickEnabled(false);
        }
        this.annotationLayer.removeAllAnnotations();
        this.annotationLayer.addAnnotation((Annotation)this.annotationPanel);
        if (!this.controller.getActiveLayers().contains((Object)this.annotationLayer)) {
            this.controller.addInternalLayer((Layer)this.annotationLayer);
        }
    }

    protected void hideAnnotationPanel() {
        if (this.annotationLayer != null) {
            this.annotationLayer.removeAllAnnotations();
            this.controller.getActiveLayers().remove((Layer)this.annotationLayer);
            this.annotationLayer.dispose();
            this.annotationLayer = null;
        }
        if (this.annotationPanel != null) {
            this.annotationPanel.dispose();
            this.annotationPanel = null;
        }
    }

    protected AnnotationAttributes getAnnotationPanelAttributes(String string) {
        AnnotationAttributes annotationAttributes = new AnnotationAttributes();
        annotationAttributes.setAdjustWidthToText("gov.nasa.worldwind.avkey.SizeFixed");
        annotationAttributes.setSize(this.computePanelSize(string));
        annotationAttributes.setFrameShape("gov.nasa.worldwind.avkey.ShapeRectangle");
        annotationAttributes.setTextColor(Color.WHITE);
        annotationAttributes.setBackgroundColor(new Color(0.0f, 0.0f, 0.0f, 0.6f));
        annotationAttributes.setCornerRadius(10);
        annotationAttributes.setInsets(new Insets(10, 10, 0, 0));
        annotationAttributes.setBorderColor(new Color(0xABABAB));
        annotationAttributes.setFont(Font.decode("Arial-PLAIN-12"));
        annotationAttributes.setTextAlign("gov.nasa.worldwind.avkey.Left");
        return annotationAttributes;
    }

    protected Dimension computePanelSize(String string) {
        Dimension dimension = this.computeLengths(string);
        int n = 7 * Math.min(dimension.width, this.maxLineLength);
        int n2 = dimension.height * 17;
        return new Dimension(n, n2);
    }

    protected Dimension computeLengths(String string) {
        String[] stringArray = Util.splitLines(string);
        int n = 0;
        for (String string2 : stringArray) {
            if (string2.length() <= n) continue;
            n = string2.length();
        }
        return new Dimension(n + 5, stringArray.length + 1);
    }

    protected String splitLines(String string) {
        String[] stringArray;
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : stringArray = Util.splitLines(string)) {
            stringBuilder.append(string2.length() <= this.maxLineLength ? string2 : this.splitLine(string2)).append("\n");
        }
        return stringBuilder.toString();
    }

    protected String splitLine(String string) {
        String[] stringArray;
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = "";
        for (int i = 0; i < string.length() && string.charAt(i) == '\u00a0'; ++i) {
            string2 = string2 + HARD_SPACE;
        }
        StringBuilder stringBuilder2 = new StringBuilder(string2);
        for (String string3 : stringArray = Util.splitWords(string, "[\u00a0 ]")) {
            if (stringBuilder2.length() + 1 + string3.length() + string2.length() > this.maxLineLength) {
                if (stringBuilder.length() == 0) {
                    string2 = string2 + INDENT;
                }
                stringBuilder.append(stringBuilder2.toString());
                stringBuilder2 = new StringBuilder("\n").append(string2);
            }
            if (!stringBuilder2.toString().endsWith(HARD_SPACE)) {
                stringBuilder2.append(HARD_SPACE);
            }
            stringBuilder2.append(string3);
        }
        if (stringBuilder2.length() > 1) {
            stringBuilder.append(stringBuilder2.toString());
        }
        return stringBuilder.toString();
    }
}

