/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.worldwindow.core;

import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.ogc.OGCCapabilities;
import gov.nasa.worldwind.ogc.wms.WMSLayerCapabilities;
import gov.nasa.worldwind.ogc.wms.WMSLayerStyle;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class WMSLayerInfo {
    private OGCCapabilities caps;
    private AVListImpl params = new AVListImpl();

    public WMSLayerInfo(OGCCapabilities oGCCapabilities, WMSLayerCapabilities wMSLayerCapabilities, WMSLayerStyle wMSLayerStyle) {
        this.caps = oGCCapabilities;
        this.params = new AVListImpl();
        this.params.setValue("gov.nasa.worldwind.avkey.LayerNames", (Object)wMSLayerCapabilities.getName());
        if (wMSLayerStyle != null) {
            this.params.setValue("gov.nasa.worldwind.avkey.StyleNames", (Object)wMSLayerStyle.getName());
        }
        String string = wMSLayerCapabilities.getTitle();
        this.params.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)string);
    }

    public String getTitle() {
        return this.params.getStringValue("gov.nasa.worldwind.avkey.DisplayName");
    }

    public OGCCapabilities getCaps() {
        return this.caps;
    }

    public AVListImpl getParams() {
        return this.params;
    }

    public static List<WMSLayerInfo> createLayerInfos(OGCCapabilities oGCCapabilities, WMSLayerCapabilities wMSLayerCapabilities) {
        ArrayList<WMSLayerInfo> arrayList = new ArrayList<WMSLayerInfo>();
        Set set = wMSLayerCapabilities.getStyles();
        if (set == null || set.size() == 0) {
            arrayList.add(new WMSLayerInfo(oGCCapabilities, wMSLayerCapabilities, null));
        } else {
            for (WMSLayerStyle wMSLayerStyle : set) {
                WMSLayerInfo wMSLayerInfo = new WMSLayerInfo(oGCCapabilities, wMSLayerCapabilities, wMSLayerStyle);
                arrayList.add(wMSLayerInfo);
            }
        }
        return arrayList;
    }
}

