/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.worldwindow.features;

import gov.nasa.worldwind.Disposable;
import gov.nasa.worldwind.globes.ElevationModel;
import gov.nasa.worldwind.ogc.wms.WMSCapabilities;
import gov.nasa.worldwind.terrain.CompoundElevationModel;
import gov.nasa.worldwind.wms.CapabilitiesRequest;
import gov.nasa.worldwindx.applications.worldwindow.core.Controller;
import gov.nasa.worldwindx.applications.worldwindow.core.Registry;
import gov.nasa.worldwindx.applications.worldwindow.features.AbstractFeature;
import gov.nasa.worldwindx.applications.worldwindow.features.NetworkActivitySignal;
import gov.nasa.worldwindx.applications.worldwindow.util.Util;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;

public abstract class AbstractElevationsFeature
extends AbstractFeature
implements NetworkActivitySignal.NetworkUser {
    protected boolean on;
    protected List<ElevationModel> elevationModels;
    protected Thread createModelsThread;

    protected abstract void doCreateModels();

    protected AbstractElevationsFeature(String string, String string2, String string3, Registry registry) {
        super(string, string2, string3, registry);
    }

    @Override
    public void initialize(Controller controller) {
        super.initialize(controller);
        this.addToToolBar();
    }

    @Override
    public boolean hasNetworkActivity() {
        return this.createModelsThread != null && this.createModelsThread.isAlive();
    }

    @Override
    public boolean isOn() {
        return this.on;
    }

    protected void setOn(boolean bl) {
        this.on = bl;
    }

    @Override
    public void turnOn(boolean bl) {
        if (bl == this.isOn()) {
            return;
        }
        if (bl) {
            if (this.getElevationModels().size() == 0) {
                this.createModels();
            } else {
                this.addModels(this.getElevationModels());
            }
        } else {
            this.removeModels();
        }
        this.setOn(bl);
        this.controller.redraw();
    }

    public List<ElevationModel> getElevationModels() {
        return this.elevationModels != null ? this.elevationModels : new ArrayList<ElevationModel>();
    }

    protected void handleInterrupt() {
        if (Thread.currentThread().isInterrupted() && this.elevationModels != null) {
            Util.getLogger().info("Data retrieval cancelled");
            this.destroyElevationModels();
        }
    }

    protected void destroyElevationModels() {
        this.killPopulateLayerThread();
        if (this.elevationModels == null) {
            return;
        }
        for (ElevationModel elevationModel : this.elevationModels) {
            this.destroyElevationModel(elevationModel);
        }
        this.elevationModels.clear();
        this.elevationModels = null;
    }

    protected void destroyElevationModel(ElevationModel elevationModel) {
        this.removeModel(elevationModel);
        if (elevationModel instanceof Disposable) {
            elevationModel.dispose();
        }
    }

    protected void removeModels() {
        for (ElevationModel elevationModel : this.getElevationModels()) {
            this.removeModel(elevationModel);
        }
    }

    protected void addModels(List<ElevationModel> list) {
        for (ElevationModel elevationModel : list) {
            this.addModel(elevationModel);
        }
    }

    protected void removeModel(ElevationModel elevationModel) {
        if (elevationModel == null) {
            return;
        }
        ElevationModel elevationModel2 = this.controller.getWWd().getModel().getGlobe().getElevationModel();
        if (elevationModel2 instanceof CompoundElevationModel) {
            ((CompoundElevationModel)elevationModel2).removeElevationModel(elevationModel);
        }
    }

    protected void killPopulateLayerThread() {
        if (this.createModelsThread != null && this.createModelsThread.isAlive()) {
            this.createModelsThread.interrupt();
            this.controller.getNetworkActivitySignal().removeNetworkUser(this);
            this.createModelsThread = null;
        }
    }

    protected void createModels() {
        if (this.elevationModels == null) {
            this.elevationModels = new ArrayList<ElevationModel>();
        }
        this.createModelsThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    AbstractElevationsFeature.this.doCreateModels();
                    AbstractElevationsFeature.this.handleInterrupt();
                }
                catch (Throwable throwable) {
                    AbstractElevationsFeature.this.handleInterrupt();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AbstractElevationsFeature.this.controller.getNetworkActivitySignal().removeNetworkUser(AbstractElevationsFeature.this);
                            AbstractElevationsFeature.this.createModelsThread = null;
                            AbstractElevationsFeature.this.controller.redraw();
                        }
                    });
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        });
        this.createModelsThread.setPriority(1);
        this.createModelsThread.start();
        this.controller.getNetworkActivitySignal().addNetworkUser(this);
    }

    protected void addModel(ElevationModel elevationModel) {
        this.removeModel(elevationModel);
        this.doAddModel(elevationModel);
        if (this.elevationModels == null) {
            this.elevationModels = new ArrayList<ElevationModel>();
        }
        if (!this.getElevationModels().contains(elevationModel)) {
            this.getElevationModels().add(elevationModel);
        }
    }

    protected void doAddModel(ElevationModel elevationModel) {
        ElevationModel elevationModel2 = this.controller.getWWd().getModel().getGlobe().getElevationModel();
        if (!(elevationModel2 instanceof CompoundElevationModel)) {
            CompoundElevationModel compoundElevationModel = new CompoundElevationModel();
            compoundElevationModel.addElevationModel(elevationModel2);
            elevationModel2 = compoundElevationModel;
            this.controller.getWWd().getModel().getGlobe().setElevationModel(elevationModel2);
        }
        ((CompoundElevationModel)elevationModel2).addElevationModel(elevationModel);
    }

    protected WMSCapabilities retrieveCapsDoc(String string) {
        try {
            CapabilitiesRequest capabilitiesRequest = new CapabilitiesRequest(new URI(string));
            return new WMSCapabilities(capabilitiesRequest);
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        return null;
    }
}

