/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.worldwindow.features;

import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwindx.applications.worldwindow.core.Controller;
import gov.nasa.worldwindx.applications.worldwindow.core.Registry;
import gov.nasa.worldwindx.applications.worldwindow.features.AbstractFeature;
import java.awt.event.ActionEvent;

public abstract class AbstractFeatureLayer
extends AbstractFeature {
    protected Layer layer;
    private boolean twoState = false;

    protected abstract Layer doAddLayer();

    protected AbstractFeatureLayer(String string, String string2, String string3, boolean bl, Registry registry) {
        super(string, string2, string3, registry);
        this.twoState = bl;
    }

    @Override
    public void initialize(Controller controller) {
        super.initialize(controller);
        this.layer = this.doAddLayer();
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this.layer != null) {
            this.layer.setEnabled(this.isEnabled());
        }
    }

    @Override
    public boolean isOn() {
        return this.layer != null && this.isEnabled() && this.layer.isEnabled() && this.controller.getActiveLayers().contains((Object)this.layer);
    }

    @Override
    public boolean isTwoState() {
        return this.twoState;
    }

    @Override
    public void turnOn(boolean bl) {
        boolean bl2 = this.isOn();
        this.layer.setEnabled(bl);
        this.firePropertyChange("gov.nasa.worldwindx.applications.worldwindow.OnState", bl2, this.layer.isEnabled());
        this.controller.redraw();
    }

    @Override
    protected void doActionPerformed(ActionEvent actionEvent) {
        this.turnOn(this.layer == null || !this.layer.isEnabled());
        this.controller.redraw();
    }
}

