/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.worldwindow.features;

import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.cache.FileStore;
import gov.nasa.worldwind.data.DataStoreProducer;
import gov.nasa.worldwind.data.TiledElevationProducer;
import gov.nasa.worldwind.data.TiledImageProducer;
import gov.nasa.worldwind.data.WWDotNetLayerSetConverter;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.util.DataConfigurationFilter;
import gov.nasa.worldwind.util.DataConfigurationUtils;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.util.WWXML;
import gov.nasa.worldwindx.applications.worldwindow.core.Controller;
import gov.nasa.worldwindx.applications.worldwindow.core.Registry;
import gov.nasa.worldwindx.applications.worldwindow.core.WWMenu;
import gov.nasa.worldwindx.applications.worldwindow.features.AbstractFeatureDialog;
import gov.nasa.worldwindx.applications.worldwindow.features.DataImportUtil;
import gov.nasa.worldwindx.applications.worldwindow.features.ImportedDataPanel;
import gov.nasa.worldwindx.applications.worldwindow.features.NetworkActivitySignal;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileFilter;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import javax.xml.xpath.XPath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ImportedDataDialog
extends AbstractFeatureDialog
implements NetworkActivitySignal.NetworkUser {
    protected FileStore fileStore;
    protected ImportedDataPanel dataConfigPanel;
    protected Thread importThread;

    public ImportedDataDialog(Registry registry) {
        super("Import Imagery and Elevations...", "gov.nasa.worldwindx.applications.worldwindow.feature.ImportImagery", null, registry);
    }

    @Override
    public void initialize(Controller controller) {
        super.initialize(controller);
        this.dialog = this.getJDialog();
        WWMenu wWMenu = (WWMenu)this.getController().getRegisteredObject("gov.nasa.worldwindx.applications.worldwindow.feature.FileMenu");
        if (wWMenu != null) {
            wWMenu.addMenu(this.getFeatureID());
        }
        this.fileStore = WorldWind.getDataFileStore();
        this.layoutComponents();
        this.loadPreviouslyImportedData();
    }

    @Override
    public boolean hasNetworkActivity() {
        return this.importThread != null && this.importThread.isAlive();
    }

    @Override
    public boolean isTwoState() {
        return true;
    }

    @Override
    public boolean isOn() {
        return this.dialog != null && this.dialog.isVisible();
    }

    protected void loadPreviouslyImportedData() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                ImportedDataDialog.loadImportedDataFromFileStore(ImportedDataDialog.this.fileStore, ImportedDataDialog.this.dataConfigPanel);
            }
        });
        thread.start();
    }

    protected void importFromFile() {
        JFileChooser jFileChooser = this.getController().getFileChooser();
        jFileChooser.setDialogTitle("Import File");
        jFileChooser.setMultiSelectionEnabled(false);
        ImportableDataFilter importableDataFilter = new ImportableDataFilter();
        jFileChooser.addChoosableFileFilter(importableDataFilter);
        int n = jFileChooser.showDialog(this.getController().getFrame(), "Import");
        if (n != 0) {
            return;
        }
        final File file = jFileChooser.getSelectedFile();
        if (file == null) {
            return;
        }
        jFileChooser.removeChoosableFileFilter(importableDataFilter);
        jFileChooser.setMultiSelectionEnabled(true);
        jFileChooser.setDialogTitle("");
        this.importThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ImportedDataDialog.this.getController().getNetworkActivitySignal().addNetworkUser(ImportedDataDialog.this);
                try {
                    Document document = null;
                    try {
                        document = ImportedDataDialog.importDataFromFile(ImportedDataDialog.this.dialog, file, ImportedDataDialog.this.fileStore);
                    }
                    catch (Exception exception) {
                        final String string = exception.getMessage();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                JOptionPane.showMessageDialog(ImportedDataDialog.this.dialog, string, "Import Error", 0);
                            }
                        });
                    }
                    if (document != null) {
                        ImportedDataDialog.addImportedData(document, null, ImportedDataDialog.this.dataConfigPanel);
                    }
                }
                finally {
                    ImportedDataDialog.this.controller.getNetworkActivitySignal().removeNetworkUser(ImportedDataDialog.this);
                }
            }
        });
        this.importThread.start();
    }

    protected void layoutComponents() {
        this.setTitle("Import Data");
        this.dataConfigPanel = new ImportedDataPanel("Currently Imported Data", this.getController());
        this.setTaskComponent(this.dataConfigPanel);
        this.setLocation(0, 0);
        this.getJDialog().setResizable(true);
        JButton jButton = new JButton("Import...");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImportedDataDialog.this.importFromFile();
            }
        });
        this.insertLeftDialogComponent(jButton);
        this.dialog.setPreferredSize(new Dimension(400, 400));
        this.dialog.validate();
        this.dialog.pack();
    }

    protected static void addImportedData(final Document document, final AVList aVList, final ImportedDataPanel importedDataPanel) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ImportedDataDialog.addImportedData(document, aVList, importedDataPanel);
                }
            });
        } else {
            importedDataPanel.addImportedData(document.getDocumentElement(), aVList);
        }
    }

    protected static void loadImportedDataFromDirectory(File file, ImportedDataPanel importedDataPanel) {
        String[] stringArray = WWIO.listDescendantFilenames((File)file, (FileFilter)new DataConfigurationFilter(), (boolean)false);
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        for (String string : stringArray) {
            File file2;
            Document document = null;
            try {
                file2 = new File(file, string);
                document = WWXML.openDocument((Object)file2);
                document = DataConfigurationUtils.convertToStandardDataConfigDocument((Document)document);
            }
            catch (WWRuntimeException wWRuntimeException) {
                wWRuntimeException.printStackTrace();
            }
            if (document == null) continue;
            file2 = new AVListImpl();
            ImportedDataDialog.setFallbackParams(document, string, (AVList)file2);
            ImportedDataDialog.addImportedData(document, (AVList)file2, importedDataPanel);
        }
    }

    protected static void loadImportedDataFromFileStore(FileStore fileStore, ImportedDataPanel importedDataPanel) {
        for (File file : fileStore.getLocations()) {
            if (!file.exists() || !fileStore.isInstallLocation(file.getPath())) continue;
            ImportedDataDialog.loadImportedDataFromDirectory(file, importedDataPanel);
        }
    }

    protected static void setFallbackParams(Document document, String string, AVList aVList) {
        String string2;
        XPath xPath = WWXML.makeXPath();
        Element element = document.getDocumentElement();
        String string3 = WWXML.getText((Element)element, (String)"DataCacheName", (XPath)xPath);
        if (string3 == null || string3.length() == 0) {
            DataConfigurationUtils.getDataConfigCacheName((String)string, (AVList)aVList);
        }
        if ((string2 = DataConfigurationUtils.getDataConfigType((Element)element)).equalsIgnoreCase("ElevationModel")) {
            if (WWXML.getDouble((Element)element, (String)"ExtremeElevations/@min", (XPath)xPath) == null) {
                aVList.setValue("gov.nasa.worldwind.avkey.ElevationMinKey", (Object)-11000.0);
            }
            if (WWXML.getDouble((Element)element, (String)"ExtremeElevations/@max", (XPath)xPath) == null) {
                aVList.setValue("gov.nasa.worldwind.avkey.ElevationMaxKey", (Object)8500.0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Document importDataFromFile(Component component, File file, FileStore fileStore) throws Exception {
        final DataStoreProducer dataStoreProducer = ImportedDataDialog.createDataStoreProducerFromFile(file);
        if (dataStoreProducer == null) {
            throw new IllegalArgumentException("Unrecognized file type");
        }
        final ProgressMonitor progressMonitor = new ProgressMonitor(component, "Importing " + file.getName(), null, 0, 100);
        final AtomicInteger atomicInteger = new AtomicInteger(0);
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (progressMonitor.isCanceled()) {
                    return;
                }
                if (propertyChangeEvent.getPropertyName().equals("gov.nasa.worldwind.avkey.Progress")) {
                    atomicInteger.set((int)(100.0 * (Double)propertyChangeEvent.getNewValue()));
                }
            }
        };
        dataStoreProducer.addPropertyChangeListener(propertyChangeListener);
        progressMonitor.setProgress(0);
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                progressMonitor.setProgress(atomicInteger.get());
                if (progressMonitor.isCanceled()) {
                    dataStoreProducer.stopProduction();
                    this.cancel();
                }
            }
        }, progressMonitor.getMillisToDecideToPopup(), 100L);
        Document document = null;
        try {
            document = ImportedDataDialog.createDataStoreFromFile(file, fileStore, dataStoreProducer);
            if (progressMonitor.isCanceled()) {
                document = null;
                dataStoreProducer.removeProductionState();
            }
        }
        finally {
            dataStoreProducer.removePropertyChangeListener(propertyChangeListener);
            progressMonitor.close();
            timer.cancel();
        }
        return document;
    }

    protected static Document createDataStoreFromFile(File file, FileStore fileStore, DataStoreProducer dataStoreProducer) throws Exception {
        Object t;
        File file2 = DataImportUtil.getDefaultImportLocation(fileStore);
        if (file2 == null) {
            String string = Logging.getMessage((String)"generic.NoDefaultImportLocation");
            Logging.logger().severe(string);
            return null;
        }
        AVListImpl aVListImpl = new AVListImpl();
        aVListImpl.setValue("gov.nasa.worldwind.avkey.DatasetNameKey", (Object)file.getName());
        aVListImpl.setValue("gov.nasa.worldwind.avkey.DataCacheNameKey", (Object)file.getName());
        aVListImpl.setValue("gov.nasa.worldwind.avkey.FileStoreLocation", (Object)file2.getAbsolutePath());
        dataStoreProducer.setStoreParameters((AVList)aVListImpl);
        dataStoreProducer.offerDataSource((Object)file, null);
        try {
            dataStoreProducer.startProduction();
        }
        catch (Exception exception) {
            dataStoreProducer.removeProductionState();
            throw exception;
        }
        Iterable iterable = dataStoreProducer.getProductionResults();
        if (iterable != null && iterable.iterator() != null && iterable.iterator().hasNext() && (t = iterable.iterator().next()) != null && t instanceof Document) {
            return (Document)t;
        }
        return null;
    }

    protected static DataStoreProducer createDataStoreProducerFromFile(File file) {
        if (file == null) {
            return null;
        }
        WWDotNetLayerSetConverter wWDotNetLayerSetConverter = null;
        AVListImpl aVListImpl = new AVListImpl();
        if (DataImportUtil.isDataRaster(file, (AVList)aVListImpl)) {
            if ("gov.nasa.worldwind.avkey.Elevation".equals(aVListImpl.getStringValue("gov.nasa.worldwind.avkey.PixelFormat"))) {
                wWDotNetLayerSetConverter = new TiledElevationProducer();
            } else if ("gov.nasa.worldwind.avkey.Image".equals(aVListImpl.getStringValue("gov.nasa.worldwind.avkey.PixelFormat"))) {
                wWDotNetLayerSetConverter = new TiledImageProducer();
            }
        } else if (DataImportUtil.isWWDotNetLayerSet(file)) {
            wWDotNetLayerSetConverter = new WWDotNetLayerSetConverter();
        }
        return wWDotNetLayerSetConverter;
    }

    protected static class ImportableDataFilter
    extends javax.swing.filechooser.FileFilter {
        @Override
        public boolean accept(File file) {
            if (file == null || file.isDirectory()) {
                return true;
            }
            if (DataImportUtil.isDataRaster(file, null)) {
                return true;
            }
            return DataImportUtil.isWWDotNetLayerSet(file);
        }

        @Override
        public String getDescription() {
            return "Supported Images/Elevations";
        }
    }
}

