/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.worldwindow.features;

import gov.nasa.worldwind.Factory;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Cylinder;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.globes.ElevationModel;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.terrain.CompoundElevationModel;
import gov.nasa.worldwind.util.DataConfigurationUtils;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWXML;
import gov.nasa.worldwindx.applications.worldwindow.core.Controller;
import gov.nasa.worldwindx.applications.worldwindow.core.layermanager.LayerManager;
import gov.nasa.worldwindx.applications.worldwindow.core.layermanager.LayerPath;
import gov.nasa.worldwindx.applications.worldwindow.util.PanelTitle;
import gov.nasa.worldwindx.applications.worldwindow.util.ShadedPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.w3c.dom.Element;

public class ImportedDataPanel
extends ShadedPanel {
    protected Controller controller;
    protected JPanel dataConfigPanel;

    public ImportedDataPanel(String string, Controller controller) {
        super(new BorderLayout());
        if (controller == null) {
            String string2 = Logging.getMessage((String)"nullValue.WorldWindow");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.controller = controller;
        this.layoutComponents(string);
    }

    public void addImportedData(Element element, AVList aVList) {
        if (element == null) {
            String string = Logging.getMessage((String)"nullValue.DocumentIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.addToWorldWindow(element, aVList);
        String string = this.getDescription(element);
        Sector sector = this.getSector(element);
        Box box = Box.createHorizontalBox();
        box.setOpaque(false);
        box.add(new JButton(new GoToSectorAction(sector)));
        box.add(Box.createHorizontalStrut(10));
        JLabel jLabel = new JLabel(string);
        jLabel.setOpaque(false);
        box.add(jLabel);
        this.dataConfigPanel.add(box);
        this.revalidate();
    }

    protected void layoutComponents(String string) {
        this.add((Component)new PanelTitle(string, 0), "North");
        this.dataConfigPanel = new JPanel(new GridLayout(0, 1, 0, 4));
        this.dataConfigPanel.setOpaque(false);
        this.dataConfigPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(false);
        jPanel.add((Component)this.dataConfigPanel, "North");
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        jScrollPane.setOpaque(false);
        jScrollPane.getViewport().setOpaque(false);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        JPanel jPanel2 = new JPanel(new GridLayout(0, 1, 0, 10));
        jPanel2.setOpaque(false);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9));
        jPanel2.add((Component)jScrollPane, "Center");
        this.add((Component)jPanel2, "Center");
    }

    protected String getDescription(Element element) {
        String string = DataConfigurationUtils.getDataConfigDisplayName((Element)element);
        String string2 = DataConfigurationUtils.getDataConfigType((Element)element);
        StringBuilder stringBuilder = new StringBuilder(string);
        if (string2.equalsIgnoreCase("Layer")) {
            stringBuilder.append(" (Layer)");
        } else if (string2.equalsIgnoreCase("ElevationModel")) {
            stringBuilder.append(" (Elevations)");
        }
        return stringBuilder.toString();
    }

    protected Sector getSector(Element element) {
        return WWXML.getSector((Element)element, (String)"Sector", null);
    }

    protected void addToWorldWindow(Element element, AVList aVList) {
        String string = DataConfigurationUtils.getDataConfigType((Element)element);
        if (string == null) {
            return;
        }
        if (string.equalsIgnoreCase("Layer")) {
            this.addLayerToWorldWindow(element, aVList);
        } else if (string.equalsIgnoreCase("ElevationModel")) {
            this.addElevationModelToWorldWindow(element, aVList);
        }
    }

    protected void addLayerToWorldWindow(Element element, AVList aVList) {
        try {
            Factory factory = (Factory)WorldWind.createConfigurationComponent((String)"gov.nasa.worldwind.avkey.LayerFactory");
            Layer layer = (Layer)factory.createFromConfigSource((Object)element, aVList);
            if (layer != null) {
                layer.setEnabled(true);
                this.addLayer(layer, new LayerPath("Imported", new String[0]));
            }
        }
        catch (Exception exception) {
            String string = Logging.getMessage((String)"generic.CreationFromConfigurationFailed", (String)DataConfigurationUtils.getDataConfigDisplayName((Element)element));
            Logging.logger().log(Level.SEVERE, string, exception);
        }
    }

    protected void addLayer(final Layer layer, final LayerPath layerPath) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LayerPath layerPath2 = new LayerPath(layerPath, layer.getName());
                ImportedDataPanel.this.doAddLayer(layer, layerPath2);
            }
        });
    }

    protected void doAddLayer(Layer layer, LayerPath layerPath) {
        LayerManager layerManager = this.controller.getLayerManager();
        layerManager.addLayer(layer, layerPath.lastButOne());
        layerManager.selectLayer(layer, true);
        layerManager.expandPath(layerPath.lastButOne());
    }

    protected void addElevationModelToWorldWindow(Element element, AVList aVList) {
        String string;
        Factory factory;
        ElevationModel elevationModel = null;
        try {
            factory = (Factory)WorldWind.createConfigurationComponent((String)"gov.nasa.worldwind.avkey.ElevationModelFactory");
            elevationModel = (ElevationModel)factory.createFromConfigSource((Object)element, aVList);
        }
        catch (Exception exception) {
            string = Logging.getMessage((String)"generic.CreationFromConfigurationFailed", (String)DataConfigurationUtils.getDataConfigDisplayName((Element)element));
            Logging.logger().log(Level.SEVERE, string, exception);
        }
        if (elevationModel == null) {
            return;
        }
        factory = this.controller.getWWd().getModel().getGlobe().getElevationModel();
        if (factory instanceof CompoundElevationModel) {
            if (!((CompoundElevationModel)factory).containsElevationModel(elevationModel)) {
                ((CompoundElevationModel)factory).addElevationModel(elevationModel);
            }
        } else {
            string = new CompoundElevationModel();
            string.addElevationModel((ElevationModel)factory);
            string.addElevationModel(elevationModel);
            this.controller.getWWd().getModel().getGlobe().setElevationModel((ElevationModel)string);
        }
    }

    protected class GoToSectorAction
    extends AbstractAction {
        protected Sector sector;

        public GoToSectorAction(Sector sector) {
            super("Go To");
            this.sector = sector;
            this.setEnabled(this.sector != null);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Cylinder cylinder = Sector.computeBoundingCylinder((Globe)ImportedDataPanel.this.controller.getWWd().getModel().getGlobe(), (double)ImportedDataPanel.this.controller.getWWd().getSceneController().getVerticalExaggeration(), (Sector)this.sector);
            Angle angle = ImportedDataPanel.this.controller.getWWd().getView().getFieldOfView();
            Position position = new Position(this.sector.getCentroid(), 0.0);
            double d = cylinder.getRadius() / angle.cosHalfAngle() / angle.tanHalfAngle();
            ImportedDataPanel.this.controller.getWWd().getView().goTo(position, d);
        }
    }
}

