/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.worldwindow.features;

import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.PatternFactory;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwindx.applications.worldwindow.core.Controller;
import gov.nasa.worldwindx.applications.worldwindow.core.Registry;
import gov.nasa.worldwindx.applications.worldwindow.features.AbstractFeatureDialog;
import gov.nasa.worldwindx.applications.worldwindow.features.MeasurementPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MeasurementDialog
extends AbstractFeatureDialog {
    private static final String LAYER_NAME = "Measurement";
    private JTabbedPane tabbedPane = new JTabbedPane();
    private int labelSequence = 0;
    private RenderableLayer shapeLayer;
    private RenderableLayer controlPointsLayer;
    private static int nextColor = 0;
    private static Color[] colors = new Color[]{Color.RED, Color.GREEN, Color.BLUE, Color.MAGENTA, Color.CYAN, Color.ORANGE, Color.PINK, Color.YELLOW};

    private static Color getNextColor() {
        return colors[nextColor++ % colors.length];
    }

    public MeasurementDialog(Registry registry) {
        super(LAYER_NAME, "gov.nasa.worldwindx.applications.worldwindow.feature.MeasurementDialog", registry);
    }

    @Override
    public void initialize(final Controller controller) {
        super.initialize(controller);
        this.shapeLayer = new RenderableLayer();
        this.shapeLayer.setName(LAYER_NAME);
        this.controller.addInternalActiveLayer((Layer)this.shapeLayer);
        this.controlPointsLayer = this.shapeLayer;
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setOpaque(false);
        this.tabbedPane.add(new JPanel());
        this.tabbedPane.setTitleAt(0, "+");
        this.tabbedPane.setToolTipTextAt(0, "Create measurement");
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (MeasurementDialog.this.tabbedPane.getSelectedIndex() == 0) {
                    MeasurementDialog.this.addNewPanel(MeasurementDialog.this.tabbedPane);
                }
            }
        });
        this.addNewPanel(this.tabbedPane);
        this.tabbedPane.setSelectedIndex(1);
        this.setTaskComponent(this.tabbedPane);
        this.setLocation(7, 1);
        this.getJDialog().setResizable(true);
        JButton jButton = new JButton(new ImageIcon(this.getClass().getResource("/gov/nasa/worldwindx/applications/worldwindow/images/delete-20x20.png")));
        jButton.setToolTipText("Remove current measurement");
        jButton.setOpaque(false);
        jButton.setBackground(new Color(0, 0, 0, 0));
        jButton.setBorderPainted(false);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MeasurementDialog.this.deleteCurrentPanel();
                controller.redraw();
            }
        });
        jButton.setEnabled(true);
        this.insertLeftDialogComponent(jButton);
    }

    @Override
    public void setVisible(boolean bl) {
        if (!bl && this.countRenderables(this.shapeLayer) < 3) {
            this.controller.getActiveLayers().remove((Layer)this.shapeLayer);
        }
        if (bl && !this.controller.getActiveLayers().contains((Object)this.shapeLayer)) {
            this.controller.addInternalActiveLayer((Layer)this.shapeLayer);
        }
        super.setVisible(bl);
    }

    private int countRenderables(RenderableLayer renderableLayer) {
        int n = 0;
        for (Renderable renderable : renderableLayer.getRenderables()) {
            ++n;
        }
        return n;
    }

    private void deleteCurrentPanel() {
        MeasurementPanel measurementPanel = this.getCurrentPanel();
        if (this.tabbedPane.getTabCount() > 2) {
            measurementPanel.deletePanel();
            this.tabbedPane.remove(this.tabbedPane.getSelectedComponent());
        } else {
            measurementPanel.clearPanel();
        }
    }

    private void addNewPanel(JTabbedPane jTabbedPane) {
        final MeasurementPanel measurementPanel = new MeasurementPanel(null);
        measurementPanel.initialize(this.controller);
        measurementPanel.setLayers(this.shapeLayer, this.controlPointsLayer);
        Color color = MeasurementDialog.getNextColor();
        measurementPanel.setLineColor(color);
        measurementPanel.setFillColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), 32));
        jTabbedPane.addTab("" + ++this.labelSequence, MeasurementDialog.makeColorCircle(color), measurementPanel.getJPanel());
        jTabbedPane.setSelectedIndex(jTabbedPane.getTabCount() - 1);
        jTabbedPane.setToolTipTextAt(this.tabbedPane.getSelectedIndex(), "Select measurement");
        this.controller.getWWd().addSelectListener(new SelectListener(){

            public void selected(SelectEvent selectEvent) {
                if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.LeftClick")) {
                    if (measurementPanel.getShape() == null || measurementPanel.getShape() != selectEvent.getTopObject()) {
                        return;
                    }
                    for (Component component : MeasurementDialog.this.tabbedPane.getComponents()) {
                        Object object;
                        if (!(component instanceof JComponent) || !((object = ((JComponent)component).getClientProperty("gov.nasa.worldwindx.applications.worldwindow.FeatureOwnerProperty")) instanceof MeasurementPanel) || object != measurementPanel) continue;
                        MeasurementDialog.this.tabbedPane.setSelectedComponent(component);
                    }
                }
            }
        });
    }

    private MeasurementPanel getCurrentPanel() {
        JComponent jComponent = (JComponent)this.tabbedPane.getSelectedComponent();
        return (MeasurementPanel)jComponent.getClientProperty("gov.nasa.worldwindx.applications.worldwindow.FeatureOwnerProperty");
    }

    private static Icon makeColorCircle(Color color) {
        BufferedImage bufferedImage = PatternFactory.createPattern((String)"PatternFactory.PatternCircle", (Dimension)new Dimension(16, 16), (float)0.9f, (Color)color);
        return new ImageIcon(bufferedImage);
    }
}

