/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.worldwindow.features;

import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.ViewControlsLayer;
import gov.nasa.worldwind.layers.ViewControlsSelectListener;
import gov.nasa.worldwindx.applications.worldwindow.core.Controller;
import gov.nasa.worldwindx.applications.worldwindow.core.Registry;
import gov.nasa.worldwindx.applications.worldwindow.features.AbstractFeatureLayer;
import java.beans.PropertyChangeEvent;

public class Navigation
extends AbstractFeatureLayer {
    public static final String POSITION_PROPERTY = "gov.nasa.worldwindowx.applications.features.Navegacion.PostionProperty";
    public static final String ORIENTATION_PROPERTY = "gov.nasa.worldwindowx.applications.features.Navegacion.OrientationProperty";
    public static final String SIZE_PROPERTY = "gov.nasa.worldwindowx.applications.features.Navegacion.SizeProperty";
    public static final String OPACITY_PROPERTY = "gov.nasa.worldwindowx.applications.features.Navegacion.OpacityProperty";
    public static final String PAN_CONTROLS_PROPERTY = "gov.nasa.worldwindowx.applications.features.Navegacion.PanControlS";
    public static final String ZOOM_CONTROLS_PROPERTY = "gov.nasa.worldwindowx.applications.features.Navegacion.ZoomControlS";
    public static final String TILT_CONTROLS_PROPERTY = "gov.nasa.worldwindowx.applications.features.Navegacion.TiltControlS";
    public static final String HEADING_CONTROLS_PROPERTY = "gov.nasa.worldwindowx.applications.features.Navegacion.HeadingControlS";

    public Navigation() {
        this((Registry)null);
    }

    public Navigation(Registry registry) {
        super("Navigation", "gov.nasa.worldwindx.applications.worldwindow.feature.Navigation", "gov/nasa/worldwindx/applications/worldwindow/images/navegacion-64x64.png", true, registry);
    }

    @Override
    public void initialize(Controller controller) {
        super.initialize(controller);
    }

    @Override
    protected Layer doAddLayer() {
        ViewControlsLayer viewControlsLayer = new ViewControlsLayer();
        viewControlsLayer.setValue("gov.nasa.worldwindx.applications.worldwindow.ScreenLayer", (Object)true);
        viewControlsLayer.setValue("gov.nasa.worldwindx.applications.worldwindow.InternalLayer", (Object)true);
        viewControlsLayer.setLayout("gov.nasa.worldwind.avkey.Vertical");
        this.controller.addInternalLayer((Layer)viewControlsLayer);
        ViewControlsSelectListener viewControlsSelectListener = new ViewControlsSelectListener(this.controller.getWWd(), viewControlsLayer);
        viewControlsSelectListener.setRepeatTimerDelay(30);
        viewControlsSelectListener.setZoomIncrement(0.5);
        viewControlsSelectListener.setPanIncrement(0.5);
        this.controller.getWWd().addSelectListener((SelectListener)viewControlsSelectListener);
        return viewControlsLayer;
    }

    private ViewControlsLayer getLayer() {
        return (ViewControlsLayer)this.layer;
    }

    @Override
    public void doPropertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals(POSITION_PROPERTY)) {
            if (propertyChangeEvent.getNewValue() != null && propertyChangeEvent.getNewValue() instanceof String) {
                this.getLayer().setPosition((String)propertyChangeEvent.getNewValue());
                this.controller.redraw();
            }
        } else if (propertyChangeEvent.getPropertyName().equals(ORIENTATION_PROPERTY)) {
            if (propertyChangeEvent.getNewValue() != null && propertyChangeEvent.getNewValue() instanceof String) {
                this.getLayer().setLayout((String)propertyChangeEvent.getNewValue());
                this.controller.redraw();
            }
        } else if (propertyChangeEvent.getPropertyName().equals(PAN_CONTROLS_PROPERTY)) {
            if (propertyChangeEvent.getNewValue() != null && propertyChangeEvent.getNewValue() instanceof Boolean) {
                this.getLayer().setShowPanControls(((Boolean)propertyChangeEvent.getNewValue()).booleanValue());
                this.controller.redraw();
            }
        } else if (propertyChangeEvent.getPropertyName().equals(ZOOM_CONTROLS_PROPERTY)) {
            if (propertyChangeEvent.getNewValue() != null && propertyChangeEvent.getNewValue() instanceof Boolean) {
                this.getLayer().setShowZoomControls(((Boolean)propertyChangeEvent.getNewValue()).booleanValue());
                this.controller.redraw();
            }
        } else if (propertyChangeEvent.getPropertyName().equals(HEADING_CONTROLS_PROPERTY)) {
            if (propertyChangeEvent.getNewValue() != null && propertyChangeEvent.getNewValue() instanceof Boolean) {
                this.getLayer().setShowHeadingControls(((Boolean)propertyChangeEvent.getNewValue()).booleanValue());
                this.controller.redraw();
            }
        } else if (propertyChangeEvent.getPropertyName().equals(TILT_CONTROLS_PROPERTY) && propertyChangeEvent.getNewValue() != null && propertyChangeEvent.getNewValue() instanceof Boolean) {
            this.getLayer().setShowPitchControls(((Boolean)propertyChangeEvent.getNewValue()).booleanValue());
            this.controller.redraw();
        }
    }

    public double getSize() {
        return this.layer.getScale();
    }

    public double getOpacity() {
        return this.layer.getOpacity();
    }

    public String getOrientation() {
        return this.getLayer().getLayout();
    }

    public String getPosition() {
        return this.getLayer().getPosition();
    }

    public boolean isShowPan() {
        return this.getLayer().isShowPanControls();
    }

    public boolean isShowZoom() {
        return this.getLayer().isShowZoomControls();
    }

    public boolean isShowTilt() {
        return this.getLayer().isShowPitchControls();
    }

    public boolean isShowHeading() {
        return this.getLayer().isShowHeadingControls();
    }
}

