/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.worldwindow.features;

import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwindx.applications.worldwindow.core.Controller;
import gov.nasa.worldwindx.applications.worldwindow.core.ImageLibrary;
import gov.nasa.worldwindx.applications.worldwindow.core.Registry;
import gov.nasa.worldwindx.applications.worldwindow.features.AbstractFeature;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.Timer;

public class NetworkActivitySignal
extends AbstractFeature {
    private ArrayList<NetworkUser> networkUsers = new ArrayList();
    private AtomicBoolean isNetworkAvailable = new AtomicBoolean(true);
    private JLabel networkLabel = new JLabel();
    private ImageIcon busySignal;

    public NetworkActivitySignal(Registry registry) {
        super("Network Activity Signal", "gov.nasa.worldwindx.applications.worldwindow.NetworkStatusSignal", registry);
    }

    @Override
    public void initialize(Controller controller) {
        super.initialize(controller);
        URL uRL = ImageLibrary.getImageURL("images/indicator-16.gif");
        this.busySignal = uRL != null ? new ImageIcon(uRL) : null;
        this.networkLabel = new JLabel();
        this.networkLabel.setOpaque(false);
        NetworkUser networkUser = new NetworkUser(){

            @Override
            public boolean hasNetworkActivity() {
                return WorldWind.getRetrievalService().hasActiveTasks();
            }
        };
        this.networkUsers.add(networkUser);
        Timer timer = new Timer(500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!NetworkActivitySignal.this.isNetworkAvailable.get()) {
                    if (NetworkActivitySignal.this.networkLabel.getText() == null) {
                        NetworkActivitySignal.this.networkLabel.setIcon(null);
                        NetworkActivitySignal.this.networkLabel.setText("No network");
                        NetworkActivitySignal.this.networkLabel.setForeground(Color.RED);
                        NetworkActivitySignal.this.networkLabel.setVisible(true);
                    }
                } else {
                    for (NetworkUser networkUser : NetworkActivitySignal.this.networkUsers) {
                        if (!networkUser.hasNetworkActivity()) continue;
                        NetworkActivitySignal.this.runBusySignal(true);
                        return;
                    }
                    NetworkActivitySignal.this.runBusySignal(false);
                }
            }
        });
        timer.start();
        Timer timer2 = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        NetworkActivitySignal.this.isNetworkAvailable.set(!WorldWind.getNetworkStatus().isNetworkUnavailable());
                    }
                });
                thread.start();
            }
        });
        timer2.start();
    }

    private void runBusySignal(boolean bl) {
        if (bl) {
            if (this.networkLabel.getIcon() == null) {
                this.networkLabel.setIcon(this.busySignal);
                this.networkLabel.setText(null);
                this.networkLabel.setVisible(true);
            }
        } else if (this.networkLabel.isVisible()) {
            this.networkLabel.setText(null);
            this.networkLabel.setIcon(null);
            this.networkLabel.setVisible(false);
        }
    }

    public JLabel getLabel() {
        return this.networkLabel;
    }

    public void addNetworkUser(NetworkUser networkUser) {
        this.networkUsers.add(networkUser);
    }

    public void removeNetworkUser(NetworkUser networkUser) {
        this.networkUsers.remove(networkUser);
    }

    public static interface NetworkUser {
        public boolean hasNetworkActivity();
    }
}

