/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.worldwindow.features;

import gov.nasa.worldwindx.applications.worldwindow.core.Controller;
import gov.nasa.worldwindx.applications.worldwindow.core.Registry;
import gov.nasa.worldwindx.applications.worldwindow.core.WWMenu;
import gov.nasa.worldwindx.applications.worldwindow.features.AbstractOpenResourceFeature;
import java.awt.event.ActionEvent;
import javax.swing.JFileChooser;

public class OpenFile
extends AbstractOpenResourceFeature {
    public OpenFile(Registry registry) {
        super("Open File...", "gov.nasa.worldwindx.applications.worldwindow.feature.OpenFile", null, registry);
    }

    @Override
    public void initialize(Controller controller) {
        super.initialize(controller);
        WWMenu wWMenu = (WWMenu)this.getController().getRegisteredObject("gov.nasa.worldwindx.applications.worldwindow.feature.FileMenu");
        if (wWMenu != null) {
            wWMenu.addMenu(this.getFeatureID());
        }
    }

    @Override
    protected void doActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = this.getController().getFileChooser();
        jFileChooser.setDialogTitle("Open File");
        jFileChooser.setMultiSelectionEnabled(false);
        try {
            int n = jFileChooser.showOpenDialog(this.getController().getFrame());
            if (n == 0) {
                this.runOpenThread(jFileChooser.getSelectedFile());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        jFileChooser.setDialogTitle("");
        jFileChooser.setMultiSelectionEnabled(true);
        super.doActionPerformed(actionEvent);
    }
}

