/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.worldwindow.features;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwindx.applications.worldwindow.core.Controller;
import gov.nasa.worldwindx.applications.worldwindow.core.Registry;
import gov.nasa.worldwindx.applications.worldwindow.core.StatusPanel;
import gov.nasa.worldwindx.applications.worldwindow.features.AbstractFeature;
import gov.nasa.worldwindx.applications.worldwindow.features.FeaturePanel;
import gov.nasa.worldwindx.applications.worldwindow.features.NetworkActivitySignal;
import gov.nasa.worldwindx.applications.worldwindow.util.ShadedPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;

public class StatusPanelImpl
extends AbstractFeature
implements StatusPanel,
SelectListener {
    private ShadedPanel panel;
    private Color panelTextColor = new Color(1591684);
    private JLabel statusMessageLabel;
    protected Object lastSelectedObject;

    public StatusPanelImpl(Registry registry) {
        super("Status Panel", "gov.nasa.worldwindx.applications.worldwindow.StatusPanel", registry);
        this.panel = new ShadedPanel(new BorderLayout());
    }

    @Override
    public void initialize(Controller controller) {
        super.initialize(controller);
        this.panel.setOpaque(false);
        this.panel.setBorder(new EmptyBorder(4, 5, 4, 5));
        JPanel jPanel = this.createLeftComponents();
        JPanel jPanel2 = this.createCenterComponents();
        JPanel jPanel3 = this.createRightComponents();
        if (jPanel != null) {
            this.panel.add((Component)jPanel, "West");
        }
        if (jPanel2 != null) {
            this.panel.add((Component)jPanel2, "Center");
        }
        if (jPanel3 != null) {
            this.panel.add((Component)jPanel3, "East");
        }
        this.controller.getWWd().addSelectListener((SelectListener)this);
    }

    @Override
    public JPanel getJPanel() {
        return this.panel;
    }

    @Override
    public JComponent[] getDialogControls() {
        return null;
    }

    @Override
    public String setStatusMessage(String string) {
        String string2 = this.statusMessageLabel.getText();
        if (WWUtil.isEmpty((Object)string)) {
            this.statusMessageLabel.setText("");
        } else {
            this.statusMessageLabel.setText(string);
        }
        return WWUtil.isEmpty((Object)string2) ? null : string2;
    }

    private JPanel createLeftComponents() {
        JPanel jPanel = new JPanel(new BorderLayout(10, 5));
        jPanel.setOpaque(false);
        Object object = this.controller.getRegisteredObject("gov.nasa.worldwindx.applications.worldwindow.feature.GazetteerPanel");
        if (object != null && object instanceof FeaturePanel) {
            jPanel.add((Component)((FeaturePanel)object).getJPanel(), "West");
        }
        return jPanel;
    }

    private JPanel createCenterComponents() {
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.setOpaque(false);
        jPanel.setBorder(new EmptyBorder(0, 10, 0, 0));
        this.statusMessageLabel = new JLabel("");
        this.statusMessageLabel.setOpaque(false);
        this.statusMessageLabel.setForeground(this.panelTextColor);
        jPanel.add((Component)this.statusMessageLabel, "West");
        return jPanel;
    }

    private JPanel createRightComponents() {
        JPanel jPanel = new JPanel(new BorderLayout(20, 5));
        jPanel.setOpaque(false);
        jPanel.add((Component)this.makeClock(), "East");
        jPanel.add((Component)this.makeNetworkLabel(), "West");
        return jPanel;
    }

    private JLabel makeNetworkLabel() {
        NetworkActivitySignal networkActivitySignal = this.controller.getNetworkActivitySignal();
        return networkActivitySignal != null ? networkActivitySignal.getLabel() : new JLabel("");
    }

    private JComponent makeClock() {
        final JLabel jLabel = new JLabel(SimpleDateFormat.getDateTimeInstance(1, 1).format(new Date()));
        jLabel.setOpaque(false);
        jLabel.setForeground(this.panelTextColor);
        jLabel.setToolTipText("Time on this computer");
        Timer timer = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jLabel.setText(SimpleDateFormat.getDateTimeInstance(1, 1).format(new Date()));
            }
        });
        timer.start();
        return jLabel;
    }

    public void selected(SelectEvent selectEvent) {
        if (selectEvent.isRollover()) {
            if (this.lastSelectedObject == selectEvent.getTopObject()) {
                return;
            }
            if (this.lastSelectedObject != null) {
                this.controller.setStatusMessage(null);
                this.lastSelectedObject = null;
            }
            if (selectEvent.getTopObject() != null && selectEvent.getTopObject() instanceof AVList) {
                String string = ((AVList)selectEvent.getTopObject()).getStringValue("gov.nasa.worldwindx.applications.worldwindow.StatusBarMessage");
                if (string == null) {
                    string = ((AVList)selectEvent.getTopObject()).getStringValue("gov.nasa.worldwind.avkey.ExternalLink");
                }
                if (string != null) {
                    this.lastSelectedObject = selectEvent.getTopObject();
                    this.controller.setStatusMessage(string);
                }
            }
        }
    }
}

