/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.worldwindow.features;

import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwindx.applications.worldwindow.core.Controller;
import gov.nasa.worldwindx.applications.worldwindow.core.ImageLibrary;
import gov.nasa.worldwindx.applications.worldwindow.core.Registry;
import gov.nasa.worldwindx.applications.worldwindow.core.WWMenu;
import gov.nasa.worldwindx.applications.worldwindow.features.AbstractFeatureDialog;
import gov.nasa.worldwindx.applications.worldwindow.features.WMSPanel;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URISyntaxException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class WMSDialog
extends AbstractFeatureDialog {
    protected static final String FEATURE_TITLE = "WMS Servers...";
    protected static final String ICON_PATH = "gov/nasa/worldwindx/applications/worldwindow/images/wms-64x64.png";
    protected JTabbedPane tabbedPane = new JTabbedPane();

    public WMSDialog(Registry registry) {
        super(FEATURE_TITLE, "gov.nasa.worldwindx.applications.worldwindow.feature.WMSDialog", ICON_PATH, registry);
    }

    @Override
    public boolean isTwoState() {
        return true;
    }

    @Override
    public boolean isOn() {
        return this.dialog != null && this.dialog.isVisible();
    }

    @Override
    public void initialize(Controller controller) {
        super.initialize(controller);
        WWMenu wWMenu = (WWMenu)this.getController().getRegisteredObject("gov.nasa.worldwindx.applications.worldwindow.feature.FileMenu");
        if (wWMenu != null) {
            wWMenu.addMenu(this.getFeatureID());
        }
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setOpaque(false);
        this.tabbedPane.add(new JPanel());
        this.tabbedPane.setTitleAt(0, "+");
        this.tabbedPane.setToolTipTextAt(0, "Connect to WMS Server");
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (WMSDialog.this.tabbedPane.getSelectedIndex() == 0) {
                    WMSDialog.this.addNewPanel(WMSDialog.this.tabbedPane);
                }
            }
        });
        this.addNewPanel(this.tabbedPane);
        this.tabbedPane.setSelectedIndex(1);
        this.setTaskComponent(this.tabbedPane);
        this.setLocation(0, 0);
        this.getJDialog().setResizable(true);
        JButton jButton = new JButton(ImageLibrary.getIcon("gov/nasa/worldwindx/applications/worldwindow/images/delete-20x20.png"));
        jButton.setToolTipText("Remove Server");
        jButton.setOpaque(false);
        jButton.setBackground(new Color(0, 0, 0, 0));
        jButton.setBorderPainted(false);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WMSDialog.this.deleteCurrentPanel();
            }
        });
        jButton.setEnabled(true);
        this.insertLeftDialogComponent(jButton);
        this.setTitle("WMS Servers");
        this.dialog.validate();
        this.dialog.pack();
    }

    protected void deleteCurrentPanel() {
        JComponent jComponent = (JComponent)this.tabbedPane.getSelectedComponent();
        if (jComponent == null) {
            return;
        }
        WMSPanel wMSPanel = (WMSPanel)jComponent.getClientProperty("gov.nasa.worldwindx.applications.worldwindow.FeatureOwnerProperty");
        if (this.tabbedPane.getTabCount() > 2) {
            this.tabbedPane.remove(jComponent);
        } else {
            this.tabbedPane.setTitleAt(1, "New Server");
        }
        if (wMSPanel != null) {
            wMSPanel.clearPanel();
        }
    }

    protected WMSPanel addNewPanel(final JTabbedPane jTabbedPane) {
        WMSPanel wMSPanel = new WMSPanel(null);
        wMSPanel.initialize(this.controller);
        wMSPanel.getJPanel().putClientProperty("WMS_PANEL", wMSPanel);
        jTabbedPane.putClientProperty(wMSPanel.getURLString(), wMSPanel);
        jTabbedPane.addTab("New Server", wMSPanel.getJPanel());
        jTabbedPane.setSelectedIndex(jTabbedPane.getTabCount() - 1);
        jTabbedPane.setToolTipTextAt(this.tabbedPane.getSelectedIndex(), "Server WMS Contents");
        wMSPanel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("NewServer")) {
                    String string = (String)propertyChangeEvent.getNewValue();
                    if (WWUtil.isEmpty((Object)string)) {
                        return;
                    }
                    try {
                        WMSDialog.this.addNewPanel(jTabbedPane).contactWMSServer(string);
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        uRISyntaxException.printStackTrace();
                    }
                }
            }
        });
        return wMSPanel;
    }
}

