/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.worldwindow.features.swinglayermanager;

import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.LayerList;
import gov.nasa.worldwindx.applications.worldwindow.core.Controller;
import gov.nasa.worldwindx.applications.worldwindow.core.Registry;
import gov.nasa.worldwindx.applications.worldwindow.core.layermanager.ActiveLayersManager;
import gov.nasa.worldwindx.applications.worldwindow.features.AbstractFeaturePanel;
import gov.nasa.worldwindx.applications.worldwindow.features.swinglayermanager.ActiveLayersList;
import gov.nasa.worldwindx.applications.worldwindow.util.PanelTitle;
import gov.nasa.worldwindx.applications.worldwindow.util.ShadedPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.MouseInputAdapter;

public class ActiveLayersPanel
extends AbstractFeaturePanel
implements ActiveLayersManager {
    protected static final String TOOL_TIP = "Visible layers. Drag a layer to reposition it.";
    protected DefaultListModel model;
    protected ActiveLayersList jlist;
    private boolean on = false;

    public ActiveLayersPanel(Registry registry) {
        super("Layer List", "gov.nasa.worldwindx.applications.worldwindow.feature.ActiveLayersPanel", new ShadedPanel(new BorderLayout()), registry);
    }

    @Override
    public void initialize(final Controller controller) {
        super.initialize(controller);
        this.model = new DefaultListModel();
        this.jlist = new ActiveLayersList((ListModel)this.model);
        this.jlist.setBorder(new EmptyBorder(15, 15, 10, 10));
        this.jlist.setSelectionMode(0);
        this.jlist.setAutoscrolls(true);
        JScrollPane jScrollPane = new JScrollPane(this.jlist);
        jScrollPane.setOpaque(false);
        jScrollPane.getViewport().setOpaque(false);
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.setOpaque(false);
        jPanel.add((Component)jScrollPane, "Center");
        PanelTitle panelTitle = new PanelTitle("Active Layers", 0);
        panelTitle.setToolTipText(TOOL_TIP);
        this.panel.add((Component)panelTitle, "North");
        this.panel.add((Component)jPanel, "Center");
        LayerList layerList = controller.getWWd().getModel().getLayers();
        this.fillModel(layerList);
        layerList.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getSource() instanceof LayerList) {
                    ActiveLayersPanel.this.refresh(propertyChangeEvent);
                    controller.redraw();
                } else if (propertyChangeEvent.getSource() instanceof Layer) {
                    ActiveLayersPanel.this.jlist.repaint();
                    controller.redraw();
                }
            }
        });
        ReorderListener reorderListener = new ReorderListener(this.jlist);
        this.jlist.addMouseListener(reorderListener);
        this.jlist.addMouseMotionListener(reorderListener);
        final JPopupMenu jPopupMenu = this.makePopupMenu();
        this.jlist.setInheritsPopupMenu(true);
        this.jlist.addMouseListener(new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (jPopupMenu.isPopupTrigger(mouseEvent)) {
                    jPopupMenu.show(ActiveLayersPanel.this.panel, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
    }

    private JPopupMenu makePopupMenu() {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("Show Internal Layers");
        jCheckBoxMenuItem.setSelected(false);
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ActiveLayersPanel.this.setIncludeInternalLayers(((JCheckBoxMenuItem)actionEvent.getSource()).isSelected());
            }
        });
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(jCheckBoxMenuItem);
        return jPopupMenu;
    }

    @Override
    public boolean isIncludeInternalLayers() {
        return this.jlist.isIncludeInternalLayers();
    }

    @Override
    public void setIncludeInternalLayers(boolean bl) {
        if (bl == this.jlist.isIncludeInternalLayers()) {
            return;
        }
        this.jlist.setIncludeInternalLayers(bl);
        this.fillModel(this.controller.getActiveLayers());
    }

    @Override
    public boolean isTwoState() {
        return true;
    }

    @Override
    public boolean isOn() {
        return this.on;
    }

    @Override
    public void turnOn(boolean bl) {
        this.firePropertyChange("ShowLayerList", this.on, bl);
        this.on = !this.on;
    }

    protected void fillModel(LayerList layerList) {
        this.model.clear();
        for (Layer layer : layerList) {
            this.model.addElement(layer);
        }
    }

    protected void refresh(PropertyChangeEvent propertyChangeEvent) {
        List list;
        if (propertyChangeEvent.getNewValue() instanceof LayerList) {
            this.fillModel((LayerList)propertyChangeEvent.getNewValue());
        }
        if (propertyChangeEvent.getOldValue() instanceof LayerList && propertyChangeEvent.getNewValue() instanceof LayerList && (list = LayerList.getLayersAdded((LayerList)((LayerList)propertyChangeEvent.getOldValue()), (LayerList)((LayerList)propertyChangeEvent.getNewValue()))).size() > 0) {
            this.jlist.ensureIndexIsVisible(((LayerList)propertyChangeEvent.getNewValue()).indexOf(list.get(list.size() - 1)));
        }
    }

    @Override
    public void updateLayerList(LayerList layerList) {
        if (layerList == null) {
            layerList = this.controller.getWWd().getModel().getLayers();
        }
        ArrayList<Layer> arrayList = new ArrayList<Layer>(layerList.size());
        for (int i = 0; i < this.model.size(); ++i) {
            arrayList.add((Layer)this.model.get(i));
        }
        layerList.replaceAll(arrayList);
    }

    protected class ReorderListener
    extends MouseAdapter {
        protected JList list;
        protected int hotspot;
        protected int pressIndex;
        protected int releaseIndex;

        public ReorderListener(JList jList) {
            this.hotspot = new JCheckBox().getPreferredSize().width;
            this.pressIndex = 0;
            this.releaseIndex = 0;
            if (!(jList.getModel() instanceof DefaultListModel)) {
                throw new IllegalArgumentException("List must have a DefaultListModel");
            }
            this.list = jList;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            int n = this.list.locationToIndex(mouseEvent.getPoint());
            int n2 = this.pressIndex = mouseEvent.getX() > this.list.getCellBounds((int)n, (int)n).x + this.hotspot ? n : -1;
            if (this.pressIndex == -1) {
                Layer layer;
                layer.setEnabled(!(layer = (Layer)ActiveLayersPanel.this.model.get(n)).isEnabled());
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.releaseIndex = this.list.locationToIndex(mouseEvent.getPoint());
            if (this.releaseIndex != this.pressIndex && this.releaseIndex != -1 && this.pressIndex != -1) {
                this.reorder();
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.pressIndex != -1) {
                this.mouseReleased(mouseEvent);
                this.pressIndex = this.releaseIndex;
            }
        }

        protected void reorder() {
            DefaultListModel defaultListModel = (DefaultListModel)this.list.getModel();
            Object e = defaultListModel.elementAt(this.pressIndex);
            defaultListModel.removeElementAt(this.pressIndex);
            defaultListModel.insertElementAt(e, this.releaseIndex);
            ActiveLayersPanel.this.updateLayerList(null);
            ActiveLayersPanel.this.controller.redraw();
        }
    }
}

