/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.worldwindow.features.swinglayermanager;

import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwindx.applications.worldwindow.core.WMSLayerInfo;
import gov.nasa.worldwindx.applications.worldwindow.features.swinglayermanager.LayerNode;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.tree.DefaultMutableTreeNode;

public class LayerTreeNode
extends DefaultMutableTreeNode
implements LayerNode {
    public static final String NODE_ID = "LayerManager.LayerNode.NodeID";
    private static AtomicLong nextID = new AtomicLong(1L);
    private long id;
    private Layer layer;
    private String title;
    private boolean selected = false;
    private WMSLayerInfo wmsLayerInfo;
    private String toolTipText;
    private boolean enableSelectionBox = true;

    static long getNewID() {
        return nextID.getAndIncrement();
    }

    public LayerTreeNode() {
        this.id = LayerTreeNode.getNewID();
        this.title = Long.toString(this.id);
    }

    public LayerTreeNode(String string) {
        this.id = LayerTreeNode.getNewID();
        this.title = string;
    }

    public LayerTreeNode(Layer layer) {
        this.id = LayerTreeNode.getNewID();
        this.layer = layer;
        this.selected = layer.isEnabled();
        this.layer.setValue(NODE_ID, (Object)this.id);
    }

    public LayerTreeNode(WMSLayerInfo wMSLayerInfo) {
        this(wMSLayerInfo.getTitle());
        this.wmsLayerInfo = wMSLayerInfo;
    }

    public LayerTreeNode(LayerTreeNode layerTreeNode) {
        this.id = (Long)layerTreeNode.getID();
        this.layer = layerTreeNode.layer;
        this.title = layerTreeNode.title;
        this.selected = layerTreeNode.selected;
        this.wmsLayerInfo = layerTreeNode.wmsLayerInfo;
    }

    @Override
    public Object getID() {
        return this.id;
    }

    @Override
    public String getTitle() {
        return this.title != null ? this.title : (this.layer != null ? this.layer.getName() : Long.toString(this.id));
    }

    @Override
    public void setTitle(String string) {
        this.title = string;
    }

    @Override
    public Layer getLayer() {
        return this.layer;
    }

    @Override
    public void setLayer(Layer layer) {
        this.layer = layer;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    @Override
    public WMSLayerInfo getWmsLayerInfo() {
        return this.wmsLayerInfo;
    }

    @Override
    public String getToolTipText() {
        return this.toolTipText;
    }

    @Override
    public void setToolTipText(String string) {
        this.toolTipText = string;
    }

    @Override
    public void setEnableSelectionBox(boolean bl) {
        this.enableSelectionBox = bl;
    }

    @Override
    public boolean isEnableSelectionBox() {
        return this.enableSelectionBox;
    }

    @Override
    public String toString() {
        return this.getTitle() != null ? this.getTitle() : Long.toString(this.id);
    }
}

