/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.worldwindow.util;

import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.util.WWUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.io.File;
import java.text.DecimalFormatSymbols;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JDialog;

public class Util {
    public static final String DECIMAL_SYMBOL = Character.toString(new DecimalFormatSymbols().getDecimalSeparator());

    public static Logger getLogger() {
        return Logger.getLogger("gov.nasa.worldwind");
    }

    public static Frame findParentFrame(Component component) {
        while (component != null) {
            if (component instanceof Frame) {
                return (Frame)component;
            }
            component = component.getParent();
        }
        return null;
    }

    public static File ensureFileSuffix(File file, String string) {
        String string2 = WWIO.getSuffix((String)file.getPath());
        if (string2 == null || !string2.equalsIgnoreCase(string)) {
            return new File(file.getPath() + (string2 == null ? "." : "") + string);
        }
        return file;
    }

    public static void centerDialogInContainer(JDialog jDialog, Container container) {
        Dimension dimension = jDialog.getPreferredSize();
        Point point = container.getLocationOnScreen();
        Dimension dimension2 = container.getSize();
        int n = point.x + (dimension2.width - dimension.width) / 2;
        int n2 = point.y + (dimension2.height - dimension.height) / 2;
        jDialog.setLocation(n, n2);
    }

    public static void positionDialogInContainer(JDialog jDialog, Container container, int n, int n2) {
        Dimension dimension = jDialog.getPreferredSize();
        Point point = container.getLocationOnScreen();
        Dimension dimension2 = container.getSize();
        int n3 = point.x + (dimension2.width - dimension.width) / 2;
        int n4 = point.y + (dimension2.height - dimension.height) / 2;
        switch (n) {
            case 7: {
                n3 = point.x;
                break;
            }
            case 3: {
                n3 = point.x + dimension2.width - dimension.width;
            }
        }
        switch (n2) {
            case 1: {
                n4 = point.y;
                break;
            }
            case 5: {
                n4 = point.y + dimension2.height - dimension.height;
            }
        }
        jDialog.setLocation(n3, n4);
    }

    public static String[] splitLines(String string) {
        if (WWUtil.isEmpty((Object)string)) {
            return null;
        }
        String[] stringArray = string.trim().split("\n");
        return stringArray.length > 0 ? stringArray : null;
    }

    public static String[] splitWords(String string) {
        return Util.splitWords(string, ",");
    }

    public static String[] splitWords(String string, String string2) {
        if (WWUtil.isEmpty((Object)string)) {
            return null;
        }
        String[] stringArray = string.trim().split(string2);
        return stringArray.length > 0 ? stringArray : null;
    }

    public static String makeMultiLineToolTip(String string) {
        Pattern pattern;
        Matcher matcher;
        StringBuilder stringBuilder = new StringBuilder();
        if (!string.trim().toLowerCase().startsWith("<html>")) {
            stringBuilder.append("<html>");
        }
        if ((matcher = (pattern = Pattern.compile("(.{0,80}\\b\\s*)")).matcher(string)).find()) {
            stringBuilder.append(string.substring(matcher.start(), matcher.end()).trim());
        }
        while (matcher.find()) {
            stringBuilder.append("<br>");
            stringBuilder.append(string.substring(matcher.start(), matcher.end()).trim());
        }
        if (!string.trim().toLowerCase().endsWith("</html>")) {
            stringBuilder.append("</html>");
        }
        return stringBuilder.toString();
    }
}

