/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.worldwindow.util;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.TiledImageLayer;
import gov.nasa.worldwind.ogc.wms.WMSCapabilities;
import gov.nasa.worldwind.ogc.wms.WMSLayerCapabilities;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwind.wms.WMSTiledImageLayer;
import gov.nasa.worldwindx.applications.worldwindow.core.Controller;
import gov.nasa.worldwindx.applications.worldwindow.util.LayerTree;
import java.util.List;

public class WMSLayerTree
extends LayerTree {
    public WMSLayerTree(Controller controller) {
        super(controller);
    }

    @Override
    public void createLayers(Object object, AVList aVList) {
        if (object instanceof WMSCapabilities) {
            List list;
            WMSCapabilities wMSCapabilities = (WMSCapabilities)object;
            String string = wMSCapabilities.getServiceInformation().getServiceTitle();
            if (!WWUtil.isEmpty((Object)string)) {
                this.setDisplayName(string);
            }
            if ((list = wMSCapabilities.getCapabilityInformation().getLayerCapabilities()) == null) {
                return;
            }
            for (WMSLayerCapabilities wMSLayerCapabilities : list) {
                LayerTree layerTree = this.createSubTree(wMSCapabilities, wMSLayerCapabilities, aVList);
                if (layerTree == null) continue;
                this.children.add(layerTree);
            }
        }
    }

    public LayerTree createSubTree(WMSCapabilities wMSCapabilities, WMSLayerCapabilities wMSLayerCapabilities, AVList aVList) {
        WMSLayerTree wMSLayerTree = new WMSLayerTree(this.controller);
        if (!WWUtil.isEmpty((Object)wMSLayerCapabilities.getTitle())) {
            wMSLayerTree.setDisplayName(wMSLayerCapabilities.getTitle());
        } else if (!WWUtil.isEmpty((Object)wMSLayerCapabilities.getName())) {
            wMSLayerTree.setDisplayName(wMSLayerCapabilities.getName());
        } else {
            wMSLayerTree.setDisplayName("No name");
        }
        if (wMSLayerCapabilities.getName() != null) {
            TiledImageLayer tiledImageLayer = wMSLayerTree.createImageLayer(wMSCapabilities, wMSLayerCapabilities, aVList);
            if (tiledImageLayer == null) {
                return null;
            }
            wMSLayerTree.getLayers().add((Layer)tiledImageLayer);
        }
        if (wMSLayerCapabilities.getLayers() != null) {
            for (WMSLayerCapabilities wMSLayerCapabilities2 : wMSLayerCapabilities.getLayers()) {
                Object object;
                if (wMSLayerCapabilities2.isLeaf()) {
                    object = wMSLayerTree.createImageLayer(wMSCapabilities, wMSLayerCapabilities2, aVList);
                    if (object == null) continue;
                    wMSLayerTree.getLayers().add((Layer)object);
                    continue;
                }
                object = this.createSubTree(wMSCapabilities, wMSLayerCapabilities2, aVList);
                if (object == null) continue;
                wMSLayerTree.children.add(object);
            }
        }
        return wMSLayerTree;
    }

    protected TiledImageLayer createImageLayer(WMSCapabilities wMSCapabilities, WMSLayerCapabilities wMSLayerCapabilities, AVList aVList) {
        AVListImpl aVListImpl = new AVListImpl();
        if (aVList != null) {
            aVListImpl.setValues(aVList);
        }
        aVListImpl.setValue("gov.nasa.worldwind.avkey.LayerNames", (Object)wMSLayerCapabilities.getName());
        return new WMSTiledImageLayer(wMSCapabilities, (AVList)aVListImpl);
    }
}

