/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.worldwindow.util.measuretool;

import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.AnnotationAttributes;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.GlobeAnnotation;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwindx.applications.worldwindow.util.measuretool.WWOMeasureTool;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.util.ArrayList;

public class WWOMeasureToolControlPoints
implements WWOMeasureTool.ControlPointList,
Renderable {
    protected WWOMeasureTool measureTool;
    protected ArrayList<ControlPoint> points = new ArrayList();
    protected AnnotationAttributes controlPointAttributes;

    public WWOMeasureToolControlPoints(WWOMeasureTool wWOMeasureTool) {
        this.measureTool = wWOMeasureTool;
        this.controlPointAttributes = new AnnotationAttributes();
        this.controlPointAttributes.setFrameShape("gov.nasa.worldwind.avkey.ShapeRectangle");
        this.controlPointAttributes.setLeader("gov.nasa.worldwind.avkey.ShapeNone");
        this.controlPointAttributes.setAdjustWidthToText("gov.nasa.worldwind.avkey.SizeFixed");
        this.controlPointAttributes.setSize(new Dimension(8, 8));
        this.controlPointAttributes.setDrawOffset(new Point(0, -4));
        this.controlPointAttributes.setInsets(new Insets(0, 0, 0, 0));
        this.controlPointAttributes.setBorderWidth(0.0);
        this.controlPointAttributes.setCornerRadius(0);
        this.controlPointAttributes.setBackgroundColor(Color.BLUE);
        this.controlPointAttributes.setTextColor(Color.GREEN);
        this.controlPointAttributes.setHighlightScale(1.2);
        this.controlPointAttributes.setDistanceMaxScale(1.0);
        this.controlPointAttributes.setDistanceMinScale(1.0);
        this.controlPointAttributes.setDistanceMinOpacity(1.0);
    }

    @Override
    public void addToLayer(RenderableLayer renderableLayer) {
        renderableLayer.addRenderable((Renderable)this);
    }

    @Override
    public void removeFromLayer(RenderableLayer renderableLayer) {
        renderableLayer.removeRenderable((Renderable)this);
    }

    @Override
    public int size() {
        return this.points.size();
    }

    @Override
    public WWOMeasureTool.ControlPoint createControlPoint(Position position) {
        return new ControlPoint(position);
    }

    @Override
    public WWOMeasureTool.ControlPoint get(int n) {
        return this.points.get(n);
    }

    @Override
    public void add(WWOMeasureTool.ControlPoint controlPoint) {
        this.points.add((ControlPoint)controlPoint);
    }

    @Override
    public void remove(WWOMeasureTool.ControlPoint controlPoint) {
        this.points.remove((ControlPoint)controlPoint);
    }

    @Override
    public void remove(int n) {
        this.points.remove(n);
    }

    @Override
    public void clear() {
        this.points.clear();
    }

    @Override
    public void render(DrawContext drawContext) {
        for (ControlPoint controlPoint : this.points) {
            controlPoint.render(drawContext);
        }
    }

    public class ControlPoint
    extends GlobeAnnotation
    implements WWOMeasureTool.ControlPoint {
        public ControlPoint(Position position) {
            super("", position, WWOMeasureToolControlPoints.this.controlPointAttributes);
        }

        @Override
        public WWOMeasureTool getParent() {
            return WWOMeasureToolControlPoints.this.measureTool;
        }

        @Override
        public void setPosition(Position position) {
            super.setPosition(position);
        }

        @Override
        public Position getPosition() {
            return super.getPosition();
        }

        @Override
        public void highlight(boolean bl) {
            this.getAttributes().setHighlighted(bl);
            this.getAttributes().setBackgroundColor(bl ? this.getAttributes().getTextColor() : null);
        }

        @Override
        public Object setValue(String string, Object object) {
            return super.setValue(string, object);
        }

        @Override
        public Object getValue(String string) {
            return super.getValue(string);
        }
    }
}

