/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import com.jogamp.opengl.util.awt.TextRenderer;
import gov.nasa.worldwind.View;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.layers.AnnotationLayer;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.pick.PickedObjectList;
import gov.nasa.worldwind.render.Annotation;
import gov.nasa.worldwind.render.AnnotationAttributes;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.FrameFactory;
import gov.nasa.worldwind.render.GlobeAnnotation;
import gov.nasa.worldwind.render.PatternFactory;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.ScreenAnnotation;
import gov.nasa.worldwind.render.ScreenRelativeAnnotation;
import gov.nasa.worldwind.util.BasicDragger;
import gov.nasa.worldwind.util.BrowserOpener;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import gov.nasa.worldwindx.examples.util.PowerOfTwoPaddedImage;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.media.opengl.GL2;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Annotations
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind Annotations", AppFrame.class);
    }

    private static class AppFrame
    extends ApplicationTemplate.AppFrame {
        private AnnotationLayer layer;
        private Annotation currentAnnotation;
        private static final PowerOfTwoPaddedImage IMAGE_WWJ_SPLASH = PowerOfTwoPaddedImage.fromPath("images/400x230-splash-nww.png");
        private static final PowerOfTwoPaddedImage IMAGE_NASA = PowerOfTwoPaddedImage.fromPath("images/32x32-icon-nasa.png");
        private static final PowerOfTwoPaddedImage IMAGE_EARTH = PowerOfTwoPaddedImage.fromPath("images/32x32-icon-earth.png");
        private JTextArea inputTextArea;
        private JCheckBox cbAdjustWidth;
        private JSlider widthSlider;
        private JSlider heightSlider;
        private JSlider scaleSlider;
        private JSlider opacitySlider;
        private JSlider cornerRadiusSlider;
        private JSlider borderWidthSlider;
        private JSlider stippleFactorSlider;
        private JComboBox cbFontName;
        private JComboBox cbFontStyle;
        private JComboBox cbFontSize;
        private JComboBox cbTextAlign;
        private JComboBox cbShape;
        private JComboBox cbLeader;
        private JComboBox cbImage;
        private JComboBox cbImageRepeat;
        private JComboBox cbTextEffect;
        private JSlider leaderGapWidthSlider;
        private JSlider imageOpacitySlider;
        private JSlider imageScaleSlider;
        private JSlider imageOffsetXSlider;
        private JSlider imageOffsetYSlider;
        private JSlider offsetXSlider;
        private JSlider offsetYSlider;
        private JSlider distanceMinScaleSlider;
        private JSlider distanceMaxScaleSlider;
        private JSlider distanceMinOpacitySlider;
        private JSlider highlightScaleSlider;
        private JSpinner insetsTop;
        private JSpinner insetsRight;
        private JSpinner insetsBottom;
        private JSpinner insetsLeft;
        private JButton btTextColor;
        private JButton btBackColor;
        private JButton btBorderColor;
        private JComboBox cbTextColorAlpha;
        private JComboBox cbBackColorAlpha;
        private JComboBox cbBorderColorAlpha;
        private JButton btApply;
        private JButton btRemove;
        private boolean suspendUpdate = false;
        private Color savedBorderColor;
        private BufferedImage savedImage;
        private Annotation lastPickedObject;

        public AppFrame() {
            this.setupAnnotations();
            this.getLayerPanel().add((Component)this.makeControlPanel(), "South");
            this.enableControlPanel(false);
            this.setupSelection();
        }

        private void setupAnnotations() {
            RenderableLayer renderableLayer = new RenderableLayer();
            renderableLayer.setName("Annotations (stand alone)");
            ApplicationTemplate.insertBeforeCompass(this.getWwd(), (Layer)renderableLayer);
            GlobeAnnotation globeAnnotation = new GlobeAnnotation("AGL Annotation\nElev 1000m", Position.fromDegrees((double)10.0, (double)25.0, (double)1000.0));
            globeAnnotation.setHeightInMeter(10000.0);
            renderableLayer.addRenderable((Renderable)globeAnnotation);
            AMSLGlobeAnnotation aMSLGlobeAnnotation = new AMSLGlobeAnnotation("AMSL Annotation\nAlt 1000m", Position.fromDegrees((double)10.0, (double)20.0, (double)1000.0));
            aMSLGlobeAnnotation.setHeightInMeter(10000.0);
            renderableLayer.addRenderable((Renderable)aMSLGlobeAnnotation);
            globeAnnotation = this.makeTopImageBottomTextAnnotation(IMAGE_WWJ_SPLASH, "Text below image", Position.fromDegrees((double)0.0, (double)-40.0, (double)0.0));
            renderableLayer.addRenderable((Renderable)globeAnnotation);
            this.layer = new AnnotationLayer();
            AnnotationAttributes annotationAttributes = new AnnotationAttributes();
            annotationAttributes.setCornerRadius(10);
            annotationAttributes.setInsets(new Insets(8, 8, 8, 8));
            annotationAttributes.setBackgroundColor(new Color(0.0f, 0.0f, 0.0f, 0.5f));
            annotationAttributes.setTextColor(Color.WHITE);
            annotationAttributes.setDrawOffset(new Point(25, 25));
            annotationAttributes.setDistanceMinScale(0.5);
            annotationAttributes.setDistanceMaxScale(2.0);
            annotationAttributes.setDistanceMinOpacity(0.5);
            annotationAttributes.setLeaderGapWidth(14);
            annotationAttributes.setDrawOffset(new Point(20, 40));
            AnnotationAttributes annotationAttributes2 = new AnnotationAttributes();
            annotationAttributes2.setDefaults(annotationAttributes);
            annotationAttributes2.setFont(Font.decode("Arial-BOLD-12"));
            this.layer.addAnnotation((Annotation)new GlobeAnnotation("MONACO", Position.fromDegrees((double)43.734, (double)7.4211, (double)0.0), annotationAttributes2));
            this.layer.addAnnotation((Annotation)new GlobeAnnotation("NICE", Position.fromDegrees((double)43.696, (double)7.27, (double)0.0), annotationAttributes2));
            this.layer.addAnnotation((Annotation)new GlobeAnnotation("ANTIBES", Position.fromDegrees((double)43.581, (double)7.1248, (double)0.0), annotationAttributes2));
            this.layer.addAnnotation((Annotation)new GlobeAnnotation("CANNES", Position.fromDegrees((double)43.5536, (double)7.0171, (double)0.0), annotationAttributes2));
            this.layer.addAnnotation((Annotation)new GlobeAnnotation("GRASSE", Position.fromDegrees((double)43.659, (double)6.924, (double)0.0), annotationAttributes2));
            this.layer.addAnnotation((Annotation)new GlobeAnnotation("FREJUS", Position.fromDegrees((double)43.4326, (double)6.7356, (double)0.0), annotationAttributes2));
            this.layer.addAnnotation((Annotation)new GlobeAnnotation("SAINTE MAXIME", Position.fromDegrees((double)43.3087, (double)6.6353, (double)0.0), annotationAttributes2));
            this.layer.addAnnotation((Annotation)new GlobeAnnotation("SAINT TROPEZ", Position.fromDegrees((double)43.271, (double)6.6386, (double)0.0), annotationAttributes2));
            this.layer.addAnnotation((Annotation)new GlobeAnnotation("TOULON", Position.fromDegrees((double)43.1264, (double)5.9126, (double)0.0), annotationAttributes2));
            this.layer.addAnnotation((Annotation)new GlobeAnnotation("MARSEILLE", Position.fromDegrees((double)43.2904, (double)5.3806, (double)0.0), annotationAttributes2));
            this.layer.addAnnotation((Annotation)new GlobeAnnotation("AIX EN PROVENCE", Position.fromDegrees((double)43.5286, (double)5.4485, (double)0.0), annotationAttributes2));
            AnnotationAttributes annotationAttributes3 = new AnnotationAttributes();
            annotationAttributes3.setDefaults(annotationAttributes);
            annotationAttributes3.setFont(Font.decode("Arial-BOLDITALIC-10"));
            annotationAttributes3.setTextColor(Color.YELLOW);
            this.layer.addAnnotation((Annotation)new GlobeAnnotation("A\u00e9roport International\nNice C\u00f4te d'Azur", Position.fromDegrees((double)43.6582, (double)7.2167, (double)0.0), annotationAttributes3));
            this.layer.addAnnotation((Annotation)new GlobeAnnotation("Sophia Antipolis", Position.fromDegrees((double)43.6222, (double)7.0474, (double)0.0), annotationAttributes3));
            AnnotationAttributes annotationAttributes4 = new AnnotationAttributes();
            annotationAttributes4.setDefaults(annotationAttributes);
            annotationAttributes4.setFrameShape("gov.nasa.worldwind.avkey.ShapeNone");
            annotationAttributes4.setFont(Font.decode("Arial-ITALIC-12"));
            annotationAttributes4.setTextColor(Color.GREEN);
            annotationAttributes4.setTextAlign("gov.nasa.worldwind.avkey.Center");
            annotationAttributes4.setDrawOffset(new Point(0, 5));
            annotationAttributes4.setEffect("gov.nasa.worldwind.avkey.TextEffectOutline");
            annotationAttributes4.setBackgroundColor(Color.BLACK);
            this.layer.addAnnotation((Annotation)new GlobeAnnotation("Mont Chauve\nFort militaire\nAlt: 853m", Position.fromDegrees((double)43.7701, (double)7.2544, (double)0.0), annotationAttributes4));
            this.layer.addAnnotation((Annotation)new GlobeAnnotation("Mont Agel\nFort militaire\nAlt: 1148m", Position.fromDegrees((double)43.7704, (double)7.4203, (double)0.0), annotationAttributes4));
            this.layer.addAnnotation((Annotation)new GlobeAnnotation("Cap Ferrat", Position.fromDegrees((double)43.682, (double)7.329, (double)0.0), annotationAttributes4));
            this.layer.addAnnotation((Annotation)new GlobeAnnotation("Gorges du Loup", Position.fromDegrees((double)43.7351, (double)6.9988, (double)0.0), annotationAttributes4));
            this.layer.addAnnotation((Annotation)new GlobeAnnotation("Cap d'Antibes", Position.fromDegrees((double)43.5526, (double)7.1297, (double)0.0), annotationAttributes4));
            this.layer.addAnnotation((Annotation)new GlobeAnnotation("Iles de L\u00e9rins", Position.fromDegrees((double)43.5125, (double)7.0467, (double)0.0), annotationAttributes4));
            this.layer.addAnnotation((Annotation)new GlobeAnnotation("Montagne du Cheiron\nAlt: 1778m", Position.fromDegrees((double)43.8149, (double)6.9669, (double)0.0), annotationAttributes4));
            this.layer.addAnnotation((Annotation)new GlobeAnnotation("Giens", Position.fromDegrees((double)43.0394, (double)6.1384, (double)0.0), annotationAttributes4));
            this.layer.addAnnotation((Annotation)new GlobeAnnotation("Iles de Porquerolles", Position.fromDegrees((double)42.9974, (double)6.2147, (double)0.0), annotationAttributes4));
            this.layer.addAnnotation((Annotation)new GlobeAnnotation("Ile du Levent", Position.fromDegrees((double)43.0315, (double)6.4702, (double)0.0), annotationAttributes4));
            this.layer.addAnnotation((Annotation)new GlobeAnnotation("Ile de Port Cros", Position.fromDegrees((double)43.0045, (double)6.3959, (double)0.0), annotationAttributes4));
            this.layer.addAnnotation((Annotation)new GlobeAnnotation("Montagne Sainte Victoire\nAlt: 1010m", Position.fromDegrees((double)43.5319, (double)5.612, (double)0.0), annotationAttributes4));
            this.layer.addAnnotation((Annotation)new GlobeAnnotation("Sainte Baume\nAlt: 1147m", Position.fromDegrees((double)43.3373, (double)5.8008, (double)0.0), annotationAttributes4));
            this.layer.addAnnotation((Annotation)new GlobeAnnotation("Pic de l'Ours\nAlt: 496m", Position.fromDegrees((double)43.4763, (double)6.9042, (double)0.0), annotationAttributes4));
            AnnotationAttributes annotationAttributes5 = new AnnotationAttributes();
            annotationAttributes5.setDefaults(annotationAttributes);
            annotationAttributes5.setFrameShape("gov.nasa.worldwind.avkey.ShapeEllipse");
            annotationAttributes5.setTextAlign("gov.nasa.worldwind.avkey.Center");
            annotationAttributes5.setFont(Font.decode("Arial-ITALIC-12"));
            annotationAttributes5.setTextColor(Color.CYAN);
            annotationAttributes5.setInsets(new Insets(8, 12, 9, 12));
            this.layer.addAnnotation((Annotation)new GlobeAnnotation("Lac de Sainte Croix", Position.fromDegrees((double)43.772, (double)6.1879, (double)0.0), annotationAttributes5));
            this.layer.addAnnotation((Annotation)new GlobeAnnotation("Lac de Castillon", Position.fromDegrees((double)43.9008, (double)6.5348, (double)0.0), annotationAttributes5));
            this.layer.addAnnotation((Annotation)new GlobeAnnotation("Lac de Serre Pon\u00e7on", Position.fromDegrees((double)44.5081, (double)6.3242, (double)0.0), annotationAttributes5));
            globeAnnotation = new GlobeAnnotation("Transition Permien-Trias\nDate: 251Ma \nPlus grand \u00e9pisode d'extinction massive.", Position.fromDegrees((double)44.0551, (double)7.1215, (double)0.0), Font.decode("Arial-ITALIC-12"), Color.DARK_GRAY);
            globeAnnotation.getAttributes().setTextAlign("gov.nasa.worldwind.avkey.Right");
            globeAnnotation.getAttributes().setBackgroundColor(new Color(0.8f, 0.8f, 0.8f, 0.7f));
            globeAnnotation.getAttributes().setBorderColor(Color.BLACK);
            this.layer.addAnnotation((Annotation)globeAnnotation);
            globeAnnotation = new GlobeAnnotation("<p>\n<b><font color=\"#664400\">LA CLAPI\u00c8RE</font></b><br />\n<i>Alt: 1100-1700m</i>\n</p>\n<p>\n<b>Glissement de terrain majeur</b> dans la haute Tin\u00e9e, sur un flanc du <a href=\"http://www.mercantour.eu\">Parc du Mercantour</a>, Alpes Maritimes.\n</p>\n<p>\nRisque aggrav\u00e9 d'<b>inondation</b> du village de <i>Saint \u00c9tienne de Tin\u00e9e</i> juste en amont.\n</p>", Position.fromDegrees((double)44.2522, (double)6.9424, (double)0.0), Font.decode("Serif-PLAIN-14"), Color.DARK_GRAY);
            globeAnnotation.setMinActiveAltitude(10000.0);
            globeAnnotation.setMaxActiveAltitude(1000000.0);
            globeAnnotation.getAttributes().setTextAlign("gov.nasa.worldwind.avkey.Right");
            globeAnnotation.getAttributes().setBackgroundColor(new Color(1.0f, 1.0f, 1.0f, 0.7f));
            globeAnnotation.getAttributes().setBorderColor(Color.BLACK);
            globeAnnotation.getAttributes().setSize(new Dimension(220, 0));
            globeAnnotation.getAttributes().setImageSource((Object)IMAGE_EARTH.getPowerOfTwoImage());
            globeAnnotation.getAttributes().setImageRepeat("gov.nasa.worldwind.avkey.RepeatNone");
            globeAnnotation.getAttributes().setImageOpacity(0.6);
            globeAnnotation.getAttributes().setImageScale(0.7);
            globeAnnotation.getAttributes().setImageOffset(new Point(7, 7));
            this.layer.addAnnotation((Annotation)globeAnnotation);
            globeAnnotation = new GlobeAnnotation("Latitude: 44.0 N\nLongitude: 7.0 W", Position.fromDegrees((double)44.0, (double)7.0, (double)0.0), Font.decode("Arial-ITALIC-12"), Color.DARK_GRAY);
            globeAnnotation.getAttributes().setTextAlign("gov.nasa.worldwind.avkey.Center");
            globeAnnotation.getAttributes().setBackgroundColor(new Color(0.9f, 0.9f, 0.8f, 0.7f));
            globeAnnotation.getAttributes().setBorderColor(Color.BLACK);
            globeAnnotation.getAttributes().setBorderWidth(2.0);
            globeAnnotation.getAttributes().setBorderStippleFactor(3);
            this.layer.addAnnotation((Annotation)globeAnnotation);
            globeAnnotation = new GlobeAnnotation("SAHARA DESERT\n\nThe Sahara is technically the world's second largest desert after Antarctica.\n\nAt over 9,000,000 square kilometres (3,500,000 sq mi), it covers most parts of northern Africa. ", Position.fromDegrees((double)22.0, (double)12.0, (double)0.0), Font.decode("Arial-BOLD-12"));
            globeAnnotation.getAttributes().setDefaults(annotationAttributes);
            globeAnnotation.getAttributes().setImageSource((Object)IMAGE_NASA.getPowerOfTwoImage());
            globeAnnotation.getAttributes().setImageRepeat("gov.nasa.worldwind.avkey.RepeatY");
            globeAnnotation.getAttributes().setImageOpacity(0.6);
            globeAnnotation.getAttributes().setImageScale(0.7);
            globeAnnotation.getAttributes().setImageOffset(new Point(1, 1));
            globeAnnotation.getAttributes().setInsets(new Insets(6, 28, 6, 6));
            this.layer.addAnnotation((Annotation)globeAnnotation);
            globeAnnotation = new GlobeAnnotation("Java SDK", Position.fromDegrees((double)20.0, (double)0.0, (double)0.0), Font.decode("Arial-BOLD-14"));
            globeAnnotation.getAttributes().setTextAlign("gov.nasa.worldwind.avkey.Right");
            globeAnnotation.getAttributes().setImageSource((Object)IMAGE_WWJ_SPLASH.getPowerOfTwoImage());
            globeAnnotation.getAttributes().setImageRepeat("gov.nasa.worldwind.avkey.RepeatNone");
            globeAnnotation.getAttributes().setImageScale(0.5);
            globeAnnotation.getAttributes().setSize(new Dimension(200, 115));
            globeAnnotation.getAttributes().setAdjustWidthToText("gov.nasa.worldwind.avkey.SizeFixed");
            globeAnnotation.getAttributes().setCornerRadius(0);
            this.layer.addAnnotation((Annotation)globeAnnotation);
            AnnotationAttributes annotationAttributes6 = new AnnotationAttributes();
            annotationAttributes6.setDefaults(annotationAttributes);
            annotationAttributes6.setFont(Font.decode("Arial-BOLD-16"));
            annotationAttributes6.setTextColor(Color.GRAY);
            globeAnnotation = new GlobeAnnotation("Background patterns...", Position.fromDegrees((double)10.0, (double)100.0, (double)0.0), annotationAttributes6);
            globeAnnotation.getAttributes().setImageSource((Object)PatternFactory.createPattern((String)"PatternFactory.GradientVLinear", (Dimension)new Dimension(32, 128), (float)1.0f, (Color)Color.WHITE, (Color)new Color(0.0f, 0.0f, 0.0f, 0.0f)));
            globeAnnotation.getAttributes().setSize(new Dimension(200, 128));
            this.layer.addAnnotation((Annotation)globeAnnotation);
            globeAnnotation = new GlobeAnnotation("Background patterns...", Position.fromDegrees((double)10.0, (double)110.0, (double)0.0), annotationAttributes6);
            globeAnnotation.getAttributes().setImageSource((Object)PatternFactory.createPattern((String)"PatternFactory.GradientVLinear", (Dimension)new Dimension(32, 64), (float)1.0f, (Color)Color.LIGHT_GRAY, (Color)Color.WHITE));
            globeAnnotation.getAttributes().setSize(new Dimension(200, 128));
            this.layer.addAnnotation((Annotation)globeAnnotation);
            globeAnnotation = new GlobeAnnotation("Background patterns...", Position.fromDegrees((double)10.0, (double)120.0, (double)0.0), annotationAttributes6);
            globeAnnotation.getAttributes().setImageSource((Object)PatternFactory.createPattern((String)"PatternFactory.PatternDiagonalUp", (Color)Color.YELLOW));
            globeAnnotation.getAttributes().setSize(new Dimension(200, 128));
            this.layer.addAnnotation((Annotation)globeAnnotation);
            globeAnnotation = new GlobeAnnotation("Background patterns...", Position.fromDegrees((double)0.0, (double)100.0, (double)0.0), annotationAttributes6);
            globeAnnotation.getAttributes().setImageSource((Object)PatternFactory.createPattern((String)"PatternFactory.GradientHLinear", (Dimension)new Dimension(256, 32), (float)1.0f, (Color)Color.WHITE, (Color)new Color(0.0f, 0.0f, 0.0f, 0.0f)));
            globeAnnotation.getAttributes().setSize(new Dimension(200, 128));
            this.layer.addAnnotation((Annotation)globeAnnotation);
            globeAnnotation = new GlobeAnnotation("Background patterns...", Position.fromDegrees((double)0.0, (double)110.0, (double)0.0), annotationAttributes6);
            globeAnnotation.getAttributes().setImageSource((Object)PatternFactory.createPattern((String)"PatternFactory.GradientHLinear", (Dimension)new Dimension(32, 64), (float)1.0f, (Color)Color.LIGHT_GRAY, (Color)Color.WHITE));
            globeAnnotation.getAttributes().setSize(new Dimension(200, 128));
            this.layer.addAnnotation((Annotation)globeAnnotation);
            globeAnnotation = new GlobeAnnotation("Background patterns...", Position.fromDegrees((double)0.0, (double)120.0, (double)0.0), annotationAttributes6);
            globeAnnotation.getAttributes().setImageSource((Object)PatternFactory.createPattern((String)"PatternFactory.PatternSquares", (Color)Color.YELLOW));
            globeAnnotation.getAttributes().setSize(new Dimension(200, 128));
            this.layer.addAnnotation((Annotation)globeAnnotation);
            globeAnnotation = new GlobeAnnotation("Background patterns...", Position.fromDegrees((double)-10.0, (double)100.0, (double)0.0), annotationAttributes6);
            globeAnnotation.getAttributes().setImageSource((Object)PatternFactory.createPattern((String)"PatternFactory.GradientHLinear", (Dimension)new Dimension(16, 16), (float)1.0f, (Color)Color.BLACK, (Color)Color.WHITE));
            globeAnnotation.getAttributes().setImageRepeat("gov.nasa.worldwind.avkey.RepeatY");
            globeAnnotation.getAttributes().setBackgroundColor(Color.WHITE);
            globeAnnotation.getAttributes().setSize(new Dimension(200, 128));
            this.layer.addAnnotation((Annotation)globeAnnotation);
            globeAnnotation = new GlobeAnnotation("Background patterns...", Position.fromDegrees((double)-10.0, (double)110.0, (double)0.0), annotationAttributes6);
            globeAnnotation.getAttributes().setImageSource((Object)PatternFactory.createPattern((String)"PatternFactory.GradientVLinear", (Dimension)new Dimension(16, 16), (float)1.0f, (Color)Color.BLACK, (Color)Color.WHITE));
            globeAnnotation.getAttributes().setImageRepeat("gov.nasa.worldwind.avkey.RepeatX");
            globeAnnotation.getAttributes().setBackgroundColor(Color.WHITE);
            globeAnnotation.getAttributes().setSize(new Dimension(200, 128));
            this.layer.addAnnotation((Annotation)globeAnnotation);
            globeAnnotation = new GlobeAnnotation("Background patterns...", Position.fromDegrees((double)-10.0, (double)120.0, (double)0.0), annotationAttributes6);
            globeAnnotation.getAttributes().setImageSource((Object)PatternFactory.createPattern((String)"PatternFactory.PatternHVLine", (float)0.15f, (Color)Color.GREEN));
            globeAnnotation.getAttributes().setImageScale(0.4);
            globeAnnotation.getAttributes().setSize(new Dimension(200, 128));
            this.layer.addAnnotation((Annotation)globeAnnotation);
            for (int i = 1; i <= 10; ++i) {
                globeAnnotation = new GlobeAnnotation("Pattern scale:" + (float)i / 10.0f, Position.fromDegrees((double)-20.0, (double)(97 + i * 3), (double)0.0), annotationAttributes6);
                globeAnnotation.getAttributes().setImageSource((Object)PatternFactory.createPattern((String)"PatternFactory.PatternCircles", (float)((float)i / 10.0f), (Color)Color.LIGHT_GRAY));
                globeAnnotation.getAttributes().setImageScale(0.4);
                globeAnnotation.getAttributes().setSize(new Dimension(160, 60));
                this.layer.addAnnotation((Annotation)globeAnnotation);
            }
            class SimpleGlobeAnnotation
            extends GlobeAnnotation {
                Font font;

                public SimpleGlobeAnnotation(String string, Position position) {
                    super(string, position);
                    this.font = Font.decode("Arial-PLAIN-12");
                }

                protected void applyScreenTransform(DrawContext drawContext, int n, int n2, int n3, int n4, double d) {
                    GL2 gL2 = drawContext.getGL().getGL2();
                    gL2.glTranslated((double)n, (double)n2, 0.0);
                    gL2.glScaled(d, d, 1.0);
                }

                protected void doDraw(DrawContext drawContext, int n, int n2, double d, Position position) {
                    if (drawContext.isPickingMode()) {
                        return;
                    }
                    TextRenderer textRenderer = this.getTextRenderer(drawContext, this.font);
                    String string = this.getText().split("\n")[0];
                    int n3 = (int)textRenderer.getBounds(string).getWidth();
                    Color color = this.modulateColorOpacity(this.getAttributes().getTextColor(), d);
                    Color color2 = this.modulateColorOpacity(this.getAttributes().getBackgroundColor(), d);
                    textRenderer.begin3DRendering();
                    textRenderer.setColor(color2);
                    textRenderer.draw(string, -n3 / 2 + 1, 11);
                    textRenderer.setColor(color);
                    textRenderer.draw(string, -n3 / 2, 12);
                    textRenderer.end3DRendering();
                    Color color3 = this.getAttributes().getBorderColor();
                    this.applyColor(drawContext, color3, d, false);
                    GL2 gL2 = drawContext.getGL().getGL2();
                    gL2.glDisable(2848);
                    gL2.glDisable(2852);
                    gL2.glLineWidth(1.0f);
                    gL2.glTranslated(-1.0, -1.0, 0.0);
                    FrameFactory.drawShape((DrawContext)drawContext, (String)"gov.nasa.worldwind.avkey.ShapeRectangle", (double)3.0, (double)3.0, (int)3, (int)0);
                }
            }
            globeAnnotation = new SimpleGlobeAnnotation("Mount Rainier\nAlt: 4392m", Position.fromDegrees((double)46.8534, (double)-121.7609, (double)0.0));
            this.layer.addAnnotation((Annotation)globeAnnotation);
            globeAnnotation = new SimpleGlobeAnnotation("Mount Adams\nAlt: 3742m", Position.fromDegrees((double)46.2018, (double)-121.4931, (double)0.0));
            this.layer.addAnnotation((Annotation)globeAnnotation);
            globeAnnotation = new SimpleGlobeAnnotation("Mount Saint Helens\nAlt: 4392m", Position.fromDegrees((double)46.1991, (double)-122.1882, (double)0.0));
            this.layer.addAnnotation((Annotation)globeAnnotation);
            globeAnnotation = new GlobeAnnotation("DRAG ME!", Position.fromDegrees((double)42.0, (double)-118.0, (double)0.0), Font.decode("Arial-BOLD-18")){

                public void doDraw(DrawContext drawContext, int n, int n2, double d, Position position) {
                    if (this.getPosition().getLatitude().degrees != 42.0 || this.getPosition().getLongitude().degrees != -118.0) {
                        this.setText(String.format("Lat %7.4f\u00b0\nLon %7.4f\u00b0", this.getPosition().getLatitude().degrees, this.getPosition().getLongitude().degrees));
                    }
                    super.doDraw(drawContext, n, n2, d, position);
                }
            };
            this.layer.addAnnotation((Annotation)globeAnnotation);
            globeAnnotation = new GlobeAnnotation("Annotation with extra frames drawn by a render delegate.", Position.fromDegrees((double)40.0, (double)-116.0, (double)0.0), Font.decode("Serif-BOLD-18"), Color.DARK_GRAY){

                public void doDraw(DrawContext drawContext, int n, int n2, double d, Position position) {
                    super.doDraw(drawContext, n, n2, d, position);
                    Rectangle rectangle = this.computeInsetBounds(n, n2);
                    Rectangle rectangle2 = this.computeFreeBounds(drawContext, n, n2);
                    this.applyColor(drawContext, Color.BLACK, 0.5 * d, true);
                    GL2 gL2 = drawContext.getGL().getGL2();
                    gL2.glTranslated((double)(rectangle.x - 3), (double)(rectangle.y - 3), 0.0);
                    FrameFactory.drawShape((DrawContext)drawContext, (String)"gov.nasa.worldwind.avkey.ShapeRectangle", (double)(rectangle.width + 6), (double)(rectangle.height + 6), (int)3, (int)4);
                    if (rectangle2.height > 0) {
                        gL2.glTranslated(3.0, 3.0, 0.0);
                        FrameFactory.drawShape((DrawContext)drawContext, (String)"gov.nasa.worldwind.avkey.ShapeEllipse", (double)rectangle2.width, (double)rectangle2.height, (int)6, (int)0);
                    }
                }
            };
            globeAnnotation.getAttributes().setTextAlign("gov.nasa.worldwind.avkey.Center");
            globeAnnotation.getAttributes().setBackgroundColor(new Color(1.0f, 1.0f, 1.0f, 0.7f));
            globeAnnotation.getAttributes().setBorderColor(Color.BLACK);
            globeAnnotation.getAttributes().setSize(new Dimension(160, 200));
            this.layer.addAnnotation((Annotation)globeAnnotation);
            ScreenAnnotation screenAnnotation = new ScreenAnnotation("Fixed position annotation", new Point(20, 50));
            screenAnnotation.getAttributes().setDefaults(annotationAttributes);
            screenAnnotation.getAttributes().setCornerRadius(0);
            screenAnnotation.getAttributes().setSize(new Dimension(200, 0));
            screenAnnotation.getAttributes().setAdjustWidthToText("gov.nasa.worldwind.avkey.SizeFixed");
            screenAnnotation.getAttributes().setDrawOffset(new Point(100, 0));
            screenAnnotation.getAttributes().setHighlightScale(1.0);
            this.layer.addAnnotation((Annotation)screenAnnotation);
            this.makeRelativeAnnotations(this.layer);
            ApplicationTemplate.insertBeforeCompass(this.getWwd(), (Layer)this.layer);
            this.getLayerPanel().update(this.getWwd());
        }

        public void makeRelativeAnnotations(AnnotationLayer annotationLayer) {
            AnnotationAttributes annotationAttributes = new AnnotationAttributes();
            annotationAttributes.setBackgroundColor(new Color(0.0f, 0.0f, 0.0f, 0.0f));
            annotationAttributes.setTextColor(Color.YELLOW);
            annotationAttributes.setLeaderGapWidth(14);
            annotationAttributes.setCornerRadius(0);
            annotationAttributes.setSize(new Dimension(300, 0));
            annotationAttributes.setAdjustWidthToText("gov.nasa.worldwind.avkey.SizeFitText");
            annotationAttributes.setFont(Font.decode("Arial-BOLD-24"));
            annotationAttributes.setBorderWidth(0.0);
            annotationAttributes.setHighlightScale(1.0);
            annotationAttributes.setCornerRadius(0);
            ScreenRelativeAnnotation screenRelativeAnnotation = new ScreenRelativeAnnotation("Lower Left", 0.1, 0.01);
            screenRelativeAnnotation.setKeepFullyVisible(true);
            screenRelativeAnnotation.setXMargin(5);
            screenRelativeAnnotation.setYMargin(5);
            screenRelativeAnnotation.getAttributes().setDefaults(annotationAttributes);
            ScreenRelativeAnnotation screenRelativeAnnotation2 = new ScreenRelativeAnnotation("Upper Left", 0.1, 0.99);
            screenRelativeAnnotation2.setKeepFullyVisible(true);
            screenRelativeAnnotation2.setXMargin(5);
            screenRelativeAnnotation2.setYMargin(5);
            screenRelativeAnnotation2.getAttributes().setDefaults(annotationAttributes);
            ScreenRelativeAnnotation screenRelativeAnnotation3 = new ScreenRelativeAnnotation("Upper Right", 0.99, 0.99);
            screenRelativeAnnotation3.setKeepFullyVisible(true);
            screenRelativeAnnotation3.setXMargin(5);
            screenRelativeAnnotation3.setYMargin(5);
            screenRelativeAnnotation3.getAttributes().setDefaults(annotationAttributes);
            ScreenRelativeAnnotation screenRelativeAnnotation4 = new ScreenRelativeAnnotation("Lower Right", 0.99, 0.01);
            screenRelativeAnnotation4.setKeepFullyVisible(true);
            screenRelativeAnnotation4.setXMargin(5);
            screenRelativeAnnotation4.setYMargin(5);
            screenRelativeAnnotation4.getAttributes().setDefaults(annotationAttributes);
            ScreenRelativeAnnotation screenRelativeAnnotation5 = new ScreenRelativeAnnotation("Center", 0.5, 0.5);
            screenRelativeAnnotation5.setKeepFullyVisible(true);
            screenRelativeAnnotation5.setXMargin(5);
            screenRelativeAnnotation5.setYMargin(5);
            screenRelativeAnnotation5.getAttributes().setDefaults(annotationAttributes);
            annotationLayer.addAnnotation((Annotation)screenRelativeAnnotation);
            annotationLayer.addAnnotation((Annotation)screenRelativeAnnotation2);
            annotationLayer.addAnnotation((Annotation)screenRelativeAnnotation3);
            annotationLayer.addAnnotation((Annotation)screenRelativeAnnotation4);
            annotationLayer.addAnnotation((Annotation)screenRelativeAnnotation5);
        }

        public GlobeAnnotation makeTopImageBottomTextAnnotation(PowerOfTwoPaddedImage powerOfTwoPaddedImage, String string, Position position) {
            GlobeAnnotation globeAnnotation = new GlobeAnnotation(string, position);
            int n = 10;
            globeAnnotation.getAttributes().setInsets(new Insets(powerOfTwoPaddedImage.getOriginalHeight() + n * 2, n, n, n));
            globeAnnotation.getAttributes().setImageSource((Object)powerOfTwoPaddedImage.getPowerOfTwoImage());
            globeAnnotation.getAttributes().setImageOffset(new Point(n, n));
            globeAnnotation.getAttributes().setImageRepeat("gov.nasa.worldwind.avkey.RepeatNone");
            globeAnnotation.getAttributes().setImageOpacity(1.0);
            globeAnnotation.getAttributes().setSize(new Dimension(powerOfTwoPaddedImage.getOriginalWidth() + n * 2, 0));
            globeAnnotation.getAttributes().setAdjustWidthToText("gov.nasa.worldwind.avkey.SizeFixed");
            globeAnnotation.getAttributes().setBackgroundColor(Color.WHITE);
            globeAnnotation.getAttributes().setTextColor(Color.BLACK);
            globeAnnotation.getAttributes().setBorderColor(Color.BLACK);
            return globeAnnotation;
        }

        private void setupSelection() {
            this.getWwd().addSelectListener(new SelectListener(){
                private BasicDragger dragger;
                {
                    this.dragger = new BasicDragger(AppFrame.this.getWwd());
                }

                public void selected(SelectEvent selectEvent) {
                    if (selectEvent.hasObjects() && selectEvent.getTopObject() instanceof Annotation) {
                        if (selectEvent.getTopPickedObject().getValue("gov.nasa.worldwind.avkey.URL") != null) {
                            ((Component)AppFrame.this.getWwd()).setCursor(Cursor.getPredefinedCursor(12));
                        } else {
                            ((Component)AppFrame.this.getWwd()).setCursor(Cursor.getDefaultCursor());
                        }
                    }
                    if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.LeftClick")) {
                        if (selectEvent.hasObjects()) {
                            if (selectEvent.getTopObject() instanceof Annotation) {
                                PickedObject pickedObject = selectEvent.getTopPickedObject();
                                if (pickedObject.getValue("gov.nasa.worldwind.avkey.Text") != null) {
                                    System.out.println("Text: \"" + pickedObject.getValue("gov.nasa.worldwind.avkey.Text") + "\" Hyperlink: " + pickedObject.getValue("gov.nasa.worldwind.avkey.URL"));
                                    if (pickedObject.getValue("gov.nasa.worldwind.avkey.URL") != null) {
                                        try {
                                            BrowserOpener.browse((URL)new URL((String)pickedObject.getValue("gov.nasa.worldwind.avkey.URL")));
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                    }
                                    if (AppFrame.this.currentAnnotation == selectEvent.getTopObject()) {
                                        return;
                                    }
                                }
                                if (AppFrame.this.currentAnnotation != null) {
                                    AppFrame.this.currentAnnotation.getAttributes().setBorderColor(AppFrame.this.savedBorderColor);
                                }
                                if (AppFrame.this.currentAnnotation != selectEvent.getTopObject()) {
                                    AppFrame.this.currentAnnotation = (Annotation)selectEvent.getTopObject();
                                    AppFrame.this.savedBorderColor = AppFrame.this.currentAnnotation.getAttributes().getBorderColor();
                                    AppFrame.this.savedImage = AppFrame.this.currentAnnotation.getAttributes().getImageSource() instanceof BufferedImage ? (BufferedImage)AppFrame.this.currentAnnotation.getAttributes().getImageSource() : null;
                                    AppFrame.this.currentAnnotation.getAttributes().setBorderColor(Color.YELLOW);
                                } else {
                                    AppFrame.this.currentAnnotation = null;
                                }
                                AppFrame.this.updateControlPanel();
                            } else {
                                System.out.println("Left click on " + selectEvent.getTopObject());
                            }
                        }
                    } else if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Rollover") && !this.dragger.isDragging()) {
                        AppFrame.this.highlight(selectEvent.getTopObject());
                    } else if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.DragEnd") || selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Drag")) {
                        PickedObjectList pickedObjectList;
                        if (selectEvent.hasObjects() && selectEvent.getTopObject() == AppFrame.this.currentAnnotation) {
                            this.dragger.selected(selectEvent);
                        }
                        if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.DragEnd") && (pickedObjectList = AppFrame.this.getWwd().getObjectsAtCurrentPosition()) != null) {
                            AppFrame.this.highlight(pickedObjectList.getTopObject());
                            AppFrame.this.getWwd().redraw();
                        }
                    }
                }
            });
        }

        private void highlight(Object object) {
            if (this.lastPickedObject == object) {
                return;
            }
            if (this.lastPickedObject != null) {
                this.lastPickedObject.getAttributes().setHighlighted(false);
                this.lastPickedObject = null;
            }
            if (object != null && object instanceof Annotation) {
                this.lastPickedObject = (Annotation)object;
                this.lastPickedObject.getAttributes().setHighlighted(true);
            }
        }

        private JPanel makeControlPanel() {
            this.inputTextArea = new JTextArea();
            this.inputTextArea.setFont(new Font("Sans_Serif", 0, 16));
            this.inputTextArea.setLineWrap(true);
            this.inputTextArea.setWrapStyleWord(true);
            JScrollPane jScrollPane = new JScrollPane(this.inputTextArea);
            jScrollPane.setVerticalScrollBarPolicy(22);
            jScrollPane.setPreferredSize(new Dimension(200, 100));
            jScrollPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            JPanel jPanel = new JPanel(new GridLayout(0, 1, 0, 0));
            jPanel.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), new TitledBorder("Width and Height")));
            this.widthSlider = new JSlider(0, 0, 800, 160);
            this.widthSlider.setMajorTickSpacing(100);
            this.widthSlider.setMinorTickSpacing(10);
            this.widthSlider.setPaintLabels(true);
            this.widthSlider.setToolTipText("Preferred annotation width");
            this.widthSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.updateAnnotation();
                    }
                }
            });
            jPanel.add(this.widthSlider);
            this.heightSlider = new JSlider(0, 0, 800, 0);
            this.heightSlider.setMajorTickSpacing(100);
            this.heightSlider.setMinorTickSpacing(10);
            this.heightSlider.setPaintLabels(true);
            this.heightSlider.setToolTipText("Preferred annotation height, zero = no limit");
            this.heightSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.updateAnnotation();
                    }
                }
            });
            jPanel.add(this.heightSlider);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 0));
            jPanel2.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            jPanel2.add(new JLabel("Corner radius:"));
            jPanel2.add(Box.createRigidArea(new Dimension(10, 0)));
            this.cornerRadiusSlider = new JSlider(0, 0, 50, 10);
            this.cornerRadiusSlider.setMajorTickSpacing(10);
            this.cornerRadiusSlider.setMinorTickSpacing(1);
            this.cornerRadiusSlider.setPaintLabels(true);
            this.cornerRadiusSlider.setToolTipText("Rounded corners radius");
            this.cornerRadiusSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.updateAnnotation();
                    }
                }
            });
            jPanel2.add(this.cornerRadiusSlider);
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new BoxLayout(jPanel3, 0));
            jPanel3.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            jPanel3.add(new JLabel("Insets:"));
            jPanel3.add(Box.createRigidArea(new Dimension(10, 0)));
            this.insetsTop = new JSpinner();
            this.insetsTop.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.updateAnnotation();
                    }
                }
            });
            this.insetsRight = new JSpinner();
            this.insetsRight.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.updateAnnotation();
                    }
                }
            });
            this.insetsBottom = new JSpinner();
            this.insetsBottom.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.updateAnnotation();
                    }
                }
            });
            this.insetsLeft = new JSpinner();
            this.insetsLeft.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.updateAnnotation();
                    }
                }
            });
            jPanel3.add(this.insetsTop);
            jPanel3.add(Box.createRigidArea(new Dimension(10, 0)));
            jPanel3.add(this.insetsRight);
            jPanel3.add(Box.createRigidArea(new Dimension(10, 0)));
            jPanel3.add(this.insetsBottom);
            jPanel3.add(Box.createRigidArea(new Dimension(10, 0)));
            jPanel3.add(this.insetsLeft);
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new BoxLayout(jPanel4, 0));
            jPanel4.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            jPanel4.add(new JLabel("Border width:"));
            jPanel4.add(Box.createRigidArea(new Dimension(10, 0)));
            this.borderWidthSlider = new JSlider(0, 0, 50, 10);
            this.borderWidthSlider.setMajorTickSpacing(10);
            this.borderWidthSlider.setMinorTickSpacing(1);
            this.borderWidthSlider.setPaintLabels(true);
            this.borderWidthSlider.setToolTipText("Border width 1/10th");
            this.borderWidthSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.updateAnnotation();
                    }
                }
            });
            jPanel4.add(this.borderWidthSlider);
            JPanel jPanel5 = new JPanel();
            jPanel5.setLayout(new BoxLayout(jPanel5, 0));
            jPanel5.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            jPanel5.add(new JLabel("Stipple factor:"));
            jPanel5.add(Box.createRigidArea(new Dimension(10, 0)));
            this.stippleFactorSlider = new JSlider(0, 0, 10, 0);
            this.stippleFactorSlider.setMajorTickSpacing(1);
            this.stippleFactorSlider.setPaintLabels(true);
            this.stippleFactorSlider.setToolTipText("Border line pattern repeat factor");
            this.stippleFactorSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.updateAnnotation();
                    }
                }
            });
            jPanel5.add(this.stippleFactorSlider);
            JPanel jPanel6 = new JPanel(new GridLayout(0, 1, 0, 0));
            jPanel6.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), new TitledBorder("Scale and Opacity")));
            this.scaleSlider = new JSlider(0, 0, 30, 10);
            this.scaleSlider.setMajorTickSpacing(10);
            this.scaleSlider.setMinorTickSpacing(1);
            this.scaleSlider.setPaintLabels(true);
            this.scaleSlider.setToolTipText("Annotation scaling");
            this.scaleSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.updateAnnotation();
                    }
                }
            });
            jPanel6.add(this.scaleSlider);
            this.opacitySlider = new JSlider(0, 0, 10, 10);
            this.opacitySlider.setMajorTickSpacing(1);
            this.opacitySlider.setPaintLabels(true);
            this.opacitySlider.setToolTipText("Annotation opacity");
            this.opacitySlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.updateAnnotation();
                    }
                }
            });
            jPanel6.add(this.opacitySlider);
            JPanel jPanel7 = new JPanel();
            jPanel7.setLayout(new BoxLayout(jPanel7, 0));
            jPanel7.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            jPanel7.add(new JLabel("Font"));
            jPanel7.add(Box.createRigidArea(new Dimension(10, 0)));
            this.cbFontName = new JComboBox<String>(new String[]{"Arial", "SansSerif", "Serif", "Courier", "Times", "Helvetica", "Trebuchet", "Tahoma"});
            this.cbFontName.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.updateAnnotation();
                    }
                }
            });
            jPanel7.add(this.cbFontName);
            jPanel7.add(Box.createRigidArea(new Dimension(10, 0)));
            this.cbFontStyle = new JComboBox<String>(new String[]{"Plain", "Bold", "Italic", "BoldItalic"});
            this.cbFontStyle.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.updateAnnotation();
                    }
                }
            });
            jPanel7.add(this.cbFontStyle);
            jPanel7.add(Box.createRigidArea(new Dimension(10, 0)));
            this.cbFontSize = new JComboBox<String>(new String[]{"10", "12", "14", "16", "18", "20", "24", "28", "34", "48", "64"});
            this.cbFontSize.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.updateAnnotation();
                    }
                }
            });
            jPanel7.add(this.cbFontSize);
            JPanel jPanel8 = new JPanel(new GridLayout(0, 3, 5, 5));
            jPanel8.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            jPanel8.add(new JLabel("Align & Effect:"));
            this.cbTextAlign = new JComboBox<String>(new String[]{"Left", "Center", "Right"});
            this.cbTextAlign.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.updateAnnotation();
                    }
                }
            });
            jPanel8.add(this.cbTextAlign);
            this.cbTextEffect = new JComboBox<String>(new String[]{"None", "Shadow", "Outline"});
            this.cbTextEffect.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.updateAnnotation();
                    }
                }
            });
            jPanel8.add(this.cbTextEffect);
            JPanel jPanel9 = new JPanel(new GridLayout(0, 1, 5, 5));
            jPanel9.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            this.cbAdjustWidth = new JCheckBox("Adjust width to text");
            this.cbAdjustWidth.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.updateAnnotation();
                    }
                }
            });
            this.cbAdjustWidth.setSelected(true);
            jPanel9.add(this.cbAdjustWidth);
            JPanel jPanel10 = new JPanel(new GridLayout(0, 2, 5, 5));
            jPanel10.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            jPanel10.add(new JLabel("Shape:"));
            this.cbShape = new JComboBox<String>(new String[]{"Rectangle", "Ellipse", "None"});
            this.cbShape.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.updateAnnotation();
                    }
                }
            });
            jPanel10.add(this.cbShape);
            jPanel10.add(new JLabel("Leader Shape:"));
            this.cbLeader = new JComboBox<String>(new String[]{"Triangle", "None"});
            this.cbLeader.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.updateAnnotation();
                    }
                }
            });
            jPanel10.add(this.cbLeader);
            jPanel10.add(new JLabel("Leader Gap Width:"));
            this.leaderGapWidthSlider = new JSlider(0, 0, 50, 40);
            this.leaderGapWidthSlider.setMajorTickSpacing(10);
            this.leaderGapWidthSlider.setMinorTickSpacing(1);
            this.leaderGapWidthSlider.setPaintLabels(true);
            this.leaderGapWidthSlider.setToolTipText("Leader gap width");
            this.leaderGapWidthSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.updateAnnotation();
                    }
                }
            });
            jPanel10.add(this.leaderGapWidthSlider);
            JPanel jPanel11 = new JPanel(new GridLayout(0, 2, 5, 5));
            jPanel11.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            jPanel11.add(new JLabel("Image:"));
            this.cbImage = new JComboBox<String>(new String[]{"None", "Earth", "NASA", "WWJ Splash", "Custom"});
            this.cbImage.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.updateAnnotation();
                    }
                }
            });
            jPanel11.add(this.cbImage);
            jPanel11.add(new JLabel("Repeat:"));
            this.cbImageRepeat = new JComboBox<String>(new String[]{"None", "Repeat-X", "Repeat-Y", "Repeat-XY"});
            this.cbImageRepeat.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.updateAnnotation();
                    }
                }
            });
            jPanel11.add(this.cbImageRepeat);
            JPanel jPanel12 = new JPanel(new GridLayout(0, 1, 0, 0));
            jPanel12.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), new TitledBorder("Scale and Opacity")));
            this.imageScaleSlider = new JSlider(0, 0, 30, 10);
            this.imageScaleSlider.setMajorTickSpacing(10);
            this.imageScaleSlider.setMinorTickSpacing(1);
            this.imageScaleSlider.setPaintLabels(true);
            this.imageScaleSlider.setToolTipText("Background image scaling");
            this.imageScaleSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.updateAnnotation();
                    }
                }
            });
            jPanel12.add(this.imageScaleSlider);
            this.imageOpacitySlider = new JSlider(0, 0, 10, 10);
            this.imageOpacitySlider.setMajorTickSpacing(1);
            this.imageOpacitySlider.setPaintLabels(true);
            this.imageOpacitySlider.setToolTipText("Background image opacity");
            this.imageOpacitySlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.updateAnnotation();
                    }
                }
            });
            jPanel12.add(this.imageOpacitySlider);
            JPanel jPanel13 = new JPanel(new GridLayout(0, 1, 0, 0));
            jPanel13.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), new TitledBorder("Offset")));
            this.imageOffsetXSlider = new JSlider(0, -200, 200, 0);
            this.imageOffsetXSlider.setMajorTickSpacing(100);
            this.imageOffsetXSlider.setMinorTickSpacing(1);
            this.imageOffsetXSlider.setPaintLabels(true);
            this.imageOffsetXSlider.setToolTipText("Background image horizontal offset (X)");
            this.imageOffsetXSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.updateAnnotation();
                    }
                }
            });
            jPanel13.add(this.imageOffsetXSlider);
            this.imageOffsetYSlider = new JSlider(0, -200, 200, 0);
            this.imageOffsetYSlider.setMajorTickSpacing(100);
            this.imageOffsetXSlider.setMinorTickSpacing(1);
            this.imageOffsetYSlider.setPaintLabels(true);
            this.imageOffsetYSlider.setToolTipText("Background image vertical offset (Y)");
            this.imageOffsetYSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.updateAnnotation();
                    }
                }
            });
            jPanel13.add(this.imageOffsetYSlider);
            JPanel jPanel14 = new JPanel(new GridLayout(0, 1, 0, 0));
            jPanel14.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), new TitledBorder("Draw offset")));
            this.offsetXSlider = new JSlider(0, -200, 200, 0);
            this.offsetXSlider.setMajorTickSpacing(100);
            this.offsetXSlider.setMinorTickSpacing(1);
            this.offsetXSlider.setPaintLabels(true);
            this.offsetXSlider.setToolTipText("Annotation horizontal offset (X)");
            this.offsetXSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.updateAnnotation();
                    }
                }
            });
            jPanel14.add(this.offsetXSlider);
            this.offsetYSlider = new JSlider(0, 0, 200, 0);
            this.offsetYSlider.setMajorTickSpacing(100);
            this.offsetYSlider.setMinorTickSpacing(1);
            this.offsetYSlider.setPaintLabels(true);
            this.offsetYSlider.setToolTipText("Annotation vertical offset (Y)");
            this.offsetYSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.updateAnnotation();
                    }
                }
            });
            jPanel14.add(this.offsetYSlider);
            JPanel jPanel15 = new JPanel(new GridLayout(0, 1, 0, 0));
            jPanel15.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), new TitledBorder("Distance min/max scale and opacity")));
            this.distanceMinScaleSlider = new JSlider(0, 0, 30, 10);
            this.distanceMinScaleSlider.setMajorTickSpacing(10);
            this.distanceMinScaleSlider.setMinorTickSpacing(1);
            this.distanceMinScaleSlider.setPaintLabels(true);
            this.distanceMinScaleSlider.setToolTipText("Minimum scale 1/10th");
            this.distanceMinScaleSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.updateAnnotation();
                    }
                }
            });
            jPanel15.add(this.distanceMinScaleSlider);
            this.distanceMaxScaleSlider = new JSlider(0, 0, 30, 10);
            this.distanceMaxScaleSlider.setMajorTickSpacing(10);
            this.distanceMaxScaleSlider.setMinorTickSpacing(1);
            this.distanceMaxScaleSlider.setPaintLabels(true);
            this.distanceMaxScaleSlider.setToolTipText("Maximum scale 1/10th");
            this.distanceMaxScaleSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.updateAnnotation();
                    }
                }
            });
            jPanel15.add(this.distanceMaxScaleSlider);
            this.distanceMinOpacitySlider = new JSlider(0, 0, 10, 10);
            this.distanceMinOpacitySlider.setMajorTickSpacing(1);
            this.distanceMinOpacitySlider.setPaintLabels(true);
            this.distanceMinOpacitySlider.setToolTipText("Minimum opacity");
            this.distanceMinOpacitySlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.updateAnnotation();
                    }
                }
            });
            jPanel15.add(this.distanceMinOpacitySlider);
            JPanel jPanel16 = new JPanel(new GridLayout(0, 1, 0, 0));
            jPanel16.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), new TitledBorder("Highlight scale")));
            this.highlightScaleSlider = new JSlider(0, 0, 30, 10);
            this.highlightScaleSlider.setMajorTickSpacing(10);
            this.highlightScaleSlider.setMinorTickSpacing(1);
            this.highlightScaleSlider.setPaintLabels(true);
            this.highlightScaleSlider.setToolTipText("Highlight scale 1/10th");
            this.highlightScaleSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.updateAnnotation();
                    }
                }
            });
            jPanel16.add(this.highlightScaleSlider);
            final JPanel jPanel17 = new JPanel(new GridLayout(0, 3, 5, 5));
            jPanel17.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            jPanel17.add(new JLabel("Text color:"));
            this.btTextColor = new JButton("");
            this.btTextColor.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Color color = JColorChooser.showDialog(jPanel17, "Choose a color...", ((JButton)actionEvent.getSource()).getBackground());
                    if (color != null) {
                        ((JButton)actionEvent.getSource()).setBackground(color);
                        if (AppFrame.this.currentAnnotation != null) {
                            AppFrame.this.updateAnnotation();
                        }
                    }
                }
            });
            jPanel17.add(this.btTextColor);
            this.cbTextColorAlpha = new JComboBox<String>(new String[]{"10", "9", "8", "7", "6", "5", "4", "3", "2", "1", "0"});
            this.cbTextColorAlpha.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.updateAnnotation();
                    }
                }
            });
            jPanel17.add(this.cbTextColorAlpha);
            jPanel17.add(new JLabel("Back color:"));
            this.btBackColor = new JButton("");
            this.btBackColor.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Color color = JColorChooser.showDialog(jPanel17, "Choose a color...", ((JButton)actionEvent.getSource()).getBackground());
                    if (color != null) {
                        ((JButton)actionEvent.getSource()).setBackground(color);
                        if (AppFrame.this.currentAnnotation != null) {
                            AppFrame.this.updateAnnotation();
                        }
                    }
                }
            });
            jPanel17.add(this.btBackColor);
            this.cbBackColorAlpha = new JComboBox<String>(new String[]{"10", "9", "8", "7", "6", "5", "4", "3", "2", "1", "0"});
            this.cbBackColorAlpha.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.updateAnnotation();
                    }
                }
            });
            jPanel17.add(this.cbBackColorAlpha);
            jPanel17.add(new JLabel("Border color:"));
            this.btBorderColor = new JButton("");
            this.btBorderColor.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Color color = JColorChooser.showDialog(jPanel17, "Choose a color...", ((JButton)actionEvent.getSource()).getBackground());
                    if (color != null) {
                        ((JButton)actionEvent.getSource()).setBackground(color);
                        if (AppFrame.this.currentAnnotation != null) {
                            AppFrame.this.updateAnnotation();
                        }
                    }
                }
            });
            jPanel17.add(this.btBorderColor);
            this.cbBorderColorAlpha = new JComboBox<String>(new String[]{"10", "9", "8", "7", "6", "5", "4", "3", "2", "1", "0"});
            this.cbBorderColorAlpha.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.updateAnnotation();
                    }
                }
            });
            jPanel17.add(this.cbBorderColorAlpha);
            JPanel jPanel18 = new JPanel();
            jPanel18.setLayout(new BoxLayout(jPanel18, 0));
            jPanel18.setBorder(BorderFactory.createEmptyBorder(14, 4, 4, 4));
            this.btApply = new JButton("Apply");
            this.btApply.setEnabled(false);
            this.btApply.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.updateAnnotation();
                    }
                }
            });
            JButton jButton = new JButton("Add new");
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Position position = AppFrame.this.computeGroundPosition(AppFrame.this.getWwd());
                    if (position != null && AppFrame.this.inputTextArea.getText().length() > 0) {
                        Annotation annotation = AppFrame.this.currentAnnotation;
                        AppFrame.this.currentAnnotation = (Annotation)new GlobeAnnotation(AppFrame.this.inputTextArea.getText(), position);
                        AppFrame.this.updateAnnotation();
                        AppFrame.this.layer.addAnnotation(AppFrame.this.currentAnnotation);
                        AppFrame.this.currentAnnotation = annotation;
                        AppFrame.this.getWwd().redraw();
                    }
                }
            });
            this.btRemove = new JButton("Remove");
            this.btRemove.setEnabled(false);
            this.btRemove.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.layer.removeAnnotation(AppFrame.this.currentAnnotation);
                        AppFrame.this.currentAnnotation = null;
                        AppFrame.this.inputTextArea.setText("");
                        AppFrame.this.widthSlider.setEnabled(false);
                        AppFrame.this.btApply.setEnabled(false);
                        AppFrame.this.btRemove.setEnabled(false);
                        AppFrame.this.getWwd().redraw();
                    }
                }
            });
            jPanel18.add(jButton);
            jPanel18.add(Box.createRigidArea(new Dimension(10, 0)));
            jPanel18.add(this.btApply);
            jPanel18.add(Box.createRigidArea(new Dimension(10, 0)));
            jPanel18.add(this.btRemove);
            JTabbedPane jTabbedPane = new JTabbedPane();
            JPanel jPanel19 = new JPanel();
            jPanel19.setLayout(new BoxLayout(jPanel19, 1));
            jPanel19.setBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9));
            jPanel19.setToolTipText("Text and Colors");
            jPanel19.add(jScrollPane);
            jPanel19.add(jPanel7);
            jPanel19.add(jPanel8);
            jPanel19.add(jPanel17);
            jTabbedPane.add(jPanel19);
            jTabbedPane.setTitleAt(0, "Text");
            jPanel19 = new JPanel();
            jPanel19.setLayout(new BoxLayout(jPanel19, 1));
            jPanel19.setBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9));
            jPanel19.setToolTipText("Size, scale and opacity");
            jPanel19.add(jPanel9);
            jPanel19.add(jPanel);
            jPanel19.add(jPanel6);
            jTabbedPane.add(jPanel19);
            jTabbedPane.setTitleAt(1, "Size");
            jPanel19 = new JPanel();
            jPanel19.setLayout(new BoxLayout(jPanel19, 1));
            jPanel19.setBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9));
            jPanel19.setToolTipText("Shape, insets, corner radius, border width and patterns");
            jPanel19.add(jPanel10);
            jPanel19.add(jPanel2);
            jPanel19.add(jPanel3);
            jPanel19.add(jPanel4);
            jPanel19.add(jPanel5);
            jTabbedPane.add(jPanel19);
            jTabbedPane.setTitleAt(2, "Shape");
            jPanel19 = new JPanel();
            jPanel19.setLayout(new BoxLayout(jPanel19, 1));
            jPanel19.setBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9));
            jPanel19.setToolTipText("Background image texture controls");
            jPanel19.add(jPanel11);
            jPanel19.add(jPanel12);
            jPanel19.add(jPanel13);
            jTabbedPane.add(jPanel19);
            jTabbedPane.setTitleAt(3, "Image");
            jPanel19 = new JPanel();
            jPanel19.setLayout(new BoxLayout(jPanel19, 1));
            jPanel19.setBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9));
            jPanel19.setToolTipText("Offset, distance scaling and fading, highlight");
            jPanel19.add(jPanel14);
            jPanel19.add(jPanel15);
            jPanel19.add(jPanel16);
            jTabbedPane.add(jPanel19);
            jTabbedPane.setTitleAt(4, "Misc.");
            jPanel19 = new JPanel();
            jPanel19.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9), new TitledBorder("Annotation")));
            jPanel19.setToolTipText("Current or new annotation");
            jPanel19.setLayout(new BorderLayout());
            jPanel19.add((Component)jTabbedPane, "North");
            jPanel19.add((Component)jPanel18, "South");
            return jPanel19;
        }

        private void updateControlPanel() {
            if (this.currentAnnotation != null) {
                Object object;
                this.suspendUpdate = true;
                this.inputTextArea.setText(this.currentAnnotation.getText());
                this.widthSlider.setValue(this.currentAnnotation.getAttributes().getSize().width);
                this.heightSlider.setValue(this.currentAnnotation.getAttributes().getSize().height);
                this.scaleSlider.setValue((int)(this.currentAnnotation.getAttributes().getScale() * 10.0));
                this.opacitySlider.setValue((int)(this.currentAnnotation.getAttributes().getOpacity() * 10.0));
                this.cbAdjustWidth.setSelected(this.currentAnnotation.getAttributes().getAdjustWidthToText().equals("gov.nasa.worldwind.avkey.SizeFitText"));
                Font font = this.currentAnnotation.getAttributes().getFont();
                if (font != null) {
                    this.cbFontName.setSelectedItem(font.getName());
                    this.cbFontStyle.setSelectedIndex(font.getStyle());
                    this.cbFontSize.setSelectedItem(String.valueOf(font.getSize()));
                } else {
                    this.cbFontName.setSelectedItem("Arial");
                    this.cbFontStyle.setSelectedItem("Plain");
                    this.cbFontSize.setSelectedItem("12");
                }
                Color color = this.currentAnnotation.getAttributes().getTextColor();
                String string = color != null ? String.valueOf(Math.round((float)color.getAlpha() / 25.5f)) : "8";
                this.btTextColor.setBackground(color != null ? new Color(color.getRed(), color.getGreen(), color.getBlue()) : Color.WHITE);
                this.cbTextColorAlpha.setSelectedItem(string);
                color = this.currentAnnotation.getAttributes().getBackgroundColor();
                string = color != null ? String.valueOf(Math.round((float)color.getAlpha() / 25.5f)) : "4";
                this.btBackColor.setBackground(color != null ? new Color(color.getRed(), color.getGreen(), color.getBlue()) : Color.BLACK);
                this.cbBackColorAlpha.setSelectedItem(string);
                color = this.savedBorderColor;
                string = color != null ? String.valueOf(Math.round((float)color.getAlpha() / 25.5f)) : "7";
                this.btBorderColor.setBackground(color != null ? new Color(color.getRed(), color.getGreen(), color.getBlue()) : Color.WHITE);
                this.cbBorderColorAlpha.setSelectedItem(string);
                if (this.currentAnnotation.getAttributes().getTextAlign().equals("gov.nasa.worldwind.avkey.Left")) {
                    this.cbTextAlign.setSelectedIndex(0);
                } else if (this.currentAnnotation.getAttributes().getTextAlign().equals("gov.nasa.worldwind.avkey.Center")) {
                    this.cbTextAlign.setSelectedIndex(1);
                } else if (this.currentAnnotation.getAttributes().getTextAlign().equals("gov.nasa.worldwind.avkey.Right")) {
                    this.cbTextAlign.setSelectedIndex(2);
                }
                if (this.currentAnnotation.getAttributes().getEffect().equals("gov.nasa.worldwind.avkey.TextEffectNone")) {
                    this.cbTextEffect.setSelectedIndex(0);
                } else if (this.currentAnnotation.getAttributes().getEffect().equals("gov.nasa.worldwind.avkey.TextEffectShadow")) {
                    this.cbTextEffect.setSelectedIndex(1);
                } else if (this.currentAnnotation.getAttributes().getEffect().equals("gov.nasa.worldwind.avkey.TextEffectOutline")) {
                    this.cbTextEffect.setSelectedIndex(2);
                }
                if (this.currentAnnotation.getAttributes().getFrameShape().equals("gov.nasa.worldwind.avkey.ShapeRectangle")) {
                    this.cbShape.setSelectedIndex(0);
                } else if (this.currentAnnotation.getAttributes().getFrameShape().equals("gov.nasa.worldwind.avkey.ShapeEllipse")) {
                    this.cbShape.setSelectedIndex(1);
                } else {
                    this.cbShape.setSelectedIndex(2);
                }
                if (this.currentAnnotation.getAttributes().getLeader().equals("gov.nasa.worldwind.avkey.ShapeTriangle")) {
                    this.cbLeader.setSelectedIndex(0);
                } else {
                    this.cbLeader.setSelectedIndex(1);
                }
                this.leaderGapWidthSlider.setValue(this.currentAnnotation.getAttributes().getLeaderGapWidth());
                this.cornerRadiusSlider.setValue(this.currentAnnotation.getAttributes().getCornerRadius());
                Insets insets = this.currentAnnotation.getAttributes().getInsets();
                this.insetsTop.setValue(insets.top);
                this.insetsRight.setValue(insets.right);
                this.insetsBottom.setValue(insets.bottom);
                this.insetsLeft.setValue(insets.left);
                this.borderWidthSlider.setValue((int)(this.currentAnnotation.getAttributes().getBorderWidth() * 10.0));
                this.stippleFactorSlider.setValue(this.currentAnnotation.getAttributes().getBorderStippleFactor());
                if (this.currentAnnotation.getAttributes().getImageSource() != null) {
                    object = this.currentAnnotation.getAttributes().getImageSource();
                    if (object.equals(IMAGE_EARTH.getPowerOfTwoImage())) {
                        this.cbImage.setSelectedIndex(1);
                    } else if (object.equals(IMAGE_NASA.getPowerOfTwoImage())) {
                        this.cbImage.setSelectedIndex(2);
                    } else if (object.equals(IMAGE_WWJ_SPLASH.getPowerOfTwoImage())) {
                        this.cbImage.setSelectedIndex(3);
                    } else {
                        this.cbImage.setSelectedIndex(4);
                    }
                } else {
                    this.cbImage.setSelectedIndex(0);
                }
                object = this.currentAnnotation.getAttributes().getImageRepeat();
                if (((String)object).equals("gov.nasa.worldwind.avkey.RepeatNone")) {
                    this.cbImageRepeat.setSelectedIndex(0);
                } else if (((String)object).equals("gov.nasa.worldwind.avkey.RepeatX")) {
                    this.cbImageRepeat.setSelectedIndex(1);
                } else if (((String)object).equals("gov.nasa.worldwind.avkey.RepeatY")) {
                    this.cbImageRepeat.setSelectedIndex(2);
                } else if (((String)object).equals("gov.nasa.worldwind.avkey.RepeatXY")) {
                    this.cbImageRepeat.setSelectedIndex(3);
                }
                this.imageScaleSlider.setValue((int)(this.currentAnnotation.getAttributes().getImageScale() * 10.0));
                this.imageOpacitySlider.setValue((int)(this.currentAnnotation.getAttributes().getImageOpacity() * 10.0));
                this.imageOffsetXSlider.setValue(this.currentAnnotation.getAttributes().getImageOffset().x);
                this.imageOffsetYSlider.setValue(this.currentAnnotation.getAttributes().getImageOffset().y);
                this.offsetXSlider.setValue(this.currentAnnotation.getAttributes().getDrawOffset().x);
                this.offsetYSlider.setValue(this.currentAnnotation.getAttributes().getDrawOffset().y);
                this.distanceMinScaleSlider.setValue((int)(this.currentAnnotation.getAttributes().getDistanceMinScale() * 10.0));
                this.distanceMaxScaleSlider.setValue((int)(this.currentAnnotation.getAttributes().getDistanceMaxScale() * 10.0));
                this.distanceMinOpacitySlider.setValue((int)(this.currentAnnotation.getAttributes().getDistanceMinOpacity() * 10.0));
                this.highlightScaleSlider.setValue((int)(this.currentAnnotation.getAttributes().getHighlightScale() * 10.0));
                this.btApply.setEnabled(true);
                this.btRemove.setEnabled(true);
                this.suspendUpdate = false;
                this.enableControlPanel(true);
            } else {
                this.enableControlPanel(false);
                this.inputTextArea.setText("Annotation text...");
                this.btApply.setEnabled(false);
                this.btRemove.setEnabled(false);
            }
        }

        private void enableControlPanel(boolean bl) {
            this.inputTextArea.setEnabled(bl);
            this.widthSlider.setEnabled(bl);
            this.heightSlider.setEnabled(bl);
            this.scaleSlider.setEnabled(bl);
            this.opacitySlider.setEnabled(bl);
            this.cbAdjustWidth.setEnabled(bl);
            this.cbFontName.setEnabled(bl);
            this.cbFontStyle.setEnabled(bl);
            this.cbFontSize.setEnabled(bl);
            this.btTextColor.setEnabled(bl);
            this.cbTextColorAlpha.setEnabled(bl);
            this.btBackColor.setEnabled(bl);
            this.cbBackColorAlpha.setEnabled(bl);
            this.btBorderColor.setEnabled(bl);
            this.cbBorderColorAlpha.setEnabled(bl);
            this.cbTextAlign.setEnabled(bl);
            this.cbTextEffect.setEnabled(bl);
            this.cbShape.setEnabled(bl);
            this.cbLeader.setEnabled(bl);
            this.leaderGapWidthSlider.setEnabled(bl);
            this.cornerRadiusSlider.setEnabled(bl);
            this.insetsTop.setEnabled(bl);
            this.insetsRight.setEnabled(bl);
            this.insetsBottom.setEnabled(bl);
            this.insetsLeft.setEnabled(bl);
            this.borderWidthSlider.setEnabled(bl);
            this.stippleFactorSlider.setEnabled(bl);
            this.cbImage.setEnabled(bl);
            this.cbImageRepeat.setEnabled(bl);
            this.imageScaleSlider.setEnabled(bl);
            this.imageOpacitySlider.setEnabled(bl);
            this.imageOffsetXSlider.setEnabled(bl);
            this.imageOffsetYSlider.setEnabled(bl);
            this.offsetXSlider.setEnabled(bl);
            this.offsetYSlider.setEnabled(bl);
            this.distanceMinScaleSlider.setEnabled(bl);
            this.distanceMaxScaleSlider.setEnabled(bl);
            this.distanceMinOpacitySlider.setEnabled(bl);
            this.highlightScaleSlider.setEnabled(bl);
        }

        private void updateAnnotation() {
            if (this.currentAnnotation != null && !this.suspendUpdate) {
                this.currentAnnotation.setText(this.inputTextArea.getText());
                this.currentAnnotation.getAttributes().setSize(new Dimension(this.widthSlider.getValue(), this.heightSlider.getValue()));
                this.currentAnnotation.getAttributes().setScale((double)this.scaleSlider.getValue() / 10.0);
                this.currentAnnotation.getAttributes().setOpacity((double)this.opacitySlider.getValue() / 10.0);
                this.currentAnnotation.getAttributes().setAdjustWidthToText(this.cbAdjustWidth.isSelected() ? "gov.nasa.worldwind.avkey.SizeFitText" : "gov.nasa.worldwind.avkey.SizeFixed");
                String string = this.cbFontName.getSelectedItem() + "-" + this.cbFontStyle.getSelectedItem().toString().toUpperCase() + "-" + this.cbFontSize.getSelectedItem();
                this.currentAnnotation.getAttributes().setFont(Font.decode(string));
                Color color = this.btTextColor.getBackground();
                int n = (int)(Float.valueOf((String)this.cbTextColorAlpha.getSelectedItem()).floatValue() * 25.5f);
                this.currentAnnotation.getAttributes().setTextColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), n));
                color = this.btBackColor.getBackground();
                n = (int)(Float.valueOf((String)this.cbBackColorAlpha.getSelectedItem()).floatValue() * 25.5f);
                this.currentAnnotation.getAttributes().setBackgroundColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), n));
                color = this.btBorderColor.getBackground();
                n = (int)(Float.valueOf((String)this.cbBorderColorAlpha.getSelectedItem()).floatValue() * 25.5f);
                this.currentAnnotation.getAttributes().setBorderColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), n));
                this.savedBorderColor = this.currentAnnotation.getAttributes().getBorderColor();
                switch (this.cbTextAlign.getSelectedIndex()) {
                    case 0: {
                        this.currentAnnotation.getAttributes().setTextAlign("gov.nasa.worldwind.avkey.Left");
                        break;
                    }
                    case 1: {
                        this.currentAnnotation.getAttributes().setTextAlign("gov.nasa.worldwind.avkey.Center");
                        break;
                    }
                    case 2: {
                        this.currentAnnotation.getAttributes().setTextAlign("gov.nasa.worldwind.avkey.Right");
                    }
                }
                switch (this.cbTextEffect.getSelectedIndex()) {
                    case 0: {
                        this.currentAnnotation.getAttributes().setEffect("gov.nasa.worldwind.avkey.TextEffectNone");
                        break;
                    }
                    case 1: {
                        this.currentAnnotation.getAttributes().setEffect("gov.nasa.worldwind.avkey.TextEffectShadow");
                        break;
                    }
                    case 2: {
                        this.currentAnnotation.getAttributes().setEffect("gov.nasa.worldwind.avkey.TextEffectOutline");
                    }
                }
                switch (this.cbShape.getSelectedIndex()) {
                    case 0: {
                        this.currentAnnotation.getAttributes().setFrameShape("gov.nasa.worldwind.avkey.ShapeRectangle");
                        break;
                    }
                    case 1: {
                        this.currentAnnotation.getAttributes().setFrameShape("gov.nasa.worldwind.avkey.ShapeEllipse");
                        break;
                    }
                    case 2: {
                        this.currentAnnotation.getAttributes().setFrameShape("gov.nasa.worldwind.avkey.ShapeNone");
                    }
                }
                switch (this.cbLeader.getSelectedIndex()) {
                    case 0: {
                        this.currentAnnotation.getAttributes().setLeader("gov.nasa.worldwind.avkey.ShapeTriangle");
                        break;
                    }
                    case 1: {
                        this.currentAnnotation.getAttributes().setLeader("gov.nasa.worldwind.avkey.ShapeNone");
                    }
                }
                this.currentAnnotation.getAttributes().setLeaderGapWidth(this.leaderGapWidthSlider.getValue());
                this.currentAnnotation.getAttributes().setCornerRadius(this.cornerRadiusSlider.getValue());
                this.currentAnnotation.getAttributes().setInsets(new Insets(Integer.parseInt(this.insetsTop.getValue().toString()), Integer.parseInt(this.insetsLeft.getValue().toString()), Integer.parseInt(this.insetsBottom.getValue().toString()), Integer.parseInt(this.insetsRight.getValue().toString())));
                this.currentAnnotation.getAttributes().setBorderWidth((double)this.borderWidthSlider.getValue() / 10.0);
                this.currentAnnotation.getAttributes().setBorderStippleFactor(this.stippleFactorSlider.getValue());
                switch (this.cbImage.getSelectedIndex()) {
                    case 0: {
                        this.currentAnnotation.getAttributes().setImageSource(null);
                        break;
                    }
                    case 1: {
                        this.currentAnnotation.getAttributes().setImageSource((Object)IMAGE_EARTH.getPowerOfTwoImage());
                        break;
                    }
                    case 2: {
                        this.currentAnnotation.getAttributes().setImageSource((Object)IMAGE_NASA.getPowerOfTwoImage());
                        break;
                    }
                    case 3: {
                        this.currentAnnotation.getAttributes().setImageSource((Object)IMAGE_WWJ_SPLASH.getPowerOfTwoImage());
                        break;
                    }
                    case 4: {
                        this.currentAnnotation.getAttributes().setImageSource((Object)this.savedImage);
                    }
                }
                switch (this.cbImageRepeat.getSelectedIndex()) {
                    case 0: {
                        this.currentAnnotation.getAttributes().setImageRepeat("gov.nasa.worldwind.avkey.RepeatNone");
                        break;
                    }
                    case 1: {
                        this.currentAnnotation.getAttributes().setImageRepeat("gov.nasa.worldwind.avkey.RepeatX");
                        break;
                    }
                    case 2: {
                        this.currentAnnotation.getAttributes().setImageRepeat("gov.nasa.worldwind.avkey.RepeatY");
                        break;
                    }
                    case 3: {
                        this.currentAnnotation.getAttributes().setImageRepeat("gov.nasa.worldwind.avkey.RepeatXY");
                    }
                }
                this.currentAnnotation.getAttributes().setImageScale((double)this.imageScaleSlider.getValue() / 10.0);
                this.currentAnnotation.getAttributes().setImageOpacity((double)this.imageOpacitySlider.getValue() / 10.0);
                this.currentAnnotation.getAttributes().setImageOffset(new Point(this.imageOffsetXSlider.getValue(), this.imageOffsetYSlider.getValue()));
                this.currentAnnotation.getAttributes().setDrawOffset(new Point(this.offsetXSlider.getValue(), this.offsetYSlider.getValue()));
                this.currentAnnotation.getAttributes().setDistanceMinScale((double)this.distanceMinScaleSlider.getValue() / 10.0);
                this.currentAnnotation.getAttributes().setDistanceMaxScale((double)this.distanceMaxScaleSlider.getValue() / 10.0);
                this.currentAnnotation.getAttributes().setDistanceMinOpacity((double)this.distanceMinOpacitySlider.getValue() / 10.0);
                this.currentAnnotation.getAttributes().setHighlightScale((double)this.highlightScaleSlider.getValue() / 10.0);
                this.getWwd().redraw();
            }
        }

        private Position computeGroundPosition(WorldWindow worldWindow) {
            View view = worldWindow.getView();
            if (view == null) {
                return null;
            }
            return view.computePositionFromScreenPoint(view.getViewport().getWidth() / 2.0, view.getViewport().getHeight() / 2.0);
        }

        private class AMSLGlobeAnnotation
        extends GlobeAnnotation {
            public AMSLGlobeAnnotation(String string, Position position) {
                super(string, position);
            }

            public Vec4 getAnnotationDrawPoint(DrawContext drawContext) {
                return drawContext.getGlobe().computePointFromPosition(this.getPosition().getLatitude(), this.getPosition().getLongitude(), this.getPosition().getElevation() * drawContext.getVerticalExaggeration());
            }
        }
    }
}

