/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.Model;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.awt.WorldWindowGLCanvas;
import gov.nasa.worldwind.event.RenderingExceptionListener;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.exception.WWAbsentRequirementException;
import gov.nasa.worldwind.layers.CompassLayer;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.LayerList;
import gov.nasa.worldwind.layers.ViewControlsLayer;
import gov.nasa.worldwind.layers.ViewControlsSelectListener;
import gov.nasa.worldwind.layers.WorldMapLayer;
import gov.nasa.worldwind.layers.placename.PlaceNameLayer;
import gov.nasa.worldwind.util.StatisticsPanel;
import gov.nasa.worldwind.util.StatusBar;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwindx.examples.ClickAndGoSelectListener;
import gov.nasa.worldwindx.examples.LayerPanel;
import gov.nasa.worldwindx.examples.util.HighlightController;
import gov.nasa.worldwindx.examples.util.ToolTipController;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class ApplicationTemplate {
    public static void insertBeforeCompass(WorldWindow worldWindow, Layer layer) {
        int n = 0;
        LayerList layerList = worldWindow.getModel().getLayers();
        for (Layer layer2 : layerList) {
            if (!(layer2 instanceof CompassLayer)) continue;
            n = layerList.indexOf((Object)layer2);
        }
        layerList.add(n, layer);
    }

    public static void insertBeforePlacenames(WorldWindow worldWindow, Layer layer) {
        int n = 0;
        LayerList layerList = worldWindow.getModel().getLayers();
        for (Layer layer2 : layerList) {
            if (!(layer2 instanceof PlaceNameLayer)) continue;
            n = layerList.indexOf((Object)layer2);
        }
        layerList.add(n, layer);
    }

    public static void insertAfterPlacenames(WorldWindow worldWindow, Layer layer) {
        int n = 0;
        LayerList layerList = worldWindow.getModel().getLayers();
        for (Layer layer2 : layerList) {
            if (!(layer2 instanceof PlaceNameLayer)) continue;
            n = layerList.indexOf((Object)layer2);
        }
        layerList.add(n + 1, layer);
    }

    public static void insertBeforeLayerName(WorldWindow worldWindow, Layer layer, String string) {
        int n = 0;
        LayerList layerList = worldWindow.getModel().getLayers();
        for (Layer layer2 : layerList) {
            if (layer2.getName().indexOf(string) == -1) continue;
            n = layerList.indexOf((Object)layer2);
            break;
        }
        layerList.add(n, layer);
    }

    public static AppFrame start(String string, Class clazz) {
        if (Configuration.isMacOS() && string != null) {
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", string);
        }
        try {
            final AppFrame appFrame = (AppFrame)clazz.newInstance();
            appFrame.setTitle(string);
            appFrame.setDefaultCloseOperation(3);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    appFrame.setVisible(true);
                }
            });
            return appFrame;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind Application", AppFrame.class);
    }

    static {
        System.setProperty("java.net.useSystemProxies", "true");
        if (Configuration.isMacOS()) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "World Wind Application");
            System.setProperty("com.apple.mrj.application.growbox.intrudes", "false");
            System.setProperty("apple.awt.brushMetalLook", "true");
        } else if (Configuration.isWindowsOS()) {
            System.setProperty("sun.awt.noerasebackground", "true");
        }
    }

    protected static class AppFrame
    extends JFrame {
        private Dimension canvasSize = new Dimension(800, 600);
        protected AppPanel wwjPanel;
        protected LayerPanel layerPanel;
        protected StatisticsPanel statsPanel;

        public AppFrame() {
            this.initialize(true, true, false);
        }

        public AppFrame(Dimension dimension) {
            this.canvasSize = dimension;
            this.initialize(true, true, false);
        }

        public AppFrame(boolean bl, boolean bl2, boolean bl3) {
            this.initialize(bl, bl2, bl3);
        }

        protected void initialize(boolean bl, boolean bl2, boolean bl3) {
            this.wwjPanel = this.createAppPanel(this.canvasSize, bl);
            this.wwjPanel.setPreferredSize(this.canvasSize);
            this.getContentPane().add((Component)this.wwjPanel, "Center");
            if (bl2) {
                this.layerPanel = new LayerPanel(this.wwjPanel.getWwd(), null);
                this.getContentPane().add((Component)this.layerPanel, "West");
            }
            if (bl3 || System.getProperty("gov.nasa.worldwind.showStatistics") != null) {
                this.statsPanel = new StatisticsPanel(this.wwjPanel.getWwd(), new Dimension(250, this.canvasSize.height));
                this.getContentPane().add((Component)this.statsPanel, "East");
            }
            ViewControlsLayer viewControlsLayer = new ViewControlsLayer();
            ApplicationTemplate.insertBeforeCompass(this.getWwd(), (Layer)viewControlsLayer);
            this.getWwd().addSelectListener((SelectListener)new ViewControlsSelectListener(this.getWwd(), viewControlsLayer));
            this.wwjPanel.getWwd().addRenderingExceptionListener(new RenderingExceptionListener(){

                public void exceptionThrown(Throwable throwable) {
                    if (throwable instanceof WWAbsentRequirementException) {
                        String string = "Computer does not meet minimum graphics requirements.\n";
                        string = string + "Please install up-to-date graphics driver and try again.\n";
                        string = string + "Reason: " + throwable.getMessage() + "\n";
                        string = string + "This program will end when you press OK.";
                        JOptionPane.showMessageDialog(AppFrame.this, string, "Unable to Start Program", 0);
                        System.exit(-1);
                    }
                }
            });
            for (Layer layer : this.wwjPanel.getWwd().getModel().getLayers()) {
                if (!(layer instanceof SelectListener)) continue;
                this.getWwd().addSelectListener((SelectListener)layer);
            }
            this.pack();
            WWUtil.alignComponent(null, (Component)this, (String)"gov.nasa.worldwind.avkey.Center");
            this.setResizable(true);
        }

        protected AppPanel createAppPanel(Dimension dimension, boolean bl) {
            return new AppPanel(dimension, bl);
        }

        public Dimension getCanvasSize() {
            return this.canvasSize;
        }

        public AppPanel getWwjPanel() {
            return this.wwjPanel;
        }

        public WorldWindow getWwd() {
            return this.wwjPanel.getWwd();
        }

        public StatusBar getStatusBar() {
            return this.wwjPanel.getStatusBar();
        }

        public LayerPanel getLayerPanel() {
            return this.layerPanel;
        }

        public StatisticsPanel getStatsPanel() {
            return this.statsPanel;
        }

        public void setToolTipController(ToolTipController toolTipController) {
            if (this.wwjPanel.toolTipController != null) {
                this.wwjPanel.toolTipController.dispose();
            }
            this.wwjPanel.toolTipController = toolTipController;
        }

        public void setHighlightController(HighlightController highlightController) {
            if (this.wwjPanel.highlightController != null) {
                this.wwjPanel.highlightController.dispose();
            }
            this.wwjPanel.highlightController = highlightController;
        }
    }

    public static class AppPanel
    extends JPanel {
        protected WorldWindow wwd = this.createWorldWindow();
        protected StatusBar statusBar;
        protected ToolTipController toolTipController;
        protected HighlightController highlightController;

        public AppPanel(Dimension dimension, boolean bl) {
            super(new BorderLayout());
            ((Component)this.wwd).setPreferredSize(dimension);
            Model model = (Model)WorldWind.createConfigurationComponent((String)"gov.nasa.worldwind.avkey.ModelClassName");
            this.wwd.setModel(model);
            this.wwd.addSelectListener((SelectListener)new ClickAndGoSelectListener(this.getWwd(), WorldMapLayer.class));
            this.add((Component)this.wwd, "Center");
            if (bl) {
                this.statusBar = new StatusBar();
                this.add((Component)this.statusBar, "Last");
                this.statusBar.setEventSource(this.wwd);
            }
            this.toolTipController = new ToolTipController(this.getWwd(), "gov.nasa.worldwind.avkey.DisplayName", null);
            this.highlightController = new HighlightController(this.getWwd(), "gov.nasa.worldwind.SelectEvent.Rollover");
        }

        protected WorldWindow createWorldWindow() {
            return new WorldWindowGLCanvas();
        }

        public WorldWindow getWwd() {
            return this.wwd;
        }

        public StatusBar getStatusBar() {
            return this.statusBar;
        }
    }
}

