/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.Box;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwindx.examples.ApplicationTemplate;

public class Boxes
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind Boxes", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        public AppFrame() {
            RenderableLayer renderableLayer = new RenderableLayer();
            BasicShapeAttributes basicShapeAttributes = new BasicShapeAttributes();
            basicShapeAttributes.setInteriorMaterial(Material.YELLOW);
            basicShapeAttributes.setInteriorOpacity(0.7);
            basicShapeAttributes.setEnableLighting(true);
            basicShapeAttributes.setOutlineMaterial(Material.RED);
            basicShapeAttributes.setOutlineWidth(2.0);
            basicShapeAttributes.setDrawInterior(true);
            basicShapeAttributes.setDrawOutline(false);
            BasicShapeAttributes basicShapeAttributes2 = new BasicShapeAttributes();
            basicShapeAttributes2.setInteriorMaterial(Material.PINK);
            basicShapeAttributes2.setInteriorOpacity(1.0);
            basicShapeAttributes2.setEnableLighting(true);
            basicShapeAttributes2.setOutlineMaterial(Material.WHITE);
            basicShapeAttributes2.setOutlineWidth(2.0);
            basicShapeAttributes2.setDrawOutline(false);
            Box box = new Box(Position.fromDegrees((double)40.0, (double)-120.0, (double)80000.0), 50000.0, 50000.0, 50000.0);
            box.setAltitudeMode(0);
            box.setAttributes((ShapeAttributes)basicShapeAttributes);
            box.setVisible(true);
            box.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Box with equal axes, ABSOLUTE altitude mode");
            renderableLayer.addRenderable((Renderable)box);
            Box box2 = new Box(Position.fromDegrees((double)37.5, (double)-115.0, (double)50000.0), 50000.0, 50000.0, 50000.0);
            box2.setAltitudeMode(2);
            box2.setAttributes((ShapeAttributes)basicShapeAttributes);
            box2.setVisible(true);
            box2.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Box with equal axes, RELATIVE_TO_GROUND altitude mode");
            renderableLayer.addRenderable((Renderable)box2);
            Box box3 = new Box(Position.fromDegrees((double)35.0, (double)-110.0, (double)50000.0), 50000.0, 50000.0, 50000.0);
            box3.setAltitudeMode(1);
            box3.setAttributes((ShapeAttributes)basicShapeAttributes);
            box3.setVisible(true);
            box3.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Box with equal axes, CLAMP_TO_GROUND altitude mode");
            renderableLayer.addRenderable((Renderable)box3);
            Box box4 = new Box(Position.fromDegrees((double)0.0, (double)-90.0, (double)600000.0), 600000.0, 600000.0, 600000.0);
            box4.setAltitudeMode(2);
            box4.setImageSources((Object)"gov/nasa/worldwindx/examples/images/500px-Checkerboard_pattern.png");
            box4.setAttributes((ShapeAttributes)basicShapeAttributes);
            box4.setVisible(true);
            box4.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Box with a texture");
            renderableLayer.addRenderable((Renderable)box4);
            Box box5 = new Box(Position.ZERO, 1000000.0, 500000.0, 100000.0);
            box5.setAltitudeMode(0);
            box5.setAttributes((ShapeAttributes)basicShapeAttributes);
            box5.setVisible(true);
            box5.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Scaled Box with default orientation");
            renderableLayer.addRenderable((Renderable)box5);
            Box box6 = new Box(Position.fromDegrees((double)0.0, (double)30.0, (double)750000.0), 1000000.0, 500000.0, 100000.0, Angle.fromDegrees((double)90.0), Angle.fromDegrees((double)45.0), Angle.fromDegrees((double)30.0));
            box6.setAltitudeMode(2);
            box6.setAttributes((ShapeAttributes)basicShapeAttributes2);
            box6.setVisible(true);
            box6.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Scaled Box with a pre-set orientation");
            renderableLayer.addRenderable((Renderable)box6);
            Box box7 = new Box(Position.fromDegrees((double)30.0, (double)30.0, (double)750000.0), 1000000.0, 500000.0, 100000.0, Angle.fromDegrees((double)90.0), Angle.fromDegrees((double)45.0), Angle.fromDegrees((double)30.0));
            box7.setAltitudeMode(2);
            box7.setImageSources((Object)"gov/nasa/worldwindx/examples/images/500px-Checkerboard_pattern.png");
            box7.setAttributes((ShapeAttributes)basicShapeAttributes2);
            box7.setVisible(true);
            box7.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Scaled Box with a pre-set orientation");
            renderableLayer.addRenderable((Renderable)box7);
            Box box8 = new Box(Position.fromDegrees((double)60.0, (double)30.0, (double)750000.0), 1000000.0, 500000.0, 100000.0, Angle.fromDegrees((double)90.0), Angle.fromDegrees((double)45.0), Angle.fromDegrees((double)30.0));
            box8.setAltitudeMode(2);
            box8.setAttributes((ShapeAttributes)basicShapeAttributes2);
            box8.setVisible(true);
            box8.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Scaled Box with a pre-set orientation");
            renderableLayer.addRenderable((Renderable)box8);
            Box box9 = new Box(Position.fromDegrees((double)-45.0, (double)-180.0, (double)750000.0), 1000000.0, 500000.0, 100000.0, Angle.fromDegrees((double)90.0), Angle.fromDegrees((double)45.0), Angle.fromDegrees((double)30.0));
            box9.setAltitudeMode(2);
            box9.setAttributes((ShapeAttributes)basicShapeAttributes2);
            box9.setVisible(true);
            box9.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Scaled, oriented Box in the 3rd 'quadrant' (-X, -Y, -Z)");
            renderableLayer.addRenderable((Renderable)box9);
            ApplicationTemplate.insertBeforeCompass(this.getWwd(), (Layer)renderableLayer);
            this.getLayerPanel().update(this.getWwd());
        }
    }
}

