/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.SceneController;
import gov.nasa.worldwind.WorldWindowGLAutoDrawable;
import gov.nasa.worldwind.render.GLRuntimeCapabilities;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import javax.media.opengl.GLAutoDrawable;

public class ConfiguringGLRuntimeCapabilities
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        ConfiguringGLRuntimeCapabilities.start("World Wind Configuring GL Runtime Capabilities", ApplicationTemplate.AppFrame.class);
    }

    static {
        Configuration.setValue((String)"gov.nasa.worldwind.avkey.WorldWindowClassName", (Object)MyGLAutoDrawable.class.getName());
    }

    public static class MyGLAutoDrawable
    extends WorldWindowGLAutoDrawable {
        public void init(GLAutoDrawable gLAutoDrawable) {
            super.init(gLAutoDrawable);
            this.configureGLRuntimeCaps();
        }

        protected void configureGLRuntimeCaps() {
            SceneController sceneController = this.getSceneController();
            if (sceneController == null) {
                return;
            }
            GLRuntimeCapabilities gLRuntimeCapabilities = sceneController.getGLRuntimeCapabilities();
            if (gLRuntimeCapabilities == null) {
                String string = Logging.getMessage((String)"nullValue.GLRuntimeCapabilitiesIsNull");
                Logging.logger().warning(string);
                return;
            }
            gLRuntimeCapabilities.setFramebufferObjectEnabled(this.isEnableFramebufferObjects());
        }

        protected boolean isEnableFramebufferObjects() {
            return false;
        }
    }
}

