/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.Cylinder;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Cylinders
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind Cylinders", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        public AppFrame() {
            this.getLayerPanel().add((Component)this.makeDetailHintControlPanel(), "South");
            RenderableLayer renderableLayer = new RenderableLayer();
            BasicShapeAttributes basicShapeAttributes = new BasicShapeAttributes();
            basicShapeAttributes.setInteriorMaterial(Material.YELLOW);
            basicShapeAttributes.setInteriorOpacity(0.7);
            basicShapeAttributes.setEnableLighting(true);
            basicShapeAttributes.setOutlineMaterial(Material.RED);
            basicShapeAttributes.setOutlineWidth(2.0);
            basicShapeAttributes.setDrawInterior(true);
            basicShapeAttributes.setDrawOutline(false);
            BasicShapeAttributes basicShapeAttributes2 = new BasicShapeAttributes();
            basicShapeAttributes2.setInteriorMaterial(Material.PINK);
            basicShapeAttributes2.setInteriorOpacity(1.0);
            basicShapeAttributes2.setEnableLighting(true);
            basicShapeAttributes2.setOutlineMaterial(Material.WHITE);
            basicShapeAttributes2.setOutlineWidth(2.0);
            basicShapeAttributes2.setDrawOutline(false);
            Cylinder cylinder = new Cylinder(Position.fromDegrees((double)40.0, (double)-120.0, (double)80000.0), 100000.0, 50000.0);
            cylinder.setAltitudeMode(0);
            cylinder.setAttributes((ShapeAttributes)basicShapeAttributes);
            cylinder.setVisible(true);
            cylinder.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Cylinder with equal axes, ABSOLUTE altitude mode");
            renderableLayer.addRenderable((Renderable)cylinder);
            Cylinder cylinder2 = new Cylinder(Position.fromDegrees((double)37.5, (double)-115.0, (double)50000.0), 50000.0, 50000.0, 50000.0);
            cylinder2.setAltitudeMode(2);
            cylinder2.setAttributes((ShapeAttributes)basicShapeAttributes);
            cylinder2.setVisible(true);
            cylinder2.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Cylinder with equal axes, RELATIVE_TO_GROUND altitude mode");
            renderableLayer.addRenderable((Renderable)cylinder2);
            Cylinder cylinder3 = new Cylinder(Position.fromDegrees((double)35.0, (double)-110.0, (double)50000.0), 50000.0, 50000.0, 50000.0);
            cylinder3.setAltitudeMode(1);
            cylinder3.setAttributes((ShapeAttributes)basicShapeAttributes);
            cylinder3.setVisible(true);
            cylinder3.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Cylinder with equal axes, CLAMP_TO_GROUND altitude mode");
            renderableLayer.addRenderable((Renderable)cylinder3);
            Cylinder cylinder4 = new Cylinder(Position.fromDegrees((double)0.0, (double)-90.0, (double)600000.0), 1200000.0, 600000.0);
            cylinder4.setAltitudeMode(2);
            cylinder4.setImageSources((Object)"gov/nasa/worldwindx/examples/images/500px-Checkerboard_pattern.png");
            cylinder4.setAttributes((ShapeAttributes)basicShapeAttributes);
            cylinder4.setVisible(true);
            cylinder4.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Cylinder with a texture");
            renderableLayer.addRenderable((Renderable)cylinder4);
            Cylinder cylinder5 = new Cylinder(Position.ZERO, 1000000.0, 500000.0, 100000.0);
            cylinder5.setAltitudeMode(0);
            cylinder5.setAttributes((ShapeAttributes)basicShapeAttributes);
            cylinder5.setVisible(true);
            cylinder5.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Scaled Cylinder with default orientation");
            renderableLayer.addRenderable((Renderable)cylinder5);
            Cylinder cylinder6 = new Cylinder(Position.fromDegrees((double)0.0, (double)30.0, (double)750000.0), 1000000.0, 500000.0, 100000.0, Angle.fromDegrees((double)90.0), Angle.fromDegrees((double)45.0), Angle.fromDegrees((double)30.0));
            cylinder6.setAltitudeMode(2);
            cylinder6.setAttributes((ShapeAttributes)basicShapeAttributes2);
            cylinder6.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Scaled Cylinder with a pre-set orientation");
            cylinder6.setVisible(true);
            renderableLayer.addRenderable((Renderable)cylinder6);
            Cylinder cylinder7 = new Cylinder(Position.fromDegrees((double)30.0, (double)30.0, (double)750000.0), 1000000.0, 500000.0, 100000.0, Angle.fromDegrees((double)90.0), Angle.fromDegrees((double)45.0), Angle.fromDegrees((double)30.0));
            cylinder7.setAltitudeMode(2);
            cylinder7.setImageSources((Object)"gov/nasa/worldwindx/examples/images/500px-Checkerboard_pattern.png");
            cylinder7.setAttributes((ShapeAttributes)basicShapeAttributes2);
            cylinder7.setVisible(true);
            cylinder7.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Scaled Cylinder with a pre-set orientation");
            renderableLayer.addRenderable((Renderable)cylinder7);
            Cylinder cylinder8 = new Cylinder(Position.fromDegrees((double)60.0, (double)30.0, (double)750000.0), 1000000.0, 500000.0, 100000.0, Angle.fromDegrees((double)90.0), Angle.fromDegrees((double)45.0), Angle.fromDegrees((double)30.0));
            cylinder8.setAltitudeMode(2);
            cylinder8.setAttributes((ShapeAttributes)basicShapeAttributes2);
            cylinder8.setVisible(true);
            cylinder8.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Scaled Cylinder with a pre-set orientation");
            renderableLayer.addRenderable((Renderable)cylinder8);
            Cylinder cylinder9 = new Cylinder(Position.fromDegrees((double)-45.0, (double)-180.0, (double)750000.0), 1000000.0, 500000.0, 100000.0, Angle.fromDegrees((double)90.0), Angle.fromDegrees((double)45.0), Angle.fromDegrees((double)30.0));
            cylinder9.setAltitudeMode(2);
            cylinder9.setAttributes((ShapeAttributes)basicShapeAttributes2);
            cylinder9.setVisible(true);
            cylinder9.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Scaled, oriented Cylinder in the 3rd 'quadrant' (-X, -Y, -Z)");
            renderableLayer.addRenderable((Renderable)cylinder9);
            ApplicationTemplate.insertBeforeCompass(this.getWwd(), (Layer)renderableLayer);
            this.getLayerPanel().update(this.getWwd());
        }

        protected JPanel makeDetailHintControlPanel() {
            JPanel jPanel = new JPanel(new BorderLayout(0, 10));
            jPanel.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9), new TitledBorder("Detail Hint")));
            JPanel jPanel2 = new JPanel(new BorderLayout(0, 5));
            int n = -10;
            int n2 = 10;
            int n3 = 0;
            JSlider jSlider = new JSlider(n, n2, n3);
            jSlider.setMajorTickSpacing(10);
            jSlider.setMinorTickSpacing(1);
            jSlider.setPaintTicks(true);
            Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
            hashtable.put(-10, new JLabel("-1.0"));
            hashtable.put(0, new JLabel("0.0"));
            hashtable.put(10, new JLabel("1.0"));
            jSlider.setLabelTable(hashtable);
            jSlider.setPaintLabels(true);
            jSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    double d = (double)((JSlider)changeEvent.getSource()).getValue() / 10.0;
                    AppFrame.this.setCylinderDetailHint(d);
                    AppFrame.this.getWwd().redraw();
                }
            });
            jPanel2.add((Component)jSlider, "South");
            JPanel jPanel3 = new JPanel(new GridLayout(2, 0));
            jPanel3.add(jPanel2);
            jPanel.add((Component)jPanel3, "South");
            return jPanel;
        }

        protected RenderableLayer getLayer() {
            for (Layer layer : this.getWwd().getModel().getLayers()) {
                if (!layer.getName().contains("Renderable")) continue;
                return (RenderableLayer)layer;
            }
            return null;
        }

        protected void setCylinderDetailHint(double d) {
            for (Renderable renderable : this.getLayer().getRenderables()) {
                Cylinder cylinder = (Cylinder)renderable;
                cylinder.setDetailHint(d);
            }
            System.out.println("cylinder detail hint set to " + d);
        }
    }
}

