/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.SurfaceImage;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DimGlobeSurface
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind Surface Dimming", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        protected SurfaceImage surfaceImage = new SurfaceImage((Object)this.makeFilterImage(), Sector.FULL_SPHERE);
        protected JSlider opacitySlider;

        public AppFrame() {
            super(true, true, false);
            this.surfaceImage.setOpacity(0.1);
            RenderableLayer renderableLayer = new RenderableLayer();
            renderableLayer.setName("Surface Dimmer");
            renderableLayer.setPickEnabled(false);
            renderableLayer.addRenderable((Renderable)this.surfaceImage);
            ApplicationTemplate.insertBeforePlacenames(this.getWwd(), (Layer)renderableLayer);
            JPanel jPanel = new JPanel(new BorderLayout(5, 5));
            jPanel.setBorder(new EmptyBorder(5, 10, 10, 5));
            jPanel.add((Component)new JLabel("Opacity"), "West");
            this.makeOpacitySlider();
            jPanel.add((Component)this.opacitySlider, "Center");
            this.getLayerPanel().add((Component)jPanel, "South");
            this.getLayerPanel().update(this.getWwd());
        }

        protected BufferedImage makeFilterImage() {
            BufferedImage bufferedImage = new BufferedImage(4, 4, 2);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            graphics2D.setColor(new Color(0.0f, 0.0f, 0.0f, 1.0f));
            graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
            graphics2D.dispose();
            return bufferedImage;
        }

        protected void makeOpacitySlider() {
            this.opacitySlider = new JSlider(0, 0, 100, (int)(this.surfaceImage.getOpacity() * 100.0));
            this.opacitySlider.setToolTipText("Filter opacity");
            this.opacitySlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    double d = AppFrame.this.opacitySlider.getValue();
                    AppFrame.this.surfaceImage.setOpacity(d / 100.0);
                    AppFrame.this.getWwd().redraw();
                }
            });
        }
    }
}

