/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.render.SurfaceCircle;
import gov.nasa.worldwind.render.SurfaceEllipse;
import gov.nasa.worldwind.render.SurfacePolygon;
import gov.nasa.worldwind.render.SurfacePolyline;
import gov.nasa.worldwind.render.SurfaceQuad;
import gov.nasa.worldwind.render.SurfaceSector;
import gov.nasa.worldwind.render.SurfaceSquare;
import gov.nasa.worldwind.util.BasicDragger;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;

public class DraggingShapes
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind Dragging Shapes", AppFrame.class);
    }

    protected static class AppFrame
    extends ApplicationTemplate.AppFrame {
        protected static final String SURFACE_POLYGON_IMAGE_PATH = "gov/nasa/worldwindx/examples/images/georss.png";

        public AppFrame() {
            this.getWwd().addSelectListener((SelectListener)new BasicDragger(this.getWwd()));
            this.makeShapes();
        }

        protected void makeShapes() {
            RenderableLayer renderableLayer = new RenderableLayer();
            renderableLayer.setName("Surface Shapes");
            BasicShapeAttributes basicShapeAttributes = new BasicShapeAttributes();
            basicShapeAttributes.setOutlineMaterial(Material.WHITE);
            basicShapeAttributes.setInteriorOpacity(0.5);
            basicShapeAttributes.setOutlineOpacity(0.8);
            basicShapeAttributes.setOutlineWidth(3.0);
            basicShapeAttributes.setImageSource((Object)SURFACE_POLYGON_IMAGE_PATH);
            basicShapeAttributes.setImageScale(0.5);
            double d = 28.0;
            double d2 = -82.0;
            List<LatLon> list = Arrays.asList(LatLon.fromDegrees((double)(d + 5.0), (double)(d2 + 2.5)), LatLon.fromDegrees((double)(d + 5.0), (double)(d2 - 2.5)), LatLon.fromDegrees((double)(d + 2.5), (double)(d2 - 5.0)), LatLon.fromDegrees((double)(d - 2.5), (double)(d2 - 5.0)), LatLon.fromDegrees((double)(d - 5.0), (double)(d2 - 2.5)), LatLon.fromDegrees((double)(d - 5.0), (double)(d2 + 2.5)), LatLon.fromDegrees((double)(d - 2.5), (double)(d2 + 5.0)), LatLon.fromDegrees((double)(d + 2.5), (double)(d2 + 5.0)), LatLon.fromDegrees((double)(d + 5.0), (double)(d2 + 2.5)));
            SurfacePolygon surfacePolygon = new SurfacePolygon(list);
            surfacePolygon.setAttributes((ShapeAttributes)basicShapeAttributes);
            renderableLayer.addRenderable((Renderable)surfacePolygon);
            basicShapeAttributes = new BasicShapeAttributes();
            basicShapeAttributes.setInteriorMaterial(Material.RED);
            basicShapeAttributes.setOutlineMaterial(new Material(WWUtil.makeColorBrighter((Color)Color.RED)));
            basicShapeAttributes.setInteriorOpacity(0.5);
            basicShapeAttributes.setOutlineOpacity(0.8);
            basicShapeAttributes.setOutlineWidth(3.0);
            list = Arrays.asList(LatLon.fromDegrees((double)20.0, (double)-170.0), LatLon.fromDegrees((double)15.0, (double)170.0), LatLon.fromDegrees((double)10.0, (double)-175.0), LatLon.fromDegrees((double)5.0, (double)170.0), LatLon.fromDegrees((double)0.0, (double)-170.0), LatLon.fromDegrees((double)20.0, (double)-170.0));
            surfacePolygon = new SurfacePolygon(list);
            surfacePolygon.setAttributes((ShapeAttributes)basicShapeAttributes);
            renderableLayer.addRenderable((Renderable)surfacePolygon);
            basicShapeAttributes = new BasicShapeAttributes();
            basicShapeAttributes.setInteriorMaterial(Material.CYAN);
            basicShapeAttributes.setOutlineMaterial(new Material(WWUtil.makeColorBrighter((Color)Color.CYAN)));
            basicShapeAttributes.setInteriorOpacity(0.5);
            basicShapeAttributes.setOutlineOpacity(0.8);
            basicShapeAttributes.setOutlineWidth(3.0);
            surfacePolygon = new SurfaceEllipse(LatLon.fromDegrees((double)38.0, (double)-104.0), 150000.0, 100000.0, Angle.fromDegrees((double)15.0));
            surfacePolygon.setAttributes((ShapeAttributes)basicShapeAttributes);
            renderableLayer.addRenderable((Renderable)surfacePolygon);
            basicShapeAttributes = new BasicShapeAttributes();
            basicShapeAttributes.setInteriorMaterial(Material.GREEN);
            basicShapeAttributes.setOutlineMaterial(new Material(WWUtil.makeColorBrighter((Color)Color.GREEN)));
            basicShapeAttributes.setInteriorOpacity(0.5);
            basicShapeAttributes.setOutlineOpacity(0.8);
            basicShapeAttributes.setOutlineWidth(3.0);
            surfacePolygon = new SurfaceCircle(LatLon.fromDegrees((double)36.0, (double)-104.0), 100000.0);
            surfacePolygon.setAttributes((ShapeAttributes)basicShapeAttributes);
            renderableLayer.addRenderable((Renderable)surfacePolygon);
            surfacePolygon = new SurfaceCircle(LatLon.fromDegrees((double)90.0, (double)0.0), 1000000.0);
            surfacePolygon.setAttributes((ShapeAttributes)basicShapeAttributes);
            renderableLayer.addRenderable((Renderable)surfacePolygon);
            basicShapeAttributes = new BasicShapeAttributes();
            basicShapeAttributes.setInteriorMaterial(Material.ORANGE);
            basicShapeAttributes.setOutlineMaterial(new Material(WWUtil.makeColorBrighter((Color)Color.ORANGE)));
            basicShapeAttributes.setInteriorOpacity(0.5);
            basicShapeAttributes.setOutlineOpacity(0.8);
            basicShapeAttributes.setOutlineWidth(3.0);
            surfacePolygon = new SurfaceQuad(LatLon.fromDegrees((double)42.0, (double)-104.0), 100000.0, 130000.0, Angle.fromDegrees((double)20.0));
            surfacePolygon.setAttributes((ShapeAttributes)basicShapeAttributes);
            renderableLayer.addRenderable((Renderable)surfacePolygon);
            basicShapeAttributes = new BasicShapeAttributes();
            basicShapeAttributes.setInteriorMaterial(Material.MAGENTA);
            basicShapeAttributes.setOutlineMaterial(new Material(WWUtil.makeColorBrighter((Color)Color.MAGENTA)));
            basicShapeAttributes.setInteriorOpacity(0.5);
            basicShapeAttributes.setOutlineOpacity(0.8);
            basicShapeAttributes.setOutlineWidth(3.0);
            surfacePolygon = new SurfaceSquare(LatLon.fromDegrees((double)45.0, (double)-104.0), 100000.0);
            surfacePolygon.setAttributes((ShapeAttributes)basicShapeAttributes);
            renderableLayer.addRenderable((Renderable)surfacePolygon);
            basicShapeAttributes = new BasicShapeAttributes();
            basicShapeAttributes.setInteriorMaterial(Material.YELLOW);
            basicShapeAttributes.setOutlineMaterial(new Material(WWUtil.makeColorBrighter((Color)Color.YELLOW)));
            basicShapeAttributes.setInteriorOpacity(0.5);
            basicShapeAttributes.setOutlineOpacity(0.8);
            basicShapeAttributes.setOutlineWidth(3.0);
            surfacePolygon = new SurfaceSector(new Sector(Angle.fromDegrees((double)41.0), Angle.fromDegrees((double)41.6), Angle.fromDegrees((double)-122.5), Angle.fromDegrees((double)-121.7)));
            surfacePolygon.setAttributes((ShapeAttributes)basicShapeAttributes);
            renderableLayer.addRenderable((Renderable)surfacePolygon);
            basicShapeAttributes = new BasicShapeAttributes();
            basicShapeAttributes.setInteriorMaterial(Material.CYAN);
            basicShapeAttributes.setOutlineMaterial(new Material(WWUtil.makeColorBrighter((Color)Color.CYAN)));
            basicShapeAttributes.setInteriorOpacity(0.5);
            basicShapeAttributes.setOutlineOpacity(0.8);
            basicShapeAttributes.setOutlineWidth(3.0);
            surfacePolygon = new SurfaceSector(new Sector(Angle.fromDegrees((double)38.9), Angle.fromDegrees((double)39.3), Angle.fromDegrees((double)-120.2), Angle.fromDegrees((double)-119.9)));
            surfacePolygon.setAttributes((ShapeAttributes)basicShapeAttributes);
            renderableLayer.addRenderable((Renderable)surfacePolygon);
            basicShapeAttributes = new BasicShapeAttributes();
            basicShapeAttributes.setOutlineMaterial(Material.RED);
            basicShapeAttributes.setOutlineWidth(3.0);
            basicShapeAttributes.setOutlineStippleFactor(2);
            list = Arrays.asList(LatLon.fromDegrees((double)-10.0, (double)170.0), LatLon.fromDegrees((double)-10.0, (double)-170.0));
            surfacePolygon = new SurfacePolyline(list);
            surfacePolygon.setAttributes((ShapeAttributes)basicShapeAttributes);
            ((SurfacePolyline)surfacePolygon).setClosed(false);
            renderableLayer.addRenderable((Renderable)surfacePolygon);
            ApplicationTemplate.insertBeforeCompass(this.getWwd(), (Layer)renderableLayer);
            this.getLayerPanel().update(this.getWwd());
        }
    }
}

