/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.Model;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.awt.WorldWindowGLCanvas;
import gov.nasa.worldwind.event.RenderingEvent;
import gov.nasa.worldwind.event.RenderingListener;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.TiledImageLayer;
import gov.nasa.worldwind.util.StatusBar;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwindx.examples.LayerPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class DynamicLayerPanelDisplay {
    public static AppFrame start(String string, Class clazz) {
        if (Configuration.isMacOS() && string != null) {
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", string);
        }
        try {
            final AppFrame appFrame = (AppFrame)clazz.newInstance();
            appFrame.setTitle(string);
            appFrame.setDefaultCloseOperation(3);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    appFrame.setVisible(true);
                }
            });
            return appFrame;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static void main(String[] stringArray) {
        DynamicLayerPanelDisplay.start("World Wind Application", AppFrame.class);
    }

    static {
        System.setProperty("java.net.useSystemProxies", "true");
        if (Configuration.isMacOS()) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "World Wind Application");
            System.setProperty("com.apple.mrj.application.growbox.intrudes", "false");
            System.setProperty("apple.awt.brushMetalLook", "true");
        } else if (Configuration.isWindowsOS()) {
            System.setProperty("sun.awt.noerasebackground", "true");
        }
    }

    protected static class AppFrame
    extends JFrame {
        protected Dimension canvasSize = new Dimension(800, 600);
        protected AppPanel wwjPanel;
        protected DynamicLayerPanel layerPanel;

        public AppFrame() {
            this.initialize();
        }

        protected void initialize() {
            this.wwjPanel = new AppPanel(this.canvasSize);
            this.wwjPanel.setPreferredSize(this.canvasSize);
            this.getContentPane().add((Component)this.wwjPanel, "Center");
            this.layerPanel = new DynamicLayerPanel(this.wwjPanel.wwd);
            this.getContentPane().add((Component)this.layerPanel, "West");
            this.wwjPanel.wwd.addRenderingListener(new RenderingListener(){

                public void stageChanged(RenderingEvent renderingEvent) {
                    AppFrame.this.layerPanel.updateLayerActivity(AppFrame.this.wwjPanel.wwd);
                }
            });
            this.pack();
            WWUtil.alignComponent(null, (Component)this, (String)"gov.nasa.worldwind.avkey.Center");
            this.setResizable(true);
        }
    }

    public static class AppPanel
    extends JPanel {
        protected WorldWindow wwd = new WorldWindowGLCanvas();
        protected StatusBar statusBar;

        public AppPanel(Dimension dimension) {
            super(new BorderLayout());
            ((Component)this.wwd).setPreferredSize(dimension);
            Model model = (Model)WorldWind.createConfigurationComponent((String)"gov.nasa.worldwind.avkey.ModelClassName");
            this.wwd.setModel(model);
            this.add((Component)this.wwd, "Center");
            this.statusBar = new StatusBar();
            this.add((Component)this.statusBar, "Last");
            this.statusBar.setEventSource(this.wwd);
        }
    }

    protected static class DynamicLayerPanel
    extends LayerPanel {
        protected Map<Layer, JCheckBox> checkBoxes;

        public DynamicLayerPanel(WorldWindow worldWindow) {
            super(worldWindow);
        }

        @Override
        protected void fill(WorldWindow worldWindow) {
            if (this.checkBoxes == null) {
                this.checkBoxes = new HashMap<Layer, JCheckBox>();
            }
            this.checkBoxes.clear();
            for (Layer layer : worldWindow.getModel().getLayers()) {
                if (!(layer instanceof TiledImageLayer)) continue;
                LayerPanel.LayerAction layerAction = new LayerPanel.LayerAction(layer, worldWindow, layer.isEnabled());
                JCheckBox jCheckBox = new JCheckBox(layerAction);
                jCheckBox.setSelected(layerAction.selected);
                this.layersPanel.add(jCheckBox);
                this.checkBoxes.put(layer, jCheckBox);
            }
            this.updateLayerActivity(worldWindow);
        }

        protected void updateLayerActivity(WorldWindow worldWindow) {
            for (Map.Entry<Layer, JCheckBox> entry : this.checkBoxes.entrySet()) {
                Long l = (Long)entry.getKey().getValue("gov.nasa.worldwind.avkey.FrameTimestamp");
                Long l2 = (Long)worldWindow.getSceneController().getValue("gov.nasa.worldwind.avkey.FrameTimestamp");
                if (l != null && l2 != null && l.longValue() == l2.longValue()) {
                    entry.getValue().setFont(entry.getValue().getFont().deriveFont(1));
                    continue;
                }
                entry.getValue().setFont(entry.getValue().getFont().deriveFont(0));
            }
        }
    }
}

