/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.ExtrudedPolygon;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Path;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import java.util.ArrayList;

public class ExtrudedPolygonWithBaseDepth
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind Extruded Polygon with Base Depth", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        public AppFrame() {
            super(true, true, false);
            RenderableLayer renderableLayer = new RenderableLayer();
            BasicShapeAttributes basicShapeAttributes = new BasicShapeAttributes();
            basicShapeAttributes.setInteriorMaterial(Material.MAGENTA);
            basicShapeAttributes.setOutlineOpacity(0.5);
            basicShapeAttributes.setInteriorOpacity(0.25);
            basicShapeAttributes.setOutlineMaterial(Material.GREEN);
            basicShapeAttributes.setOutlineWidth(1.0);
            basicShapeAttributes.setDrawOutline(true);
            basicShapeAttributes.setDrawInterior(true);
            BasicShapeAttributes basicShapeAttributes2 = new BasicShapeAttributes((ShapeAttributes)basicShapeAttributes);
            basicShapeAttributes2.setInteriorMaterial(Material.YELLOW);
            basicShapeAttributes2.setInteriorOpacity(0.25);
            basicShapeAttributes2.setDrawInterior(true);
            ArrayList<Position> arrayList = new ArrayList<Position>();
            arrayList.add(Position.fromDegrees((double)43.84344, (double)-114.63673, (double)20.0));
            arrayList.add(Position.fromDegrees((double)43.84343, (double)-114.63468, (double)20.0));
            arrayList.add(Position.fromDegrees((double)43.84316, (double)-114.63468, (double)20.0));
            arrayList.add(Position.fromDegrees((double)43.84314, (double)-114.63675, (double)20.0));
            arrayList.add(Position.fromDegrees((double)43.84344, (double)-114.63673, (double)20.0));
            ExtrudedPolygon extrudedPolygon = new ExtrudedPolygon(arrayList);
            extrudedPolygon.setAltitudeMode(2);
            extrudedPolygon.setSideAttributes((ShapeAttributes)basicShapeAttributes);
            extrudedPolygon.setCapAttributes((ShapeAttributes)basicShapeAttributes2);
            extrudedPolygon.setBaseDepth(20.0);
            renderableLayer.addRenderable((Renderable)extrudedPolygon);
            Path path = new Path(Position.fromDegrees((double)43.8425, (double)-114.6355, (double)0.0), Position.fromDegrees((double)43.8442, (double)-114.6356, (double)0.0));
            BasicShapeAttributes basicShapeAttributes3 = new BasicShapeAttributes();
            basicShapeAttributes3.setOutlineOpacity(1.0);
            basicShapeAttributes3.setOutlineMaterial(Material.GREEN);
            basicShapeAttributes3.setOutlineWidth(4.0);
            path.setAttributes((ShapeAttributes)basicShapeAttributes3);
            path.setAltitudeMode(2);
            renderableLayer.addRenderable((Renderable)path);
            ApplicationTemplate.insertBeforeCompass(this.getWwd(), (Layer)renderableLayer);
            this.getLayerPanel().update(this.getWwd());
            this.getWwd().getView().setEyePosition(Position.fromDegrees((double)43.843162670564354, (double)-114.63551647988652, (double)2652.865781935775));
        }
    }
}

