/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.View;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.ExtrudedPolygon;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.render.airspaces.Airspace;
import gov.nasa.worldwind.render.airspaces.Polygon;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import gov.nasa.worldwindx.examples.util.ExampleUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ExtrudedShapes
extends ApplicationTemplate {
    protected static final String DEMO_AIRSPACES_PATH = "gov/nasa/worldwindx/examples/data/AirspaceBuilder-DemoShapes.zip";
    protected static String DEFAULT_IMAGE_URL = "gov/nasa/worldwindx/examples/images/build123sm.jpg";

    protected static void loadAirspacesFromPath(String string, Collection<Airspace> collection) {
        File file = ExampleUtil.saveResourceToTempFile(string, ".zip");
        if (file == null) {
            return;
        }
        try {
            ZipFile zipFile = new ZipFile(file);
            ZipEntry zipEntry = null;
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                String string2;
                if (zipEntry != null && (string2 = WWIO.getFilename((String)zipEntry.getName())).startsWith("gov.nasa.worldwind.render.airspaces") && string2.endsWith(".xml")) {
                    String[] stringArray = string2.split("-");
                    try {
                        Class<?> clazz = Class.forName(stringArray[0]);
                        Airspace airspace = (Airspace)clazz.newInstance();
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(zipFile.getInputStream(zipEntry)));
                        String string3 = bufferedReader.readLine();
                        airspace.restoreState(string3);
                        collection.add(airspace);
                        if (stringArray.length >= 2) {
                            airspace.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)stringArray[1]);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                zipEntry = enumeration.nextElement();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind Extruded Polygons on Ground", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        public AppFrame() {
            super(true, true, false);
            try {
                RenderableLayer renderableLayer = new RenderableLayer();
                renderableLayer.setName("Extruded Shapes");
                renderableLayer.setPickEnabled(true);
                ArrayList<Airspace> arrayList = new ArrayList<Airspace>();
                ExtrudedShapes.loadAirspacesFromPath(ExtrudedShapes.DEMO_AIRSPACES_PATH, arrayList);
                BasicShapeAttributes basicShapeAttributes = new BasicShapeAttributes();
                basicShapeAttributes.setInteriorMaterial(Material.LIGHT_GRAY);
                basicShapeAttributes.setOutlineMaterial(Material.DARK_GRAY);
                BasicShapeAttributes basicShapeAttributes2 = new BasicShapeAttributes((ShapeAttributes)basicShapeAttributes);
                basicShapeAttributes2.setInteriorMaterial(Material.GRAY);
                int n = 0;
                int n2 = 0;
                for (Airspace airspace : arrayList) {
                    if (!(airspace instanceof Polygon)) continue;
                    Polygon polygon = (Polygon)airspace;
                    ArrayList<String> arrayList2 = new ArrayList<String>();
                    for (int i = 0; i < polygon.getLocations().size(); ++i) {
                        arrayList2.add(DEFAULT_IMAGE_URL);
                    }
                    double d = 40.0;
                    ExtrudedPolygon extrudedPolygon = new ExtrudedPolygon((Iterable)polygon.getLocations(), d, arrayList2);
                    extrudedPolygon.setSideAttributes((ShapeAttributes)basicShapeAttributes);
                    extrudedPolygon.setCapAttributes((ShapeAttributes)basicShapeAttributes2);
                    if (polygon.getLocations().size() == 4) {
                        float[] fArray = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f};
                        extrudedPolygon.setCapImageSource((Object)"images/32x32-icon-nasa.png", fArray, 4);
                    }
                    renderableLayer.addRenderable((Renderable)extrudedPolygon);
                    ++n;
                    n2 += ((Polygon)airspace).getLocations().size();
                }
                System.out.printf("NUM SHAPES = %d, NUM SIDES = %d\n", n, n2);
                ApplicationTemplate.insertBeforePlacenames(this.getWwd(), (Layer)renderableLayer);
                this.getLayerPanel().update(this.getWwd());
                View view = this.getWwd().getView();
                view.setEyePosition(Position.fromDegrees((double)47.656, (double)-122.306, (double)1000.0));
                this.getWwd().addSelectListener(new SelectListener(){

                    public void selected(SelectEvent selectEvent) {
                        if (selectEvent.getTopObject() instanceof ExtrudedPolygon) {
                            System.out.println("EXTRUDED POLYGON");
                        }
                    }
                });
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

