/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.formats.geojson.GeoJSONPoint;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.globes.EarthFlat;
import gov.nasa.worldwind.layers.CompassLayer;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.LayerList;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.layers.SkyColorLayer;
import gov.nasa.worldwind.layers.SkyGradientLayer;
import gov.nasa.worldwind.layers.WorldMapLayer;
import gov.nasa.worldwind.render.AnnotationAttributes;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.FrameFactory;
import gov.nasa.worldwind.render.GlobeAnnotation;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwind.view.orbit.BasicOrbitView;
import gov.nasa.worldwind.view.orbit.FlatOrbitView;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import gov.nasa.worldwindx.examples.ClickAndGoSelectListener;
import gov.nasa.worldwindx.examples.FlatWorldPanel;
import gov.nasa.worldwindx.examples.GeoJSONLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.nio.DoubleBuffer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import javax.media.opengl.GL2;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;

public class FlatWorldEarthquakes
extends ApplicationTemplate {
    protected static final String USGS_EARTHQUAKE_FEED_URL = "http://earthquake.usgs.gov/earthquakes/feed/v1.0/summary/2.5_week.geojson";
    protected static final String USGS_EARTHQUAKE_MAGNITUDE = "mag";
    protected static final String USGS_EARTHQUAKE_PLACE = "place";
    protected static final String USGS_EARTHQUAKE_TIME = "time";
    protected static final long UPDATE_INTERVAL = 300000L;
    protected static final long MILLISECONDS_PER_MINUTE = 60000L;
    protected static final long MILLISECONDS_PER_HOUR = 3600000L;
    protected static final long MILLISECONDS_PER_DAY = 86400000L;

    public static void main(String[] stringArray) {
        Configuration.setValue((String)"gov.nasa.worldwind.avkey.InitialLatitude", (Object)0);
        Configuration.setValue((String)"gov.nasa.worldwind.avkey.InitialLongitude", (Object)0);
        Configuration.setValue((String)"gov.nasa.worldwind.avkey.InitialAltitude", (Object)5.0E7);
        Configuration.setValue((String)"gov.nasa.worldwind.avkey.GlobeClassName", (Object)EarthFlat.class.getName());
        Configuration.setValue((String)"gov.nasa.worldwind.avkey.ViewClassName", (Object)FlatOrbitView.class.getName());
        ApplicationTemplate.start("World Wind USGS Earthquakes M 2.5+ - 7 days", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        private RenderableLayer eqLayer;
        private EqAnnotation mouseEq;
        private EqAnnotation latestEq;
        private GlobeAnnotation tooltipAnnotation;
        private JButton downloadButton;
        private JLabel statusLabel;
        private JLabel latestLabel;
        private Blinker blinker;
        private Timer updater;
        private long updateTime;
        private JComboBox magnitudeCombo;
        private AnnotationAttributes eqAttributes;
        private Color[] eqColors = new Color[]{Color.RED, Color.ORANGE, Color.YELLOW, Color.GREEN, Color.BLUE, Color.GRAY, Color.BLACK};

        public AppFrame() {
            super(true, true, false);
            LayerList layerList = this.getWwd().getModel().getLayers();
            for (int i = 0; i < layerList.size(); ++i) {
                if (layerList.get(i) instanceof SkyGradientLayer) {
                    layerList.set(i, (Layer)new SkyColorLayer());
                    continue;
                }
                if (layerList.get(i) instanceof WorldMapLayer) {
                    ((Layer)layerList.get(i)).setMaxActiveAltitude(2.0E7);
                    continue;
                }
                if (!(layerList.get(i) instanceof CompassLayer)) continue;
                ((Layer)layerList.get(i)).setMaxActiveAltitude(2.0E7);
            }
            this.tooltipAnnotation = new GlobeAnnotation("", Position.fromDegrees((double)0.0, (double)0.0, (double)0.0));
            Font font = Font.decode("Arial-Plain-16");
            this.tooltipAnnotation.getAttributes().setFont(font);
            this.tooltipAnnotation.getAttributes().setSize(new Dimension(400, 0));
            this.tooltipAnnotation.getAttributes().setDistanceMinScale(1.0);
            this.tooltipAnnotation.getAttributes().setDistanceMaxScale(1.0);
            this.tooltipAnnotation.getAttributes().setVisible(false);
            this.tooltipAnnotation.setPickEnabled(false);
            this.tooltipAnnotation.setAlwaysOnTop(true);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            jPanel.add(this.makeEarthquakesPanel());
            jPanel.add(new FlatWorldPanel(this.getWwd()));
            this.getLayerPanel().add((Component)jPanel, "South");
            this.getWwd().addSelectListener(new SelectListener(){

                public void selected(SelectEvent selectEvent) {
                    if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Rollover")) {
                        AppFrame.this.highlight(selectEvent.getTopObject());
                    }
                }
            });
            this.getWwd().addSelectListener((SelectListener)new ClickAndGoSelectListener(this.getWwd(), EqAnnotation.class, 1000000.0));
            this.updater = new Timer(1000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    long l = System.currentTimeMillis();
                    long l2 = l - AppFrame.this.updateTime;
                    if (l2 >= 300000L) {
                        AppFrame.this.updateTime = l;
                        AppFrame.this.downloadButton.setText("Update");
                        AppFrame.this.startEarthquakeDownload();
                    } else {
                        long l3 = 300000L - l2;
                        int n = (int)Math.floor((double)l3 / 60000.0);
                        int n2 = (int)((l3 - (long)n * 60000L) / 1000L);
                        AppFrame.this.downloadButton.setText(String.format("Update (in %1$02d:%2$02d)", n, n2));
                    }
                }
            });
            this.updater.start();
        }

        private void highlight(Object object) {
            if (this.mouseEq == object) {
                return;
            }
            if (this.mouseEq != null) {
                this.mouseEq.getAttributes().setHighlighted(false);
                this.mouseEq = null;
                this.tooltipAnnotation.getAttributes().setVisible(false);
            }
            if (object != null && object instanceof EqAnnotation) {
                this.mouseEq = (EqAnnotation)((Object)object);
                this.mouseEq.getAttributes().setHighlighted(true);
                this.tooltipAnnotation.setText(this.composeEarthquakeText(this.mouseEq));
                this.tooltipAnnotation.setPosition(this.mouseEq.getPosition());
                this.tooltipAnnotation.getAttributes().setVisible(true);
                this.getWwd().redraw();
            }
        }

        private void setBlinker(EqAnnotation eqAnnotation) {
            if (this.blinker != null) {
                this.blinker.stop();
                this.getWwd().redraw();
            }
            if (eqAnnotation == null) {
                return;
            }
            this.blinker = new Blinker(eqAnnotation);
        }

        private void setLatestLabel(EqAnnotation eqAnnotation) {
            if (eqAnnotation != null) {
                this.latestLabel.setText(this.composeEarthquakeText(eqAnnotation));
            } else {
                this.latestLabel.setText("");
            }
        }

        private String composeEarthquakeText(EqAnnotation eqAnnotation) {
            Number number;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<html>");
            Number number2 = (Number)eqAnnotation.getValue(FlatWorldEarthquakes.USGS_EARTHQUAKE_MAGNITUDE);
            String string = (String)eqAnnotation.getValue(FlatWorldEarthquakes.USGS_EARTHQUAKE_PLACE);
            if (number2 != null || !WWUtil.isEmpty((Object)string)) {
                stringBuilder.append("<b>");
                if (number2 != null) {
                    stringBuilder.append("M ").append(number2).append(" - ");
                }
                if (string != null) {
                    stringBuilder.append(string);
                }
                stringBuilder.append("</b>");
                stringBuilder.append("<br/>");
            }
            if ((number = (Number)eqAnnotation.getValue(FlatWorldEarthquakes.USGS_EARTHQUAKE_TIME)) != null) {
                long l = this.updateTime - number.longValue();
                stringBuilder.append(this.timePassedToString(l));
                stringBuilder.append("<br/>");
            }
            stringBuilder.append(String.format("%.2f", eqAnnotation.getPosition().elevation)).append(" km deep");
            stringBuilder.append("</html>");
            return stringBuilder.toString();
        }

        protected String timePassedToString(long l) {
            if (l > 86400000L) {
                long l2 = l / 86400000L;
                return l2 + (l2 > 1L ? " days ago" : " day ago");
            }
            if (l > 3600000L) {
                long l3 = l / 3600000L;
                return l3 + (l3 > 1L ? " hours ago" : " hour ago");
            }
            if (l > 60000L) {
                long l4 = l / 60000L;
                return l4 + (l4 > 1L ? " minutes ago" : " minute ago");
            }
            return "moments ago";
        }

        private JPanel makeEarthquakesPanel() {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            JPanel jPanel2 = new JPanel(new GridLayout(0, 1, 0, 0));
            jPanel2.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            JButton jButton = new JButton("Zoom on latest");
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (AppFrame.this.latestEq != null) {
                        Position position = AppFrame.this.latestEq.getPosition();
                        BasicOrbitView basicOrbitView = (BasicOrbitView)AppFrame.this.getWwd().getView();
                        basicOrbitView.addPanToAnimator(new Position((LatLon)position, 0.0), Angle.ZERO, Angle.ZERO, 1000000.0);
                    }
                }
            });
            jPanel2.add(jButton);
            jPanel.add(jPanel2);
            JPanel jPanel3 = new JPanel(new GridLayout(0, 1, 0, 0));
            jPanel3.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            JButton jButton2 = new JButton("Reset Global View");
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Double d = Configuration.getDoubleValue((String)"gov.nasa.worldwind.avkey.InitialLatitude");
                    Double d2 = Configuration.getDoubleValue((String)"gov.nasa.worldwind.avkey.InitialLongitude");
                    Double d3 = Configuration.getDoubleValue((String)"gov.nasa.worldwind.avkey.InitialAltitude");
                    Position position = Position.fromDegrees((double)d, (double)d2, (double)0.0);
                    BasicOrbitView basicOrbitView = (BasicOrbitView)AppFrame.this.getWwd().getView();
                    basicOrbitView.addPanToAnimator(new Position((LatLon)position, 0.0), Angle.ZERO, Angle.ZERO, d3.doubleValue());
                }
            });
            jPanel3.add(jButton2);
            jPanel.add(jPanel3);
            JPanel jPanel4 = new JPanel(new GridLayout(0, 1, 0, 0));
            jPanel4.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            this.downloadButton = new JButton("Update");
            this.downloadButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AppFrame.this.startEarthquakeDownload();
                }
            });
            this.downloadButton.setEnabled(false);
            jPanel4.add(this.downloadButton);
            jPanel.add(jPanel4);
            JPanel jPanel5 = new JPanel(new GridLayout(0, 1, 0, 0));
            jPanel5.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            this.statusLabel = new JLabel();
            this.statusLabel.setPreferredSize(new Dimension(200, 20));
            this.statusLabel.setVerticalAlignment(0);
            jPanel5.add(this.statusLabel);
            jPanel.add(jPanel5);
            JPanel jPanel6 = new JPanel(new GridLayout(0, 2, 0, 0));
            jPanel6.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            jPanel6.add(new JLabel("Min Magnitude:"));
            this.magnitudeCombo = new JComboBox<String>(new String[]{"2.5", "3", "4", "5", "6", "7"});
            this.magnitudeCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AppFrame.this.applyMagnitudeFilter(Double.parseDouble((String)AppFrame.this.magnitudeCombo.getSelectedItem()));
                }
            });
            jPanel6.add(this.magnitudeCombo);
            jPanel.add(jPanel6);
            JPanel jPanel7 = new JPanel(new GridLayout(0, 2, 0, 0));
            jPanel7.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            jPanel7.add(new JLabel("Latest:"));
            final JCheckBox jCheckBox = new JCheckBox("Animate");
            jCheckBox.setSelected(true);
            jCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (jCheckBox.isSelected()) {
                        AppFrame.this.setBlinker(AppFrame.this.latestEq);
                    } else {
                        AppFrame.this.setBlinker(null);
                    }
                }
            });
            jPanel7.add(jCheckBox);
            jPanel.add(jPanel7);
            JPanel jPanel8 = new JPanel(new GridLayout(0, 1, 0, 0));
            jPanel8.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            this.latestLabel = new JLabel();
            this.latestLabel.setPreferredSize(new Dimension(200, 60));
            this.latestLabel.setVerticalAlignment(1);
            jPanel8.add(this.latestLabel);
            jPanel.add(jPanel8);
            jPanel.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9), new TitledBorder("Earthquakes")));
            jPanel.setToolTipText("Earthquakes controls.");
            return jPanel;
        }

        private void startEarthquakeDownload() {
            WorldWind.getScheduledTaskService().addTask(new Runnable(){

                @Override
                public void run() {
                    AppFrame.this.downloadEarthquakes(FlatWorldEarthquakes.USGS_EARTHQUAKE_FEED_URL);
                }
            });
        }

        private void downloadEarthquakes(String string) {
            RenderableLayer renderableLayer;
            if (this.downloadButton != null) {
                this.downloadButton.setEnabled(false);
            }
            if (this.statusLabel != null) {
                this.statusLabel.setText("Updating earthquakes...");
            }
            if ((renderableLayer = (RenderableLayer)this.buildEarthquakeLayer(string)).getNumRenderables() > 0) {
                LayerList layerList = this.getWwd().getModel().getLayers();
                if (this.eqLayer != null) {
                    layerList.remove((Layer)this.eqLayer);
                }
                this.eqLayer = renderableLayer;
                this.eqLayer.addRenderable((Renderable)this.tooltipAnnotation);
                ApplicationTemplate.insertBeforePlacenames(this.getWwd(), (Layer)this.eqLayer);
                this.getLayerPanel().update(this.getWwd());
                this.applyMagnitudeFilter(Double.parseDouble((String)this.magnitudeCombo.getSelectedItem()));
                if (this.statusLabel != null) {
                    this.statusLabel.setText("Updated " + new SimpleDateFormat("EEE h:mm aa").format(new Date()));
                }
            } else if (this.statusLabel != null) {
                this.statusLabel.setText("No earthquakes");
            }
            if (this.downloadButton != null) {
                this.downloadButton.setEnabled(true);
            }
        }

        private Layer buildEarthquakeLayer(String string) {
            GeoJSONLoader geoJSONLoader = new GeoJSONLoader(){

                @Override
                protected void addRenderableForPoint(GeoJSONPoint geoJSONPoint, RenderableLayer renderableLayer, AVList aVList) {
                    try {
                        AppFrame.this.addEarthquake(geoJSONPoint, renderableLayer, aVList);
                    }
                    catch (Exception exception) {
                        Logging.logger().log(Level.WARNING, "Exception adding earthquake", exception);
                    }
                }
            };
            RenderableLayer renderableLayer = new RenderableLayer();
            renderableLayer.setName("Earthquakes");
            geoJSONLoader.addSourceGeometryToLayer(string, renderableLayer);
            return renderableLayer;
        }

        private void addEarthquake(GeoJSONPoint geoJSONPoint, RenderableLayer renderableLayer, AVList aVList) {
            if (this.eqAttributes == null) {
                this.eqAttributes = new AnnotationAttributes();
                this.eqAttributes.setLeader("gov.nasa.worldwind.avkey.ShapeNone");
                this.eqAttributes.setDrawOffset(new Point(0, -16));
                this.eqAttributes.setSize(new Dimension(32, 32));
                this.eqAttributes.setBorderWidth(0.0);
                this.eqAttributes.setCornerRadius(0);
                this.eqAttributes.setBackgroundColor(new Color(0, 0, 0, 0));
            }
            EqAnnotation eqAnnotation = new EqAnnotation(geoJSONPoint.getPosition(), this.eqAttributes);
            eqAnnotation.setAltitudeMode(1);
            eqAnnotation.setValues(aVList);
            Number number = (Number)eqAnnotation.getValue(FlatWorldEarthquakes.USGS_EARTHQUAKE_MAGNITUDE);
            Number number2 = (Number)eqAnnotation.getValue(FlatWorldEarthquakes.USGS_EARTHQUAKE_TIME);
            int n = 6;
            if (number2 != null) {
                n = (int)((this.updateTime - number2.longValue()) / 86400000L);
                if (this.latestEq != null) {
                    Number number3 = (Number)this.latestEq.getValue(FlatWorldEarthquakes.USGS_EARTHQUAKE_TIME);
                    if (number3.longValue() < number2.longValue()) {
                        this.latestEq = eqAnnotation;
                    }
                } else {
                    this.latestEq = eqAnnotation;
                }
            }
            eqAnnotation.getAttributes().setTextColor(this.eqColors[Math.min(n, this.eqColors.length - 1)]);
            eqAnnotation.getAttributes().setScale(number.doubleValue() / 10.0);
            renderableLayer.addRenderable((Renderable)eqAnnotation);
        }

        private void applyMagnitudeFilter(double d) {
            this.latestEq = null;
            this.setBlinker(null);
            this.setLatestLabel(null);
            Iterable iterable = this.eqLayer.getRenderables();
            for (Renderable renderable : iterable) {
                if (!(renderable instanceof EqAnnotation)) continue;
                EqAnnotation eqAnnotation = (EqAnnotation)renderable;
                Number number = (Number)eqAnnotation.getValue(FlatWorldEarthquakes.USGS_EARTHQUAKE_MAGNITUDE);
                Number number2 = (Number)eqAnnotation.getValue(FlatWorldEarthquakes.USGS_EARTHQUAKE_TIME);
                boolean bl = number.doubleValue() >= d;
                eqAnnotation.getAttributes().setVisible(bl);
                if (!bl) continue;
                if (this.latestEq != null) {
                    Number number3 = (Number)this.latestEq.getValue(FlatWorldEarthquakes.USGS_EARTHQUAKE_TIME);
                    if (number3 == null || number2 == null || number3.longValue() >= number2.longValue()) continue;
                    this.latestEq = eqAnnotation;
                    continue;
                }
                this.latestEq = eqAnnotation;
            }
            this.setBlinker(this.latestEq);
            this.setLatestLabel(this.latestEq);
            this.getWwd().redraw();
        }

        private class Blinker {
            private EqAnnotation annotation;
            private double initialScale;
            private double initialOpacity;
            private int steps = 10;
            private int step = 0;
            private int delay = 100;
            private Timer timer;

            private Blinker(EqAnnotation eqAnnotation) {
                this.annotation = eqAnnotation;
                this.initialScale = this.annotation.getAttributes().getScale();
                this.initialOpacity = this.annotation.getAttributes().getOpacity();
                this.timer = new Timer(this.delay, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Blinker.this.annotation.getAttributes().setScale(Blinker.this.initialScale * (double)(1.0f + 7.0f * ((float)Blinker.this.step / (float)Blinker.this.steps)));
                        Blinker.this.annotation.getAttributes().setOpacity(Blinker.this.initialOpacity * (double)(1.0f - (float)Blinker.this.step / (float)Blinker.this.steps));
                        Blinker.this.step = Blinker.this.step == Blinker.this.steps ? 0 : Blinker.this.step + 1;
                        AppFrame.this.getWwd().redraw();
                    }
                });
                this.start();
            }

            private void stop() {
                this.timer.stop();
                this.step = 0;
                this.annotation.getAttributes().setScale(this.initialScale);
                this.annotation.getAttributes().setOpacity(this.initialOpacity);
            }

            private void start() {
                this.timer.start();
            }
        }

        private class EqAnnotation
        extends GlobeAnnotation {
            private DoubleBuffer shapeBuffer;

            public EqAnnotation(Position position, AnnotationAttributes annotationAttributes) {
                super("", position, annotationAttributes);
            }

            protected void applyScreenTransform(DrawContext drawContext, int n, int n2, int n3, int n4, double d) {
                double d2 = d * this.computeScale(drawContext);
                GL2 gL2 = drawContext.getGL().getGL2();
                gL2.glTranslated((double)n, (double)n2, 0.0);
                gL2.glScaled(d2, d2, 1.0);
            }

            protected void doDraw(DrawContext drawContext, int n, int n2, double d, Position position) {
                if (drawContext.isPickingMode()) {
                    this.bindPickableObject(drawContext, position);
                }
                this.applyColor(drawContext, this.getAttributes().getTextColor(), 0.6 * d, true);
                int n3 = 32;
                if (this.shapeBuffer == null) {
                    this.shapeBuffer = FrameFactory.createShapeBuffer((String)"gov.nasa.worldwind.avkey.ShapeEllipse", (double)n3, (double)n3, (int)0, null);
                }
                GL2 gL2 = drawContext.getGL().getGL2();
                gL2.glTranslated((double)(-n3 / 2), (double)(-n3 / 2), 0.0);
                FrameFactory.drawBuffer((DrawContext)drawContext, (int)6, (DoubleBuffer)this.shapeBuffer);
            }
        }
    }
}

