/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.View;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.globes.Earth;
import gov.nasa.worldwind.globes.EarthFlat;
import gov.nasa.worldwind.globes.FlatGlobe;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.LayerList;
import gov.nasa.worldwind.layers.SkyColorLayer;
import gov.nasa.worldwind.layers.SkyGradientLayer;
import gov.nasa.worldwind.view.orbit.BasicOrbitView;
import gov.nasa.worldwind.view.orbit.FlatOrbitView;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;

public class FlatWorldPanel
extends JPanel {
    private WorldWindow wwd;
    private Globe roundGlobe;
    private FlatGlobe flatGlobe;
    private JComboBox projectionCombo;

    public FlatWorldPanel(WorldWindow worldWindow) {
        super(new GridLayout(0, 1, 0, 0));
        this.wwd = worldWindow;
        if (this.isFlatGlobe()) {
            this.flatGlobe = (FlatGlobe)worldWindow.getModel().getGlobe();
            this.roundGlobe = new Earth();
        } else {
            this.flatGlobe = new EarthFlat();
            this.roundGlobe = worldWindow.getModel().getGlobe();
        }
        this.makePanel();
    }

    private JPanel makePanel() {
        FlatWorldPanel flatWorldPanel = this;
        flatWorldPanel.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9), new TitledBorder("World")));
        flatWorldPanel.setToolTipText("Set the current projection");
        JPanel jPanel = new JPanel(new GridLayout(0, 2, 0, 0));
        jPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        JRadioButton jRadioButton = new JRadioButton("Round");
        jRadioButton.setSelected(!this.isFlatGlobe());
        jRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FlatWorldPanel.this.projectionCombo.setEnabled(false);
                FlatWorldPanel.this.enableFlatGlobe(false);
            }
        });
        jPanel.add(jRadioButton);
        JRadioButton jRadioButton2 = new JRadioButton("Flat");
        jRadioButton2.setSelected(this.isFlatGlobe());
        jRadioButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FlatWorldPanel.this.projectionCombo.setEnabled(true);
                FlatWorldPanel.this.enableFlatGlobe(true);
            }
        });
        jPanel.add(jRadioButton2);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        JPanel jPanel2 = new JPanel(new GridLayout(0, 2, 0, 0));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        jPanel2.add(new JLabel("Projection:"));
        this.projectionCombo = new JComboBox<String>(new String[]{"Mercator", "Lat-Lon", "Modified Sin.", "Sinusoidal"});
        this.projectionCombo.setEnabled(this.isFlatGlobe());
        this.projectionCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FlatWorldPanel.this.updateProjection();
            }
        });
        jPanel2.add(this.projectionCombo);
        flatWorldPanel.add(jPanel);
        flatWorldPanel.add(jPanel2);
        return flatWorldPanel;
    }

    private void updateProjection() {
        if (!this.isFlatGlobe()) {
            return;
        }
        this.flatGlobe.setProjection(this.getProjection());
        this.wwd.redraw();
    }

    private String getProjection() {
        String string = (String)this.projectionCombo.getSelectedItem();
        if (string.equals("Mercator")) {
            return "gov.nasa.worldwind.globes.projectionMercator";
        }
        if (string.equals("Sinusoidal")) {
            return "gov.nasa.worldwind.globes.projectionSinusoidal";
        }
        if (string.equals("Modified Sin.")) {
            return "gov.nasa.worldwind.globes.projectionModifiedSinusoidal";
        }
        return "gov.nasa.worldwind.globes.projectionLatLon";
    }

    public boolean isFlatGlobe() {
        return this.wwd.getModel().getGlobe() instanceof FlatGlobe;
    }

    public void enableFlatGlobe(boolean bl) {
        if (this.isFlatGlobe() == bl) {
            return;
        }
        if (!bl) {
            this.wwd.getModel().setGlobe(this.roundGlobe);
            FlatOrbitView flatOrbitView = (FlatOrbitView)this.wwd.getView();
            BasicOrbitView basicOrbitView = new BasicOrbitView();
            basicOrbitView.setCenterPosition(flatOrbitView.getCenterPosition());
            basicOrbitView.setZoom(flatOrbitView.getZoom());
            basicOrbitView.setHeading(flatOrbitView.getHeading());
            basicOrbitView.setPitch(flatOrbitView.getPitch());
            this.wwd.setView((View)basicOrbitView);
            LayerList layerList = this.wwd.getModel().getLayers();
            for (int i = 0; i < layerList.size(); ++i) {
                if (!(layerList.get(i) instanceof SkyColorLayer)) continue;
                layerList.set(i, (Layer)new SkyGradientLayer());
            }
        } else {
            this.wwd.getModel().setGlobe((Globe)this.flatGlobe);
            this.flatGlobe.setProjection(this.getProjection());
            BasicOrbitView basicOrbitView = (BasicOrbitView)this.wwd.getView();
            FlatOrbitView flatOrbitView = new FlatOrbitView();
            flatOrbitView.setCenterPosition(basicOrbitView.getCenterPosition());
            flatOrbitView.setZoom(basicOrbitView.getZoom());
            flatOrbitView.setHeading(basicOrbitView.getHeading());
            flatOrbitView.setPitch(basicOrbitView.getPitch());
            this.wwd.setView((View)flatOrbitView);
            LayerList layerList = this.wwd.getModel().getLayers();
            for (int i = 0; i < layerList.size(); ++i) {
                if (!(layerList.get(i) instanceof SkyGradientLayer)) continue;
                layerList.set(i, (Layer)new SkyColorLayer());
            }
        }
        this.wwd.redraw();
    }
}

