/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.formats.geojson.GeoJSONDoc;
import gov.nasa.worldwind.formats.geojson.GeoJSONFeature;
import gov.nasa.worldwind.formats.geojson.GeoJSONFeatureCollection;
import gov.nasa.worldwind.formats.geojson.GeoJSONGeometry;
import gov.nasa.worldwind.formats.geojson.GeoJSONGeometryCollection;
import gov.nasa.worldwind.formats.geojson.GeoJSONLineString;
import gov.nasa.worldwind.formats.geojson.GeoJSONMultiLineString;
import gov.nasa.worldwind.formats.geojson.GeoJSONMultiPoint;
import gov.nasa.worldwind.formats.geojson.GeoJSONMultiPolygon;
import gov.nasa.worldwind.formats.geojson.GeoJSONObject;
import gov.nasa.worldwind.formats.geojson.GeoJSONPoint;
import gov.nasa.worldwind.formats.geojson.GeoJSONPolygon;
import gov.nasa.worldwind.formats.geojson.GeoJSONPositionArray;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.Path;
import gov.nasa.worldwind.render.PointPlacemark;
import gov.nasa.worldwind.render.PointPlacemarkAttributes;
import gov.nasa.worldwind.render.Polygon;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.render.SurfacePolygon;
import gov.nasa.worldwind.render.SurfacePolyline;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwindx.examples.util.RandomShapeAttributes;
import java.io.IOException;
import java.util.logging.Level;

public class GeoJSONLoader {
    protected static final RandomShapeAttributes randomAttrs = new RandomShapeAttributes();

    public void addSourceGeometryToLayer(Object object, RenderableLayer renderableLayer) {
        if (WWUtil.isEmpty((Object)object)) {
            String string = Logging.getMessage((String)"nullValue.SourceIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (renderableLayer == null) {
            String string = Logging.getMessage((String)"nullValue.LayerIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        GeoJSONDoc geoJSONDoc = null;
        try {
            geoJSONDoc = new GeoJSONDoc(object);
            geoJSONDoc.parse();
            if (geoJSONDoc.getRootObject() instanceof GeoJSONObject) {
                this.addGeoJSONGeometryToLayer((GeoJSONObject)geoJSONDoc.getRootObject(), renderableLayer);
            } else if (geoJSONDoc.getRootObject() instanceof Object[]) {
                for (Object object2 : (Object[])geoJSONDoc.getRootObject()) {
                    if (object2 instanceof GeoJSONObject) {
                        this.addGeoJSONGeometryToLayer((GeoJSONObject)object2, renderableLayer);
                        continue;
                    }
                    this.handleUnrecognizedObject(object2);
                }
            } else {
                this.handleUnrecognizedObject(geoJSONDoc.getRootObject());
            }
        }
        catch (IOException iOException) {
            String string = Logging.getMessage((String)"generic.ExceptionAttemptingToReadGeoJSON", (Object[])new Object[]{object});
            Logging.logger().log(Level.SEVERE, string, iOException);
            throw new WWRuntimeException(string, (Throwable)iOException);
        }
        finally {
            WWIO.closeStream((Object)geoJSONDoc, (String)object.toString());
        }
    }

    public void addGeoJSONGeometryToLayer(GeoJSONObject geoJSONObject, RenderableLayer renderableLayer) {
        if (geoJSONObject == null) {
            String string = Logging.getMessage((String)"nullValue.ObjectIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (renderableLayer == null) {
            String string = Logging.getMessage((String)"nullValue.LayerIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (geoJSONObject.isGeometry()) {
            this.addRenderableForGeometry(geoJSONObject.asGeometry(), renderableLayer, null);
        } else if (geoJSONObject.isFeature()) {
            this.addRenderableForFeature(geoJSONObject.asFeature(), renderableLayer);
        } else if (geoJSONObject.isFeatureCollection()) {
            this.addRenderableForFeatureCollection(geoJSONObject.asFeatureCollection(), renderableLayer);
        } else {
            this.handleUnrecognizedObject(geoJSONObject);
        }
    }

    public Layer createLayerFromSource(Object object) {
        if (WWUtil.isEmpty((Object)object)) {
            String string = Logging.getMessage((String)"nullValue.SourceIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        RenderableLayer renderableLayer = new RenderableLayer();
        this.addSourceGeometryToLayer(object, renderableLayer);
        return renderableLayer;
    }

    public Layer createLayerFromGeoJSON(GeoJSONObject geoJSONObject) {
        if (geoJSONObject == null) {
            String string = Logging.getMessage((String)"nullValue.ObjectIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        RenderableLayer renderableLayer = new RenderableLayer();
        this.addGeoJSONGeometryToLayer(geoJSONObject, renderableLayer);
        return renderableLayer;
    }

    protected void handleUnrecognizedObject(Object object) {
        Logging.logger().warning(Logging.getMessage((String)"generic.UnrecognizedObjectType", (Object[])new Object[]{object}));
    }

    protected void addRenderableForGeometry(GeoJSONGeometry geoJSONGeometry, RenderableLayer renderableLayer, AVList aVList) {
        if (geoJSONGeometry.isPoint()) {
            this.addRenderableForPoint(geoJSONGeometry.asPoint(), renderableLayer, aVList);
        } else if (geoJSONGeometry.isMultiPoint()) {
            this.addRenderableForMultiPoint(geoJSONGeometry.asMultiPoint(), renderableLayer, aVList);
        } else if (geoJSONGeometry.isLineString()) {
            this.addRenderableForLineString(geoJSONGeometry.asLineString(), renderableLayer, aVList);
        } else if (geoJSONGeometry.isMultiLineString()) {
            this.addRenderableForMutiLineString(geoJSONGeometry.asMultiLineString(), renderableLayer, aVList);
        } else if (geoJSONGeometry.isPolygon()) {
            this.addRenderableForPolygon(geoJSONGeometry.asPolygon(), renderableLayer, aVList);
        } else if (geoJSONGeometry.isMultiPolygon()) {
            this.addRenderableForMultiPolygon(geoJSONGeometry.asMultiPolygon(), renderableLayer, aVList);
        } else if (geoJSONGeometry.isGeometryCollection()) {
            this.addRenderableForGeometryCollection(geoJSONGeometry.asGeometryCollection(), renderableLayer, aVList);
        } else {
            this.handleUnrecognizedObject(geoJSONGeometry);
        }
    }

    protected void addRenderableForGeometryCollection(GeoJSONGeometryCollection geoJSONGeometryCollection, RenderableLayer renderableLayer, AVList aVList) {
        if (geoJSONGeometryCollection.getGeometries() == null || geoJSONGeometryCollection.getGeometries().length == 0) {
            return;
        }
        for (GeoJSONGeometry geoJSONGeometry : geoJSONGeometryCollection.getGeometries()) {
            this.addRenderableForGeometry(geoJSONGeometry, renderableLayer, aVList);
        }
    }

    protected void addRenderableForFeature(GeoJSONFeature geoJSONFeature, RenderableLayer renderableLayer) {
        if (geoJSONFeature.getGeometry() == null) {
            Logging.logger().warning(Logging.getMessage((String)"nullValue.GeometryIsNull"));
            return;
        }
        this.addRenderableForGeometry(geoJSONFeature.getGeometry(), renderableLayer, geoJSONFeature.getProperties());
    }

    protected void addRenderableForFeatureCollection(GeoJSONFeatureCollection geoJSONFeatureCollection, RenderableLayer renderableLayer) {
        if (geoJSONFeatureCollection.getFeatures() != null && geoJSONFeatureCollection.getFeatures().length == 0) {
            return;
        }
        for (GeoJSONFeature geoJSONFeature : geoJSONFeatureCollection.getFeatures()) {
            this.addRenderableForFeature(geoJSONFeature, renderableLayer);
        }
    }

    protected void addRenderableForPoint(GeoJSONPoint geoJSONPoint, RenderableLayer renderableLayer, AVList aVList) {
        PointPlacemarkAttributes pointPlacemarkAttributes = this.createPointAttributes((GeoJSONGeometry)geoJSONPoint, (Layer)renderableLayer);
        renderableLayer.addRenderable(this.createPoint((GeoJSONGeometry)geoJSONPoint, geoJSONPoint.getPosition(), pointPlacemarkAttributes, aVList));
    }

    protected void addRenderableForMultiPoint(GeoJSONMultiPoint geoJSONMultiPoint, RenderableLayer renderableLayer, AVList aVList) {
        PointPlacemarkAttributes pointPlacemarkAttributes = this.createPointAttributes((GeoJSONGeometry)geoJSONMultiPoint, (Layer)renderableLayer);
        for (int i = 0; i < geoJSONMultiPoint.getPointCount(); ++i) {
            renderableLayer.addRenderable(this.createPoint((GeoJSONGeometry)geoJSONMultiPoint, geoJSONMultiPoint.getPosition(i), pointPlacemarkAttributes, aVList));
        }
    }

    protected void addRenderableForLineString(GeoJSONLineString geoJSONLineString, RenderableLayer renderableLayer, AVList aVList) {
        ShapeAttributes shapeAttributes = this.createPolylineAttributes((GeoJSONGeometry)geoJSONLineString, (Layer)renderableLayer);
        renderableLayer.addRenderable(this.createPolyline((GeoJSONGeometry)geoJSONLineString, (Iterable<? extends Position>)geoJSONLineString.getCoordinates(), shapeAttributes, aVList));
    }

    protected void addRenderableForMutiLineString(GeoJSONMultiLineString geoJSONMultiLineString, RenderableLayer renderableLayer, AVList aVList) {
        ShapeAttributes shapeAttributes = this.createPolylineAttributes((GeoJSONGeometry)geoJSONMultiLineString, (Layer)renderableLayer);
        for (GeoJSONPositionArray geoJSONPositionArray : geoJSONMultiLineString.getCoordinates()) {
            renderableLayer.addRenderable(this.createPolyline((GeoJSONGeometry)geoJSONMultiLineString, (Iterable<? extends Position>)geoJSONPositionArray, shapeAttributes, aVList));
        }
    }

    protected void addRenderableForPolygon(GeoJSONPolygon geoJSONPolygon, RenderableLayer renderableLayer, AVList aVList) {
        ShapeAttributes shapeAttributes = this.createPolygonAttributes((GeoJSONGeometry)geoJSONPolygon, (Layer)renderableLayer);
        renderableLayer.addRenderable(this.createPolygon((GeoJSONGeometry)geoJSONPolygon, (Iterable<? extends Position>)geoJSONPolygon.getExteriorRing(), (Iterable<? extends Position>[])geoJSONPolygon.getInteriorRings(), shapeAttributes, aVList));
    }

    protected void addRenderableForMultiPolygon(GeoJSONMultiPolygon geoJSONMultiPolygon, RenderableLayer renderableLayer, AVList aVList) {
        ShapeAttributes shapeAttributes = this.createPolygonAttributes((GeoJSONGeometry)geoJSONMultiPolygon, (Layer)renderableLayer);
        for (int i = 0; i < geoJSONMultiPolygon.getPolygonCount(); ++i) {
            renderableLayer.addRenderable(this.createPolygon((GeoJSONGeometry)geoJSONMultiPolygon, (Iterable<? extends Position>)geoJSONMultiPolygon.getExteriorRing(i), (Iterable<? extends Position>[])geoJSONMultiPolygon.getInteriorRings(i), shapeAttributes, aVList));
        }
    }

    protected Renderable createPoint(GeoJSONGeometry geoJSONGeometry, Position position, PointPlacemarkAttributes pointPlacemarkAttributes, AVList aVList) {
        PointPlacemark pointPlacemark = new PointPlacemark(position);
        pointPlacemark.setAttributes(pointPlacemarkAttributes);
        if (position.getAltitude() != 0.0) {
            pointPlacemark.setAltitudeMode(0);
            pointPlacemark.setLineEnabled(true);
        } else {
            pointPlacemark.setAltitudeMode(1);
        }
        if (aVList != null) {
            pointPlacemark.setValue("gov.nasa.worldwind.avkey.Properties", (Object)aVList);
        }
        return pointPlacemark;
    }

    protected Renderable createPolyline(GeoJSONGeometry geoJSONGeometry, Iterable<? extends Position> iterable, ShapeAttributes shapeAttributes, AVList aVList) {
        if (GeoJSONLoader.positionsHaveNonzeroAltitude(iterable)) {
            Path path = new Path();
            path.setPositions(iterable);
            path.setAltitudeMode(0);
            path.setAttributes(shapeAttributes);
            if (aVList != null) {
                path.setValue("gov.nasa.worldwind.avkey.Properties", (Object)aVList);
            }
            return path;
        }
        SurfacePolyline surfacePolyline = new SurfacePolyline(shapeAttributes, iterable);
        if (aVList != null) {
            surfacePolyline.setValue("gov.nasa.worldwind.avkey.Properties", (Object)aVList);
        }
        return surfacePolyline;
    }

    protected Renderable createPolygon(GeoJSONGeometry geoJSONGeometry, Iterable<? extends Position> iterable, Iterable<? extends Position>[] iterableArray, ShapeAttributes shapeAttributes, AVList aVList) {
        if (GeoJSONLoader.positionsHaveNonzeroAltitude(iterable)) {
            Polygon polygon = new Polygon(iterable);
            polygon.setAttributes(shapeAttributes);
            if (iterableArray != null) {
                for (Iterable<? extends Position> iterable2 : iterableArray) {
                    polygon.addInnerBoundary(iterable2);
                }
            }
            if (aVList != null) {
                polygon.setValue("gov.nasa.worldwind.avkey.Properties", (Object)aVList);
            }
            return polygon;
        }
        SurfacePolygon surfacePolygon = new SurfacePolygon(shapeAttributes, iterable);
        if (iterableArray != null) {
            for (Iterable<? extends Position> iterable3 : iterableArray) {
                surfacePolygon.addInnerBoundary(iterable3);
            }
        }
        if (aVList != null) {
            surfacePolygon.setValue("gov.nasa.worldwind.avkey.Properties", (Object)aVList);
        }
        return surfacePolygon;
    }

    protected static boolean positionsHaveNonzeroAltitude(Iterable<? extends Position> iterable) {
        for (Position position : iterable) {
            if (position.getAltitude() == 0.0) continue;
            return true;
        }
        return false;
    }

    protected PointPlacemarkAttributes createPointAttributes(GeoJSONGeometry geoJSONGeometry, Layer layer) {
        if (layer == null) {
            return randomAttrs.nextPointAttributes();
        }
        String string = this.getClass().getName() + ".PointAttributes";
        PointPlacemarkAttributes pointPlacemarkAttributes = (PointPlacemarkAttributes)layer.getValue(string);
        if (pointPlacemarkAttributes == null) {
            pointPlacemarkAttributes = randomAttrs.nextPointAttributes();
            layer.setValue(string, (Object)pointPlacemarkAttributes);
        }
        return pointPlacemarkAttributes;
    }

    protected ShapeAttributes createPolylineAttributes(GeoJSONGeometry geoJSONGeometry, Layer layer) {
        if (layer == null) {
            return randomAttrs.nextPolylineAttributes();
        }
        String string = this.getClass().getName() + ".PolylineAttributes";
        ShapeAttributes shapeAttributes = (ShapeAttributes)layer.getValue(string);
        if (shapeAttributes == null) {
            shapeAttributes = randomAttrs.nextPolylineAttributes();
            layer.setValue(string, (Object)shapeAttributes);
        }
        return shapeAttributes;
    }

    protected ShapeAttributes createPolygonAttributes(GeoJSONGeometry geoJSONGeometry, Layer layer) {
        if (layer == null) {
            return randomAttrs.nextPolygonAttributes();
        }
        String string = this.getClass().getName() + ".PolygonAttributes";
        ShapeAttributes shapeAttributes = (ShapeAttributes)layer.getValue(string);
        if (shapeAttributes == null) {
            shapeAttributes = randomAttrs.nextPolygonAttributes();
            layer.setValue(string, (Object)shapeAttributes);
        }
        return shapeAttributes;
    }
}

