/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.formats.georss.GeoRSSParser;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import java.util.List;

public class GeoRSS
extends ApplicationTemplate {
    private static final String GeoRSS_DOCSTRING_A = "<?xml version=\"1.0\" encoding=\"utf-8\"?><feed xmlns=\"http://www.w3.org/2005/Atom\"      xmlns:georss=\"http://www.georss.org/georss\"      xmlns:gml=\"http://www.opengis.net/gml\">  <title>Earthquakes</title>    <subtitle>International earthquake observation labs</subtitle>    <link href=\"http://example.org/\"/>    <updated>2005-12-13T18:30:02Z</updated>    <author>      <name>Dr. Thaddeus Remor</name>      <email>tremor@quakelab.edu</email>    </author>    <id>urn:uuid:60a76c80-d399-11d9-b93C-0003939e0af6</id>  <entry>    <title>M 3.2, Mona Passage</title>    <link href=\"http://example.org/2005/09/09/atom01\"/>    <id>urn:uuid:1225c695-cfb8-4ebb-aaaa-80da344efa6a</id>    <updated>2005-08-17T07:02:32Z</updated>    <summary>We just had a big one.</summary>    <georss:where>      <gml:Polygon>        <gml:exterior>          <gml:LinearRing>            <gml:posList>              45.256 -110.45 46.46 -109.48 43.84 -109.86 45.256 -110.45            </gml:posList>          </gml:LinearRing>        </gml:exterior>      </gml:Polygon>    </georss:where>  </entry></feed>";
    private static final String GeoRSS_DOCSTRING_B = "<feed xmlns=\"http://www.w3.org/2005/Atom\"              xmlns:georss=\"http://www.georss.org/georss\">              <title>scribble</title>              <id>http://example.com/atom</id>              <author><name>Christopher Schmidt</name></author><entry>  <id>http://example.com/19.atom</id>  <link href=\"http://example.com/19.html\"/>  <title>Feature #19</title>  <content type=\"html\">Some content.</content>  <georss:line>    23.1811523438 -159.609375     22.5 -161.564941406     20.654296875 -160.422363281     18.4350585938 -156.247558594     18.3471679688 -154.731445312     19.951171875 -153.588867188     21.8188476562 -155.983886719    23.02734375 -158.994140625    23.0932617188 -159.631347656  </georss:line></entry></feed>";

    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind GeoRSS", AppFrame.class);
    }

    private static class AppFrame
    extends ApplicationTemplate.AppFrame {
        public AppFrame() {
            super(true, true, false);
            RenderableLayer renderableLayer = this.buildGeoRSSLayer();
            renderableLayer.setName("GeoRSS Shapes");
            ApplicationTemplate.insertBeforePlacenames(this.getWwd(), (Layer)renderableLayer);
            this.getLayerPanel().update(this.getWwd());
        }

        private RenderableLayer buildGeoRSSLayer() {
            RenderableLayer renderableLayer = new RenderableLayer();
            List list = GeoRSSParser.parseShapes((String)GeoRSS.GeoRSS_DOCSTRING_A);
            if (list != null) {
                this.addRenderables(renderableLayer, list);
            }
            if ((list = GeoRSSParser.parseShapes((String)GeoRSS.GeoRSS_DOCSTRING_B)) != null) {
                this.addRenderables(renderableLayer, list);
            }
            return renderableLayer;
        }

        private void addRenderables(RenderableLayer renderableLayer, Iterable<Renderable> iterable) {
            for (Renderable renderable : iterable) {
                renderableLayer.addRenderable(renderable);
            }
        }
    }
}

